/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.bookmarks;

import de.cismet.cids.custom.beans.watergis.Bookmark;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.ManageBookmarksDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class DeleteBookmarkAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(DeleteBookmarkAction.class);
    private ManageBookmarksDialog manageBookmarksDialog;

    public DeleteBookmarkAction() {
        this((ManageBookmarksDialog)null);
    }

    public DeleteBookmarkAction(ManageBookmarksDialog manageBookmarksDialog) {
        String tooltip = NbBundle.getMessage(DeleteBookmarkAction.class, (String)"DeleteBookmarkAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(DeleteBookmarkAction.class, (String)"DeleteBookmarkAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(DeleteBookmarkAction.class, (String)"DeleteBookmarkAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.manageBookmarksDialog = manageBookmarksDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Bookmark selectedBookmark = this.manageBookmarksDialog.getSelectedBookmark();
        this.manageBookmarksDialog.removeBookmarkFromList(selectedBookmark);
        AppBroker.getInstance().getBookmarkManager().remove(selectedBookmark);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

