/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.bookmarks;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.gui.WatergisApp;
import de.cismet.watergis.gui.dialog.ManageBookmarksDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class LoadBookmarksAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(LoadBookmarksAction.class);
    private ManageBookmarksDialog manageBookmarksDialog;

    public LoadBookmarksAction() {
        this((ManageBookmarksDialog)null);
    }

    public LoadBookmarksAction(ManageBookmarksDialog manageBookmarksDialog) {
        String tooltip = NbBundle.getMessage(LoadBookmarksAction.class, (String)"LoadBookmarksAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(LoadBookmarksAction.class, (String)"LoadBookmarksAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(LoadBookmarksAction.class, (String)"LoadBookmarksAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.manageBookmarksDialog = manageBookmarksDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file = StaticSwingTools.chooseFile((String)WatergisApp.getDIRECTORYPATH_WATERGIS(), (boolean)false, (String[])new String[]{"lz"}, (String)NbBundle.getMessage(LoadBookmarksAction.class, (String)"LoadBookmarksAction.load.FileFilter.getDescription.return"), (Component)AppBroker.getInstance().getComponent(ComponentName.MAIN));
        if (file != null) {
            if (file.exists()) {
                AppBroker.getInstance().getBookmarkManager().loadFromFile(file);
                if (this.manageBookmarksDialog != null) {
                    this.manageBookmarksDialog.updateModel();
                }
            } else {
                LOG.warn((Object)"Bookmark file, which the user wanted to open, does not exist.");
                String message = NbBundle.getMessage(LoadBookmarksAction.class, (String)"LoadBookmarksAction.load.fileDoesNotExist.message");
                String title = NbBundle.getMessage(LoadBookmarksAction.class, (String)"LoadBookmarksAction.load.fileDoesNotExist.title");
                JOptionPane.showMessageDialog((Component)AppBroker.getInstance().getMappingComponent(), message, title, 1);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

