/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.checks;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.custom.watergis.server.search.FgBakCount;
import de.cismet.cids.custom.watergis.server.search.LeisEswGeschWrongPlace;
import de.cismet.cids.custom.watergis.server.search.OverlappedTech;
import de.cismet.cids.custom.watergis.server.search.TechDWrongPlace;
import de.cismet.cids.custom.watergis.server.search.TechDueWrongPlace;
import de.cismet.cids.custom.watergis.server.search.TechGeschWrongPlace;
import de.cismet.cids.custom.watergis.server.search.TechOffWrongPlace;
import de.cismet.cids.custom.watergis.server.search.TechVWrongPlace;
import de.cismet.cids.custom.watergis.server.search.TechWithHole;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.checks.AbstractCheckAction;
import de.cismet.watergis.gui.actions.checks.AbstractCheckResult;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class SonstigeCheckAction
extends AbstractCheckAction {
    private static final MetaClass GU_WIWE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.gu_wiwe");
    private static final MetaClass FG_BA_UGHZ = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_ughz");
    private static final MetaClass FG_BA_LEIS = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_leis");
    private static final MetaClass FG_BA_TECH = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_tech");
    private static final MetaClass FOTO = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.foto");
    private static final MetaClass FG_BA_RL = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_rl");
    private static final MetaClass FG_BA_D = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_d");
    private static final MetaClass FG_BA_DUE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_due");
    private static String QUERY_WIWE_HOLE;
    private static String QUERY_WIWE_ATTR;
    private static String QUERY_LEIS_ATTR;
    private static String QUERY_TECH_ATTR;
    private static String QUERY_FOTO_ATTR;
    private static String QUERY_UGHZ_ATTR;
    private static final String CHECK_SONSTIGES_TECH_TECH__LUECKE = "Pr\u00fcfungen->Sonstiges->Tech->Tech: L\u00fccke";
    private static final String CHECK_SONSTIGES_TECH_TECH__UEBERLAPPUNG = "Pr\u00fcfungen->Sonstiges->Tech->Tech: \u00dcberlappung";
    private static final String CHECK_SONSTIGES_UGHZ_UGHZ__ATTRIBUTE = "Pr\u00fcfungen->Sonstiges->Ughz->Ughz: Attribute";
    private static final String CHECK_SONSTIGES_FOTO_FOTO__ATTRIBUTE = "Pr\u00fcfungen->Sonstiges->Foto->Foto: Attribute";
    private static final String CHECK_SONSTIGES_TECH_TECH_FALSCH_AUF_GES = "Pr\u00fcfungen->Sonstiges->Tech->Tech: falsch auf geschlossenem Gerinne";
    private static final String CHECK_SONSTIGES_TECH_TECH_FALSCH_AUF_OFF = "Pr\u00fcfungen->Sonstiges->Tech->Tech: falsch auf offenem Gerinne";
    private static final String CHECK_SONSTIGES_TECH_TECH_D_NICHT_AUF_DD = "Pr\u00fcfungen->Sonstiges->Tech->Tech: d nicht auf d";
    private static final String CHECK_SONSTIGES_TECH_TECH_V_NICHT_AUF_RL = "Pr\u00fcfungen->Sonstiges->Tech->Tech: v nicht auf rl";
    private static final String CHECK_SONSTIGES_TECH_TECH_DUE_NICHT_AUF_DUE = "Pr\u00fcfungen->Sonstiges->Tech->Tech: due nicht auf due";
    private static final String CHECK_SONSTIGES_TECH_TECH__ATTRIBUTE = "Pr\u00fcfungen->Sonstiges->Tech->Tech: Attribute";
    private static final String CHECK_SONSTIGES_LEIS_LEIS__ESW_FUER_GESCHL = "Pr\u00fcfungen->Sonstiges->Leis->Leis: Esw f\u00fcr geschlossenes Gerinne";
    private static final String CHECK_SONSTIGES_LEIS_LEIS__ATTRIBUTE = "Pr\u00fcfungen->Sonstiges->Leis->Leis: Attribute";
    private static final String CHECK_SONSTIGES_WIWE_WIWE__LUECKE = "Pr\u00fcfungen->Sonstiges->Wiwe->Wiwe: L\u00fccke";
    private static final String CHECK_SONSTIGES_WIWE_WIWE__ATTRIBUTE = "Pr\u00fcfungen->Sonstiges->Wiwe->Wiwe: Attribute";
    private static final String CHECK_SONSTIGES_DEICH_DEICH_KREUZT_OFFEN = "Pr\u00fcfungen->Sonstiges->Deich->Deich: kreuzt offenes Gerinne";
    private static final String CHECK_SONSTIGES_DEICH_DEICH__ATTRIBUTE = "Pr\u00fcfungen->Sonstiges->Deich->Deich: Attribute";
    private static final String CHECK_SONSTIGES_DEICH_DEICH__LUECKE = "Pr\u00fcfungen->Sonstiges->Deich->Deich: L\u00fccke";
    private static final int[] USED_CLASS_IDS;
    private static final String[] ALL_CHECKS;
    private boolean successful = true;

    public SonstigeCheckAction() {
        this(false);
    }

    public SonstigeCheckAction(boolean isBackgroundCheck) {
        super(isBackgroundCheck);
        String tooltip = NbBundle.getMessage(SonstigeCheckAction.class, (String)"SonstigeCheckAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(SonstigeCheckAction.class, (String)"SonstigeCheckAction.text");
        this.putValue("Name", text);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-zoom.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public int getProgressSteps() {
        return 14;
    }

    @Override
    public boolean startCheckInternal(final boolean isExport, WaitDialog wd, List<H2FeatureService> result) {
        if (isExport) {
            try {
                CheckResult cr = this.check(isExport, wd);
                if (result != null) {
                    this.addService(result, cr.getAttributesUghz());
                    this.addService(result, cr.getAttributesLeis());
                    this.addService(result, cr.getAttributesTech());
                    this.addService(result, cr.getGapTech());
                    this.addService(result, cr.getGerinneLeis());
                    this.addService(result, cr.getOverlappedTech());
                    this.addService(result, cr.getdTech());
                    this.addService(result, cr.getvTech());
                    this.addService(result, cr.getdueTech());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while performing check", (Throwable)e);
                return false;
            }
            return true;
        }
        WaitingDialogThread<CheckResult> wdt = new WaitingDialogThread<CheckResult>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(SonstigeCheckAction.class, (String)"SonstigeCheckAction.actionPerformed().dialog"), null, 100){

            protected CheckResult doInBackground() throws Exception {
                this.wd.setMax(SonstigeCheckAction.this.getProgressSteps());
                return SonstigeCheckAction.this.check(isExport, this.wd);
            }

            protected void done() {
                try {
                    CheckResult result = (CheckResult)this.get();
                    SonstigeCheckAction.this.removeServicesFromLayerModel(ALL_CHECKS);
                    if (isExport) {
                        return;
                    }
                    if (result.getProblemTreeObjectCount() == null || result.getProblemTreeObjectCount().getCount() == 0) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(SonstigeCheckAction.class, (String)"SonstigeCheckAction.actionPerformed().result.text.withoutProblems", (Object[])new Object[]{result.getBakCount(), result.getAttributesWiweErrors(), result.getAttributesUghzErrors(), result.getAttributesFotoErrors(), result.getAttributesLeisErrors(), result.getAttributesTechErrors(), result.getGapWiweErrors(), result.getGapTechErrors(), result.getOverlappedTechErrors(), result.getGerinneWiweErrors(), result.getGerinneLeisErrors(), result.getOffGerinneTechErrors() + result.getGeschGerinneTechErrors() + result.getdTechErrors() + result.getvTechErrors() + result.getDueTechErrors(), 0}), NbBundle.getMessage(SonstigeCheckAction.class, (String)"SonstigeCheckAction.actionPerformed().result.title"), 1);
                    } else {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(SonstigeCheckAction.class, (String)"SonstigeCheckAction.actionPerformed().result.text", (Object[])new Object[]{result.getBakCount(), result.getAttributesWiweErrors(), result.getAttributesUghzErrors(), result.getAttributesFotoErrors(), result.getAttributesLeisErrors(), result.getAttributesTechErrors(), result.getGapWiweErrors(), result.getGapTechErrors(), result.getOverlappedTechErrors(), result.getGerinneWiweErrors(), result.getGerinneLeisErrors(), result.getOffGerinneTechErrors() + result.getGeschGerinneTechErrors() + result.getdTechErrors() + result.getvTechErrors() + result.getDueTechErrors(), result.getProblemTreeObjectCount().getCount(), result.getProblemTreeObjectCount().getClasses()}), NbBundle.getMessage(SonstigeCheckAction.class, (String)"SonstigeCheckAction.actionPerformed().result.title"), 1);
                    }
                    if (result.getvTech() != null) {
                        SonstigeCheckAction.this.showService(result.getvTech());
                    }
                    if (result.getdTech() != null) {
                        SonstigeCheckAction.this.showService(result.getdTech());
                    }
                    if (result.getdueTech() != null) {
                        SonstigeCheckAction.this.showService(result.getdueTech());
                    }
                    if (result.getGeschGerinneTech() != null) {
                        SonstigeCheckAction.this.showService(result.getGeschGerinneTech());
                    }
                    if (result.getOffGerinneTech() != null) {
                        SonstigeCheckAction.this.showService(result.getOffGerinneTech());
                    }
                    if (result.getOverlappedTech() != null) {
                        SonstigeCheckAction.this.showService(result.getOverlappedTech());
                    }
                    if (result.getGapTech() != null) {
                        SonstigeCheckAction.this.showService(result.getGapTech());
                    }
                    if (result.getAttributesTech() != null) {
                        SonstigeCheckAction.this.showService(result.getAttributesTech());
                    }
                    if (result.getGerinneLeis() != null) {
                        SonstigeCheckAction.this.showService(result.getGerinneLeis());
                    }
                    if (result.getAttributesLeis() != null) {
                        SonstigeCheckAction.this.showService(result.getAttributesLeis());
                    }
                    if (result.getAttributesFoto() != null) {
                        SonstigeCheckAction.this.showService(result.getAttributesFoto());
                    }
                    if (result.getAttributesUghz() != null) {
                        SonstigeCheckAction.this.showService(result.getAttributesUghz());
                    }
                    if (result.getGerinneWiwe() != null) {
                        SonstigeCheckAction.this.showService(result.getGerinneWiwe());
                    }
                    if (result.getGapWiwe() != null) {
                        SonstigeCheckAction.this.showService(result.getGapWiwe());
                    }
                    if (result.getAttributesWiwe() != null) {
                        SonstigeCheckAction.this.showService(result.getAttributesWiwe());
                    }
                    if (result.getGerinneDeich() != null) {
                        SonstigeCheckAction.this.showService(result.getGerinneDeich());
                    }
                    if (result.getGapDeich() != null) {
                        SonstigeCheckAction.this.showService(result.getGapDeich());
                    }
                    if (result.getAttributesDeich() != null) {
                        SonstigeCheckAction.this.showService(result.getAttributesDeich());
                    }
                    SonstigeCheckAction.this.refreshTree();
                    SonstigeCheckAction.this.refreshMap();
                }
                catch (Exception e) {
                    AbstractCheckAction.LOG.error((Object)"Error while performing the sonstige analyse.", (Throwable)e);
                    SonstigeCheckAction.this.successful = false;
                }
            }
        };
        wdt.start();
        return this.successful;
    }

    @Override
    protected CheckResult check(boolean isExport, WaitDialog wd) throws Exception {
        String expCondition;
        ArrayList innerList;
        CheckResult result = new CheckResult();
        String user = AppBroker.getInstance().getOwner();
        int[] selectedIds = this.getSelectedIds(isExport);
        if (user.equalsIgnoreCase("Administratoren")) {
            user = null;
        }
        this.removeServicesFromDb(ALL_CHECKS);
        ArrayList countList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new FgBakCount(user, selectedIds, null));
        if (countList != null && !countList.isEmpty() && (innerList = (ArrayList)countList.get(0)) != null && !innerList.isEmpty() && innerList.get(0) instanceof Number) {
            result.setBakCount(((Number)innerList.get(0)).intValue());
        }
        ArrayList<FeatureServiceAttribute> serviceAttributeDefinition = new ArrayList<FeatureServiceAttribute>();
        FeatureServiceAttribute serviceAttribute = new FeatureServiceAttribute("id", String.valueOf(4), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("geom", String.valueOf(10012), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ww_gr", String.valueOf(4), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_cd", String.valueOf(12), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_von", String.valueOf(8), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_bis", String.valueOf(8), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("laenge", String.valueOf(8), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_date", String.valueOf(93), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_user", String.valueOf(12), true);
        serviceAttributeDefinition.add(serviceAttribute);
        boolean useExpCond = user != null;
        boolean export = isExport && useExpCond;
        String string = expCondition = isExport && useExpCond ? " exists(select id from dlm25w.fg_ba_exp_complete where owner = '" + user + "' and bak_id = bak.id)" : "false";
        if (!isExport) {
            result.setAttributesWiwe(this.analyseByQuery(GU_WIWE, String.format(QUERY_WIWE_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds)), CHECK_SONSTIGES_WIWE_WIWE__ATTRIBUTE));
            this.increaseProgress(wd, 1);
            result.setGapWiwe(this.analyseByQuery(GU_WIWE, String.format(QUERY_WIWE_HOLE, SQLFormatter.createSqlArrayString((int[])selectedIds)), CHECK_SONSTIGES_WIWE_WIWE__LUECKE));
            this.increaseProgress(wd, 1);
        } else {
            this.increaseProgress(wd, 6);
        }
        result.setProblemTreeObjectCount(this.getErrorObjectsFromTree(user, selectedIds, USED_CLASS_IDS, isExport));
        String query = useExpCond ? String.format(QUERY_LEIS_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_LEIS_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setAttributesLeis(this.analyseByQuery(FG_BA_LEIS, query, CHECK_SONSTIGES_LEIS_LEIS__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        result.setGerinneLeis(this.analyseByCustomSearch((CidsServerSearch)new LeisEswGeschWrongPlace(user, selectedIds, export), CHECK_SONSTIGES_LEIS_LEIS__ESW_FUER_GESCHL, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_TECH_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_TECH_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setAttributesTech(this.analyseByQuery(FG_BA_TECH, query, CHECK_SONSTIGES_TECH_TECH__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        result.setvTech(this.analyseByCustomSearch((CidsServerSearch)new TechVWrongPlace(user, selectedIds, export), CHECK_SONSTIGES_TECH_TECH_V_NICHT_AUF_RL, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setdTech(this.analyseByCustomSearch((CidsServerSearch)new TechDWrongPlace(user, selectedIds, export), CHECK_SONSTIGES_TECH_TECH_D_NICHT_AUF_DD, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setdueTech(this.analyseByCustomSearch((CidsServerSearch)new TechDueWrongPlace(user, selectedIds, export), CHECK_SONSTIGES_TECH_TECH_DUE_NICHT_AUF_DUE, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setOffGerinneTech(this.analyseByCustomSearch((CidsServerSearch)new TechOffWrongPlace(user, selectedIds, export), CHECK_SONSTIGES_TECH_TECH_FALSCH_AUF_OFF, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setGeschGerinneTech(this.analyseByCustomSearch((CidsServerSearch)new TechGeschWrongPlace(user, selectedIds, export), CHECK_SONSTIGES_TECH_TECH_FALSCH_AUF_GES, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        if (!isExport) {
            result.setAttributesFoto(this.analyseByQuery(FOTO, String.format(QUERY_FOTO_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds)), CHECK_SONSTIGES_FOTO_FOTO__ATTRIBUTE));
        }
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_UGHZ_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_UGHZ_ATTR, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setAttributesUghz(this.analyseByQuery(FG_BA_UGHZ, query, CHECK_SONSTIGES_UGHZ_UGHZ__ATTRIBUTE));
        this.increaseProgress(wd, 1);
        result.setOverlappedTech(this.analyseByCustomSearch((CidsServerSearch)new OverlappedTech(user, selectedIds, export), CHECK_SONSTIGES_TECH_TECH__UEBERLAPPUNG, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setGapTech(this.analyseByCustomSearch((CidsServerSearch)new TechWithHole(user, selectedIds, export), CHECK_SONSTIGES_TECH_TECH__LUECKE, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        if (result.getAttributesDeich() != null) {
            result.setAttributesDeichErrors(result.getAttributesDeich().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getAttributesFoto() != null) {
            result.setAttributesFotoErrors(result.getAttributesFoto().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getAttributesLeis() != null) {
            result.setAttributesLeisErrors(result.getAttributesLeis().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getAttributesTech() != null) {
            result.setAttributesTechErrors(result.getAttributesTech().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getAttributesUghz() != null) {
            result.setAttributesUghzErrors(result.getAttributesUghz().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getAttributesWiwe() != null) {
            result.setAttributesWiweErrors(result.getAttributesWiwe().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getGapDeich() != null) {
            result.setGapDeichErrors(result.getGapDeich().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getGapTech() != null) {
            result.setGapTechErrors(result.getGapTech().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getGapWiwe() != null) {
            result.setGapWiweErrors(result.getGapWiwe().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getGerinneDeich() != null) {
            result.setGerinneDeichErrors(result.getGerinneDeich().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getGerinneLeis() != null) {
            result.setGerinneLeisErrors(result.getGerinneLeis().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getGerinneWiwe() != null) {
            result.setGerinneWiweErrors(result.getGerinneWiwe().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getGeschGerinneTech() != null) {
            result.setGeschGerinneTechErrors(result.getGeschGerinneTech().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getOffGerinneTech() != null) {
            result.setOffGerinneTechErrors(result.getOffGerinneTech().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getOverlappedTech() != null) {
            result.setOverlappedTechErrors(result.getOverlappedTech().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getdTech() != null) {
            result.setdTechErrors(result.getdTech().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getvTech() != null) {
            result.setvTechErrors(result.getvTech().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getdueTech() != null) {
            result.setDueTechErrors(result.getdueTech().getFeatureCount(null));
            this.successful = false;
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    static {
        USED_CLASS_IDS = new int[]{GU_WIWE != null ? GU_WIWE.getId() : -1, FG_BA_UGHZ != null ? FG_BA_UGHZ.getId() : -1, FG_BA_LEIS != null ? FG_BA_LEIS.getId() : -1, FG_BA_TECH != null ? FG_BA_TECH.getId() : -1, FOTO != null ? FOTO.getId() : -1, FG_BA_RL != null ? FG_BA_RL.getId() : -1, FG_BA_D != null ? FG_BA_D.getId() : -1, FG_BA_DUE != null ? FG_BA_DUE.getId() : -1};
        ALL_CHECKS = new String[]{CHECK_SONSTIGES_TECH_TECH__LUECKE, CHECK_SONSTIGES_TECH_TECH__UEBERLAPPUNG, CHECK_SONSTIGES_UGHZ_UGHZ__ATTRIBUTE, CHECK_SONSTIGES_FOTO_FOTO__ATTRIBUTE, CHECK_SONSTIGES_TECH_TECH_FALSCH_AUF_GES, CHECK_SONSTIGES_TECH_TECH_FALSCH_AUF_OFF, CHECK_SONSTIGES_TECH_TECH_D_NICHT_AUF_DD, CHECK_SONSTIGES_TECH_TECH_DUE_NICHT_AUF_DUE, CHECK_SONSTIGES_TECH_TECH_V_NICHT_AUF_RL, CHECK_SONSTIGES_TECH_TECH__ATTRIBUTE, CHECK_SONSTIGES_LEIS_LEIS__ESW_FUER_GESCHL, CHECK_SONSTIGES_LEIS_LEIS__ATTRIBUTE, CHECK_SONSTIGES_WIWE_WIWE__LUECKE, CHECK_SONSTIGES_WIWE_WIWE__ATTRIBUTE};
        if (GU_WIWE != null && FG_BA_UGHZ != null && FG_BA_LEIS != null && FG_BA_TECH != null) {
            User user = SessionManager.getSession().getUser();
            QUERY_WIWE_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + GU_WIWE.getID() + ", w." + GU_WIWE.getPrimaryKey() + "\tfrom dlm25w.gu_wiwe w\n\tleft join geom g on (w.geom = g.id)\n\tleft join dlm25w.k_wiwe kw on (w.wiwe = kw.id)\n\tleft join dlm25w.k_material m on (w.material = m.id)\nwhere w.wiwe is null or obj_nr is null or (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br is not null and (br < 0 or br > 30)) or st_length(g.geo_field) < 1\nor (kw.wiwe = 'Decke' and m.material not in ('As', 'B', 'Kies','Kies-wgRec','Rec-wg','Sand','Sand-wg','Scho','Scho-wg'))\nor (kw.wiwe in ('Decke-Pfl','Decke-Pl','Decke-Rg') and m.material <> 'B')\nor (kw.wiwe = 'Spur' and m.material not in ('As','B'))\nor (kw.wiwe in ('Spur-Pfl','Spur-Pl','Spur-Rg') and m.material <> 'B')" : "select " + GU_WIWE.getID() + ", w." + GU_WIWE.getPrimaryKey() + "\tfrom dlm25w.gu_wiwe w\n\tleft join geom g on (w.geom = g.id)\n\tleft join dlm25w.k_wiwe kw on (w.wiwe = kw.id)\n\tleft join dlm25w.k_material m on (w.material = m.id)\n\tleft join dlm25w.k_ww_gr gr on (w.ww_gr = gr.id)\nwhere (w.wiwe is null or obj_nr is null or (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br is not null and (br < 0 or br > 30)) or st_length(g.geo_field) < 1\nor (kw.wiwe = 'Decke' and m.material not in ('As', 'B', 'Kies','Kies-wgRec','Rec-wg','Sand','Sand-wg','Scho','Scho-wg'))\nor (kw.wiwe in ('Decke-Pfl','Decke-Pl','Decke-Rg') and m.material <> 'B')\nor (kw.wiwe = 'Spur' and m.material not in ('As','B'))\nor (kw.wiwe in ('Spur-Pfl','Spur-Pl','Spur-Rg') and m.material <> 'B')) and gr.owner = '" + user.getUserGroup().getName() + "'";
            QUERY_WIWE_HOLE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + GU_WIWE.getID() + ", d1." + GU_WIWE.getPrimaryKey() + "\tfrom (select d.id, g.geo_field geo from \n\tdlm25w.gu_wiwe d\n\tjoin geom g on (d.geom = g.id)\n\t) as d1,\n\t(select d.id, g.geo_field geo from \n\tdlm25w.gu_wiwe d\n\tjoin geom g on (d.geom = g.id)\n\t) as d2\nwhere d1.id <> d2.id and st_distance(dlm25w.endpunkte(d1.geo), dlm25w.endpunkte(d2.geo)) > 0.001 and st_distance(dlm25w.endpunkte(d1.geo), dlm25w.endpunkte(d2.geo)) < 0.5;" : "select distinct " + GU_WIWE.getID() + ", d1." + GU_WIWE.getPrimaryKey() + "\tfrom (select d.id, g.geo_field geo from \n\tdlm25w.gu_wiwe d\n\tjoin geom g on (d.geom = g.id)\njoin dlm25w.k_ww_gr gr on (d.ww_gr = gr.id) where gr.owner = '" + user.getUserGroup().getName() + "'\n\t) as d1,\n\t(select d.id, g.geo_field geo from \n\tdlm25w.gu_wiwe d\n\tjoin geom g on (d.geom = g.id)\n\t) as d2\nwhere d1.id <> d2.id and st_distance(dlm25w.endpunkte(d1.geo), dlm25w.endpunkte(d2.geo)) > 0.001 and st_distance(dlm25w.endpunkte(d1.geo), dlm25w.endpunkte(d2.geo)) < 0.5;";
            QUERY_LEIS_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_LEIS.getID() + ", l." + FG_BA_LEIS.getPrimaryKey() + " from dlm25w.fg_ba_leis l\n\tjoin dlm25w.fg_ba_linie linie on (l.ba_st = linie.id)\n\tjoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\n\tjoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\n\tjoin dlm25w.fg_ba ba on (von.route = ba.id)\n\tjoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nwhere (%1$s is null or von.route = any(%1$s)) and ((leis is null or obj_nr is null or l_rl is null or abs(von.wert - bis.wert) < 0.5) or (l.esw is not null and (l.esw < 0 or l.esw > 1)) )" : "select " + FG_BA_LEIS.getID() + ", l." + FG_BA_LEIS.getPrimaryKey() + " from dlm25w.fg_ba_leis l\n\tjoin dlm25w.fg_ba_linie linie on (l.ba_st = linie.id)\n\tjoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\n\tjoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\n\tjoin dlm25w.fg_ba ba on (von.route = ba.id)\n\tjoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\n\tjoin dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or von.route = any(%1$s)) and ((leis is null or obj_nr is null or l_rl is null or abs(von.wert - bis.wert) < 0.5)  or (l.esw is not null and (l.esw < 0 or l.esw > 1)) ) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_TECH_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_TECH.getID() + ", t." + FG_BA_TECH.getPrimaryKey() + " from dlm25w.fg_ba_tech t\n\tjoin dlm25w.fg_ba_linie linie on (t.ba_st = linie.id)\n\tjoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\n\tjoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\n\tjoin dlm25w.fg_ba ba on (von.route = ba.id)\n\tjoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\nwhere (%1$s is null or von.route = any(%1$s)) and (obj_nr is null or abs(von.wert - bis.wert) < 0.5)" : "select " + FG_BA_TECH.getID() + ", t." + FG_BA_TECH.getPrimaryKey() + " from dlm25w.fg_ba_tech t\n\tjoin dlm25w.fg_ba_linie linie on (t.ba_st = linie.id)\n\tjoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\n\tjoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\n\tjoin dlm25w.fg_ba ba on (von.route = ba.id)\n\tjoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\n\tjoin dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or von.route = any(%1$s)) and (obj_nr is null or abs(von.wert - bis.wert) < 0.5) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_FOTO_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FOTO.getID() + ", f." + FOTO.getPrimaryKey() + " from dlm25w.foto f\n\tleft join dlm25w.fg_ba_punkt von on (f.ba_st = von.id)\n\tleft join dlm25w.fg_ba ba on (von.route = ba.id)\n\tleft join dlm25w.fg_bak bak on (ba.bak_id = bak.id)\n\tleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or von.route = any(%1$s)) and (foto_nr is null or winkel < 0 or winkel > 360 or foto is null \nor freigabe is null or upl_name is null or upl_datum is null or upl_zeit is null or (aufn_datum is not null and ( date_part('year', aufn_datum) < 1900 or date_part('year', aufn_datum) > date_part('year', now()) ) ))" : "select " + FOTO.getID() + ", f." + FOTO.getPrimaryKey() + " from dlm25w.foto f\n\tleft join dlm25w.fg_ba_punkt von on (f.ba_st = von.id)\n\tleft join dlm25w.fg_ba ba on (von.route = ba.id)\n\tleft join dlm25w.fg_bak bak on (ba.bak_id = bak.id)\n\tleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or von.route = any(%1$s)) and (foto_nr is null or winkel < 0 or winkel > 360 or foto is null \nor freigabe is null or upl_name is null or upl_datum is null or upl_zeit is null or (aufn_datum is not null and ( date_part('year', aufn_datum) < 1900 or date_part('year', aufn_datum) > date_part('year', now()) ) ))  and gr.owner = '" + user.getUserGroup().getName() + "'";
            QUERY_UGHZ_ATTR = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BA_UGHZ.getID() + ", u." + FG_BA_UGHZ.getPrimaryKey() + " from dlm25w.fg_ba_ughz u\n\tjoin dlm25w.fg_ba_linie linie on (u.ba_st = linie.id)\n\tjoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\n\tjoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\n\tjoin dlm25w.fg_ba ba on (von.route = ba.id)\n\tjoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\n\tjoin dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or von.route = any(%1$s)) and (l_rl is null or ughz is null or obj_nr is null \nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br is not null and (br < 0 or br > 30))\nor (ho_d_o is not null and (ho_d_o < 0 or ho_d_o > 15))\nor (ho_d_u is not null and (ho_d_u < 0 or ho_d_u > 15))\nor abs(von.wert - bis.wert) < 0.5\n or (u.esw is not null and (u.esw < 0 or u.esw > 1)) or (ho_d_o is not null and ho_d_u is not null and ho_d_o <= ho_d_u))" : "select " + FG_BA_UGHZ.getID() + ", u." + FG_BA_UGHZ.getPrimaryKey() + " from dlm25w.fg_ba_ughz u\n\tjoin dlm25w.fg_ba_linie linie on (u.ba_st = linie.id)\n\tjoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\n\tjoin dlm25w.fg_ba_punkt bis on (linie.bis = bis.id)\n\tjoin dlm25w.fg_ba ba on (von.route = ba.id)\n\tjoin dlm25w.fg_bak bak on (ba.bak_id = bak.id)\n\tjoin dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or von.route = any(%1$s)) and (l_rl is null or ughz is null or obj_nr is null \nor (ausbaujahr is not null and (ausbaujahr < 1800 or ausbaujahr > date_part('year', now()) + 2))\nor (br is not null and (br < 0 or br > 30))\nor (ho_d_o is not null and (ho_d_o < 0 or ho_d_o > 15))\nor (ho_d_u is not null and (ho_d_u < 0 or ho_d_u > 15))\nor abs(von.wert - bis.wert) < 0.5\n or (u.esw is not null and (u.esw < 0 or u.esw > 1)) or (ho_d_o is not null and ho_d_u is not null and ho_d_o <= ho_d_u)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
        }
    }

    protected static class CheckResult
    extends AbstractCheckResult {
        private static final String[] CHECK_NAMES = new String[]{"ATTRIBUTES_DEICH", "GAP_DEICH", "GERINNE_DEICH", "ATTRIBUTES_WIWE", "GAP_WIWE", "GERINNE_WIWE", "ATTRIBUTES_UGHZ", "ATTRIBUTES_Foto", "ATTRIBUTES_LEIS", "GERINNE_LEIS", "ATTRIBUTES_TECH", "GAP_TECH", "OVERLAPPED_TECH", "GESCH_GERINNE_TECH", "OFF_GERINNE_TECH", "D_TECH", "V_TECH", "DUE_TECH"};
        private int bakCount;
        private int attributesDeichErrors;
        private int gapDeichErrors;
        private int gerinneDeichErrors;
        private int attributesWiweErrors;
        private int gapWiweErrors;
        private int gerinneWiweErrors;
        private int attributesUghzErrors;
        private int attributesFotoErrors;
        private int attributesLeisErrors;
        private int gerinneLeisErrors;
        private int attributesTechErrors;
        private int gapTechErrors;
        private int overlappedTechErrors;
        private int geschGerinneTechErrors;
        private int offGerinneTechErrors;
        private int dTechErrors;
        private int vTechErrors;
        private int dueTechErrors;
        private AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount;
        private H2FeatureService attributesDeich;
        private H2FeatureService gapDeich;
        private H2FeatureService gerinneDeich;
        private H2FeatureService attributesWiwe;
        private H2FeatureService gapWiwe;
        private H2FeatureService gerinneWiwe;
        private H2FeatureService attributesUghz;
        private H2FeatureService attributesFoto;
        private H2FeatureService attributesLeis;
        private H2FeatureService gerinneLeis;
        private H2FeatureService attributesTech;
        private H2FeatureService gapTech;
        private H2FeatureService overlappedTech;
        private H2FeatureService geschGerinneTech;
        private H2FeatureService offGerinneTech;
        private H2FeatureService dTech;
        private H2FeatureService dueTech;
        private H2FeatureService vTech;

        protected CheckResult() {
        }

        @Override
        public AbstractCheckAction.ProblemCountAndClasses getProblemTreeObjectCount() {
            return this.problemTreeObjectCount;
        }

        public void setProblemTreeObjectCount(AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount) {
            this.problemTreeObjectCount = problemTreeObjectCount;
        }

        public int getAttributesDeichErrors() {
            return this.attributesDeichErrors;
        }

        public void setAttributesDeichErrors(int attributesDeichErrors) {
            this.attributesDeichErrors = attributesDeichErrors;
        }

        public int getGapDeichErrors() {
            return this.gapDeichErrors;
        }

        public void setGapDeichErrors(int gapDeichErrors) {
            this.gapDeichErrors = gapDeichErrors;
        }

        public int getGerinneDeichErrors() {
            return this.gerinneDeichErrors;
        }

        public void setGerinneDeichErrors(int gerinneDeichErrors) {
            this.gerinneDeichErrors = gerinneDeichErrors;
        }

        public int getAttributesWiweErrors() {
            return this.attributesWiweErrors;
        }

        public void setAttributesWiweErrors(int attributesWiweErrors) {
            this.attributesWiweErrors = attributesWiweErrors;
        }

        public int getGapWiweErrors() {
            return this.gapWiweErrors;
        }

        public void setGapWiweErrors(int gapWiweErrors) {
            this.gapWiweErrors = gapWiweErrors;
        }

        public int getGerinneWiweErrors() {
            return this.gerinneWiweErrors;
        }

        public void setGerinneWiweErrors(int gerinneWiweErrors) {
            this.gerinneWiweErrors = gerinneWiweErrors;
        }

        public int getAttributesUghzErrors() {
            return this.attributesUghzErrors;
        }

        public void setAttributesUghzErrors(int attributesUghzErrors) {
            this.attributesUghzErrors = attributesUghzErrors;
        }

        public int getAttributesFotoErrors() {
            return this.attributesFotoErrors;
        }

        public void setAttributesFotoErrors(int attributesFotoErrors) {
            this.attributesFotoErrors = attributesFotoErrors;
        }

        public int getAttributesLeisErrors() {
            return this.attributesLeisErrors;
        }

        public void setAttributesLeisErrors(int attributesLeisErrors) {
            this.attributesLeisErrors = attributesLeisErrors;
        }

        public int getGerinneLeisErrors() {
            return this.gerinneLeisErrors;
        }

        public void setGerinneLeisErrors(int gerinneLeisErrors) {
            this.gerinneLeisErrors = gerinneLeisErrors;
        }

        public int getAttributesTechErrors() {
            return this.attributesTechErrors;
        }

        public void setAttributesTechErrors(int attributesTechErrors) {
            this.attributesTechErrors = attributesTechErrors;
        }

        public int getGapTechErrors() {
            return this.gapTechErrors;
        }

        public void setGapTechErrors(int gapTechErrors) {
            this.gapTechErrors = gapTechErrors;
        }

        public int getOverlappedTechErrors() {
            return this.overlappedTechErrors;
        }

        public void setOverlappedTechErrors(int overlappedTechErrors) {
            this.overlappedTechErrors = overlappedTechErrors;
        }

        public int getGeschGerinneTechErrors() {
            return this.geschGerinneTechErrors;
        }

        public void setGeschGerinneTechErrors(int geschGerinneTechErrors) {
            this.geschGerinneTechErrors = geschGerinneTechErrors;
        }

        public int getOffGerinneTechErrors() {
            return this.offGerinneTechErrors;
        }

        public void setOffGerinneTechErrors(int offGerinneTechErrors) {
            this.offGerinneTechErrors = offGerinneTechErrors;
        }

        public int getdTechErrors() {
            return this.dTechErrors;
        }

        public void setdTechErrors(int dTechErrors) {
            this.dTechErrors = dTechErrors;
        }

        public int getvTechErrors() {
            return this.vTechErrors;
        }

        public void setvTechErrors(int vTechErrors) {
            this.vTechErrors = vTechErrors;
        }

        public int getDueTechErrors() {
            return this.dueTechErrors;
        }

        public void setDueTechErrors(int dueTechErrors) {
            this.dueTechErrors = dueTechErrors;
        }

        public H2FeatureService getAttributesDeich() {
            return this.attributesDeich;
        }

        public void setAttributesDeich(H2FeatureService attributesDeich) {
            this.attributesDeich = attributesDeich;
        }

        public H2FeatureService getGapDeich() {
            return this.gapDeich;
        }

        public void setGapDeich(H2FeatureService gapDeich) {
            this.gapDeich = gapDeich;
        }

        public H2FeatureService getGerinneDeich() {
            return this.gerinneDeich;
        }

        public void setGerinneDeich(H2FeatureService gerinneDeich) {
            this.gerinneDeich = gerinneDeich;
        }

        public H2FeatureService getAttributesWiwe() {
            return this.attributesWiwe;
        }

        public void setAttributesWiwe(H2FeatureService attributesWiwe) {
            this.attributesWiwe = attributesWiwe;
        }

        public H2FeatureService getGapWiwe() {
            return this.gapWiwe;
        }

        public void setGapWiwe(H2FeatureService gapWiwe) {
            this.gapWiwe = gapWiwe;
        }

        public H2FeatureService getGerinneWiwe() {
            return this.gerinneWiwe;
        }

        public void setGerinneWiwe(H2FeatureService gerinneWiwe) {
            this.gerinneWiwe = gerinneWiwe;
        }

        public H2FeatureService getAttributesUghz() {
            return this.attributesUghz;
        }

        public void setAttributesUghz(H2FeatureService attributesUghz) {
            this.attributesUghz = attributesUghz;
        }

        public H2FeatureService getAttributesFoto() {
            return this.attributesFoto;
        }

        public void setAttributesFoto(H2FeatureService attributesFoto) {
            this.attributesFoto = attributesFoto;
        }

        public H2FeatureService getAttributesLeis() {
            return this.attributesLeis;
        }

        public void setAttributesLeis(H2FeatureService attributesLeis) {
            this.attributesLeis = attributesLeis;
        }

        public H2FeatureService getGerinneLeis() {
            return this.gerinneLeis;
        }

        public void setGerinneLeis(H2FeatureService gerinneLeis) {
            this.gerinneLeis = gerinneLeis;
        }

        public H2FeatureService getAttributesTech() {
            return this.attributesTech;
        }

        public void setAttributesTech(H2FeatureService attributesTech) {
            this.attributesTech = attributesTech;
        }

        public H2FeatureService getGapTech() {
            return this.gapTech;
        }

        public void setGapTech(H2FeatureService gapTech) {
            this.gapTech = gapTech;
        }

        public H2FeatureService getOverlappedTech() {
            return this.overlappedTech;
        }

        public void setOverlappedTech(H2FeatureService overlappedTech) {
            this.overlappedTech = overlappedTech;
        }

        public H2FeatureService getGeschGerinneTech() {
            return this.geschGerinneTech;
        }

        public void setGeschGerinneTech(H2FeatureService geschGerinneTech) {
            this.geschGerinneTech = geschGerinneTech;
        }

        public H2FeatureService getOffGerinneTech() {
            return this.offGerinneTech;
        }

        public void setOffGerinneTech(H2FeatureService offGerinneTech) {
            this.offGerinneTech = offGerinneTech;
        }

        public H2FeatureService getdTech() {
            return this.dTech;
        }

        public void setdTech(H2FeatureService dTech) {
            this.dTech = dTech;
        }

        public H2FeatureService getdueTech() {
            return this.dueTech;
        }

        public void setdueTech(H2FeatureService dueTech) {
            this.dueTech = dueTech;
        }

        public H2FeatureService getvTech() {
            return this.vTech;
        }

        public void setvTech(H2FeatureService vTech) {
            this.vTech = vTech;
        }

        public int getBakCount() {
            return this.bakCount;
        }

        public void setBakCount(int bakCount) {
            this.bakCount = bakCount;
        }

        @Override
        public String[] getCheckNames() {
            return CHECK_NAMES;
        }

        @Override
        public int getErrorsPerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.attributesDeichErrors;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.gapDeichErrors;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.gerinneDeichErrors;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.attributesWiweErrors;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.gapWiweErrors;
            }
            if (checkName.equals(CHECK_NAMES[5])) {
                return this.gerinneWiweErrors;
            }
            if (checkName.equals(CHECK_NAMES[6])) {
                return this.attributesUghzErrors;
            }
            if (checkName.equals(CHECK_NAMES[7])) {
                return this.attributesFotoErrors;
            }
            if (checkName.equals(CHECK_NAMES[8])) {
                return this.attributesLeisErrors;
            }
            if (checkName.equals(CHECK_NAMES[9])) {
                return this.gerinneLeisErrors;
            }
            if (checkName.equals(CHECK_NAMES[10])) {
                return this.attributesTechErrors;
            }
            if (checkName.equals(CHECK_NAMES[11])) {
                return this.gapTechErrors;
            }
            if (checkName.equals(CHECK_NAMES[12])) {
                return this.overlappedTechErrors;
            }
            if (checkName.equals(CHECK_NAMES[13])) {
                return this.geschGerinneTechErrors;
            }
            if (checkName.equals(CHECK_NAMES[14])) {
                return this.offGerinneTechErrors;
            }
            if (checkName.equals(CHECK_NAMES[15])) {
                return this.dTechErrors;
            }
            if (checkName.equals(CHECK_NAMES[16])) {
                return this.vTechErrors;
            }
            if (checkName.equals(CHECK_NAMES[17])) {
                return this.dueTechErrors;
            }
            return 0;
        }

        @Override
        public H2FeatureService getErrorTablePerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.attributesDeich;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.gapDeich;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.gerinneDeich;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.attributesWiwe;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.gapWiwe;
            }
            if (checkName.equals(CHECK_NAMES[5])) {
                return this.gerinneWiwe;
            }
            if (checkName.equals(CHECK_NAMES[6])) {
                return this.attributesUghz;
            }
            if (checkName.equals(CHECK_NAMES[7])) {
                return this.attributesFoto;
            }
            if (checkName.equals(CHECK_NAMES[8])) {
                return this.attributesLeis;
            }
            if (checkName.equals(CHECK_NAMES[9])) {
                return this.gerinneLeis;
            }
            if (checkName.equals(CHECK_NAMES[10])) {
                return this.attributesTech;
            }
            if (checkName.equals(CHECK_NAMES[11])) {
                return this.gapTech;
            }
            if (checkName.equals(CHECK_NAMES[12])) {
                return this.overlappedTech;
            }
            if (checkName.equals(CHECK_NAMES[13])) {
                return this.geschGerinneTech;
            }
            if (checkName.equals(CHECK_NAMES[14])) {
                return this.offGerinneTech;
            }
            if (checkName.equals(CHECK_NAMES[15])) {
                return this.dTech;
            }
            if (checkName.equals(CHECK_NAMES[16])) {
                return this.vTech;
            }
            if (checkName.equals(CHECK_NAMES[17])) {
                return this.dueTech;
            }
            return null;
        }
    }
}

