/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.foto;

import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.foto.ReportAction;
import de.cismet.watergis.gui.dialog.PhotoExportDialog;
import de.cismet.watergis.gui.panels.Photo;
import de.cismet.watergis.utils.FeatureServiceHelper;
import de.cismet.watergis.utils.JumpShapeWriter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ExportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ExportAction.class);

    public ExportAction() {
        String tooltip = NbBundle.getMessage(ExportAction.class, (String)"ExportAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(ExportAction.class, (String)"ExportAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(ExportAction.class, (String)"ExportAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-exportfile.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<FeatureServiceFeature> features;
        StaticSwingTools.showDialog((JDialog)PhotoExportDialog.getInstance());
        if (!PhotoExportDialog.getInstance().isCancelled() && !(features = FeatureServiceHelper.getSelectedCidsLayerFeatures("foto")).isEmpty()) {
            final File zipFile = new File(PhotoExportDialog.getInstance().getZipFile());
            final File tmpBaseDir = ExportAction.createTmpDirectory(zipFile.getParentFile());
            WaitingDialogThread<Boolean> wdt = new WaitingDialogThread<Boolean>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(ReportAction.class, (String)"ExportAction.actionPerformed.waitingDialog"), null, 100, true){

                protected Boolean doInBackground() throws Exception {
                    this.wd.setMax(features.size());
                    int i = 0;
                    this.wd.setText(NbBundle.getMessage(ReportAction.class, (String)"ExportAction.actionPerformed.progress", (Object)i, (Object)features.size()));
                    File tmpShapeDir = new File(tmpBaseDir, "Shape");
                    File tmpPhotoDir = new File(tmpBaseDir, "Fotos");
                    File tmpReportDir = new File(tmpBaseDir, "Steckbriefe");
                    if (PhotoExportDialog.getInstance().isPhotosSelected()) {
                        tmpPhotoDir.mkdirs();
                    }
                    if (PhotoExportDialog.getInstance().isReportSelected()) {
                        tmpReportDir.mkdirs();
                    }
                    if (PhotoExportDialog.getInstance().isShapeSelected()) {
                        tmpShapeDir.mkdirs();
                    }
                    for (Object feature : features) {
                        CidsLayerFeature cidsFeature = (CidsLayerFeature)feature;
                        if (Thread.interrupted()) {
                            return false;
                        }
                        if (PhotoExportDialog.getInstance().isPhotosSelected()) {
                            int count;
                            InputStream is = Photo.loadFileFromWebDav(cidsFeature, null);
                            File destFile = new File(tmpPhotoDir, (String)feature.getProperty("foto"));
                            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destFile));
                            BufferedInputStream bin = new BufferedInputStream(is);
                            byte[] tmp = new byte[256];
                            while ((count = bin.read(tmp)) != -1) {
                                os.write(tmp, 0, count);
                            }
                            is.close();
                            os.close();
                        }
                        if (Thread.interrupted()) {
                            return false;
                        }
                        if (PhotoExportDialog.getInstance().isReportSelected()) {
                            JasperPrint print = Photo.fillreport((CidsLayerFeature)feature);
                            print.setOrientation(print.getOrientationValue());
                            String photoFile = (String)feature.getProperty("foto");
                            photoFile = photoFile + ".pdf";
                            File file = new File(tmpReportDir, photoFile);
                            FileOutputStream fout = new FileOutputStream(file);
                            BufferedOutputStream out = new BufferedOutputStream(fout);
                            JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)out);
                            out.close();
                        }
                        this.wd.setText(NbBundle.getMessage(ReportAction.class, (String)"ExportAction.actionPerformed.progress", (Object)(++i), (Object)features.size()));
                        this.wd.setProgress(this.wd.getProgress() + 1);
                    }
                    if (Thread.interrupted()) {
                        return false;
                    }
                    if (PhotoExportDialog.getInstance().isShapeSelected()) {
                        this.wd.setText(NbBundle.getMessage(ReportAction.class, (String)"ExportAction.actionPerformed.createShape", (Object)(++i), (Object)features.size()));
                        ArrayList<String[]> attribList = new ArrayList<String[]>();
                        for (String attr : ((FeatureServiceFeature)features.get(0)).getLayerProperties().getFeatureService().getOrderedFeatureServiceAttributes()) {
                            String[] attrName = new String[]{attr, attr};
                            attribList.add(attrName);
                        }
                        File shapeFile = new File(tmpShapeDir, "fotos");
                        JumpShapeWriter shapeWriter = new JumpShapeWriter();
                        String charset = Charset.defaultCharset().name();
                        shapeWriter.writeShpFile(features.toArray(new FeatureServiceFeature[features.size()]), new File(shapeFile.toString() + ".shp"), null, charset);
                        BufferedWriter bw = new BufferedWriter(new FileWriter(shapeFile.getAbsolutePath() + ".prj"));
                        bw.write("PROJCS[\"ETRS_1989_UTM_Zone_33N_zE-N\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",33500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",5650]]");
                        bw.close();
                        BufferedWriter bwCpg = new BufferedWriter(new FileWriter(shapeFile.getAbsolutePath() + ".cpg"));
                        bwCpg.write(charset);
                        bwCpg.close();
                        de.cismet.watergis.gui.actions.gaf.ExportAction.downloadMetaDocument((CidsLayer)((FeatureServiceFeature)features.get(0)).getLayerProperties().getFeatureService(), shapeFile.getAbsolutePath());
                    }
                    if (Thread.interrupted()) {
                        return false;
                    }
                    this.wd.setText(NbBundle.getMessage(ReportAction.class, (String)"ExportAction.actionPerformed.createZip", (Object)(++i), (Object)features.size()));
                    ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(zipFile));
                    ExportAction.zipDirectory(tmpBaseDir, zipStream, "");
                    zipStream.close();
                    return true;
                }

                protected void done() {
                    try {
                        this.get();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while exporting photos.", (Throwable)e);
                    }
                    finally {
                        if (tmpBaseDir.exists()) {
                            ExportAction.deleteDirectory(tmpBaseDir);
                        }
                    }
                }
            };
            wdt.start();
        }
    }

    private static void deleteDirectory(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                ExportAction.deleteDirectory(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    private static File createTmpDirectory(File directorybase) {
        File tmpSubDirectory = null;
        String subDirName = null;
        Random rand = new Random(new Date().getTime());
        while ((tmpSubDirectory = new File(directorybase, subDirName = "tmp" + rand.nextInt(Integer.MAX_VALUE))).exists()) {
        }
        tmpSubDirectory.mkdirs();
        return tmpSubDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipDirectory(File inputDir, ZipOutputStream out, String dirName) throws Exception {
        int BYTES_ARRAY_LENGTH = 256;
        byte[] tmp = new byte[256];
        for (File f : inputDir.listFiles()) {
            if (f.isDirectory()) {
                String parent = dirName.equals("") ? "" : dirName + "/";
                ExportAction.zipDirectory(f, out, parent + f.getName() + "/");
                continue;
            }
            ZipEntry entry = new ZipEntry(dirName + f.getName());
            out.putNextEntry(entry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            try {
                int byteCount;
                while ((byteCount = bis.read(tmp, 0, 256)) != -1) {
                    out.write(tmp, 0, byteCount);
                }
            }
            finally {
                out.closeEntry();
                bis.close();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

