/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.foto;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.PhotoReportDialog;
import de.cismet.watergis.gui.panels.Photo;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ReportAction.class);

    public ReportAction() {
        String tooltip = NbBundle.getMessage(ReportAction.class, (String)"ReportAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(ReportAction.class, (String)"ReportAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(ReportAction.class, (String)"ReportAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-contact-businesscard.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StaticSwingTools.showDialog((JDialog)PhotoReportDialog.getInstance());
        if (!PhotoReportDialog.getInstance().isCancelled()) {
            final ArrayList<FeatureServiceFeature> features = new ArrayList<FeatureServiceFeature>();
            if (PhotoReportDialog.getInstance().isObjectRestrictionSelected()) {
                features.addAll(FeatureServiceHelper.getSelectedCidsLayerFeatures("foto"));
            }
            if (!features.isEmpty() || !PhotoReportDialog.getInstance().isObjectRestrictionSelected()) {
                WaitingDialogThread<Boolean> wdt = new WaitingDialogThread<Boolean>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(ReportAction.class, (String)"ReportAction.actionPerformed.waitingDialog"), null, 100, true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected Boolean doInBackground() throws Exception {
                        if (features.isEmpty()) {
                            CidsLayer layer = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.foto"));
                            layer.initAndWait();
                            features.addAll(layer.getFeatureFactory().createFeatures((Object)layer.getQuery(), null, null, 0, 0, null));
                        }
                        this.wd.setMax(features.size());
                        int i = 0;
                        this.wd.setText(NbBundle.getMessage(ReportAction.class, (String)"ReportAction.actionPerformed.progress", (Object)i, (Object)features.size()));
                        for (FeatureServiceFeature feature : features) {
                            try {
                                if (Thread.interrupted()) {
                                    Boolean bl = false;
                                    return bl;
                                }
                                JasperPrint print = Photo.fillreport((CidsLayerFeature)feature);
                                print.setOrientation(print.getOrientationValue());
                                String photoFile = (String)feature.getProperty("foto");
                                if (photoFile.contains(".")) {
                                    photoFile = photoFile.substring(0, photoFile.lastIndexOf("."));
                                }
                                photoFile = photoFile + ".pdf";
                                File file = new File(PhotoReportDialog.getInstance().getPath() + File.separator + photoFile);
                                if (Thread.interrupted()) {
                                    Boolean bl = false;
                                    return bl;
                                }
                                if (file.exists()) {
                                    // empty if block
                                }
                                FileOutputStream fout = new FileOutputStream(file);
                                BufferedOutputStream out = new BufferedOutputStream(fout);
                                JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)out);
                                out.close();
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Error while creating photo report", (Throwable)ex);
                            }
                            finally {
                                this.wd.setText(NbBundle.getMessage(ReportAction.class, (String)"ReportAction.actionPerformed.progress", (Object)(++i), (Object)features.size()));
                                this.wd.setProgress(this.wd.getProgress() + 1);
                            }
                        }
                        return true;
                    }

                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while create photo reports.", (Throwable)e);
                        }
                    }
                };
                wdt.start();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

