/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.gaf;

import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.panels.GafProf;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class DeleteAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(DeleteAction.class);

    public DeleteAction() {
        String tooltip = NbBundle.getMessage(DeleteAction.class, (String)"DeleteAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(DeleteAction.class, (String)"DeleteAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(DeleteAction.class, (String)"DeleteAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-circledelete.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("qp");
        int ans = JOptionPane.showConfirmDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(DeleteAction.class, (String)"DeleteAction.actionPerformed().text", (Object)features.size()), NbBundle.getMessage(DeleteAction.class, (String)"DeleteAction.actionPerformed().title"), 0);
        if (ans == 0 && !features.isEmpty()) {
            WaitingDialogThread<Boolean> wdt = new WaitingDialogThread<Boolean>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(DeleteAction.class, (String)"DeleteAction.actionPerformed.waitingDialog"), null, 100, true){

                protected Boolean doInBackground() throws Exception {
                    this.wd.setMax(features.size());
                    int i = 0;
                    this.wd.setText(NbBundle.getMessage(DeleteAction.class, (String)"DeleteAction.actionPerformed.progress", (Object)i, (Object)features.size()));
                    for (FeatureServiceFeature feature : features) {
                        if (Thread.interrupted()) {
                            return false;
                        }
                        GafProf.deleteProfile((CidsLayerFeature)feature);
                        this.wd.setText(NbBundle.getMessage(DeleteAction.class, (String)"DeleteAction.actionPerformed.progress", (Object)(++i), (Object)features.size()));
                    }
                    return true;
                }

                protected void done() {
                    try {
                        this.get();
                        SelectionManager.getInstance().removeSelectedFeatures(features);
                        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp");
                        services.addAll(FeatureServiceHelper.getCidsLayerServicesFromTree("qp_gaf_pp"));
                        for (AbstractFeatureService featureService : services) {
                            featureService.retrieve(true);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while deleting gaf profiles.", (Throwable)e);
                    }
                }
            };
            wdt.start();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

