/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.gaf;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.WatergisApp;
import de.cismet.watergis.gui.actions.gaf.CheckAction;
import de.cismet.watergis.gui.dialog.UploadQpDialog;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class UploadAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(UploadAction.class);

    public UploadAction() {
        String tooltip = NbBundle.getMessage(UploadAction.class, (String)"UploadAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(UploadAction.class, (String)"UploadAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(UploadAction.class, (String)"UploadAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-uploadalt.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UploadQpDialog.getInstance().setSize(195, 675);
        StaticSwingTools.showDialog((JDialog)UploadQpDialog.getInstance());
    }

    public static void handleErrors(String[] errors, File errorPath) throws IOException {
        UploadAction.handleCheckResults(errors, true, errorPath);
    }

    public static void handleHints(String[] hints, File errorPath) throws IOException {
        UploadAction.handleCheckResults(hints, false, errorPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleCheckResults(String[] hints, boolean errors, File errorPath) throws IOException {
        String fileName = errorPath.getName();
        if (fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.indexOf("."));
        }
        if (fileName.equals("")) {
            fileName = WatergisApp.getDIRECTORYPATH_WATERGIS() + "/gaf";
        }
        errorPath = errorPath.getParentFile();
        File errorFile = new File(errorPath, fileName + (errors ? "-fehler.txt" : "-hinweise.txt"));
        try (BufferedWriter bw = null;){
            bw = new BufferedWriter(new FileWriter(errorFile));
            for (String error : hints) {
                bw.write(error + System.lineSeparator());
            }
        }
        if (errors) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(CheckAction.class, (String)"CheckAction.actionPerformed().error.message"), NbBundle.getMessage(CheckAction.class, (String)"CheckAction.actionPerformed().error.title"), 1);
        } else {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(CheckAction.class, (String)"CheckAction.actionPerformed().hints.message"), NbBundle.getMessage(CheckAction.class, (String)"CheckAction.actionPerformed().hints.title"), 1);
        }
        DownloadManager.instance().add((Download)new FakeFileDownload(errorFile, "Pr\u00fcfergebnis"));
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

