/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.geoprocessing;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexedLine;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.geoprocessing.AbstractGeoprocessingAction;
import de.cismet.watergis.gui.dialog.MergeDialog;
import de.cismet.watergis.gui.dialog.StationDialog;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class TechProfAction
extends AbstractGeoprocessingAction {
    private static final List<String> TECH_ATTR = new ArrayList<String>();
    private static final List<String> PROF_ATTR = new ArrayList<String>();
    private static final Map<String, String> PROF_NAME_MAPPING = new HashMap<String, String>();
    private static final List<String> ATTRIBUTE_ORDER = new ArrayList<String>();
    private StationDialog dialog;

    public TechProfAction() {
        this.putValue("ShortDescription", this.getShortDescription());
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getSmallIcon());
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result = JOptionPane.showOptionDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(TechProfAction.class, (String)"TechProfAction.actionPerformed.message"), NbBundle.getMessage(TechProfAction.class, (String)"TechProfAction.actionPerformed.title"), 0, -1, null, new Object[]{"Weiter", "Abbrechen"}, null);
        if (result == 0 && (result = JOptionPane.showOptionDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(TechProfAction.class, (String)"TechProfAction.actionPerformed.message2"), NbBundle.getMessage(TechProfAction.class, (String)"TechProfAction.actionPerformed.title2"), 0, -1, null, new Object[]{"Verschneiden", "Abbrechen"}, null)) == 0) {
            WaitingDialogThread<H2FeatureService> wdt = new WaitingDialogThread<H2FeatureService>((Frame)AppBroker.getInstance().getWatergisApp(), true, "Erstelle Verschnitt                  ", null, 100, true){

                protected H2FeatureService doInBackground() throws Exception {
                    FeatureServiceAttribute attr;
                    int progress = 10;
                    this.wd.setText(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.butOkActionPerformed.doInBackground.retrieving"));
                    this.wd.setMax(100);
                    this.wd.setProgress(5);
                    if (Thread.interrupted()) {
                        return null;
                    }
                    CidsLayer tech = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_tech"));
                    CidsLayer prof = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_prof"));
                    String query = "dlm25wPk_ww_gr1.ww_gr = 3100";
                    tech.initAndWait();
                    List featureListTech = tech.getFeatureFactory().createFeatures((Object)"dlm25wPk_ww_gr1.ww_gr = 3100", null, null, 0, 0, null);
                    this.wd.setProgress(10);
                    prof.initAndWait();
                    List featureListProf = prof.getFeatureFactory().createFeatures((Object)"dlm25wPk_ww_gr1.ww_gr = 3100", null, null, 0, 0, null);
                    this.wd.setProgress(20);
                    if (Thread.interrupted()) {
                        return null;
                    }
                    ArrayList<FeatureServiceFeature> resultedFeatures = new ArrayList<FeatureServiceFeature>();
                    LayerProperties techLayerProperties = ((FeatureServiceFeature)featureListTech.get(0)).getLayerProperties();
                    LayerProperties profServiceLayerProperties = ((FeatureServiceFeature)featureListProf.get(0)).getLayerProperties();
                    HashMap featureServiceAttributesTech = new HashMap(techLayerProperties.getFeatureService().getFeatureServiceAttributes());
                    HashMap featureServiceAttributesProf = new HashMap(profServiceLayerProperties.getFeatureService().getFeatureServiceAttributes());
                    HashMap<String, FeatureServiceAttribute> newFeatureServiceAttributes = new HashMap<String, FeatureServiceAttribute>();
                    for (String key : featureServiceAttributesTech.keySet()) {
                        if (!TECH_ATTR.contains(key)) continue;
                        attr = ((FeatureServiceAttribute)featureServiceAttributesTech.get(key)).clone();
                        newFeatureServiceAttributes.put(key, attr);
                    }
                    for (String key : featureServiceAttributesProf.keySet()) {
                        if (!PROF_ATTR.contains(key)) continue;
                        attr = ((FeatureServiceAttribute)featureServiceAttributesProf.get(key)).clone();
                        if (PROF_NAME_MAPPING.get(key) != null) {
                            attr.setName((String)PROF_NAME_MAPPING.get(key));
                            newFeatureServiceAttributes.put((String)PROF_NAME_MAPPING.get(key), attr);
                            continue;
                        }
                        newFeatureServiceAttributes.put(key, attr);
                    }
                    LayerProperties newLayerProperties = techLayerProperties.clone();
                    int count = 0;
                    int totalCount = featureListTech.size();
                    newLayerProperties.setFeatureService((AbstractFeatureService)techLayerProperties.getFeatureService().clone());
                    newLayerProperties.getFeatureService().setFeatureServiceAttributes(newFeatureServiceAttributes);
                    this.wd.setText(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.butOkActionPerformed.doInBackground.createFeatures"));
                    for (FeatureServiceFeature techFeature : featureListTech) {
                        ++count;
                        String baCd = (String)techFeature.getProperty("ba_cd");
                        double von = (Double)techFeature.getProperty("ba_st_von");
                        double bis = (Double)techFeature.getProperty("ba_st_bis");
                        ArrayList<Part> parts = new ArrayList<Part>();
                        for (FeatureServiceFeature profFeature : featureListProf) {
                            double vonProf = (Double)profFeature.getProperty("ba_st_von");
                            double bisProf = (Double)profFeature.getProperty("ba_st_bis");
                            if (!baCd.equals(profFeature.getProperty("ba_cd")) || !(von <= bisProf) || !(bis >= vonProf) || !(Math.abs(Math.max(von, vonProf) - Math.min(bis, bisProf)) > 0.01)) continue;
                            parts.add(new Part(Math.max(von, vonProf), Math.min(bis, bisProf)));
                            resultedFeatures.add((FeatureServiceFeature)this.createNewFeature(profFeature, techFeature, von, bis, vonProf, bisProf, newLayerProperties));
                        }
                        Collections.sort(parts);
                        if (parts.isEmpty()) {
                            resultedFeatures.add((FeatureServiceFeature)this.createNewFeature(null, techFeature, von, bis, -1.0, -1.0, newLayerProperties));
                        } else {
                            double currentStat = von;
                            for (Part p : parts) {
                                if (currentStat < p.getFrom() - 0.01) {
                                    resultedFeatures.add((FeatureServiceFeature)this.createNewFeature(null, techFeature, currentStat, p.getFrom(), -1.0, -1.0, newLayerProperties));
                                }
                                currentStat = p.getTo();
                            }
                            if (currentStat < bis - 0.01) {
                                resultedFeatures.add((FeatureServiceFeature)this.createNewFeature(null, techFeature, currentStat, bis, -1.0, -1.0, newLayerProperties));
                            }
                        }
                        if (Thread.interrupted()) {
                            return null;
                        }
                        if (progress >= 20 + count * 70 / totalCount) continue;
                        progress = 20 + count * 70 / totalCount;
                        this.wd.setProgress(progress);
                    }
                    this.wd.setText(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.butOkActionPerformed.doInBackground.creatingDatasource"));
                    H2FeatureService.removeTableIfExists((String)"TechProf");
                    return FeatureServiceHelper.createNewService(AppBroker.getInstance().getWatergisApp(), resultedFeatures, "TechProf", new ArrayList<FeatureServiceAttribute>(newFeatureServiceAttributes.values()), ATTRIBUTE_ORDER);
                }

                protected void done() {
                    try {
                        H2FeatureService service = (H2FeatureService)this.get();
                        H2FeatureService newService = new H2FeatureService(service.getName(), service.getDatabasePath(), service.getTableName(), null);
                        if (service != null) {
                            AppBroker.getInstance().getMappingComponent().getMappingModel().removeLayer((RetrievalServiceLayer)service);
                            FeatureServiceHelper.addServiceLayerToTheTree((AbstractFeatureService)newService);
                        }
                    }
                    catch (Exception ex) {
                        AbstractGeoprocessingAction.LOG.error((Object)"Error while execute the merge operation.", (Throwable)ex);
                    }
                }

                private DefaultFeatureServiceFeature createNewFeature(FeatureServiceFeature profFeature, FeatureServiceFeature techFeature, double von, double bis, double vonProf, double bisProf, LayerProperties newLayerProperties) {
                    DefaultFeatureServiceFeature newFeature = new DefaultFeatureServiceFeature();
                    if (profFeature != null) {
                        newFeature.setProperty("id2", profFeature.getProperty("id"));
                        newFeature.setProperty("ww_gr2", profFeature.getProperty("ww_gr"));
                        newFeature.setProperty("l_st2", profFeature.getProperty("l_st"));
                        newFeature.setProperty("profil", profFeature.getProperty("profil"));
                        newFeature.setProperty("obj_nr2", profFeature.getProperty("obj_nr"));
                        newFeature.setProperty("obj_nr_gu2", profFeature.getProperty("obj_nr_gu2"));
                        newFeature.setProperty("traeger", profFeature.getProperty("traeger"));
                        newFeature.setProperty("traeger_gu", profFeature.getProperty("traeger_gu"));
                        newFeature.setProperty("wbbl", profFeature.getProperty("wbbl"));
                        newFeature.setProperty("ausbaujahr", profFeature.getProperty("ausbaujahr"));
                        newFeature.setProperty("zust_kl", profFeature.getProperty("zust_kl"));
                        newFeature.setProperty("bemerkung2", profFeature.getProperty("bemerkung"));
                        newFeature.setProperty("br", profFeature.getProperty("br"));
                        newFeature.setProperty("ho_e", profFeature.getProperty("ho_e"));
                        newFeature.setProperty("ho_a", profFeature.getProperty("ho_a"));
                        newFeature.setProperty("gefaelle", profFeature.getProperty("gefaelle"));
                        newFeature.setProperty("bv_re", profFeature.getProperty("bv_re"));
                        newFeature.setProperty("bh_re", profFeature.getProperty("bh_re"));
                        newFeature.setProperty("bl_re", profFeature.getProperty("bl_re"));
                        newFeature.setProperty("bv_li", profFeature.getProperty("bv_li"));
                        newFeature.setProperty("bh_li", profFeature.getProperty("bh_li"));
                        newFeature.setProperty("bl_li", profFeature.getProperty("bl_li"));
                        newFeature.setProperty("mw", profFeature.getProperty("mw"));
                        newFeature.setProperty("laenge2", profFeature.getProperty("laenge"));
                    } else {
                        vonProf = -1.0;
                        bisProf = Double.MAX_VALUE;
                    }
                    newFeature.setProperty("id", techFeature.getProperty("id"));
                    newFeature.setProperty("ww_gr", techFeature.getProperty("ww_gr"));
                    newFeature.setProperty("ba_cd", techFeature.getProperty("ba_cd"));
                    newFeature.setProperty("ba_st_von", (Object)Math.max(von, vonProf));
                    newFeature.setProperty("ba_st_bis", (Object)Math.min(bis, bisProf));
                    newFeature.setProperty("l_st", techFeature.getProperty("l_st"));
                    newFeature.setProperty("tech", techFeature.getProperty("tech"));
                    newFeature.setProperty("obj_nr", techFeature.getProperty("obj_nr"));
                    newFeature.setProperty("obj_nr_gu", techFeature.getProperty("obj_nr_gu"));
                    newFeature.setProperty("bemerkung", techFeature.getProperty("bemerkung"));
                    newFeature.setProperty("na_gu", techFeature.getProperty("na_gu"));
                    newFeature.setProperty("mahd_gu", techFeature.getProperty("mahd_gu"));
                    newFeature.setProperty("gu_gu", techFeature.getProperty("gu_gu"));
                    newFeature.setProperty("laenge", techFeature.getProperty("laenge"));
                    newFeature.setLayerProperties(newLayerProperties);
                    if (Math.max(von, vonProf) == von && Math.min(bis, bisProf) == bis) {
                        newFeature.setGeometry(techFeature.getGeometry());
                    } else if (Math.max(von, vonProf) == vonProf && Math.min(bis, bisProf) == bisProf) {
                        newFeature.setGeometry(profFeature.getGeometry());
                    } else {
                        LocationIndexedLine lineLIL;
                        double len;
                        Geometry g = null;
                        double realTechVon = (Double)techFeature.getProperty("ba_st_von");
                        if (von != realTechVon) {
                            g = techFeature.getGeometry();
                            len = bis - von;
                            lineLIL = new LocationIndexedLine(g);
                            LinearLocation startLoc = lineLIL.indexOf(lineLIL.extractPoint(lineLIL.getStartIndex(), von - realTechVon));
                            LinearLocation endLoc = lineLIL.getEndIndex();
                            g = lineLIL.extractLine(startLoc, endLoc);
                        } else if (Math.max(von, vonProf) == von) {
                            g = techFeature.getGeometry();
                        } else if (Math.max(von, vonProf) == vonProf) {
                            g = profFeature.getGeometry();
                        }
                        len = Math.min(bis, bisProf) - Math.max(von, vonProf);
                        lineLIL = new LengthIndexedLine(g);
                        newFeature.setGeometry(lineLIL.extractLine(0.0, len));
                    }
                    return newFeature;
                }

                class Part
                implements Comparable<Part> {
                    private double from;
                    private double to;

                    public Part(double from, double to) {
                        if (from > to) {
                            this.to = from;
                            this.from = to;
                        } else {
                            this.from = from;
                            this.to = to;
                        }
                    }

                    public double getFrom() {
                        return this.from;
                    }

                    public void setFrom(double from) {
                        this.from = from;
                    }

                    public double getTo() {
                        return this.to;
                    }

                    public void setTo(double to) {
                        this.to = to;
                    }

                    @Override
                    public int compareTo(Part o) {
                        return new Double(this.getFrom()).compareTo(o.getFrom());
                    }
                }
            };
            wdt.start();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public final String getName() {
        return "Verschnitt tech/prof";
    }

    @Override
    public final String getShortDescription() {
        return "Verschnitt tech/prof";
    }

    @Override
    public final ImageIcon getSmallIcon() {
        return new ImageIcon(TechProfAction.class.getResource("/de/cismet/watergis/res/icons16/icon-flickralt.png"));
    }

    @Override
    public int getSortOrder() {
        return 85;
    }

    static {
        TECH_ATTR.add("id");
        TECH_ATTR.add("geom");
        TECH_ATTR.add("ww_gr");
        TECH_ATTR.add("ba_cd");
        TECH_ATTR.add("ba_st_von");
        TECH_ATTR.add("ba_st_bis");
        TECH_ATTR.add("tech");
        TECH_ATTR.add("obj_nr");
        TECH_ATTR.add("obj_nr_gu");
        TECH_ATTR.add("na_gu");
        TECH_ATTR.add("mahd_gu");
        TECH_ATTR.add("gu_gu");
        TECH_ATTR.add("laenge");
        PROF_ATTR.add("profil");
        PROF_ATTR.add("ausbaujahr");
        PROF_ATTR.add("br");
        PROF_ATTR.add("bv_re");
        PROF_ATTR.add("bh_re");
        PROF_ATTR.add("bl_re");
        PROF_ATTR.add("bv_li");
        PROF_ATTR.add("bh_li");
        PROF_ATTR.add("bl_li");
        ATTRIBUTE_ORDER.add("id");
        ATTRIBUTE_ORDER.add("ww_gr");
        ATTRIBUTE_ORDER.add("geom");
        ATTRIBUTE_ORDER.add("ba_cd");
        ATTRIBUTE_ORDER.add("ba_st_von");
        ATTRIBUTE_ORDER.add("ba_st_bis");
        ATTRIBUTE_ORDER.add("tech");
        ATTRIBUTE_ORDER.add("obj_nr");
        ATTRIBUTE_ORDER.add("obj_nr_gu");
        ATTRIBUTE_ORDER.add("na_gu");
        ATTRIBUTE_ORDER.add("mahd_gu");
        ATTRIBUTE_ORDER.add("gu_gu");
        ATTRIBUTE_ORDER.add("laenge");
        ATTRIBUTE_ORDER.add("profil");
        ATTRIBUTE_ORDER.add("ausbaujahr");
        ATTRIBUTE_ORDER.add("br");
        ATTRIBUTE_ORDER.add("bv_re");
        ATTRIBUTE_ORDER.add("bh_re");
        ATTRIBUTE_ORDER.add("bl_re");
        ATTRIBUTE_ORDER.add("bv_li");
        ATTRIBUTE_ORDER.add("bh_li");
        ATTRIBUTE_ORDER.add("bl_li");
    }
}

