/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerWidget;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class CopyObjectAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(CopyObjectAction.class);

    public CopyObjectAction() {
        String tooltip = NbBundle.getMessage(CopyObjectAction.class, (String)"CopyObjectAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(CopyObjectAction.class, (String)"CopyObjectAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(CopyObjectAction.class, (String)"CopyObjectAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-copy.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ThemeLayerWidget tree = (ThemeLayerWidget)AppBroker.getInstance().getComponent(ComponentName.TREE);
        TreePath[] tps = tree.getSelectionPath();
        if (tps != null && tps.length == 1) {
            AbstractFeatureService service = (AbstractFeatureService)tps[0].getLastPathComponent();
            List features = SelectionManager.getInstance().getSelectedFeatures(service);
            ArrayList<FeatureServiceFeature> featureServiceFeatures = new ArrayList<FeatureServiceFeature>();
            for (Feature f : features) {
                if (!(f instanceof FeatureServiceFeature)) continue;
                featureServiceFeatures.add((FeatureServiceFeature)f);
            }
            AttributeTable.copySelectedFeaturesToClipboard(featureServiceFeatures);
            AppBroker.getInstance().getWatergisApp().topicTreeSelectionChanged(null);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

