/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.ClipboardWaitDialog;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.GeoLinkUrl;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class CreateGeoLinkAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(CreateGeoLinkAction.class);
    private ClipboardWaitDialog clipboarder;

    public CreateGeoLinkAction() {
        String tooltip = NbBundle.getMessage(CreateGeoLinkAction.class, (String)"CreateGeoLinkAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(CreateGeoLinkAction.class, (String)"CreateGeoLinkAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(CreateGeoLinkAction.class, (String)"CreateGeoLinkAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-link.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.clipboarder == null) {
            this.clipboarder = new ClipboardWaitDialog((Frame)AppBroker.getInstance().getWatergisApp(), true);
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                XBoundingBox bb = (XBoundingBox)AppBroker.getInstance().getMappingComponent().getCurrentBoundingBoxFromCamera();
                int port = AppBroker.getInstance().getWatergisApp().getHttpInterfacePort();
                String u = "http://localhost:" + port + "/gotoBoundingBox?x1=" + bb.getX1() + "&y1=" + bb.getY1() + "&x2=" + bb.getX2() + "&y2=" + bb.getY2();
                GeoLinkUrl url = new GeoLinkUrl(u);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(url, null);
                return null;
            }

            @Override
            protected void done() {
                CreateGeoLinkAction.this.clipboarder.dispose();
            }
        }.execute();
        StaticSwingTools.showDialog((JDialog)this.clipboarder);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

