/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.CustomAction;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.CleanUpAction;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class FlipAction
extends AbstractAction
implements CleanUpAction {
    private static final Logger LOG = Logger.getLogger(FlipAction.class);

    public FlipAction() {
        this.setEnabled(false);
        String tooltip = NbBundle.getMessage(FlipAction.class, (String)"FlipAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(FlipAction.class, (String)"FlipAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(FlipAction.class, (String)"FlipAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-fliphorizontal.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MappingComponent map = AppBroker.getInstance().getMappingComponent();
        Collection selectedFeature = map.getFeatureCollection().getSelectedFeatures();
        boolean invalidGeometryType = false;
        boolean geometryChanged = false;
        for (Feature feature : selectedFeature) {
            if (feature.getGeometry().getGeometryType().equals("LineString")) {
                if (!feature.isEditable()) continue;
                feature.setGeometry(feature.getGeometry().reverse());
                PFeature pf = (PFeature)map.getPFeatureHM().get(feature);
                if (pf != null) {
                    pf.refresh();
                    pf.visualize();
                }
                CismapBroker.getInstance().getMappingComponent().getMemUndo().addAction((CustomAction)new FeatureFlipAction(feature, map));
                geometryChanged = true;
                continue;
            }
            invalidGeometryType = true;
        }
        if (!geometryChanged && invalidGeometryType) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(FlipAction.class, (String)"FlipAction.actionPerformed.wrongGeometryType.text"), NbBundle.getMessage(FlipAction.class, (String)"FlipAction.actionPerformed.wrongGeometryType.title"), 0);
        }
        if (selectedFeature.isEmpty()) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(FlipAction.class, (String)"FlipAction.actionPerformed.nothingSelected.text"), NbBundle.getMessage(FlipAction.class, (String)"FlipAction.actionPerformed.nothingSelected.title"), 0);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void cleanUp() {
        ((DefaultFeatureCollection)AppBroker.getInstance().getMappingComponent().getFeatureCollection()).removeFeaturesByInstance(PureNewFeature.class);
    }

    private static class FeatureFlipAction
    implements CustomAction {
        private final Feature f;
        private final MappingComponent mc;

        public FeatureFlipAction(Feature f, MappingComponent mc) {
            this.f = f;
            this.mc = mc;
        }

        public void doAction() {
            Vector<Feature> v = new Vector<Feature>();
            PFeature pf = (PFeature)this.mc.getPFeatureHM().get(this.f);
            v.add(this.f);
            this.f.setGeometry(this.f.getGeometry().reverse());
            pf.visualize();
            ((DefaultFeatureCollection)this.mc.getFeatureCollection()).fireFeaturesChanged(v);
        }

        public String info() {
            return "Geometrie drehen";
        }

        public CustomAction getInverse() {
            return new FeatureFlipAction(this.f, this.mc);
        }

        public boolean featureConcerned(Feature feature) {
            return this.f != null && this.f.equals(feature);
        }
    }
}

