/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.StaticDecimalTools;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.gui.dialog.GotoDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class GoToAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(GoToAction.class);
    private ImageIcon pointIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/linRefPoint.png"));

    public GoToAction() {
        String tooltip = NbBundle.getMessage(GoToAction.class, (String)"GoToAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(GoToAction.class, (String)"GoToAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(GoToAction.class, (String)"GoToAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-map-marker.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Goto to position");
        }
        final MappingComponent mappingComponent = AppBroker.getInstance().getMappingComponent();
        XBoundingBox c = (XBoundingBox)mappingComponent.getCurrentBoundingBoxFromCamera();
        double x = (c.getX1() + c.getX2()) / 2.0;
        double y = (c.getY1() + c.getY2()) / 2.0;
        GotoDialog dialog = new GotoDialog(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getComponent(ComponentName.MAIN)), true);
        dialog.setXVal(StaticDecimalTools.round((double)x).replace('.', ','));
        dialog.setYVal(StaticDecimalTools.round((double)y).replace('.', ','));
        StaticSwingTools.showDialog((JDialog)dialog);
        if (!dialog.isCancelled()) {
            try {
                final Double gotoX = new Double(dialog.getXVal().replace(',', '.'));
                final Double gotoY = new Double(dialog.getYVal().replace(',', '.'));
                String currentCrsCode = CismapBroker.getInstance().getSrs().getCode();
                XBoundingBox bb = new XBoundingBox(gotoX.doubleValue(), gotoY.doubleValue(), gotoX.doubleValue(), gotoY.doubleValue(), currentCrsCode, mappingComponent.isInMetricSRS());
                mappingComponent.gotoBoundingBox((BoundingBox)bb, true, false, mappingComponent.getAnimationDuration());
                Timer t = new Timer();
                t.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        GoToAction.this.showPointInMap(mappingComponent, gotoX, gotoY);
                    }
                }, mappingComponent.getAnimationDuration());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void showPointInMap(MappingComponent mappingComponent, double x, double y) {
        DefaultStyledFeature styledFeature = new DefaultStyledFeature();
        String currentCrsCode = CismapBroker.getInstance().getSrs().getCode();
        int srid = CrsTransformer.extractSridFromCrs((String)currentCrsCode);
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), srid);
        styledFeature.setGeometry((Geometry)gf.createPoint(new Coordinate(x, y)));
        FeatureAnnotationSymbol fas = new FeatureAnnotationSymbol(this.pointIcon.getImage());
        fas.setSweetSpotX(0.5);
        fas.setSweetSpotY(0.5);
        styledFeature.setPointAnnotationSymbol(fas);
        mappingComponent.highlightFeature((Feature)styledFeature, 1500);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

