/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import de.cismet.cismap.DrawingManager;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.gui.WatergisApp;
import de.cismet.watergis.gui.actions.map.SaveDrawingsAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class LoadDrawingsAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(SaveDrawingsAction.class);

    public LoadDrawingsAction() {
        String tooltip = NbBundle.getMessage(LoadDrawingsAction.class, (String)"LoadDrawingsAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(LoadDrawingsAction.class, (String)"LoadDrawingsAction.text");
        this.putValue("Name", text);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-importfile.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file = StaticSwingTools.chooseFile((String)WatergisApp.getDIRECTORYPATH_WATERGIS(), (boolean)false, (String[])new String[]{"ze"}, (String)NbBundle.getMessage(LoadDrawingsAction.class, (String)"LoadDrawingsAction.actionPerformed.FileFilter.getDescription"), (Component)AppBroker.getInstance().getComponent(ComponentName.MAIN));
        if (file != null) {
            if (file.exists()) {
                try {
                    DrawingManager.getInstance().addFeatures(file);
                    DrawingManager.getInstance().loadFeatures();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while loading drawings.", (Throwable)ex);
                }
            } else {
                LOG.warn((Object)"Drawing file, which the user wanted to open, does not exist.");
                String message = NbBundle.getMessage(LoadDrawingsAction.class, (String)"LoadDrawingsAction.actionPerformed.fileDoesNotExist.message");
                String title = NbBundle.getMessage(LoadDrawingsAction.class, (String)"LoadDrawingsAction.actionPerformed.fileDoesNotExist.title");
                JOptionPane.showMessageDialog((Component)AppBroker.getInstance().getMappingComponent(), message, title, 1);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

