/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.merge;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import de.cismet.cids.custom.watergis.server.search.DetermineClosestRoute;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.LineAndStationCreator;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.math.geometry.StaticGeometryFunctions;
import de.cismet.watergis.gui.actions.merge.FeatureMerger;
import de.cismet.watergis.gui.actions.merge.MergeException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CidsLayerFeatureMerger
implements FeatureMerger {
    private static final Logger LOG = Logger.getLogger(CidsLayerFeatureMerger.class);
    private static final String[] POSSIBLE_LINE_PROP_NAMES = new String[]{"ba_st", "bak_st", "la_st", "lak_st", "sg_su_stat"};
    private LinearReferencingHelper linearReferencingHelper = FeatureRegistry.getInstance().getLinearReferencingSolver();

    @Override
    public Feature merge(Feature masterFeature, Feature childFeature) throws MergeException {
        Geometry mergedGeom;
        block19: {
            Geometry g = masterFeature.getGeometry();
            mergedGeom = g.union(childFeature.getGeometry());
            String originGeomType = masterFeature.getGeometry().getGeometryType();
            boolean isMulti = masterFeature.getGeometry().getGeometryType().toLowerCase().startsWith("multi");
            if (g.getGeometryType().toUpperCase().contains("LINE")) {
                LineMerger lineMerger = new LineMerger();
                lineMerger.add(mergedGeom);
                if (lineMerger.getMergedLineStrings().size() == 1) {
                    mergedGeom = lineMerger.getMergedLineStrings().toArray(new Geometry[1])[0];
                } else {
                    Geometry mergedGeomReverseOrder = masterFeature.getGeometry().union(childFeature.getGeometry().reverse());
                    LineMerger reverseOrderLineMerger = new LineMerger();
                    reverseOrderLineMerger.add(mergedGeomReverseOrder);
                    if (reverseOrderLineMerger.getMergedLineStrings().size() == 1) {
                        mergedGeom = reverseOrderLineMerger.getMergedLineStrings().toArray(new Geometry[1])[0];
                    }
                }
                if (!mergedGeom.getCoordinates()[0].equals((Object)g.getCoordinates()[0]) && !mergedGeom.getCoordinates()[mergedGeom.getCoordinates().length - 1].equals((Object)g.getCoordinates()[g.getCoordinates().length - 1])) {
                    mergedGeom = mergedGeom.reverse();
                }
            }
            if (isMulti) {
                mergedGeom = StaticGeometryFunctions.toMultiGeometry((Geometry)mergedGeom);
            }
            mergedGeom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
            if (((DefaultFeatureServiceFeature)masterFeature).getLayerProperties() == null || ((DefaultFeatureServiceFeature)masterFeature).getLayerProperties().getAttributeTableRuleSet() == null) {
                LOG.error((Object)"Cids layer has no layer properties");
                return null;
            }
            try {
                double tmpVal;
                CidsBean tmp;
                AttributeTableRuleSet ruleSet = ((DefaultFeatureServiceFeature)masterFeature).getLayerProperties().getAttributeTableRuleSet();
                Object origLineBean = null;
                String linePropertyName = null;
                for (String possibleName : POSSIBLE_LINE_PROP_NAMES) {
                    origLineBean = ((CidsLayerFeature)masterFeature).getBean().getProperty(possibleName);
                    if (!(origLineBean instanceof CidsBean)) continue;
                    linePropertyName = possibleName;
                    break;
                }
                if (linePropertyName == null) break block19;
                if (ruleSet.isCatThree()) {
                    ((CidsLayerFeature)masterFeature).removeStations();
                    ((CidsLayerFeature)masterFeature).setProperty(linePropertyName, null);
                    ((CidsLayerFeature)masterFeature).getBean().setProperty(linePropertyName, null);
                    FeatureCreator creator = ruleSet.getFeatureCreator();
                    if (creator instanceof LineAndStationCreator) {
                        LineAndStationCreator lineCreator = (LineAndStationCreator)creator;
                        MetaClass routeMc = lineCreator.getRouteClass();
                        String stationProperty = lineCreator.getStationProperty();
                        CidsLayerFeatureMerger.setCalculatedLine((FeatureServiceFeature)masterFeature, routeMc, this.linearReferencingHelper, mergedGeom, stationProperty);
                        ((CidsLayerFeature)masterFeature).initStations();
                    }
                    break block19;
                }
                CidsBean otherLineBean = (CidsBean)((CidsLayerFeature)childFeature).getBean().getProperty(linePropertyName);
                CidsBean masterFrom = this.linearReferencingHelper.getStationBeanFromLineBean((CidsBean)origLineBean, true);
                CidsBean masterTill = this.linearReferencingHelper.getStationBeanFromLineBean((CidsBean)origLineBean, false);
                CidsBean otherFrom = this.linearReferencingHelper.getStationBeanFromLineBean(otherLineBean, true);
                CidsBean otherTill = this.linearReferencingHelper.getStationBeanFromLineBean(otherLineBean, false);
                double masterFromVal = this.linearReferencingHelper.getLinearValueFromStationBean(masterFrom);
                double masterTillVal = this.linearReferencingHelper.getLinearValueFromStationBean(masterTill);
                double otherFromVal = this.linearReferencingHelper.getLinearValueFromStationBean(otherFrom);
                double otherTillVal = this.linearReferencingHelper.getLinearValueFromStationBean(otherTill);
                CidsBean masterRouteBean = this.linearReferencingHelper.getRouteBeanFromStationBean(masterFrom);
                CidsBean otherRouteBean = this.linearReferencingHelper.getRouteBeanFromStationBean(otherFrom);
                double d = Math.min(Math.max(masterFromVal, masterTillVal), Math.max(otherFromVal, otherTillVal)) - Math.max(Math.min(masterFromVal, masterTillVal), Math.min(otherFromVal, otherTillVal));
                if (!(d > -0.1)) {
                    throw new MergeException("Die ausgew\u00e4hlten Objekte ber\u00fchren oder \u00fcberlappen sich nicht");
                }
                if (masterRouteBean.getMetaObject().getID() != otherRouteBean.getMetaObject().getID()) {
                    throw new MergeException("Die ausgew\u00e4hlten Objekte liegen nicht auf der gleichen Route");
                }
                if (masterFromVal > masterTillVal) {
                    tmp = masterFrom;
                    masterFrom = masterTill;
                    masterTill = tmp;
                    tmpVal = masterFromVal;
                    masterFromVal = masterTillVal;
                    masterTillVal = tmpVal;
                }
                if (otherFromVal > otherTillVal) {
                    tmp = otherFrom;
                    otherFrom = otherTill;
                    otherTill = tmp;
                    tmpVal = otherFromVal;
                    otherFromVal = otherTillVal;
                    otherTillVal = tmpVal;
                }
                if (otherFromVal < masterFromVal) {
                    this.linearReferencingHelper.setLinearValueToStationBean(Double.valueOf(otherFromVal), masterFrom);
                }
                if (otherTillVal > masterTillVal) {
                    this.linearReferencingHelper.setLinearValueToStationBean(Double.valueOf(otherTillVal), masterTill);
                }
                CidsBean geomBean = this.linearReferencingHelper.getGeomBeanFromLineBean((CidsBean)origLineBean);
                masterFeature.setGeometry((Geometry)geomBean.getProperty("geo_field"));
                return masterFeature;
            }
            catch (MergeException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while setting station beans", (Throwable)e);
            }
        }
        masterFeature.setGeometry(mergedGeom);
        return masterFeature;
    }

    public static void setCalculatedLine(FeatureServiceFeature feature, MetaClass routeClass, LinearReferencingHelper helper, Geometry g, String stationProperty) throws Exception {
        Geometry firstPoint = CidsLayerFeatureMerger.createPointFromCoords(g.getCoordinates()[0], g.getFactory());
        Geometry lastPoint = CidsLayerFeatureMerger.createPointFromCoords(g.getCoordinates()[g.getNumPoints() - 1], g.getFactory());
        ArrayList routeMetaObject = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new DetermineClosestRoute(Integer.valueOf(routeClass.getID()), routeClass.getPrimaryKey(), routeClass.getTableName(), firstPoint.toText()));
        CidsBean routeBean = null;
        if (routeMetaObject != null && !routeMetaObject.isEmpty()) {
            routeBean = ((MetaObject)routeMetaObject.get(0)).getBean();
        }
        if (routeBean != null) {
            CidsBean firstStation = CidsLayerFeatureMerger.createStationFromRoute(routeBean, firstPoint, helper);
            CidsBean lastStation = CidsLayerFeatureMerger.createStationFromRoute(routeBean, lastPoint, helper);
            CidsBean lineBean = helper.createLineBeanFromRouteBean(routeBean);
            Double firstVal = (Double)firstStation.getProperty(helper.getValueProperty(firstStation));
            Double lastVal = (Double)lastStation.getProperty(helper.getValueProperty(lastStation));
            helper.setLinearValueToStationBean(firstVal, helper.getStationBeanFromLineBean(lineBean, true));
            helper.setLinearValueToStationBean(lastVal, helper.getStationBeanFromLineBean(lineBean, false));
            feature.setProperty(stationProperty, (Object)lineBean);
        }
    }

    private static Geometry createPointFromCoords(Coordinate coord, GeometryFactory factory) {
        return factory.createPoint(coord);
    }

    private static CidsBean createStationFromRoute(CidsBean routeBean, Geometry point, LinearReferencingHelper helper) {
        Coordinate[] firstCoords = DistanceOp.nearestPoints((Geometry)helper.getGeometryFromRoute(routeBean), (Geometry)point);
        double firstPosition = LinearReferencedPointFeature.getPositionOnLine((Coordinate)firstCoords[0], (Geometry)helper.getGeometryFromRoute(routeBean));
        CidsBean station = helper.createStationBeanFromRouteBean(routeBean, firstPosition);
        return station;
    }
}

