/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.merge;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.watergis.gui.actions.merge.FeatureMerger;
import de.cismet.watergis.gui.actions.merge.MergeException;

public class SimpleFeatureMerger
implements FeatureMerger {
    @Override
    public Feature merge(Feature masterFeature, Feature childFeature) throws MergeException {
        Geometry g = masterFeature.getGeometry();
        Geometry mergedGeom = g.union(childFeature.getGeometry());
        if (g.getGeometryType().toUpperCase().contains("LINE")) {
            LineMerger lineMerger = new LineMerger();
            lineMerger.add(mergedGeom);
            if (lineMerger.getMergedLineStrings().size() == 1) {
                mergedGeom = lineMerger.getMergedLineStrings().toArray(new Geometry[1])[0];
                if (mergedGeom.getCoordinates()[0] != g.getCoordinates()[0] && mergedGeom.getCoordinates()[mergedGeom.getCoordinates().length - 1] != g.getCoordinates()[g.getCoordinates().length - 1]) {
                    mergedGeom = mergedGeom.reverse();
                }
            } else {
                Geometry mergedGeomReverseOrder = masterFeature.getGeometry().union(childFeature.getGeometry().reverse());
                LineMerger reverseOrderLineMerger = new LineMerger();
                reverseOrderLineMerger.add(mergedGeomReverseOrder);
                if (reverseOrderLineMerger.getMergedLineStrings().size() == 1) {
                    mergedGeom = reverseOrderLineMerger.getMergedLineStrings().toArray(new Geometry[1])[0];
                }
            }
        }
        masterFeature.setGeometry(mergedGeom);
        return masterFeature;
    }
}

