/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGemeinden;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.dialog.GerinneGeschlGemeindeReportDialog;
import de.cismet.watergis.reports.GerinneGGemeindeReport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class GerinneGGemeindeReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(GerinneGGemeindeReportAction.class);

    public GerinneGGemeindeReportAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-analytics-piechart.png");
        String text = "Gemeinden";
        String tooltiptext = "Gemeindenauswertung";
        String mnemonic = "E";
        try {
            text = NbBundle.getMessage(GerinneGGemeindeReportAction.class, (String)"GerinneGGemeindeReportAction.text");
            tooltiptext = NbBundle.getMessage(GerinneGGemeindeReportAction.class, (String)"GerinneGGemeindeReportAction.toolTipText");
            mnemonic = NbBundle.getMessage(GerinneGGemeindeReportAction.class, (String)"GerinneGGemeindeReportAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            StaticSwingTools.showDialog((JDialog)GerinneGeschlGemeindeReportDialog.getInstance());
            if (!GerinneGeschlGemeindeReportDialog.getInstance().isCancelled()) {
                WaitingDialogThread<File> wdt = new WaitingDialogThread<File>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Auswertung", null, 100, true){

                    /*
                     * WARNING - void declaration
                     */
                    protected File doInBackground() throws Exception {
                        void var6_16;
                        ArrayList<Integer> baCdList = new ArrayList<Integer>();
                        ArrayList<Integer> gmdList = new ArrayList<Integer>();
                        if (GerinneGeschlGemeindeReportDialog.getInstance().isSelectionGew()) {
                            for (FeatureServiceFeature featureServiceFeature : GerinneGeschlGemeindeReportDialog.getInstance().getSelectedGew()) {
                                baCdList.add((Integer)featureServiceFeature.getProperty("id"));
                            }
                        }
                        if (GerinneGeschlGemeindeReportDialog.getInstance().isSelectionGmd()) {
                            for (FeatureServiceFeature featureServiceFeature : GerinneGeschlGemeindeReportDialog.getInstance().getSelectedGmd()) {
                                gmdList.add((Integer)featureServiceFeature.getProperty("gmd_nr"));
                            }
                        } else {
                            AllGemeinden search = new AllGemeinden(baCdList);
                            User user = SessionManager.getSession().getUser();
                            ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
                            if (attributes != null && !attributes.isEmpty()) {
                                for (ArrayList f : attributes) {
                                    gmdList.add((Integer)f.get(0));
                                }
                            }
                        }
                        GerinneGGemeindeReport gr = new GerinneGGemeindeReport();
                        int[] gmd = new int[gmdList.size()];
                        int[] gew = new int[baCdList.size()];
                        boolean bl = false;
                        while (var6_16 < gmdList.size()) {
                            gmd[var6_16] = (Integer)gmdList.get((int)var6_16);
                            ++var6_16;
                        }
                        if (baCdList.isEmpty()) {
                            gew = null;
                        } else {
                            void var6_18;
                            boolean bl2 = false;
                            while (var6_18 < baCdList.size()) {
                                gew[var6_18] = (Integer)baCdList.get((int)var6_18);
                                ++var6_18;
                            }
                        }
                        return gr.createReport(gmd, gew);
                    }

                    protected void done() {
                        try {
                            DownloadManager.instance().add((Download)new FakeFileDownload((File)this.get(), "Statistik: Gerinne (geschlossen)->Gemeinden"));
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while performing the geschlossene Gerinne report.", (Throwable)e);
                        }
                    }
                };
                wdt.start();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while creating gemeinden report", (Throwable)ex);
        }
    }
}

