/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.dialog.GerinneGeschlSbReportDialog;
import de.cismet.watergis.reports.GerinneGSbReport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class GerinneGSbReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(GerinneGSbReportAction.class);

    public GerinneGSbReportAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-analytics-piechart.png");
        String text = "Schaubezirke";
        String tooltiptext = "Schaubezirke";
        String mnemonic = "S";
        try {
            text = NbBundle.getMessage(GerinneGSbReportAction.class, (String)"GerinneGSbReportAction.text");
            tooltiptext = NbBundle.getMessage(GerinneGSbReportAction.class, (String)"GerinneGSbReportAction.toolTipText");
            mnemonic = NbBundle.getMessage(GerinneGSbReportAction.class, (String)"GerinneGSbReportAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            StaticSwingTools.showDialog((JDialog)GerinneGeschlSbReportDialog.getInstance());
            if (!GerinneGeschlSbReportDialog.getInstance().isCancelled()) {
                WaitingDialogThread<File> wdt = new WaitingDialogThread<File>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Auswertung", null, 100, true){

                    protected File doInBackground() throws Exception {
                        ArrayList<Integer> baCdList = new ArrayList<Integer>();
                        if (GerinneGeschlSbReportDialog.getInstance().isSelectionGew()) {
                            for (FeatureServiceFeature feature : GerinneGeschlSbReportDialog.getInstance().getSelectedGew()) {
                                baCdList.add((Integer)feature.getProperty("id"));
                            }
                        }
                        GerinneGSbReport gr = new GerinneGSbReport();
                        int[] gew = new int[baCdList.size()];
                        if (baCdList.isEmpty()) {
                            gew = null;
                        } else {
                            for (int i = 0; i < baCdList.size(); ++i) {
                                gew[i] = (Integer)baCdList.get(i);
                            }
                        }
                        return gr.createGerinneGewaesserReport(gew);
                    }

                    protected void done() {
                        try {
                            DownloadManager.instance().add((Download)new FakeFileDownload((File)this.get(), "Statistik: Gerinne (geschlossen)->Schaubezirke"));
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while performing the geschlossene Gerinne sb report.", (Throwable)e);
                        }
                    }
                };
                wdt.start();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while creating gemeinden report", (Throwable)ex);
        }
    }
}

