/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.WsgStatSearch;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.reports.GerinneGGewaesserReportAction;
import de.cismet.watergis.gui.dialog.WsgForstDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.NbBundle;

public class WsgWaldAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(GerinneGGewaesserReportAction.class);
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"WsgAction");

    public WsgWaldAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-spiderweb.png");
        String text = "Forstnutzung";
        String tooltiptext = "Forstnutzung";
        String mnemonic = "O";
        try {
            text = NbBundle.getMessage(WsgWaldAction.class, (String)"WsgWaldAction.text");
            tooltiptext = NbBundle.getMessage(WsgWaldAction.class, (String)"WsgWaldAction.toolTipText");
            mnemonic = NbBundle.getMessage(WsgWaldAction.class, (String)"WsgWaldAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("ShortDescription", tooltiptext);
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WaitingDialogThread<WsgForstDialog> wdt = new WaitingDialogThread<WsgForstDialog>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Auswertung", null, 100, true){

            protected WsgForstDialog doInBackground() throws Exception {
                WsgStatSearch search = new WsgStatSearch(false);
                User user = SessionManager.getSession().getUser();
                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search, CC);
                int wsgCount = ((Long)attributes.get(0)).intValue();
                double wsgTotal = ((BigDecimal)attributes.get(1)).doubleValue();
                double holzTotal = (Double)attributes.get(2);
                double nichtHolzTotal = (Double)attributes.get(3);
                double nichtEingerichtetTotal = (Double)attributes.get(4);
                WsgForstDialog dialog = new WsgForstDialog(AppBroker.getInstance().getWatergisApp(), true, wsgCount, wsgTotal, holzTotal, nichtHolzTotal, nichtEingerichtetTotal);
                return dialog;
            }

            protected void done() {
                try {
                    WsgForstDialog dialog = (WsgForstDialog)this.get();
                    if (dialog != null) {
                        StaticSwingTools.centerWindowOnScreen((Window)dialog);
                        ActiveLayerModel model = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
                        MetaClass wsgMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.wr_sg_wsg_forst");
                        CidsLayer layer = new CidsLayer(wsgMc);
                        model.removeLayer((RetrievalServiceLayer)layer);
                        model.addLayer((RetrievalServiceLayer)layer);
                    }
                }
                catch (Exception e) {
                    ErrorInfo info = new ErrorInfo("Fehler bei der Auswertung", e.getMessage(), null, null, (Throwable)e, Level.SEVERE, null);
                    JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), (ErrorInfo)info);
                }
            }
        };
        wdt.start();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

