/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports.template;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.watergis.server.actions.RefreshTemplateAction;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.tools.ExportShapeDownload;
import de.cismet.cismap.custom.attributerule.MessageDialog;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.reports.GerinneGFlReportAction;
import de.cismet.watergis.utils.GeometryUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class TemplateExportAction
extends AbstractAction
implements Comparable<TemplateExportAction> {
    private static final Logger LOG = Logger.getLogger(GerinneGFlReportAction.class);
    protected static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"TemplateExportAction");
    List<TemplateAttribute> attributes;
    private MetaClass metaClass;
    private int templateCrs = 5650;
    private int position = -1;
    private String folder;
    private String refresh = null;

    public TemplateExportAction(Element config) {
        this.init(config);
    }

    public String getFolder() {
        return this.folder;
    }

    private void init(Element config) {
        URL icon;
        Element nameElement = config.getChild("Name");
        Element tooltipElement = config.getChild("Tooltip");
        Element iconElement = config.getChild("Icon");
        Element mnemonicElement = config.getChild("Mnemonic");
        Element crsElement = config.getChild("Crs");
        Element tableElement = config.getChild("TableName");
        Element attributesElement = config.getChild("Attributes");
        Element positionElement = config.getChild("Position");
        Element folderElement = config.getChild("Folder");
        Element refreshElement = config.getChild("refresh");
        if (positionElement != null && positionElement.getText() != null) {
            try {
                this.position = Integer.parseInt(positionElement.getText());
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Invalid position found: " + positionElement.getText()), (Throwable)e);
            }
        }
        if (nameElement != null && nameElement.getText() != null) {
            this.putValue("Name", nameElement.getText());
        }
        if (folderElement != null && folderElement.getText() != null) {
            this.folder = folderElement.getText();
        }
        if (refreshElement != null && refreshElement.getText() != null) {
            this.refresh = refreshElement.getText();
        }
        if (tooltipElement != null && tooltipElement.getText() != null) {
            this.putValue("ShortDescription", tooltipElement.getText());
        }
        if (iconElement != null && iconElement.getText() != null && (icon = this.getClass().getResource(iconElement.getText())) != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        if (mnemonicElement != null && mnemonicElement.getText() != null) {
            this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonicElement.getText()).getKeyCode());
        }
        if (crsElement != null && crsElement.getText() != null) {
            try {
                this.templateCrs = Integer.parseInt(crsElement.getText());
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Invalid template crs found", (Throwable)e);
            }
        }
        if (tableElement != null && tableElement.getText() != null) {
            this.metaClass = ClassCacheMultiple.getMetaClass((String)AppBroker.getInstance().getDomain(), (String)tableElement.getText(), (ConnectionContext)CC);
        }
        if (attributesElement != null) {
            this.attributes = new ArrayList<TemplateAttribute>();
            List attributeList = attributesElement.getChildren("FeatureServiceAttribute");
            for (Element attr : attributeList) {
                TemplateAttribute attribute = new TemplateAttribute(attr);
                this.attributes.add(attribute);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WaitingDialogThread<TemplateDataContainer> wdt = new WaitingDialogThread<TemplateDataContainer>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "Empfange Daten der Schablone", null, 100, true){

            protected TemplateDataContainer doInBackground() throws Exception {
                ArrayList<String[]> aliasAttributeList = new ArrayList<String[]>();
                if (TemplateExportAction.this.refresh != null) {
                    this.wd.setText("Aktualisiere Template");
                    ServerActionParameter paramTemplate = new ServerActionParameter(RefreshTemplateAction.ParameterType.TEMPLATE.toString(), (Object)TemplateExportAction.this.refresh);
                    ServerActionParameter paramWait = new ServerActionParameter(RefreshTemplateAction.ParameterType.WAIT.toString(), (Object)"true");
                    SessionManager.getProxy().executeTask("RefreshTemplate", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), new ServerActionParameter[]{paramTemplate, paramWait});
                    this.wd.setText("Erstelle Shape-Datei");
                }
                CidsLayer service = new CidsLayer(TemplateExportAction.this.metaClass);
                service.initAndWait();
                List features = service.getFeatureFactory().createFeatures((Object)service.getQuery(), null, null);
                ArrayList<String> ignoredAttributes = new ArrayList<String>();
                if (TemplateExportAction.this.attributes != null) {
                    for (String attrName : service.getFeatureServiceAttributes().keySet()) {
                        TemplateAttribute attr = TemplateExportAction.this.getAttributeFromList(TemplateExportAction.this.attributes, attrName);
                        if (attr != null) {
                            aliasAttributeList.add(new String[]{attr.getName(), attr.getAlias()});
                            if (!attr.hasFillValue()) continue;
                            for (FeatureServiceFeature f : features) {
                                f.setProperty(attrName, attr.getFillValue());
                            }
                            continue;
                        }
                        ignoredAttributes.add(attrName);
                    }
                }
                for (String ignoredAttribute : ignoredAttributes) {
                    service.getFeatureServiceAttributes().remove(ignoredAttribute);
                    service.getOrderedFeatureServiceAttributes().remove(ignoredAttribute);
                }
                String crsString = CrsTransformer.createCrsFromSrid((int)TemplateExportAction.this.templateCrs);
                for (FeatureServiceFeature f : features) {
                    f.setGeometry(CrsTransformer.transformToGivenCrs((Geometry)f.getGeometry(), (String)crsString));
                    if (!f.getGeometry().isValid()) {
                        Geometry validGeometry = GeometryUtils.makeValid(f.getGeometry());
                        f.setGeometry(validGeometry);
                    }
                    for (String ignoredAttribute : ignoredAttributes) {
                        f.getProperties().remove(ignoredAttribute);
                    }
                }
                return new TemplateDataContainer(aliasAttributeList, service, features);
            }

            protected void done() {
                try {
                    TemplateDataContainer data = (TemplateDataContainer)this.get();
                    List<String[]> aliasAttributeList = data.getAliasAttributeList();
                    CidsLayer service = data.getService();
                    List<FeatureServiceFeature> features = data.getFeatures();
                    MessageDialog d = new MessageDialog((Frame)AppBroker.getInstance().getWatergisApp(), true, NbBundle.getMessage(TemplateExportAction.class, (String)"TemplateExportAction.actionPerformed.crs.message", (Object[])new Object[]{TemplateExportAction.this.templateCrs}), NbBundle.getMessage(TemplateExportAction.class, (String)"TemplateExportAction.actionPerformed.crs.title"));
                    d.setSize(500, 80);
                    StaticSwingTools.showDialog((JDialog)d);
                    File outputFile = StaticSwingTools.chooseFileWithMultipleFilters((String)"", (boolean)true, (String[])new String[]{"shp"}, (String[])new String[]{"shp"}, (Component)AppBroker.getInstance().getRootWindow());
                    if (outputFile != null) {
                        ExportShapeDownload shapeDownload = new ExportShapeDownload();
                        aliasAttributeList.add(new String[]{"$charset$", "windows-1252"});
                        aliasAttributeList.add(new String[]{"$charset_alias$", "ANSI 1252"});
                        shapeDownload.init(outputFile.getAbsolutePath(), "", features.toArray(new FeatureServiceFeature[features.size()]), (AbstractFeatureService)service, aliasAttributeList, null);
                        DownloadManager.instance().add((Download)shapeDownload);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while receiving template features", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private TemplateAttribute getAttributeFromList(List<TemplateAttribute> attributes, String name) {
        for (TemplateAttribute tmp : attributes) {
            if (!tmp.getName().equalsIgnoreCase(name)) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public int compareTo(TemplateExportAction o) {
        return Integer.valueOf(this.position).compareTo(o.position);
    }

    private class TemplateDataContainer {
        private List<String[]> aliasAttributeList;
        private CidsLayer service;
        private List<FeatureServiceFeature> features;

        public TemplateDataContainer(List<String[]> aliasAttributeList, CidsLayer service, List<FeatureServiceFeature> features) {
            this.aliasAttributeList = aliasAttributeList;
            this.service = service;
            this.features = features;
        }

        public List<String[]> getAliasAttributeList() {
            return this.aliasAttributeList;
        }

        public void setAliasAttributeList(List<String[]> aliasAttributeList) {
            this.aliasAttributeList = aliasAttributeList;
        }

        public CidsLayer getService() {
            return this.service;
        }

        public void setService(CidsLayer service) {
            this.service = service;
        }

        public List<FeatureServiceFeature> getFeatures() {
            return this.features;
        }

        public void setFeatures(List<FeatureServiceFeature> features) {
            this.features = features;
        }
    }

    private static class TemplateAttribute {
        private final String name;
        private String alias;
        private final String fill;

        public TemplateAttribute(Element config) {
            this.name = config.getAttributeValue("name");
            this.alias = config.getAttributeValue("alias");
            if (this.alias == null || this.alias.equals("")) {
                this.alias = this.name;
            }
            this.fill = config.getAttributeValue("fill");
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public Object getFillValue() {
            if (this.fill != null) {
                if (this.fill.equals("$username")) {
                    return SessionManager.getSession().getUser().getName();
                }
                if (this.fill.equals("$date")) {
                    GregorianCalendar date = new GregorianCalendar();
                    return date.get(1) + this.to2Digits(date.get(2) + 1) + this.to2Digits(date.get(5));
                }
                return this.fill;
            }
            return this.fill;
        }

        private String to2Digits(int value) {
            if (value > 9) {
                return "" + value;
            }
            return "0" + value;
        }

        public boolean hasFillValue() {
            return this.fill != null;
        }
    }
}

