/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.selection;

import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.listener.SelectionModeChangedEvent;
import de.cismet.watergis.broker.listener.SelectionModeListener;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SelectionEllipseAction
extends AbstractAction
implements SelectionModeListener {
    private static final Logger LOG = Logger.getLogger(SelectionEllipseAction.class);

    public SelectionEllipseAction() {
        String tooltip = NbBundle.getMessage(SelectionEllipseAction.class, (String)"SelectionEllipseAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(SelectionEllipseAction.class, (String)"SelectionEllipseAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(SelectionEllipseAction.class, (String)"SelectionEllipseAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-lasso.png"));
        this.putValue("SmallIcon", icon);
        AppBroker.getInstance().addSelecionModeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SelectionListener sl = (SelectionListener)AppBroker.getInstance().getMappingComponent().getInputEventListener().get("SELECT");
        String oldMode = sl.getMode();
        sl.setMode("ELLIPSE");
        AppBroker.getInstance().getMappingComponent().setInteractionMode("SELECT");
        AppBroker.getInstance().fireSelectionModeChanged(this, oldMode, "ELLIPSE");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void selectionModeChanged(SelectionModeChangedEvent e) {
        if (e.getNewMode().equals("ELLIPSE")) {
            this.putValue("SwingSelectedKey", true);
        } else {
            this.putValue("SwingSelectedKey", false);
        }
    }
}

