/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.selection;

import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.listener.SelectionModeChangedEvent;
import de.cismet.watergis.broker.listener.SelectionModeListener;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SelectionRectangleAction
extends AbstractAction
implements SelectionModeListener {
    private static final Logger LOG = Logger.getLogger(SelectionRectangleAction.class);

    public SelectionRectangleAction() {
        String tooltip = NbBundle.getMessage(SelectionRectangleAction.class, (String)"SelectionRectangleAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(SelectionRectangleAction.class, (String)"SelectionRectangleAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(SelectionRectangleAction.class, (String)"SelectionRectangleAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-rectangle.png"));
        this.putValue("SmallIcon", icon);
        AppBroker.getInstance().addSelecionModeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SelectionListener sl = (SelectionListener)AppBroker.getInstance().getMappingComponent().getInputEventListener().get("SELECT");
        String oldMode = sl.getMode();
        sl.setMode("BOUNDING_BOX");
        AppBroker.getInstance().getMappingComponent().setInteractionMode("SELECT");
        AppBroker.getInstance().fireSelectionModeChanged(this, oldMode, "BOUNDING_BOX");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void selectionModeChanged(SelectionModeChangedEvent e) {
        if (e.getNewMode().equals("BOUNDING_BOX")) {
            this.putValue("SwingSelectedKey", true);
        } else {
            this.putValue("SwingSelectedKey", false);
        }
    }
}

