/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.selection;

import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerWidget;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToLayerWorker;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ZoomSelectedThemesAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ZoomSelectedThemesAction.class);

    public ZoomSelectedThemesAction() {
        String tooltip = NbBundle.getMessage(ZoomSelectedThemesAction.class, (String)"ZoomSelectedThemesAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(ZoomSelectedThemesAction.class, (String)"ZoomSelectedThemesAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(ZoomSelectedThemesAction.class, (String)"ZoomSelectedThemesAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-googleplusold.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ThemeLayerWidget tree = (ThemeLayerWidget)AppBroker.getInstance().getComponent(ComponentName.TREE);
        TreePath[] tps = tree.getSelectionPath();
        ZoomToLayerWorker worker = new ZoomToLayerWorker(tps, 10);
        worker.execute();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

