/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.components;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.printing.Scale;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.watergis.broker.AppBroker;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class ScaleJComboBox
extends JComboBox
implements StatusListener,
ItemListener {
    private static final Logger LOG = Logger.getLogger(ScaleJComboBox.class);
    private static final int TIMER_DELAY = 250;
    Timer checkIfPending;
    private Pattern p = Pattern.compile("1 *: *[\\d. ]+ *");
    private Pattern p2 = Pattern.compile("[\\d. ]+");

    public ScaleJComboBox() {
        CismapBroker.getInstance().addStatusListener((StatusListener)this);
        this.addItemListener(this);
        this.setModelWithScales();
        this.checkIfPending = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScaleJComboBox.this.refreshSelectedItem();
            }
        });
        this.checkIfPending.setRepeats(false);
    }

    public void statusValueChanged(StatusEvent e) {
        if (e.getName().equals("scale")) {
            this.checkIfPending.restart();
        }
    }

    private void refreshSelectedItem() {
        this.removeItemListener(this);
        MappingComponent mappingComponent = AppBroker.getInstance().getMappingComponent();
        int sd = (int)(mappingComponent.getScaleDenominator() + 0.5);
        this.setSelectedItem("1:" + sd);
        this.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            String item = (String)event.getItem();
            if (this.isValid(item)) {
                Integer i;
                CismapBroker.getInstance().removeStatusListener((StatusListener)this);
                MappingComponent mappingComponent = AppBroker.getInstance().getMappingComponent();
                item = item.replace('.', ' ');
                item = item.replace(" ", "");
                if (item.indexOf(":") != -1) {
                    String[] array = item.split(":");
                    i = new Integer(array[1].trim());
                } else {
                    i = new Integer(item.trim());
                }
                mappingComponent.gotoBoundingBoxWithHistory(mappingComponent.getBoundingBoxFromScale((double)i.intValue()));
                this.setBackground(Color.white, Color.white);
                CismapBroker.getInstance().addStatusListener((StatusListener)this);
            } else {
                this.setBackground(Color.red, Color.white);
            }
        }
    }

    private void setModelWithScales() {
        ArrayList<String> scales = new ArrayList<String>();
        for (Scale s : AppBroker.getInstance().getMappingComponent().getScales()) {
            if (s.getDenominator() <= 0) continue;
            scales.add(s.getText());
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(scales.toArray(new String[scales.size()]));
        this.setModel(model);
    }

    private boolean isValid(String selectedItem) {
        Matcher m = this.p.matcher(selectedItem);
        Matcher m2 = this.p2.matcher(selectedItem);
        return m.matches() || m2.matches();
    }

    public void setBackground(Color editField, Color popUp) {
        if (this.getEditor() != null && this.getEditor().getEditorComponent() != null) {
            this.getEditor().getEditorComponent().setBackground(editField);
        }
        super.setBackground(popUp);
    }
}

