/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.components;

import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.HighlightingRadioButtonMenuItem;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.listener.SelectionModeChangedEvent;
import de.cismet.watergis.broker.listener.SelectionModeListener;
import de.cismet.watergis.utils.JPopupMenuButton;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.jdom.Element;

public class SelectionButton
extends JPopupMenuButton
implements PropertyChangeListener,
Configurable,
SelectionModeListener {
    private static final int POLYGON_MODE = 1;
    private static final int RECTANGLE_MODE = 2;
    private static final int ELLIPSE_MODE = 3;
    private static final String CONFIGURATION = "SelectionButton";
    private static final String MODE_ATTRIBUTE = "mode";
    private JPopupMenu popup = new JPopupMenu();
    private JRadioButtonMenuItem polygonMenu = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
    private JRadioButtonMenuItem rectangleMenu = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
    private JRadioButtonMenuItem ellipseMenu = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
    private int mode = 2;
    private ButtonGroup buttonGroup;

    public SelectionButton() {
        this.setModel(new JToggleButton.ToggleButtonModel());
        this.ellipseMenu.setAction(new AbstractAction("Ellipse"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionListener sl = (SelectionListener)AppBroker.getInstance().getMappingComponent().getInputEventListener().get("SELECT");
                String oldMode = sl.getMode();
                SelectionButton.this.setMode(3, false);
                sl.setMode("ELLIPSE");
                AppBroker.getInstance().fireSelectionModeChanged(this, oldMode, "ELLIPSE");
            }
        });
        this.rectangleMenu.setAction(new AbstractAction("Rechteck"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionListener sl = (SelectionListener)AppBroker.getInstance().getMappingComponent().getInputEventListener().get("SELECT");
                String oldMode = sl.getMode();
                SelectionButton.this.setMode(2, false);
                sl.setMode("BOUNDING_BOX");
                AppBroker.getInstance().fireSelectionModeChanged(this, oldMode, "BOUNDING_BOX");
            }
        });
        this.polygonMenu.setAction(new AbstractAction("Polygon"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionListener sl = (SelectionListener)AppBroker.getInstance().getMappingComponent().getInputEventListener().get("SELECT");
                String oldMode = sl.getMode();
                SelectionButton.this.setMode(1, false);
                sl.setMode("POLYGON");
                AppBroker.getInstance().fireSelectionModeChanged(this, oldMode, "POLYGON");
            }
        });
        this.rectangleMenu.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-rectangle.png")));
        this.ellipseMenu.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-lasso.png")));
        this.polygonMenu.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-polygonlasso.png")));
        this.rectangleMenu.setSelected(true);
        this.popup.add(this.rectangleMenu);
        this.popup.add(this.polygonMenu);
        this.popup.add(this.ellipseMenu);
        this.setPopupMenu(this.popup);
        this.setUI(new JToggleButton().getUI());
        this.setFireOnArrow(true);
    }

    private void setMode(int mode, boolean internal) {
        this.mode = mode;
        this.rectangleMenu.setSelected(mode == 2);
        this.ellipseMenu.setSelected(mode == 3);
        this.polygonMenu.setSelected(mode == 1);
        if (mode == 2) {
            this.setIcon(this.rectangleMenu.getIcon());
        } else if (mode == 3) {
            this.setIcon(this.ellipseMenu.getIcon());
        } else if (mode == 1) {
            this.setIcon(this.polygonMenu.getIcon());
        }
        this.repaint();
        if (!internal) {
            AppBroker.getInstance().getMappingComponent().setInteractionMode("SELECT");
        }
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public void setButtonGroup(ButtonGroup buttonGroup) {
        this.buttonGroup = buttonGroup;
        buttonGroup.add((AbstractButton)((Object)this));
    }

    public void setSelected(boolean b) {
        super.setSelected(b);
    }

    public void setAction(Action a) {
        super.setAction(a);
        a.addPropertyChangeListener(this);
        Boolean selected = (Boolean)a.getValue("SwingSelectedKey");
        if (selected != null && selected.booleanValue()) {
            this.setSelected(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SwingSelectedKey") && evt.getNewValue() != null && ((Boolean)evt.getNewValue()).booleanValue()) {
            this.setSelected(true);
        }
    }

    public void configure(Element parent) {
        Element conf;
        if (parent != null && (conf = parent.getChild(CONFIGURATION)) != null) {
            String modeAttr = conf.getAttributeValue(MODE_ATTRIBUTE);
            try {
                int mode = Integer.parseInt(modeAttr);
                this.setMode(mode, true);
                SelectionListener sl = (SelectionListener)AppBroker.getInstance().getMappingComponent().getInputEventListener().get("SELECT");
                String oldMode = sl.getMode();
                String newMode = null;
                switch (mode) {
                    case 1: {
                        sl.setMode("POLYGON");
                        newMode = "POLYGON";
                        break;
                    }
                    case 2: {
                        sl.setMode("BOUNDING_BOX");
                        newMode = "BOUNDING_BOX";
                        break;
                    }
                    case 3: {
                        sl.setMode("ELLIPSE");
                        newMode = "ELLIPSE";
                    }
                }
                AppBroker.getInstance().fireSelectionModeChanged(this, oldMode, newMode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void masterConfigure(Element parent) {
        this.configure(parent);
    }

    public Element getConfiguration() throws NoWriteError {
        Element conf = new Element(CONFIGURATION);
        conf.setAttribute(MODE_ATTRIBUTE, String.valueOf(this.mode));
        return conf;
    }

    @Override
    public void selectionModeChanged(SelectionModeChangedEvent e) {
        int newMode = 2;
        if (e.getNewMode().equals("ELLIPSE")) {
            newMode = 3;
        } else if (e.getNewMode().equals("POLYGON")) {
            newMode = 1;
        }
        this.setMode(newMode, true);
    }
}

