/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.components.location;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.watergis.gui.components.location.SpatialSelectionMethodInterface;
import de.cismet.watergis.utils.GeometryUtils;
import org.openide.util.NbBundle;

public class IntersectSourceSpatialMethod
implements SpatialSelectionMethodInterface {
    @Override
    public boolean featureGeometryFulfilsRequirements(Geometry source, Geometry featureGeometry, double distance) {
        boolean onlyPointsOrLines;
        boolean bl = onlyPointsOrLines = GeometryUtils.isLineOrPoint(source) && GeometryUtils.isLineOrPoint(featureGeometry);
        if (featureGeometry != null && source != null) {
            if (distance == 0.0) {
                if (onlyPointsOrLines) {
                    return source.intersects(featureGeometry.buffer(0.001));
                }
                if (source.intersects(featureGeometry)) {
                    if (source instanceof Polygon && featureGeometry instanceof Polygon) {
                        Polygon sp = (Polygon)source;
                        Polygon fp = (Polygon)featureGeometry;
                        return !sp.getExteriorRing().intersection((Geometry)fp.getExteriorRing()).equalsExact(sp.intersection((Geometry)fp));
                    }
                    if (source instanceof Polygon) {
                        Geometry innerPolygon = source.buffer(-0.01);
                        Geometry sp = source.difference(innerPolygon);
                        return !sp.intersection(featureGeometry).equalsExact(source.intersection(featureGeometry));
                    }
                    if (featureGeometry instanceof Polygon) {
                        Geometry innerPolygon = featureGeometry.buffer(-0.01);
                        Geometry sp = featureGeometry.difference(innerPolygon);
                        return !sp.intersection(source).equalsExact(featureGeometry.intersection(source));
                    }
                    return true;
                }
                return false;
            }
            return featureGeometry.isWithinDistance(source, distance);
        }
        return false;
    }

    @Override
    public boolean isDistanceRequired() {
        return false;
    }

    public String toString() {
        return NbBundle.getMessage(IntersectSourceSpatialMethod.class, (String)"IntersectSourceSpatialMethod.toString");
    }

    @Override
    public Integer getOrderId() {
        return 1;
    }

    @Override
    public boolean isUsedForGeoprocessing() {
        return true;
    }
}

