/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.components.location;

import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.watergis.gui.components.location.IntersectSourceSpatialMethod;
import de.cismet.watergis.gui.components.location.SelectionMethodInterface;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.NbBundle;

public class RemoveFromSelectedFeaturesSelectionMethod
implements SelectionMethodInterface {
    @Override
    public void executeMethod(List<FeatureServiceFeature> features, AbstractFeatureService source, List<AbstractFeatureService> target) {
        ArrayList<Feature> staySelected = new ArrayList<Feature>();
        for (Feature feature : SelectionManager.getInstance().getSelectedFeatures()) {
            if (feature instanceof FeatureServiceFeature) {
                if (this.containedInService(target, (FeatureServiceFeature)feature)) {
                    if (features.contains(feature)) continue;
                    staySelected.add(feature);
                    continue;
                }
                staySelected.add(feature);
                continue;
            }
            staySelected.add(feature);
        }
        for (AbstractFeatureService targetService : target) {
            SelectionManager.getInstance().removeSelectedFeatures(SelectionManager.getInstance().getSelectedFeatures(targetService));
        }
        SelectionManager.getInstance().addSelectedFeatures(staySelected);
    }

    private boolean containedInService(List<AbstractFeatureService> target, FeatureServiceFeature feature) {
        for (AbstractFeatureService service : target) {
            if (feature.getLayerProperties() != service.getLayerProperties()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return NbBundle.getMessage(IntersectSourceSpatialMethod.class, (String)"RemoveFromSelectedFeaturesSelectionMethod.toString");
    }

    @Override
    public Integer getOrderId() {
        return 3;
    }
}

