/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.resource.PropertyManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.helper.ActionHelper;
import de.cismet.cids.custom.watergis.server.actions.CreateSchemaAction;
import de.cismet.cids.custom.watergis.server.actions.CreateUserAction;
import de.cismet.cids.custom.watergis.server.actions.CreateViewAction;
import de.cismet.cids.custom.watergis.server.actions.RemoveSchemaAction;
import de.cismet.cids.custom.watergis.server.actions.RemoveUserAction;
import de.cismet.cids.custom.watergis.server.actions.SchemaExistsAction;
import de.cismet.cids.custom.watergis.server.actions.UserExistsAction;
import de.cismet.cids.custom.watergis.server.search.AllGroups;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DbUserDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(DbUserDialog.class);
    private static final ConnectionContext CONNECTION_CONTEXT = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"create db user");
    private int selectedThemeFeatureCount = 0;
    private ButtonGroup bgBuffer;
    private JButton butCancel;
    private JButton butOk;
    private JCheckBox cbOverride;
    private JComboBox cbUserGroup;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JLabel labTableName;
    private JLabel labTableName1;
    private JLabel labTableName2;
    private JLabel labTheme;
    private JTextField txtDBSchema;
    private JTextField txtDbPassword;
    private JTextField txtDbUser;

    public DbUserDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLayerModel();
        this.enabledOrNot();
    }

    private void initComponents() {
        this.bgBuffer = new ButtonGroup();
        this.jDialog1 = new JDialog();
        this.labTheme = new JLabel();
        this.cbUserGroup = new JComboBox();
        this.labTableName = new JLabel();
        this.txtDbUser = new JTextField();
        this.txtDbPassword = new JTextField();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.labTableName1 = new JLabel();
        this.labTableName2 = new JLabel();
        this.txtDBSchema = new JTextField();
        this.cbOverride = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTheme, (String)NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.labTheme.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.labTheme, gridBagConstraints);
        this.cbUserGroup.setMinimumSize(new Dimension(200, 27));
        this.cbUserGroup.setPreferredSize(new Dimension(200, 27));
        this.cbUserGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbUserDialog.this.cbUserGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.cbUserGroup, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableName, (String)NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.labTableName.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableName, gridBagConstraints);
        this.txtDbUser.setMinimumSize(new Dimension(200, 27));
        this.txtDbUser.setPreferredSize(new Dimension(200, 27));
        this.txtDbUser.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DbUserDialog.this.txtDbUserKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtDbUser, gridBagConstraints);
        this.txtDbPassword.setMinimumSize(new Dimension(200, 27));
        this.txtDbPassword.setPreferredSize(new Dimension(200, 27));
        this.txtDbPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DbUserDialog.this.txtDbPasswordKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtDbPassword, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(80, 29));
        this.butOk.setPreferredSize(new Dimension(150, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbUserDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.setPreferredSize(new Dimension(150, 29));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbUserDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableName1, (String)NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.labTableName1.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableName1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableName2, (String)NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.labTableName2.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableName2, gridBagConstraints);
        this.txtDBSchema.setMinimumSize(new Dimension(200, 27));
        this.txtDBSchema.setPreferredSize(new Dimension(200, 27));
        this.txtDBSchema.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DbUserDialog.this.txtDBSchemaKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtDBSchema, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbOverride, (String)NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.cbOverride.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.cbOverride, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        final String userGroup = (String)this.cbUserGroup.getSelectedItem();
        final String dbUser = this.txtDbUser.getText();
        final String dbPassword = this.txtDbPassword.getText();
        final String schema = this.txtDBSchema.getText();
        if (!AppBroker.getInstance().isAdminUser()) {
            return;
        }
        if (dbUser == null || dbUser.equals("") || dbPassword == null || dbPassword.equals("") || schema == null || schema.equals("")) {
            return;
        }
        if (ActionHelper.isInvalidSchemaName((String)schema)) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.butOkActionPerformed().invalidSchemaName.text"), NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.butOkActionPerformed().invalidSchemaName.title"), 0);
            return;
        }
        if (ActionHelper.isInvalidUserName((String)dbUser)) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.butOkActionPerformed().invalidUserName.text"), NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.butOkActionPerformed().invalidUserName.title"), 0);
            return;
        }
        WaitingDialogThread<String> wdt = new WaitingDialogThread<String>((Frame)AppBroker.getInstance().getWatergisApp(), true, "Erstelle neues DB Profil                             ", null, 100, true){

            protected String doInBackground() throws Exception {
                PropertyManager propertyManager = PropertyManager.getManager();
                ServerActionParameter paramSchema = new ServerActionParameter(SchemaExistsAction.ParameterType.SCHEMA.toString(), (Object)schema);
                Boolean schemaExists = (Boolean)SessionManager.getProxy().executeTask("schemaExists", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), new ServerActionParameter[]{paramSchema});
                ServerActionParameter paramUser = new ServerActionParameter(UserExistsAction.ParameterType.DB_USER.toString(), (Object)dbUser);
                Boolean userExists = (Boolean)SessionManager.getProxy().executeTask("userExists", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), new ServerActionParameter[]{paramUser});
                if (!schemaExists.booleanValue() && !userExists.booleanValue() || DbUserDialog.this.cbOverride.isSelected()) {
                    Connection connection = SessionManager.getConnection();
                    ConnectionInfo connInfo = new ConnectionInfo();
                    connInfo.setCallserverURL(AppBroker.getInstance().getCallserverUrl());
                    connInfo.setUsername(SessionManager.getSession().getUser().getName());
                    connInfo.setUserDomain(SessionManager.getSession().getUser().getDomain());
                    connInfo.setUsergroup(userGroup);
                    connInfo.setUsergroupDomain(SessionManager.getSession().getUser().getUserGroup().getDomain());
                    connInfo.setPassword(SessionManager.getSession().getConnectionInfo().getPassword());
                    ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connInfo, true, CONNECTION_CONTEXT);
                    ConnectionProxy proxy = ConnectionFactory.getFactory().createProxy("Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler", session, CONNECTION_CONTEXT);
                    String errorMessage = null;
                    if (schemaExists.booleanValue() && (errorMessage = DbUserDialog.removeSchema(schema)) != null) {
                        return errorMessage;
                    }
                    if (userExists.booleanValue() && (errorMessage = this.removeUser(dbUser)) != null) {
                        return errorMessage;
                    }
                    errorMessage = this.createUser(dbUser, dbPassword);
                    if (errorMessage != null) {
                        return errorMessage;
                    }
                    errorMessage = DbUserDialog.createSchema(schema, dbUser);
                    if (errorMessage != null) {
                        return errorMessage;
                    }
                    MetaClass[] mc = proxy.getClasses("DLM25W", ConnectionContext.createDummy());
                    int count = 0;
                    this.wd.setMax(mc.length);
                    for (MetaClass clazz : mc) {
                        Collection createAsView;
                        Collection attributes = clazz.getAttributeByName("cidsLayer");
                        Collection hidden = clazz.getAttributeByName("hidden");
                        this.wd.setProgress(count++);
                        if (attributes == null || attributes.isEmpty() || hidden != null && !hidden.isEmpty() && hidden.toArray()[0].toString().equals("true") || (createAsView = clazz.getAttributeByName("create_ro_view")) == null || createAsView.isEmpty() || !createAsView.toArray()[0].toString().equalsIgnoreCase("true")) continue;
                        DbUserDialog.createView(clazz, schema, dbUser, session.getUser());
                    }
                } else {
                    return NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.userOrSchemaAlreadyExists", (Object[])new Object[]{schema});
                }
                return null;
            }

            private String createUser(String user, String password) throws ConnectionException {
                ServerActionParameter paramDbUser = new ServerActionParameter(CreateUserAction.ParameterType.DB_USER.toString(), (Object)user);
                ServerActionParameter paramDbPassword = new ServerActionParameter(CreateUserAction.ParameterType.DB_PASSWORD.toString(), (Object)password);
                Boolean userCreated = (Boolean)SessionManager.getProxy().executeTask("createUser", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), new ServerActionParameter[]{paramDbUser, paramDbPassword});
                if (userCreated.booleanValue()) {
                    return null;
                }
                return NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.createUser().failure", (Object[])new Object[]{user});
            }

            private String removeUser(String user) throws ConnectionException {
                ServerActionParameter paramDbUser = new ServerActionParameter(RemoveUserAction.ParameterType.DB_USER.toString(), (Object)user);
                Boolean userRemoved = (Boolean)SessionManager.getProxy().executeTask("removeUser", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), new ServerActionParameter[]{paramDbUser});
                if (userRemoved.booleanValue()) {
                    return null;
                }
                return NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.removeUser().failure", (Object[])new Object[]{user});
            }

            protected void done() {
                try {
                    String errorMessage = (String)this.get();
                    if (errorMessage != null) {
                        if (!errorMessage.equals("")) {
                            JOptionPane.showMessageDialog(DbUserDialog.this, errorMessage, "Fehler beim Erstellen des Schemas", 0);
                        } else {
                            JOptionPane.showMessageDialog(DbUserDialog.this, "Beim Erstellen des Schemas ist ein Fehler aufgetreten", "Fehler beim Erstellen des Schemas", 0);
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while execute the create db user operation.", (Throwable)ex);
                }
            }
        };
        this.setVisible(false);
        wdt.start();
    }

    private void cbUserGroupActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DbUserDialog.this.enabledOrNot();
            }
        });
    }

    private void txtDbUserKeyTyped(KeyEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DbUserDialog.this.enabledOrNot();
            }
        });
    }

    private void txtDbPasswordKeyTyped(KeyEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DbUserDialog.this.enabledOrNot();
            }
        });
    }

    private void txtDBSchemaKeyTyped(KeyEvent evt) {
        this.enabledOrNot();
    }

    private void setLayerModel() {
        final Object selectedObject = this.cbUserGroup.getSelectedItem();
        this.cbUserGroup.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(DbUserDialog.class, (String)"DBUserDialog.setlayerModel.searchUser")}));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    User user = SessionManager.getSession().getUser();
                    List routes = (List)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new AllGroups(), CONNECTION_CONTEXT);
                    DbUserDialog.this.cbUserGroup.setModel(new DefaultComboBoxModel<String>(routes.toArray(new String[routes.size()])));
                    if (selectedObject != null) {
                        DbUserDialog.this.cbUserGroup.setSelectedItem(selectedObject);
                    } else if (DbUserDialog.this.cbUserGroup.getModel().getSize() > 0) {
                        DbUserDialog.this.cbUserGroup.setSelectedIndex(0);
                    } else {
                        DbUserDialog.this.cbUserGroup.setSelectedItem(null);
                    }
                }
                catch (ConnectionException e) {
                    LOG.error((Object)"Cannot load the user groups", (Throwable)e);
                }
            }
        });
        t.start();
    }

    private void enabledOrNot() {
        boolean isUserSelected = this.cbUserGroup.getSelectedItem() instanceof String;
        boolean userGiven = this.txtDbUser.getText() != null && !this.txtDbUser.getText().equals("");
        boolean passwordGiven = this.txtDbPassword.getText() != null && !this.txtDbPassword.getText().equals("");
        boolean schemaGiven = this.txtDBSchema.getText() != null && !this.txtDBSchema.getText().equals("");
        this.butOk.setEnabled(isUserSelected && userGiven && passwordGiven && schemaGiven);
    }

    public static String createView(MetaClass clazz, String schema, String dbUser, User user) throws ConnectionException {
        Boolean viewCreated;
        ArrayList<ServerActionParameter> parameter = new ArrayList<ServerActionParameter>();
        ServerActionParameter paramClass = new ServerActionParameter(CreateViewAction.ParameterType.CLASS.toString(), (Object)clazz.getId());
        ServerActionParameter paramDbUser = new ServerActionParameter(CreateViewAction.ParameterType.DB_USER.toString(), (Object)dbUser);
        ServerActionParameter paramSchema = new ServerActionParameter(CreateViewAction.ParameterType.SCHEMA.toString(), (Object)schema);
        ServerActionParameter paramUser = new ServerActionParameter(CreateViewAction.ParameterType.USER.toString(), (Object)user);
        parameter.add(paramClass);
        parameter.add(paramDbUser);
        parameter.add(paramSchema);
        parameter.add(paramUser);
        CidsLayer layer = new CidsLayer(clazz);
        AttributeTableRuleSet ruleSet = layer.getLayerProperties().getAttributeTableRuleSet();
        if (ruleSet != null && ruleSet.getAdditionalFieldNames() != null) {
            ArrayList<CreateViewAction.AdditionalField> additionalFields = new ArrayList<CreateViewAction.AdditionalField>();
            for (String fieldName : ruleSet.getAdditionalFieldNames()) {
                String formula = layer.decorateQuery(ruleSet.getAdditionalFieldFormula(fieldName));
                if (formula == null) continue;
                CreateViewAction.AdditionalField field = new CreateViewAction.AdditionalField(fieldName, Integer.valueOf(ruleSet.getIndexOfAdditionalFieldName(fieldName)), formula);
                additionalFields.add(field);
            }
            if (additionalFields.size() > 0) {
                parameter.add(new ServerActionParameter(CreateViewAction.ParameterType.ADDITIONAL_FIELDS.toString(), (Object)additionalFields.toArray(new CreateViewAction.AdditionalField[additionalFields.size()])));
            }
        }
        if ((viewCreated = (Boolean)SessionManager.getProxy().executeTask("createView", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), parameter.toArray(new ServerActionParameter[parameter.size()]))).booleanValue()) {
            return null;
        }
        return NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.createView().failure", (Object[])new Object[]{clazz.getTableName()});
    }

    public static String removeSchema(String schema) throws ConnectionException {
        ServerActionParameter paramSchema = new ServerActionParameter(RemoveSchemaAction.ParameterType.SCHEMA.toString(), (Object)schema);
        Boolean schemaRemoved = (Boolean)SessionManager.getProxy().executeTask("removeSchema", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), new ServerActionParameter[]{paramSchema});
        if (schemaRemoved.booleanValue()) {
            return null;
        }
        return NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.removeSchema().failure", (Object[])new Object[]{schema});
    }

    public static String createSchema(String schema, String user) throws ConnectionException {
        ServerActionParameter paramSchema = new ServerActionParameter(CreateSchemaAction.ParameterType.SCHEMA.toString(), (Object)schema);
        ServerActionParameter paramUser = new ServerActionParameter(CreateSchemaAction.ParameterType.DB_USER.toString(), (Object)user);
        Boolean createSchema = (Boolean)SessionManager.getProxy().executeTask("createSchema", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), new ServerActionParameter[]{paramSchema, paramUser});
        if (createSchema.booleanValue()) {
            return null;
        }
        return NbBundle.getMessage(DbUserDialog.class, (String)"DbUserDialog.createSchema().failure", (Object[])new Object[]{schema});
    }
}

