/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.RestrictedFileSystemView;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.BufferDialog;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GafProfReportDialog
extends JDialog {
    private boolean cancelled = false;
    private String lastPath = DownloadManager.instance().getDestinationDirectory().toString();
    private JButton butCancel;
    private JButton butFile;
    private JButton butOk;
    private JCheckBox ckbBasis;
    private JCheckBox ckbLawa;
    private JCheckBox ckbOhne;
    private JCheckBox ckbProfileSelection;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel labBez;
    private JTextField txtFile;

    private GafProfReportDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        if (!modal) {
            CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

                public void featuresAdded(FeatureCollectionEvent fce) {
                }

                public void allFeaturesRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresChanged(FeatureCollectionEvent fce) {
                }

                public void featureSelectionChanged(FeatureCollectionEvent fce) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GafProfReportDialog.this.refreshSelectedFeatureCount(false);
                        }
                    });
                }

                public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
                }

                public void featureCollectionChanged() {
                }
            });
        }
    }

    public static GafProfReportDialog getInstance() {
        return LazyInitializer.INSTANCE;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.refreshSelectedFeatureCount(true);
            this.cancelled = true;
        }
        super.setVisible(b);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.txtFile = new JTextField();
        this.butFile = new JButton();
        this.filler1 = new Box.Filler(new Dimension(200, 0), new Dimension(200, 0), new Dimension(200, Short.MAX_VALUE));
        this.ckbProfileSelection = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.labBez = new JLabel();
        this.ckbBasis = new JCheckBox();
        this.ckbLawa = new JCheckBox();
        this.ckbOhne = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(GafProfReportDialog.class, (String)"GafProfReportDialog.title_1", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(GafProfReportDialog.class, (String)"GafProfReportDialog.butOk.text_1", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(170, 29));
        this.butOk.setPreferredSize(new Dimension(170, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProfReportDialog.this.butOkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(GafProfReportDialog.class, (String)"GafProfReportDialog.butCancel.text_1", (Object[])new Object[0]));
        this.butCancel.setMinimumSize(new Dimension(170, 29));
        this.butCancel.setPreferredSize(new Dimension(170, 29));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProfReportDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.txtFile.setText(NbBundle.getMessage(GafProfReportDialog.class, (String)"GafProfReportDialog.txtFile.text_1", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.txtFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butFile, (String)NbBundle.getMessage(GafProfReportDialog.class, (String)"GafProfReportDialog.butFile.text_1", (Object[])new Object[0]));
        this.butFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProfReportDialog.this.butFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.butFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        this.getContentPane().add((Component)this.filler1, gridBagConstraints);
        this.ckbProfileSelection.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbProfileSelection, (String)NbBundle.getMessage(GafProfReportDialog.class, (String)"GafProfReportDialog.ckbProfileSelection.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbProfileSelection, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labBez, (String)NbBundle.getMessage(GafProfReportDialog.class, (String)"GafProfReportDialog.labBez.text", (Object[])new Object[0]));
        this.labBez.setPreferredSize(new Dimension(55, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel4.add((Component)this.labBez, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbBasis, (String)NbBundle.getMessage(GafProfReportDialog.class, (String)"GafProfReportDialog.ckbBasis.text", (Object[])new Object[0]));
        this.ckbBasis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProfReportDialog.this.ckbBasisActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.jPanel4.add((Component)this.ckbBasis, gridBagConstraints);
        this.ckbLawa.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbLawa, (String)NbBundle.getMessage(GafProfReportDialog.class, (String)"GafProfReportDialog.ckbLawa.text", (Object[])new Object[0]));
        this.ckbLawa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProfReportDialog.this.ckbLawaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.jPanel4.add((Component)this.ckbLawa, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbOhne, (String)NbBundle.getMessage(GafProfReportDialog.class, (String)"GafProfReportDialog.ckbOhne.text", (Object[])new Object[0]));
        this.ckbOhne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProfReportDialog.this.ckbOhneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.jPanel4.add((Component)this.ckbOhne, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        if (!this.txtFile.getText().equals("")) {
            this.cancelled = false;
            this.setVisible(false);
        } else {
            this.butFileActionPerformed(null);
        }
    }

    private void butFileActionPerformed(ActionEvent evt) {
        JFileChooser fc;
        try {
            fc = new JFileChooser(this.lastPath);
        }
        catch (Exception bug) {
            fc = new JFileChooser(this.lastPath, (FileSystemView)new RestrictedFileSystemView());
        }
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(GafProfReportDialog.class, (String)"GewaesserReportDialog.butFileActionPerformed().getDescription()");
            }
        });
        int ans = fc.showSaveDialog(this);
        if (ans == 0) {
            this.lastPath = fc.getSelectedFile().getParent();
            this.txtFile.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void ckbLawaActionPerformed(ActionEvent evt) {
        this.refreshOkButton();
    }

    private void ckbOhneActionPerformed(ActionEvent evt) {
        this.refreshOkButton();
    }

    private void ckbBasisActionPerformed(ActionEvent evt) {
        this.refreshOkButton();
    }

    void refreshOkButton() {
        this.butOk.setEnabled(this.ckbBasis.isSelected() || this.ckbLawa.isSelected() || this.ckbOhne.isSelected());
    }

    public void refreshSelectedFeatureCount(boolean forceGuiRefresh) {
        List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("qp");
        int count = features.size();
        this.ckbProfileSelection.setText(NbBundle.getMessage(GafProfReportDialog.class, (String)"GafProfReportDialog.ckbProfileSelection.text") + NbBundle.getMessage(BufferDialog.class, (String)"GafProfReportDialog.refreshSelectedFeatureCount.text", (Object)count));
    }

    public String getPath() {
        return this.txtFile.getText();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isLawaSelected() {
        return this.ckbLawa.isSelected();
    }

    public boolean isBasisSelected() {
        return this.ckbBasis.isSelected();
    }

    public boolean isWithoutSelected() {
        return this.ckbOhne.isSelected();
    }

    public boolean isObjectRestrictionSelected() {
        return this.ckbProfileSelection.isSelected();
    }

    private static final class LazyInitializer {
        private static final transient GafProfReportDialog INSTANCE = new GafProfReportDialog((Frame)AppBroker.getInstance().getWatergisApp(), true);

        private LazyInitializer() {
        }
    }
}

