/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.RestrictedFileSystemView;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.WatergisApp;
import de.cismet.watergis.gui.dialog.BufferDialog;
import de.cismet.watergis.gui.dialog.KatasterFlaechenReportDialog;
import de.cismet.watergis.gui.dialog.PointInPolygonDialog;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GerinneOFlaechenReportDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(GerinneOFlaechenReportDialog.class);
    private boolean cancelled = false;
    private int selectedThemeFeatureCount = -1;
    private int selectedGewThemeFeatureCount = -1;
    private String lastPath = null;
    private JButton butCancel;
    private JButton butFile;
    private JButton butOk;
    private JComboBox cbbAttr1;
    private JComboBox cbbAttr2;
    private JComboBox cbbFlaeche;
    private JCheckBox ckb1501;
    private JCheckBox ckb1502;
    private JCheckBox ckb1503;
    private JCheckBox ckb1504;
    private JCheckBox ckb1505;
    private JCheckBox ckbFlSelection;
    private JCheckBox ckbGewSelection;
    private JCheckBox ckbPerGew;
    private JCheckBox ckbPerPart;
    private JCheckBox ckbPerPartProf;
    private JCheckBox ckbSumGu;
    private JCheckBox ckbWdm;
    private Box.Filler filler1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JTextField txtFile;

    private GerinneOFlaechenReportDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.txtFile.setText(DownloadManager.instance().getDestinationDirectory().getPath());
        if (!modal) {
            CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

                public void featuresAdded(FeatureCollectionEvent fce) {
                }

                public void allFeaturesRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresChanged(FeatureCollectionEvent fce) {
                }

                public void featureSelectionChanged(FeatureCollectionEvent fce) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GerinneOFlaechenReportDialog.this.selectedThemeFeatureCount = GerinneOFlaechenReportDialog.this.refreshSelectedFeatureCount(false);
                            GerinneOFlaechenReportDialog.this.selectedGewThemeFeatureCount = GerinneOFlaechenReportDialog.this.refreshSelectedGewFeatureCount(false);
                        }
                    });
                }

                public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
                }

                public void featureCollectionChanged() {
                }
            });
        }
        this.cbbFlaeche.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : (value != null ? ((AbstractFeatureService)value).getName() : " ");
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        ActiveLayerModel layerModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        layerModel.addTreeModelWithoutProgressListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                GerinneOFlaechenReportDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                GerinneOFlaechenReportDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                GerinneOFlaechenReportDialog.this.setLayerModel();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                GerinneOFlaechenReportDialog.this.setLayerModel();
            }
        });
        this.setLayerModel();
    }

    public static GerinneOFlaechenReportDialog getInstance() {
        return LazyInitializer.INSTANCE;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.cancelled = true;
            this.selectedThemeFeatureCount = this.refreshSelectedFeatureCount(true);
            this.selectedGewThemeFeatureCount = this.refreshSelectedGewFeatureCount(true);
        }
        super.setVisible(b);
    }

    private void setLayerModel() {
        this.cbbFlaeche.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(PointInPolygonDialog.class, (String)"PointInPolygonDialog.setlayerModel.searchPolygonServices")}));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                GerinneOFlaechenReportDialog.this.cbbFlaeche.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(new String[]{"Polygon", "MultiPolygon"}).toArray(new AbstractFeatureService[0])));
                GerinneOFlaechenReportDialog.this.cbbFlaeche.setSelectedItem(null);
            }
        });
        t.start();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel8 = new JPanel();
        this.ckb1501 = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.txtFile = new JTextField();
        this.butFile = new JButton();
        this.filler1 = new Box.Filler(new Dimension(200, 0), new Dimension(200, 0), new Dimension(200, Short.MAX_VALUE));
        this.jLabel2 = new JLabel();
        this.ckbFlSelection = new JCheckBox();
        this.ckb1502 = new JCheckBox();
        this.ckb1503 = new JCheckBox();
        this.ckb1505 = new JCheckBox();
        this.ckbSumGu = new JCheckBox();
        this.ckbWdm = new JCheckBox();
        this.ckb1504 = new JCheckBox();
        this.ckbGewSelection = new JCheckBox();
        this.ckbPerGew = new JCheckBox();
        this.ckbPerPart = new JCheckBox();
        this.ckbPerPartProf = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.cbbFlaeche = new JComboBox();
        this.jLabel11 = new JLabel();
        this.cbbAttr1 = new JComboBox();
        this.jLabel12 = new JLabel();
        this.cbbAttr2 = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel8.setLayout(new GridBagLayout());
        this.ckb1501.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckb1501, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.ckb1501.text", (Object[])new Object[0]));
        this.ckb1501.setMaximumSize(new Dimension(100, 24));
        this.ckb1501.setMinimumSize(new Dimension(100, 24));
        this.ckb1501.setPreferredSize(new Dimension(100, 24));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.jPanel8.add((Component)this.ckb1501, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(120, 29));
        this.butOk.setPreferredSize(new Dimension(150, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOFlaechenReportDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.setMinimumSize(new Dimension(120, 29));
        this.butCancel.setPreferredSize(new Dimension(150, 29));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOFlaechenReportDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 27;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel8.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.txtFile.setText(NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.txtFile.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.txtFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butFile, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.butFile.text", (Object[])new Object[0]));
        this.butFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOFlaechenReportDialog.this.butFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.butFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel8.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        this.jPanel8.add((Component)this.filler1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.jLabel2.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel8.add((Component)this.jLabel2, gridBagConstraints);
        this.ckbFlSelection.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbFlSelection, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GemeindeReportDialog.ckbGemSelektion.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel8.add((Component)this.ckbFlSelection, gridBagConstraints);
        this.ckb1502.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckb1502, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.ckb1502.text", (Object[])new Object[0]));
        this.ckb1502.setMaximumSize(new Dimension(100, 24));
        this.ckb1502.setMinimumSize(new Dimension(100, 24));
        this.ckb1502.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.jPanel8.add((Component)this.ckb1502, gridBagConstraints);
        this.ckb1503.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckb1503, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.ckb1503.text", (Object[])new Object[0]));
        this.ckb1503.setMaximumSize(new Dimension(100, 24));
        this.ckb1503.setMinimumSize(new Dimension(100, 24));
        this.ckb1503.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.jPanel8.add((Component)this.ckb1503, gridBagConstraints);
        this.ckb1505.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckb1505, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.ckb1505.text", (Object[])new Object[0]));
        this.ckb1505.setMaximumSize(new Dimension(100, 24));
        this.ckb1505.setMinimumSize(new Dimension(100, 24));
        this.ckb1505.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.jPanel8.add((Component)this.ckb1505, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSumGu, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.ckbSumGu.text", (Object[])new Object[0]));
        this.ckbSumGu.setMaximumSize(new Dimension(260, 24));
        this.ckbSumGu.setMinimumSize(new Dimension(260, 24));
        this.ckbSumGu.setPreferredSize(new Dimension(260, 24));
        this.ckbSumGu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOFlaechenReportDialog.this.ckbSumGuActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.jPanel8.add((Component)this.ckbSumGu, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbWdm, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.ckbWdm.text", (Object[])new Object[0]));
        this.ckbWdm.setMaximumSize(new Dimension(350, 24));
        this.ckbWdm.setMinimumSize(new Dimension(350, 24));
        this.ckbWdm.setPreferredSize(new Dimension(350, 24));
        this.ckbWdm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOFlaechenReportDialog.this.ckbWdmActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 15, 10);
        this.jPanel8.add((Component)this.ckbWdm, gridBagConstraints);
        this.ckb1504.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckb1504, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.ckb1504.text", (Object[])new Object[0]));
        this.ckb1504.setMaximumSize(new Dimension(100, 24));
        this.ckb1504.setMinimumSize(new Dimension(100, 24));
        this.ckb1504.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.jPanel8.add((Component)this.ckb1504, gridBagConstraints);
        this.ckbGewSelection.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbGewSelection, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.ckbGewSelection.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel8.add((Component)this.ckbGewSelection, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbPerGew, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.ckbPerGew.text", (Object[])new Object[0]));
        this.ckbPerGew.setMaximumSize(new Dimension(260, 24));
        this.ckbPerGew.setMinimumSize(new Dimension(260, 24));
        this.ckbPerGew.setPreferredSize(new Dimension(260, 24));
        this.ckbPerGew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOFlaechenReportDialog.this.ckbPerGewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.jPanel8.add((Component)this.ckbPerGew, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbPerPart, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.ckbPerPart.text", (Object[])new Object[0]));
        this.ckbPerPart.setMaximumSize(new Dimension(350, 24));
        this.ckbPerPart.setMinimumSize(new Dimension(350, 24));
        this.ckbPerPart.setPreferredSize(new Dimension(350, 24));
        this.ckbPerPart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOFlaechenReportDialog.this.ckbPerPartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 5, 10);
        this.jPanel8.add((Component)this.ckbPerPart, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbPerPartProf, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.ckbPerPartProf.text", (Object[])new Object[0]));
        this.ckbPerPartProf.setMaximumSize(new Dimension(350, 24));
        this.ckbPerPartProf.setMinimumSize(new Dimension(350, 24));
        this.ckbPerPartProf.setPreferredSize(new Dimension(350, 24));
        this.ckbPerPartProf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOFlaechenReportDialog.this.ckbPerPartProfActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 40, 15, 10);
        this.jPanel8.add((Component)this.ckbPerPartProf, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.jLabel8.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel4.add((Component)this.jLabel8, gridBagConstraints);
        this.cbbFlaeche.setPreferredSize(new Dimension(160, 27));
        this.cbbFlaeche.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GerinneOFlaechenReportDialog.this.cbbFlaecheItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel4.add((Component)this.cbbFlaeche, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.jLabel11.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel4.add((Component)this.jLabel11, gridBagConstraints);
        this.cbbAttr1.setPreferredSize(new Dimension(160, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel4.add((Component)this.cbbAttr1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneOFlaechenReportDialog.jLabel12.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel4.add((Component)this.jLabel12, gridBagConstraints);
        this.cbbAttr2.setPreferredSize(new Dimension(160, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel4.add((Component)this.cbbAttr2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel8.add((Component)this.jPanel4, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanel8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        if (!this.txtFile.getText().equals("")) {
            this.cancelled = false;
            this.setVisible(false);
        } else {
            this.butFileActionPerformed(null);
        }
    }

    private void butFileActionPerformed(ActionEvent evt) {
        JFileChooser fc;
        try {
            fc = new JFileChooser(this.lastPath == null ? DownloadManager.instance().getDestinationDirectory().toString() : this.lastPath);
        }
        catch (Exception bug) {
            fc = new JFileChooser(WatergisApp.getDIRECTORYPATH_WATERGIS(), (FileSystemView)new RestrictedFileSystemView());
        }
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GewaesserReportDialog.butFileActionPerformed().getDescription()");
            }
        });
        int ans = fc.showSaveDialog(this);
        if (ans == 0) {
            this.txtFile.setText(fc.getSelectedFile().getAbsolutePath());
            this.lastPath = fc.getSelectedFile().getAbsolutePath();
        }
    }

    private void ckbWdmActionPerformed(ActionEvent evt) {
        if (this.ckbWdm.isSelected()) {
            this.ckbSumGu.setSelected(true);
        }
    }

    private void ckbPerPartActionPerformed(ActionEvent evt) {
        if (this.ckbPerPart.isSelected()) {
            this.ckbPerGew.setSelected(true);
        }
        if (!this.ckbPerPart.isSelected()) {
            this.ckbPerPartProf.setSelected(false);
        }
    }

    private void ckbPerPartProfActionPerformed(ActionEvent evt) {
        if (this.ckbPerPartProf.isSelected()) {
            this.ckbPerGew.setSelected(true);
            this.ckbPerPart.setSelected(true);
        }
    }

    private void ckbPerGewActionPerformed(ActionEvent evt) {
        if (!this.ckbPerGew.isSelected()) {
            this.ckbPerPartProf.setSelected(false);
            this.ckbPerPart.setSelected(false);
        }
    }

    private void ckbSumGuActionPerformed(ActionEvent evt) {
        if (!this.ckbSumGu.isSelected()) {
            this.ckbWdm.setSelected(false);
        }
    }

    private void cbbFlaecheItemStateChanged(ItemEvent evt) {
        this.refreshFieldModel();
        this.selectedThemeFeatureCount = this.refreshSelectedFeatureCount(false);
    }

    private void refreshFieldModel() {
        AbstractFeatureService service = (AbstractFeatureService)this.cbbFlaeche.getSelectedItem();
        if (service != null) {
            List<String> fields = FeatureServiceHelper.getAllFieldNames(service, null);
            this.cbbAttr1.setModel(new DefaultComboBoxModel<String>(fields.toArray(new String[fields.size()])));
            this.cbbAttr2.setModel(new DefaultComboBoxModel<String>(fields.toArray(new String[fields.size()])));
        } else {
            this.cbbAttr1.setModel(new DefaultComboBoxModel());
            this.cbbAttr2.setModel(new DefaultComboBoxModel());
        }
    }

    public String getAttr1() {
        return String.valueOf(this.cbbAttr1.getSelectedItem());
    }

    public String getAttr2() {
        return String.valueOf(this.cbbAttr2.getSelectedItem());
    }

    public int refreshSelectedFeatureCount(boolean forceGuiRefresh) {
        TreeSet<FeatureServiceFeature> set = new TreeSet<FeatureServiceFeature>();
        if (!(this.cbbFlaeche.getSelectedItem() instanceof AbstractFeatureService)) {
            return -1;
        }
        set.addAll(FeatureServiceHelper.getSelectedFeatures((AbstractFeatureService)this.cbbFlaeche.getSelectedItem()));
        int count = set.size();
        this.ckbFlSelection.setText(NbBundle.getMessage(KatasterFlaechenReportDialog.class, (String)"GemeindeReportDialog.ckbGemSelektion.text") + " " + NbBundle.getMessage(BufferDialog.class, (String)"FlaechenReportDialog.refreshSelectedFeatureCount.text", (Object)count));
        this.ckbFlSelection.setEnabled(true);
        if (forceGuiRefresh || count != this.selectedThemeFeatureCount) {
            this.ckbFlSelection.setSelected(count > 0);
        }
        if (count == 0) {
            this.ckbFlSelection.setSelected(false);
            this.ckbFlSelection.setEnabled(false);
        }
        return count;
    }

    public int refreshSelectedGewFeatureCount(boolean forceGuiRefresh) {
        TreeSet<FeatureServiceFeature> set = new TreeSet<FeatureServiceFeature>();
        for (AbstractFeatureService service : this.getAllActiveFgBaServices()) {
            set.addAll(FeatureServiceHelper.getSelectedFeatures(service));
        }
        int count = set.size();
        this.ckbGewSelection.setText(NbBundle.getMessage(GerinneOFlaechenReportDialog.class, (String)"GerinneGeschlGemeindeReportDialog.ckbGewSelection.text") + " " + NbBundle.getMessage(BufferDialog.class, (String)"GewaesserReportDialog.refreshSelectedFeatureCount.text", (Object)count));
        this.ckbGewSelection.setEnabled(true);
        if (forceGuiRefresh || count != this.selectedGewThemeFeatureCount) {
            this.ckbGewSelection.setSelected(count > 0);
        }
        if (count == 0) {
            this.ckbGewSelection.setSelected(false);
            this.ckbGewSelection.setEnabled(false);
        }
        return count;
    }

    public FeatureServiceFeature[] getSelectedFl() {
        TreeSet<FeatureServiceFeature> set = new TreeSet<FeatureServiceFeature>();
        AbstractFeatureService service = (AbstractFeatureService)this.cbbFlaeche.getSelectedItem();
        set.addAll(FeatureServiceHelper.getSelectedFeatures(service));
        return set.toArray(new FeatureServiceFeature[set.size()]);
    }

    public AbstractFeatureService getFlaechenService() {
        return (AbstractFeatureService)this.cbbFlaeche.getSelectedItem();
    }

    public FeatureServiceFeature[] getSelectedGew() {
        TreeSet<FeatureServiceFeature> set = new TreeSet<FeatureServiceFeature>();
        for (AbstractFeatureService service : this.getAllActiveFgBaServices()) {
            set.addAll(FeatureServiceHelper.getSelectedFeatures(service));
        }
        return set.toArray(new FeatureServiceFeature[set.size()]);
    }

    public boolean isSelectionFl() {
        return this.ckbFlSelection.isSelected();
    }

    private List<AbstractFeatureService> getAllActiveFgBaServices() {
        ArrayList<AbstractFeatureService> serviceList = new ArrayList<AbstractFeatureService>();
        ActiveLayerModel mappingModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        TreeMap treeMap = mappingModel.getMapServices();
        ArrayList keyList = new ArrayList(treeMap.keySet());
        Iterator it = keyList.iterator();
        while (it.hasNext()) {
            CidsLayer featureService;
            Object service = treeMap.get(it.next());
            if (!(service instanceof CidsLayer) || !(featureService = (CidsLayer)service).getMetaClass().getTableName().equalsIgnoreCase("dlm25w.fg_ba")) continue;
            try {
                if (!featureService.isInitialized()) {
                    ((AbstractFeatureService)service).initAndWait();
                }
                serviceList.add((AbstractFeatureService)featureService);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while initialising service", (Throwable)e);
            }
        }
        return serviceList;
    }

    public String getPath() {
        return this.txtFile.getText();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isPerGew() {
        return this.ckbPerGew.isSelected();
    }

    public boolean isPerPart() {
        return this.ckbPerPart.isSelected();
    }

    public boolean isPerPartProf() {
        return this.ckbPerPartProf.isSelected();
    }

    public boolean isSumGu() {
        return this.ckbSumGu.isSelected();
    }

    public boolean isPerWdm() {
        return this.ckbWdm.isSelected();
    }

    public boolean is1501() {
        return this.ckb1501.isSelected();
    }

    public boolean is1502() {
        return this.ckb1502.isSelected();
    }

    public boolean is1503() {
        return this.ckb1503.isSelected();
    }

    public boolean is1504() {
        return this.ckb1504.isSelected();
    }

    public boolean is1505() {
        return this.ckb1505.isSelected();
    }

    public boolean isSelectionGmd() {
        return this.ckbFlSelection.isSelected();
    }

    public boolean isSelectionGew() {
        return this.ckbGewSelection.isSelected();
    }

    private static final class LazyInitializer {
        private static final transient GerinneOFlaechenReportDialog INSTANCE = new GerinneOFlaechenReportDialog((Frame)AppBroker.getInstance().getWatergisApp(), true);

        private LazyInitializer() {
        }
    }
}

