/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.RestrictedFileSystemView;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.WatergisApp;
import de.cismet.watergis.gui.dialog.BufferDialog;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GerinneOGewaesserReportDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(GerinneOGewaesserReportDialog.class);
    private boolean cancelled = false;
    private int selectedThemeFeatureCount = -1;
    private String lastPath = null;
    private JButton butCancel;
    private JButton butFile;
    private JButton butOk;
    private JCheckBox ckb1501;
    private JCheckBox ckb1502;
    private JCheckBox ckb1503;
    private JCheckBox ckb1504;
    private JCheckBox ckb1505;
    private JCheckBox ckbAbschn;
    private JCheckBox ckbAbschnProf;
    private JCheckBox ckbGewSelection;
    private JCheckBox ckbSumGu;
    private JCheckBox ckbWdmSeparated;
    private Box.Filler filler1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JTextField txtFile;

    private GerinneOGewaesserReportDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.txtFile.setText(DownloadManager.instance().getDestinationDirectory().getPath());
        if (!modal) {
            CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

                public void featuresAdded(FeatureCollectionEvent fce) {
                }

                public void allFeaturesRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresChanged(FeatureCollectionEvent fce) {
                }

                public void featureSelectionChanged(FeatureCollectionEvent fce) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GerinneOGewaesserReportDialog.this.selectedThemeFeatureCount = GerinneOGewaesserReportDialog.this.refreshSelectedFeatureCount(false);
                        }
                    });
                }

                public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
                }

                public void featureCollectionChanged() {
                }
            });
        }
    }

    public static GerinneOGewaesserReportDialog getInstance() {
        return LazyInitializer.INSTANCE;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.cancelled = true;
            this.selectedThemeFeatureCount = this.refreshSelectedFeatureCount(true);
        }
        super.setVisible(b);
    }

    private void initComponents() {
        this.ckb1501 = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.txtFile = new JTextField();
        this.butFile = new JButton();
        this.filler1 = new Box.Filler(new Dimension(200, 0), new Dimension(200, 0), new Dimension(200, Short.MAX_VALUE));
        this.jLabel2 = new JLabel();
        this.ckb1502 = new JCheckBox();
        this.ckb1503 = new JCheckBox();
        this.ckb1505 = new JCheckBox();
        this.ckbAbschnProf = new JCheckBox();
        this.ckbSumGu = new JCheckBox();
        this.ckbWdmSeparated = new JCheckBox();
        this.ckb1504 = new JCheckBox();
        this.ckbGewSelection = new JCheckBox();
        this.ckbAbschn = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        this.ckb1501.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckb1501, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.ckb1501.text", (Object[])new Object[0]));
        this.ckb1501.setMaximumSize(new Dimension(100, 24));
        this.ckb1501.setMinimumSize(new Dimension(100, 24));
        this.ckb1501.setPreferredSize(new Dimension(100, 24));
        this.ckb1501.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.ckb1501ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.getContentPane().add((Component)this.ckb1501, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(120, 29));
        this.butOk.setPreferredSize(new Dimension(150, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.setMinimumSize(new Dimension(120, 29));
        this.butCancel.setPreferredSize(new Dimension(150, 29));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.txtFile.setText(NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.txtFile.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.txtFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butFile, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.butFile.text", (Object[])new Object[0]));
        this.butFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.butFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.butFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        this.getContentPane().add((Component)this.filler1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.jLabel2.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.ckb1502.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckb1502, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.ckb1502.text", (Object[])new Object[0]));
        this.ckb1502.setMaximumSize(new Dimension(100, 24));
        this.ckb1502.setMinimumSize(new Dimension(100, 24));
        this.ckb1502.setPreferredSize(new Dimension(100, 24));
        this.ckb1502.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.ckb1502ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.getContentPane().add((Component)this.ckb1502, gridBagConstraints);
        this.ckb1503.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckb1503, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.ckb1503.text", (Object[])new Object[0]));
        this.ckb1503.setMaximumSize(new Dimension(100, 24));
        this.ckb1503.setMinimumSize(new Dimension(100, 24));
        this.ckb1503.setPreferredSize(new Dimension(100, 24));
        this.ckb1503.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.ckb1503ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.getContentPane().add((Component)this.ckb1503, gridBagConstraints);
        this.ckb1505.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckb1505, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.ckb1505.text", (Object[])new Object[0]));
        this.ckb1505.setMaximumSize(new Dimension(100, 24));
        this.ckb1505.setMinimumSize(new Dimension(100, 24));
        this.ckb1505.setPreferredSize(new Dimension(100, 24));
        this.ckb1505.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.ckb1505ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.getContentPane().add((Component)this.ckb1505, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbAbschnProf, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.ckbAbschnProf.text", (Object[])new Object[0]));
        this.ckbAbschnProf.setMaximumSize(new Dimension(260, 24));
        this.ckbAbschnProf.setMinimumSize(new Dimension(260, 24));
        this.ckbAbschnProf.setPreferredSize(new Dimension(260, 24));
        this.ckbAbschnProf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.ckbAbschnProfActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbAbschnProf, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSumGu, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.ckbSumGu.text", (Object[])new Object[0]));
        this.ckbSumGu.setMaximumSize(new Dimension(260, 24));
        this.ckbSumGu.setMinimumSize(new Dimension(260, 24));
        this.ckbSumGu.setPreferredSize(new Dimension(260, 24));
        this.ckbSumGu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.ckbSumGuActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbSumGu, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbWdmSeparated, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.ckbWdmSeparated.text", (Object[])new Object[0]));
        this.ckbWdmSeparated.setMaximumSize(new Dimension(350, 24));
        this.ckbWdmSeparated.setMinimumSize(new Dimension(350, 24));
        this.ckbWdmSeparated.setPreferredSize(new Dimension(350, 24));
        this.ckbWdmSeparated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.ckbWdmSeparatedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 15, 15, 10);
        this.getContentPane().add((Component)this.ckbWdmSeparated, gridBagConstraints);
        this.ckb1504.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckb1504, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.ckb1504.text", (Object[])new Object[0]));
        this.ckb1504.setMaximumSize(new Dimension(100, 24));
        this.ckb1504.setMinimumSize(new Dimension(100, 24));
        this.ckb1504.setPreferredSize(new Dimension(100, 24));
        this.ckb1504.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.ckb1504ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        this.getContentPane().add((Component)this.ckb1504, gridBagConstraints);
        this.ckbGewSelection.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbGewSelection, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.ckbGewSelection.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbGewSelection, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbAbschn, (String)NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GerinneOGewaesserReportDialog.ckbAbschn.text", (Object[])new Object[0]));
        this.ckbAbschn.setMaximumSize(new Dimension(260, 24));
        this.ckbAbschn.setMinimumSize(new Dimension(260, 24));
        this.ckbAbschn.setPreferredSize(new Dimension(260, 24));
        this.ckbAbschn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GerinneOGewaesserReportDialog.this.ckbAbschnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbAbschn, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        if (!this.txtFile.getText().equals("")) {
            this.cancelled = false;
            this.setVisible(false);
        } else {
            this.butFileActionPerformed(null);
        }
    }

    private void butFileActionPerformed(ActionEvent evt) {
        JFileChooser fc;
        try {
            fc = new JFileChooser(this.lastPath == null ? DownloadManager.instance().getDestinationDirectory().toString() : this.lastPath);
        }
        catch (Exception bug) {
            fc = new JFileChooser(WatergisApp.getDIRECTORYPATH_WATERGIS(), (FileSystemView)new RestrictedFileSystemView());
        }
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GewaesserReportDialog.butFileActionPerformed().getDescription()");
            }
        });
        int ans = fc.showSaveDialog(this);
        if (ans == 0) {
            this.txtFile.setText(fc.getSelectedFile().getAbsolutePath());
            this.lastPath = fc.getSelectedFile().getAbsolutePath();
        }
    }

    private void ckbWdmSeparatedActionPerformed(ActionEvent evt) {
        if (this.ckbWdmSeparated.isSelected()) {
            this.ckbSumGu.setSelected(true);
        }
    }

    private void ckbAbschnProfActionPerformed(ActionEvent evt) {
    }

    private void ckbSumGuActionPerformed(ActionEvent evt) {
        if (!this.ckbSumGu.isSelected()) {
            this.ckbWdmSeparated.setSelected(false);
        }
    }

    private void ckbAbschnActionPerformed(ActionEvent evt) {
    }

    private void ckb1501ActionPerformed(ActionEvent evt) {
        this.deactivateWDM();
    }

    private void ckb1502ActionPerformed(ActionEvent evt) {
        this.deactivateWDM();
    }

    private void ckb1503ActionPerformed(ActionEvent evt) {
        this.deactivateWDM();
    }

    private void ckb1504ActionPerformed(ActionEvent evt) {
        this.deactivateWDM();
    }

    private void ckb1505ActionPerformed(ActionEvent evt) {
        this.deactivateWDM();
    }

    private void deactivateWDM() {
        JCheckBox[] boxes = new JCheckBox[]{this.ckb1501, this.ckb1502, this.ckb1503, this.ckb1504, this.ckb1505};
        int count = 0;
        for (JCheckBox box : boxes) {
            if (!box.isSelected()) continue;
            ++count;
        }
        if (count == 1) {
            for (JCheckBox box : boxes) {
                if (!box.isSelected()) continue;
                box.setEnabled(false);
            }
        } else {
            for (JCheckBox box : boxes) {
                if (box.isEnabled()) continue;
                box.setEnabled(true);
            }
        }
    }

    public int refreshSelectedFeatureCount(boolean forceGuiRefresh) {
        TreeSet<FeatureServiceFeature> set = new TreeSet<FeatureServiceFeature>();
        for (AbstractFeatureService service : this.getAllActiveFgBaServices()) {
            set.addAll(FeatureServiceHelper.getSelectedFeatures(service));
        }
        int count = set.size();
        this.ckbGewSelection.setText(NbBundle.getMessage(GerinneOGewaesserReportDialog.class, (String)"GewaesserReportDialog.ckbSelection1.text") + " " + NbBundle.getMessage(BufferDialog.class, (String)"GewaesserReportDialog.refreshSelectedFeatureCount.text", (Object)count));
        this.ckbGewSelection.setEnabled(true);
        if (forceGuiRefresh || count != this.selectedThemeFeatureCount) {
            this.ckbGewSelection.setSelected(count > 0);
        }
        if (count == 0) {
            this.ckbGewSelection.setSelected(false);
            this.ckbGewSelection.setEnabled(false);
        }
        return count;
    }

    public FeatureServiceFeature[] getSelectedGmd() {
        TreeSet<FeatureServiceFeature> set = new TreeSet<FeatureServiceFeature>();
        for (AbstractFeatureService service : this.getAllActiveGmdServices()) {
            set.addAll(FeatureServiceHelper.getSelectedFeatures(service));
        }
        return set.toArray(new FeatureServiceFeature[set.size()]);
    }

    public FeatureServiceFeature[] getSelectedGew() {
        TreeSet<FeatureServiceFeature> set = new TreeSet<FeatureServiceFeature>();
        for (AbstractFeatureService service : this.getAllActiveFgBaServices()) {
            set.addAll(FeatureServiceHelper.getSelectedFeatures(service));
        }
        return set.toArray(new FeatureServiceFeature[set.size()]);
    }

    private List<AbstractFeatureService> getAllActiveFgBaServices() {
        ArrayList<AbstractFeatureService> serviceList = new ArrayList<AbstractFeatureService>();
        ActiveLayerModel mappingModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        TreeMap treeMap = mappingModel.getMapServices();
        ArrayList keyList = new ArrayList(treeMap.keySet());
        Iterator it = keyList.iterator();
        while (it.hasNext()) {
            CidsLayer featureService;
            Object service = treeMap.get(it.next());
            if (!(service instanceof CidsLayer) || !(featureService = (CidsLayer)service).getMetaClass().getTableName().equalsIgnoreCase("dlm25w.fg_ba")) continue;
            try {
                if (!featureService.isInitialized()) {
                    ((AbstractFeatureService)service).initAndWait();
                }
                serviceList.add((AbstractFeatureService)featureService);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while initialising service", (Throwable)e);
            }
        }
        return serviceList;
    }

    private List<AbstractFeatureService> getAllActiveGmdServices() {
        ArrayList<AbstractFeatureService> serviceList = new ArrayList<AbstractFeatureService>();
        ActiveLayerModel mappingModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        TreeMap treeMap = mappingModel.getMapServices();
        ArrayList keyList = new ArrayList(treeMap.keySet());
        Iterator it = keyList.iterator();
        while (it.hasNext()) {
            CidsLayer featureService;
            Object service = treeMap.get(it.next());
            if (!(service instanceof CidsLayer) || !(featureService = (CidsLayer)service).getMetaClass().getTableName().equalsIgnoreCase("dlm25w.vw_alk_gmd")) continue;
            try {
                if (!featureService.isInitialized()) {
                    ((AbstractFeatureService)service).initAndWait();
                }
                serviceList.add((AbstractFeatureService)featureService);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while initialising service", (Throwable)e);
            }
        }
        return serviceList;
    }

    public String getPath() {
        return this.txtFile.getText();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isSumGu() {
        return this.ckbSumGu.isSelected();
    }

    public boolean isPerWdm() {
        return this.ckbWdmSeparated.isSelected();
    }

    public boolean isPerPartProf() {
        return this.ckbAbschnProf.isSelected();
    }

    public boolean isPerPart() {
        return this.ckbAbschn.isSelected();
    }

    public boolean is1501() {
        return this.ckb1501.isSelected();
    }

    public boolean is1502() {
        return this.ckb1502.isSelected();
    }

    public boolean is1503() {
        return this.ckb1503.isSelected();
    }

    public boolean is1504() {
        return this.ckb1504.isSelected();
    }

    public boolean is1505() {
        return this.ckb1505.isSelected();
    }

    public boolean isSelectionGew() {
        return this.ckbGewSelection.isSelected();
    }

    private static final class LazyInitializer {
        private static final transient GerinneOGewaesserReportDialog INSTANCE = new GerinneOGewaesserReportDialog((Frame)AppBroker.getInstance().getWatergisApp(), true);

        private LazyInitializer() {
        }
    }
}

