/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import de.cismet.cids.custom.beans.watergis.Bookmark;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.bookmarks.DeleteBookmarkAction;
import de.cismet.watergis.gui.actions.bookmarks.LoadBookmarksAction;
import de.cismet.watergis.gui.actions.bookmarks.PanBookmarkInMapAction;
import de.cismet.watergis.gui.actions.bookmarks.SaveBookmarksAction;
import de.cismet.watergis.gui.actions.bookmarks.ZoomBookmarkInMapAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ManageBookmarksDialog
extends JDialog {
    private DocumentListener txtNameDocumentListener;
    private DocumentListener txtaDescriptionDocumentListener;
    private JButton btnDelete;
    private JButton btnLoad;
    private JButton btnPan;
    private JButton btnSave;
    private JButton btnZoom;
    private DeleteBookmarkAction deleteBookmarkAction;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblDescription;
    private JLabel lblName;
    private LoadBookmarksAction loadBookmarksAction;
    private JList lstBookmarks;
    private SaveBookmarksAction saveBookmarksAction;
    private PanBookmarkInMapAction showBookmarkInMapAction;
    private JTextField txtName;
    private JTextArea txtaDescription;
    private ZoomBookmarkInMapAction zoomBookmarkInMapAction;

    public ManageBookmarksDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initDocumentListener();
        this.addDocumentListeners();
        this.enableComponents(false);
    }

    private void initComponents() {
        this.showBookmarkInMapAction = new PanBookmarkInMapAction(this);
        this.deleteBookmarkAction = new DeleteBookmarkAction(this);
        this.zoomBookmarkInMapAction = new ZoomBookmarkInMapAction(this);
        this.saveBookmarksAction = new SaveBookmarksAction();
        this.loadBookmarksAction = new LoadBookmarksAction(this);
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstBookmarks = new JList();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblDescription = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.txtaDescription = new JTextArea();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jPanel2 = new JPanel();
        this.btnLoad = new JButton();
        this.btnSave = new JButton();
        this.btnZoom = new JButton();
        this.btnDelete = new JButton();
        this.btnPan = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(ManageBookmarksDialog.class, (String)"ManageBookmarksDialog.title"));
        this.setPreferredSize(new Dimension(471, 441));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                ManageBookmarksDialog.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.jPanel1.setLayout(new GridBagLayout());
        this.lstBookmarks.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.lstBookmarks.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ManageBookmarksDialog.this.lstBookmarksValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstBookmarks);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 3, 0);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(ManageBookmarksDialog.class, (String)"ManageBookmarksDialog.lblName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 4, 2);
        this.jPanel1.add((Component)this.lblName, gridBagConstraints);
        this.txtName.setText(NbBundle.getMessage(ManageBookmarksDialog.class, (String)"ManageBookmarksDialog.txtName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 4, 0);
        this.jPanel1.add((Component)this.txtName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblDescription, (String)NbBundle.getMessage(ManageBookmarksDialog.class, (String)"ManageBookmarksDialog.lblDescription.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 4, 2);
        this.jPanel1.add((Component)this.lblDescription, gridBagConstraints);
        this.jScrollPane2.setPreferredSize(new Dimension(258, 125));
        this.txtaDescription.setColumns(20);
        this.txtaDescription.setRows(5);
        this.txtaDescription.setPreferredSize(new Dimension(250, 120));
        this.jScrollPane2.setViewportView(this.txtaDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 2, 4, 0);
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.filler1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnLoad.setAction(this.loadBookmarksAction);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 4);
        this.jPanel2.add((Component)this.btnLoad, gridBagConstraints);
        this.btnSave.setAction(this.saveBookmarksAction);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 0, 0, 4);
        this.jPanel2.add((Component)this.btnSave, gridBagConstraints);
        this.btnZoom.setAction(this.zoomBookmarkInMapAction);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 0, 0, 4);
        this.jPanel2.add((Component)this.btnZoom, gridBagConstraints);
        this.btnDelete.setAction(this.deleteBookmarkAction);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 4, 0, 0);
        this.jPanel2.add((Component)this.btnDelete, gridBagConstraints);
        this.btnPan.setAction(this.showBookmarkInMapAction);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 4, 0, 4);
        this.jPanel2.add((Component)this.btnPan, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.updateModel();
    }

    private void lstBookmarksValueChanged(ListSelectionEvent evt) {
        Bookmark bookmark = (Bookmark)this.lstBookmarks.getSelectedValue();
        if (bookmark != null) {
            this.txtName.setText(bookmark.getName());
            this.txtaDescription.setText(bookmark.getDescription());
            this.enableComponents(true);
        } else {
            this.removeDocumentListeners();
            this.txtName.setText("");
            this.txtaDescription.setText("");
            this.enableComponents(false);
            this.addDocumentListeners();
        }
    }

    public void updateModel() {
        DefaultListModel<Bookmark> model = new DefaultListModel<Bookmark>();
        for (Bookmark b : AppBroker.getInstance().getBookmarkManager().getBookmarks()) {
            model.addElement(b);
        }
        this.lstBookmarks.setModel(model);
    }

    private void initDocumentListener() {
        this.txtNameDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ManageBookmarksDialog.this.updateBookMarkName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ManageBookmarksDialog.this.updateBookMarkName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ManageBookmarksDialog.this.updateBookMarkName();
            }
        };
        this.txtaDescriptionDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ManageBookmarksDialog.this.updateBookMarkDescription();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ManageBookmarksDialog.this.updateBookMarkDescription();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ManageBookmarksDialog.this.updateBookMarkDescription();
            }
        };
    }

    private void updateBookMarkName() {
        Bookmark bookmark = (Bookmark)this.lstBookmarks.getSelectedValue();
        String bookmarkName = this.txtName.getText().trim();
        if (bookmarkName == null || bookmarkName.equals("")) {
            this.txtName.setBackground(Color.red);
        } else {
            bookmark.setName(this.txtName.getText());
            this.txtName.setBackground(Color.white);
        }
    }

    private void updateBookMarkDescription() {
        Bookmark bookmark = (Bookmark)this.lstBookmarks.getSelectedValue();
        bookmark.setDescription(this.txtaDescription.getText());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ManageBookmarksDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ManageBookmarksDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ManageBookmarksDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ManageBookmarksDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManageBookmarksDialog dialog = new ManageBookmarksDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public Bookmark getSelectedBookmark() {
        return (Bookmark)this.lstBookmarks.getSelectedValue();
    }

    public void removeBookmarkFromList(Bookmark bookmark) {
        ((DefaultListModel)this.lstBookmarks.getModel()).removeElement(bookmark);
    }

    private void enableComponents(boolean b) {
        this.btnDelete.setEnabled(b);
        this.btnPan.setEnabled(b);
        this.btnZoom.setEnabled(b);
        this.txtaDescription.setEnabled(b);
        this.txtName.setEnabled(b);
    }

    private void addDocumentListeners() {
        this.txtName.getDocument().addDocumentListener(this.txtNameDocumentListener);
        this.txtaDescription.getDocument().addDocumentListener(this.txtaDescriptionDocumentListener);
    }

    private void removeDocumentListeners() {
        this.txtName.getDocument().removeDocumentListener(this.txtNameDocumentListener);
        this.txtaDescription.getDocument().removeDocumentListener(this.txtaDescriptionDocumentListener);
    }
}

