/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MergeDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(MergeDialog.class);
    private int selectedThemeFeatureCount = 0;
    private int selectedTargetThemeFeatureCount = 0;
    private ButtonGroup bgBuffer;
    private JButton butCancel;
    private JButton butOk;
    private JComboBox cbTargetTheme;
    private JComboBox cbTheme;
    private JCheckBox ckbSelected;
    private JCheckBox ckbSelectedTarget;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel labSelected;
    private JLabel labSelectedTarget;
    private JLabel labTableName;
    private JLabel labTargetTheme;
    private JLabel labTheme;
    private JTextField txtTable;

    public MergeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.cbTheme.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : (value != null ? ((AbstractFeatureService)value).getName() : " ");
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        this.cbTargetTheme.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : (value != null ? ((AbstractFeatureService)value).getName() : " ");
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        this.txtTable.setText("Vereinigen");
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

            public void featuresAdded(FeatureCollectionEvent fce) {
            }

            public void allFeaturesRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresChanged(FeatureCollectionEvent fce) {
            }

            public void featureSelectionChanged(FeatureCollectionEvent fce) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFeatureService service = (AbstractFeatureService)MergeDialog.this.cbTheme.getSelectedItem();
                        MergeDialog.this.selectedThemeFeatureCount = MergeDialog.this.refreshSelectedFeatureCount(false, MergeDialog.this.ckbSelected, service, MergeDialog.this.selectedThemeFeatureCount, MergeDialog.this.labSelected);
                        AbstractFeatureService targetService = (AbstractFeatureService)MergeDialog.this.cbTargetTheme.getSelectedItem();
                        MergeDialog.this.selectedTargetThemeFeatureCount = MergeDialog.this.refreshSelectedFeatureCount(false, MergeDialog.this.ckbSelectedTarget, targetService, MergeDialog.this.selectedTargetThemeFeatureCount, MergeDialog.this.labSelectedTarget);
                    }
                });
            }

            public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
            }

            public void featureCollectionChanged() {
            }
        });
        ActiveLayerModel layerModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        layerModel.addTreeModelWithoutProgressListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                MergeDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                MergeDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                MergeDialog.this.setLayerModel();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                MergeDialog.this.setLayerModel();
            }
        });
        this.setLayerModel();
        this.enabledOrNot();
    }

    private void initComponents() {
        this.bgBuffer = new ButtonGroup();
        this.jDialog1 = new JDialog();
        this.labTheme = new JLabel();
        this.cbTheme = new JComboBox();
        this.labTableName = new JLabel();
        this.txtTable = new JTextField();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.labTargetTheme = new JLabel();
        this.cbTargetTheme = new JComboBox();
        this.jPanel3 = new JPanel();
        this.ckbSelectedTarget = new JCheckBox();
        this.labSelectedTarget = new JLabel();
        this.jPanel4 = new JPanel();
        this.ckbSelected = new JCheckBox();
        this.labSelected = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTheme, (String)NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.labTheme.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.getContentPane().add((Component)this.labTheme, gridBagConstraints);
        this.cbTheme.setMinimumSize(new Dimension(200, 27));
        this.cbTheme.setPreferredSize(new Dimension(200, 27));
        this.cbTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.cbThemeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.getContentPane().add((Component)this.cbTheme, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableName, (String)NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.labTableName.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableName, gridBagConstraints);
        this.txtTable.setMinimumSize(new Dimension(200, 27));
        this.txtTable.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtTable, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(80, 29));
        this.butOk.setPreferredSize(new Dimension(89, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTargetTheme, (String)NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.labTargetTheme.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTargetTheme, gridBagConstraints);
        this.cbTargetTheme.setMinimumSize(new Dimension(200, 27));
        this.cbTargetTheme.setPreferredSize(new Dimension(200, 27));
        this.cbTargetTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeDialog.this.cbTargetThemeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.cbTargetTheme, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelectedTarget, (String)NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.ckbSelectedTarget.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.ckbSelectedTarget, gridBagConstraints);
        this.labSelectedTarget.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel3.add((Component)this.labSelectedTarget, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelected, (String)NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.ckbSelected.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.ckbSelected, gridBagConstraints);
        this.labSelected.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.labSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void setLayerModel() {
        this.cbTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.setlayerModel.searchServices")}));
        this.cbTargetTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.setlayerModel.searchServices")}));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                MergeDialog.this.cbTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(null).toArray(new AbstractFeatureService[0])));
                MergeDialog.this.cbTargetTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(null).toArray(new AbstractFeatureService[0])));
                if (MergeDialog.this.cbTheme.getModel().getSize() > 0) {
                    MergeDialog.this.cbTheme.setSelectedIndex(0);
                } else {
                    MergeDialog.this.cbTheme.setSelectedItem(null);
                }
                if (MergeDialog.this.cbTargetTheme.getModel().getSize() > 0) {
                    MergeDialog.this.cbTargetTheme.setSelectedIndex(0);
                } else {
                    MergeDialog.this.cbTargetTheme.setSelectedItem(null);
                }
            }
        });
        t.start();
    }

    private void butOkActionPerformed(ActionEvent evt) {
        final AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        final AbstractFeatureService targetService = (AbstractFeatureService)this.cbTargetTheme.getSelectedItem();
        final String tableName = this.txtTable.getText();
        WaitingDialogThread<H2FeatureService> wdt = new WaitingDialogThread<H2FeatureService>((Frame)AppBroker.getInstance().getWatergisApp(), true, "Vereinigen", null, 100, true){

            protected H2FeatureService doInBackground() throws Exception {
                FeatureServiceFeature feature;
                int progress = 10;
                this.wd.setText(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.butOkActionPerformed.doInBackground.retrieving"));
                this.wd.setMax(100);
                this.wd.setProgress(5);
                if (Thread.interrupted()) {
                    return null;
                }
                List<FeatureServiceFeature> featureList = FeatureServiceHelper.getFeatures(service, MergeDialog.this.ckbSelected.isSelected());
                this.wd.setProgress(10);
                if (Thread.interrupted()) {
                    return null;
                }
                List<FeatureServiceFeature> targetFeatureList = FeatureServiceHelper.getFeatures(targetService, MergeDialog.this.ckbSelectedTarget.isSelected());
                ArrayList<FeatureServiceFeature> resultedFeatures = new ArrayList<FeatureServiceFeature>();
                LayerProperties serviceLayerProperties = featureList.get(0).getLayerProperties();
                LayerProperties targetServiceLayerProperties = targetFeatureList.get(0).getLayerProperties();
                HashMap<String, FeatureServiceAttribute> featureServiceAttributes = new HashMap<String, FeatureServiceAttribute>(serviceLayerProperties.getFeatureService().getFeatureServiceAttributes());
                HashMap<String, FeatureServiceAttribute> targetFeatureServiceAttributes = new HashMap<String, FeatureServiceAttribute>(targetServiceLayerProperties.getFeatureService().getFeatureServiceAttributes());
                Map<String, FeatureServiceAttribute> newFeatureServiceAttributes = FeatureServiceHelper.getSuitableMergeFeatureServiceAttribute(featureServiceAttributes, targetFeatureServiceAttributes);
                LayerProperties newLayerProperties = serviceLayerProperties.clone();
                int count = 0;
                int totalCount = featureList.size() + targetFeatureList.size();
                newLayerProperties.setFeatureService((AbstractFeatureService)serviceLayerProperties.getFeatureService().clone());
                newLayerProperties.getFeatureService().setFeatureServiceAttributes(newFeatureServiceAttributes);
                this.wd.setText(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.butOkActionPerformed.doInBackground.createFeatures"));
                for (FeatureServiceFeature f : featureList) {
                    ++count;
                    feature = (FeatureServiceFeature)f.clone();
                    feature.setLayerProperties(newLayerProperties);
                    feature.setGeometry(f.getGeometry());
                    resultedFeatures.add(feature);
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (progress >= 10 + count * 80 / totalCount) continue;
                    progress = 10 + count * 80 / totalCount;
                    this.wd.setProgress(progress);
                }
                for (FeatureServiceFeature f : targetFeatureList) {
                    feature = (FeatureServiceFeature)f.clone();
                    feature.setLayerProperties(newLayerProperties);
                    feature.setGeometry(f.getGeometry());
                    resultedFeatures.add(feature);
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (progress >= 10 + count * 80 / totalCount) continue;
                    progress = 10 + count * 80 / totalCount;
                    this.wd.setProgress(progress);
                }
                this.wd.setText(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.butOkActionPerformed.doInBackground.creatingDatasource"));
                ArrayList<String> orderedAttributeNames = new ArrayList<String>();
                orderedAttributeNames.addAll(service.getOrderedFeatureServiceAttributes());
                return FeatureServiceHelper.createNewService(AppBroker.getInstance().getWatergisApp(), resultedFeatures, tableName, orderedAttributeNames);
            }

            protected void done() {
                try {
                    H2FeatureService service2 = (H2FeatureService)this.get();
                    if (service2 != null) {
                        FeatureServiceHelper.addServiceLayerToTheTree((AbstractFeatureService)service2);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while execute the merge operation.", (Throwable)ex);
                }
            }
        };
        if (H2FeatureService.tableAlreadyExists((String)tableName)) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.butOkActionPerformed.tableAlreadyExists", (Object)tableName), NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.butOkActionPerformed.tableAlreadyExists.title"), 0);
        } else {
            this.setVisible(false);
            wdt.start();
        }
    }

    private void cbThemeActionPerformed(ActionEvent evt) {
        final AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        this.selectedThemeFeatureCount = this.refreshSelectedFeatureCount(false, this.ckbSelected, service, this.selectedThemeFeatureCount, this.labSelected);
        if (service != null) {
            this.cbTargetTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(MergeDialog.class, (String)"PointInLineDialog.setlayerModel.searchLineServices")}));
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    MergeDialog.this.cbTargetTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(new String[]{service.getGeometryType()}).toArray(new AbstractFeatureService[0])));
                    MergeDialog.this.cbTargetTheme.setSelectedItem(null);
                }
            });
            t.start();
        }
        this.enabledOrNot();
    }

    private void cbTargetThemeActionPerformed(ActionEvent evt) {
        Object selectedObject = this.cbTargetTheme.getSelectedItem();
        if (selectedObject instanceof AbstractFeatureService) {
            AbstractFeatureService service = (AbstractFeatureService)selectedObject;
            this.selectedTargetThemeFeatureCount = this.refreshSelectedFeatureCount(false, this.ckbSelectedTarget, service, this.selectedTargetThemeFeatureCount, this.labSelectedTarget);
            this.enabledOrNot();
        }
    }

    public int refreshSelectedFeatureCount(boolean forceGuiRefresh, JCheckBox box, AbstractFeatureService featureService, int lastSelectedFeatureCount, JLabel selectionCountlab) {
        int count = featureService == null ? 0 : FeatureServiceHelper.getSelectedFeatures(featureService).size();
        selectionCountlab.setText(NbBundle.getMessage(MergeDialog.class, (String)"MergeDialog.refreshSelectedFeatureCount.text", (Object)count));
        if (forceGuiRefresh || count != lastSelectedFeatureCount) {
            box.setSelected(count > 0);
        }
        return count;
    }

    private void enabledOrNot() {
        boolean isServiceSelected;
        boolean bl = isServiceSelected = this.cbTheme.getSelectedItem() instanceof AbstractFeatureService && this.cbTargetTheme.getSelectedItem() instanceof AbstractFeatureService;
        if (isServiceSelected) {
            AbstractFeatureService sourceService = (AbstractFeatureService)this.cbTheme.getSelectedItem();
            AbstractFeatureService targetService = (AbstractFeatureService)this.cbTargetTheme.getSelectedItem();
            isServiceSelected = sourceService.getGeometryType().equalsIgnoreCase(targetService.getGeometryType());
        }
        this.butOk.setEnabled(isServiceSelected);
    }
}

