/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.resource.PropertyManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.helper.ActionHelper;
import de.cismet.cids.custom.watergis.server.actions.SchemaExistsAction;
import de.cismet.cids.custom.watergis.server.actions.UserExistsAction;
import de.cismet.cids.custom.watergis.server.search.AllGroups;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.DbUserDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RefreshDbUserDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(RefreshDbUserDialog.class);
    private static final ConnectionContext CONNECTION_CONTEXT = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"create db user");
    private int selectedThemeFeatureCount = 0;
    private ButtonGroup bgBuffer;
    private JButton butCancel;
    private JButton butOk;
    private JButton butOk1;
    private JComboBox cbUserGroup;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JLabel labTableName;
    private JLabel labTableName2;
    private JLabel labTheme;
    private JTextField txtDBSchema;
    private JTextField txtDbUser;

    public RefreshDbUserDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".ro_schemas.txt");
        this.butOk1.setVisible(file.exists());
        this.setLayerModel();
        this.enabledOrNot();
    }

    private void initComponents() {
        this.bgBuffer = new ButtonGroup();
        this.jDialog1 = new JDialog();
        this.labTheme = new JLabel();
        this.cbUserGroup = new JComboBox();
        this.labTableName = new JLabel();
        this.txtDbUser = new JTextField();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.butOk1 = new JButton();
        this.jPanel4 = new JPanel();
        this.labTableName2 = new JLabel();
        this.txtDBSchema = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTheme, (String)NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.labTheme.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.labTheme, gridBagConstraints);
        this.cbUserGroup.setMinimumSize(new Dimension(200, 27));
        this.cbUserGroup.setPreferredSize(new Dimension(200, 27));
        this.cbUserGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefreshDbUserDialog.this.cbUserGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.cbUserGroup, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableName, (String)NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.labTableName.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableName, gridBagConstraints);
        this.txtDbUser.setMinimumSize(new Dimension(200, 27));
        this.txtDbUser.setPreferredSize(new Dimension(200, 27));
        this.txtDbUser.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                RefreshDbUserDialog.this.txtDbUserKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtDbUser, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(80, 29));
        this.butOk.setPreferredSize(new Dimension(150, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefreshDbUserDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.setPreferredSize(new Dimension(150, 29));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefreshDbUserDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butOk1, (String)NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.butOk1.text", (Object[])new Object[0]));
        this.butOk1.setMinimumSize(new Dimension(80, 29));
        this.butOk1.setPreferredSize(new Dimension(120, 29));
        this.butOk1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefreshDbUserDialog.this.butOk1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableName2, (String)NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.labTableName2.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableName2, gridBagConstraints);
        this.txtDBSchema.setMinimumSize(new Dimension(200, 27));
        this.txtDBSchema.setPreferredSize(new Dimension(200, 27));
        this.txtDBSchema.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                RefreshDbUserDialog.this.txtDBSchemaKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtDBSchema, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        String userGroup = (String)this.cbUserGroup.getSelectedItem();
        String dbUser = this.txtDbUser.getText();
        String schema = this.txtDBSchema.getText();
        if (!AppBroker.getInstance().isAdminUser()) {
            return;
        }
        if (dbUser == null || dbUser.equals("") || schema == null || schema.equals("")) {
            return;
        }
        this.start(userGroup, dbUser, schema);
    }

    private void cbUserGroupActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RefreshDbUserDialog.this.enabledOrNot();
            }
        });
    }

    private void txtDbUserKeyTyped(KeyEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RefreshDbUserDialog.this.enabledOrNot();
            }
        });
    }

    private void txtDBSchemaKeyTyped(KeyEvent evt) {
        this.enabledOrNot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void butOk1ActionPerformed(ActionEvent evt) {
        BufferedReader br = null;
        try {
            String tmp;
            File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".ro_schemas.txt");
            br = new BufferedReader(new FileReader(file));
            while ((tmp = br.readLine()) != null) {
                String schema;
                String dbUser;
                String userGroup;
                if (tmp.startsWith("#") || tmp.equals("") || !tmp.contains(";")) continue;
                StringTokenizer st = new StringTokenizer(tmp, ";");
                if (st.countTokens() == 2) {
                    userGroup = st.nextToken();
                    schema = dbUser = st.nextToken();
                } else {
                    if (st.countTokens() != 3) continue;
                    userGroup = st.nextToken();
                    dbUser = st.nextToken();
                    schema = st.nextToken();
                }
                this.start(userGroup, dbUser, schema);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Erro while refreshing schemas", (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void start(final String userGroup, final String dbUser, final String schema) {
        if (ActionHelper.isInvalidSchemaName((String)schema)) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.butOkActionPerformed().invalidSchemaName.text"), NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.butOkActionPerformed().invalidSchemaName.title"), 0);
            return;
        }
        if (ActionHelper.isInvalidUserName((String)dbUser)) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.butOkActionPerformed().invalidUserName.text"), NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.butOkActionPerformed().invalidUserName.title"), 0);
            return;
        }
        WaitingDialogThread<String> wdt = new WaitingDialogThread<String>((Frame)AppBroker.getInstance().getWatergisApp(), true, "Aktualisiere DB Profil                                 ", null, 100, true){

            protected String doInBackground() throws Exception {
                PropertyManager propertyManager = PropertyManager.getManager();
                ServerActionParameter paramSchema = new ServerActionParameter(SchemaExistsAction.ParameterType.SCHEMA.toString(), (Object)schema);
                Boolean schemaExists = (Boolean)SessionManager.getProxy().executeTask("schemaExists", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), new ServerActionParameter[]{paramSchema});
                ServerActionParameter paramUser = new ServerActionParameter(UserExistsAction.ParameterType.DB_USER.toString(), (Object)dbUser);
                Boolean userExists = (Boolean)SessionManager.getProxy().executeTask("userExists", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), new ServerActionParameter[]{paramUser});
                if (schemaExists.booleanValue() && userExists.booleanValue()) {
                    Connection connection = SessionManager.getConnection();
                    ConnectionInfo connInfo = new ConnectionInfo();
                    connInfo.setCallserverURL(AppBroker.getInstance().getCallserverUrl());
                    connInfo.setUsername(SessionManager.getSession().getUser().getName());
                    connInfo.setUserDomain(SessionManager.getSession().getUser().getDomain());
                    connInfo.setUsergroup(userGroup);
                    connInfo.setUsergroupDomain(SessionManager.getSession().getUser().getUserGroup().getDomain());
                    connInfo.setPassword(SessionManager.getSession().getConnectionInfo().getPassword());
                    ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connInfo, true, CONNECTION_CONTEXT);
                    ConnectionProxy proxy = ConnectionFactory.getFactory().createProxy("Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler", session, CONNECTION_CONTEXT);
                    String errorMessage = null;
                    if (errorMessage != null) {
                        return errorMessage;
                    }
                    if (errorMessage != null) {
                        return errorMessage;
                    }
                    MetaClass[] mc = proxy.getClasses("DLM25W", ConnectionContext.createDummy());
                    int count = 0;
                    this.wd.setMax(mc.length);
                    for (MetaClass clazz : mc) {
                        Collection createAsView;
                        Collection attributes = clazz.getAttributeByName("cidsLayer");
                        Collection hidden = clazz.getAttributeByName("hidden");
                        this.wd.setProgress(count++);
                        if (attributes == null || attributes.isEmpty() || hidden != null && !hidden.isEmpty() && hidden.toArray()[0].toString().equals("true") || (createAsView = clazz.getAttributeByName("create_ro_view")) == null || createAsView.isEmpty() || !createAsView.toArray()[0].toString().equalsIgnoreCase("true") || (errorMessage = DbUserDialog.createView(clazz, schema, dbUser, session.getUser())) == null) continue;
                        return errorMessage;
                    }
                } else {
                    return NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.userOrSchemaAlreadyExists", (Object[])new Object[]{schema});
                }
                return null;
            }

            protected void done() {
                try {
                    String errorMessage = (String)this.get();
                    if (errorMessage != null) {
                        if (!errorMessage.equals("")) {
                            JOptionPane.showMessageDialog(RefreshDbUserDialog.this, errorMessage, "Fehler beim Aktualisieren des Schemas", 0);
                        } else {
                            JOptionPane.showMessageDialog(RefreshDbUserDialog.this, "Beim Aktualisieren des Schemas ist ein Fehler aufgetreten", "Fehler beim Aktualisieren des Schemas", 0);
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while refresh a db schema.", (Throwable)ex);
                }
            }
        };
        this.setVisible(false);
        wdt.start();
    }

    private void setLayerModel() {
        final Object selectedObject = this.cbUserGroup.getSelectedItem();
        this.cbUserGroup.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(RefreshDbUserDialog.class, (String)"RefreshDbUserDialog.setlayerModel.searchUser")}));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    User user = SessionManager.getSession().getUser();
                    List routes = (List)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new AllGroups(), CONNECTION_CONTEXT);
                    RefreshDbUserDialog.this.cbUserGroup.setModel(new DefaultComboBoxModel<String>(routes.toArray(new String[routes.size()])));
                    if (selectedObject != null) {
                        RefreshDbUserDialog.this.cbUserGroup.setSelectedItem(selectedObject);
                    } else if (RefreshDbUserDialog.this.cbUserGroup.getModel().getSize() > 0) {
                        RefreshDbUserDialog.this.cbUserGroup.setSelectedIndex(0);
                    } else {
                        RefreshDbUserDialog.this.cbUserGroup.setSelectedItem(null);
                    }
                }
                catch (ConnectionException e) {
                    LOG.error((Object)"Cannot load the user groups", (Throwable)e);
                }
            }
        });
        t.start();
    }

    private void enabledOrNot() {
        boolean isUserSelected = this.cbUserGroup.getSelectedItem() instanceof String;
        boolean userGiven = this.txtDbUser.getText() != null && !this.txtDbUser.getText().equals("");
        boolean schemaGiven = this.txtDBSchema.getText() != null && !this.txtDBSchema.getText().equals("");
        this.butOk.setEnabled(isUserSelected && userGiven && schemaGiven);
    }
}

