/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.JDBCFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.custom.attributerule.MessageDialog;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StationDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(StationDialog.class);
    private static final String SLD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sld:StyledLayerDescriptor xmlns:sld=\"http://www.opengis.net/sld\" xmlns:xslutil=\"de.latlon.deejump.plugin.style.XSLUtility\" xmlns:java=\"java\" xmlns:deegreewfs=\"http://www.deegree.org/wfs\" xmlns:fo=\"http://www.w3.org/1999/XSL/Format\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns=\"http://www.opengis.net/sld\" version=\"1.0.0\" xsi:schemaLocation=\"http://www.opengis.net/sld http://schemas.opengis.net/sld/1.0.0/StyledLayerDescriptor.xsd\" xmlns:oj=\"http://cismet.de\" oj:dummy=\"\">\n  <sld:NamedLayer>\n    <sld:Name>$LAYER_NAME$</sld:Name>\n    <sld:UserStyle>\n      <sld:Name>$LAYER_NAME$</sld:Name>\n      <sld:Title>$LAYER_NAME$</sld:Title>\n      <sld:IsDefault>1</sld:IsDefault>\n      <sld:FeatureTypeStyle>\n        <sld:Name>$LAYER_NAME$</sld:Name>\n        <sld:Rule>\n          <sld:Name>basicPointStyle</sld:Name>\n          <sld:PointSymbolizer>\n            <sld:Geometry>\n              <ogc:PropertyName>geom</ogc:PropertyName>\n            </sld:Geometry>\n            <sld:Graphic>\n              <sld:Mark>\n                <sld:Fill>\n                  <sld:CssParameter name=\"fill\">#ff0033</sld:CssParameter>\n                  <sld:CssParameter name=\"fill-opacity\">1.0</sld:CssParameter>\n                </sld:Fill>\n                <sld:Stroke>\n                  <sld:CssParameter name=\"stroke\">#b20023</sld:CssParameter>\n                  <sld:CssParameter name=\"stroke-opacity\">1.0</sld:CssParameter>\n                  <sld:CssParameter name=\"stroke-width\">1</sld:CssParameter>\n                </sld:Stroke>\n              </sld:Mark>\n            </sld:Graphic>\n          </sld:PointSymbolizer>\n        </sld:Rule>\n        <sld:Rule>\n          <sld:Name>pointStyle</sld:Name>\n          <sld:PointSymbolizer>\n            <sld:Geometry>\n              <ogc:PropertyName>geom</ogc:PropertyName>\n            </sld:Geometry>\n            <sld:Graphic>\n              <sld:Mark>\n                <sld:WellKnownName>square</sld:WellKnownName>\n                <sld:Fill>\n                  <sld:CssParameter name=\"fill\">#ff0033</sld:CssParameter>\n                  <sld:CssParameter name=\"fill-opacity\">1.0</sld:CssParameter>\n                </sld:Fill>\n                <sld:Stroke>\n                  <sld:CssParameter name=\"stroke\">#b20023</sld:CssParameter>\n                  <sld:CssParameter name=\"stroke-opacity\">1.0</sld:CssParameter>\n                  <sld:CssParameter name=\"stroke-width\">1</sld:CssParameter>\n                </sld:Stroke>\n              </sld:Mark>\n              <sld:Size>8</sld:Size>\n            </sld:Graphic>\n          </sld:PointSymbolizer>\n        </sld:Rule>\n        <sld:Rule>\n          <sld:Name>labelStyle</sld:Name>\n          <sld:TextSymbolizer>\n            <sld:Geometry>\n              <ogc:PropertyName>geom</ogc:PropertyName>\n            </sld:Geometry>\n            <sld:Label>\n              <ogc:PropertyName>stat_c</ogc:PropertyName>\n            </sld:Label>\n            <sld:Font>\n              <sld:CssParameter name=\"font-family\">Dialog</sld:CssParameter>\n              <sld:CssParameter name=\"font-style\">normal</sld:CssParameter>\n              <sld:CssParameter name=\"font-size\">12.0</sld:CssParameter>\n              <sld:CssParameter name=\"font-color\">#ff0000</sld:CssParameter>\n            </sld:Font>\n            <sld:LabelPlacement>\n              <sld:PointPlacement>\n                <sld:Displacement>\n                  <sld:DisplacementX>0</sld:DisplacementX>\n                  <sld:DisplacementY>0</sld:DisplacementY>\n                </sld:Displacement>\n              </sld:PointPlacement>\n            </sld:LabelPlacement>\n            <sld:Fill>\n              <sld:CssParameter name=\"fill\">#ff0000</sld:CssParameter>\n              <sld:CssParameter name=\"fill-opacity\">1</sld:CssParameter>\n            </sld:Fill>\n            <VendorOption xmlns=\"\" name=\"verticalAlignment\" alignment=\"DEFAULT\"/>\n            <VendorOption xmlns=\"\" name=\"horizontalPosition\" alignment=\"CENTER\"/>\n          </sld:TextSymbolizer>\n        </sld:Rule>\n      </sld:FeatureTypeStyle>\n    </sld:UserStyle>\n  </sld:NamedLayer>\n</sld:StyledLayerDescriptor>";
    private int selectedThemeFeatureCount = 0;
    private ButtonGroup bgBuffer;
    private JButton butCancel;
    private JButton butOk;
    private JComboBox cbDistance;
    private JComboBox cbTheme;
    private JCheckBox ckbSelected;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JLabel labSelected;
    private JLabel labTableAbstand;
    private JLabel labTableAbstand1;
    private JLabel labTableName;
    private JLabel labTheme;
    private JTextField txtAbst;
    private JTextField txtTable;

    public StationDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.cbTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(null).toArray(new AbstractFeatureService[0])));
        this.cbTheme.setSelectedItem(null);
        this.cbTheme.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : (value != null ? ((AbstractFeatureService)value).getName() : " ");
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        this.txtTable.setText("Stationen|frei");
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

            public void featuresAdded(FeatureCollectionEvent fce) {
            }

            public void allFeaturesRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresChanged(FeatureCollectionEvent fce) {
            }

            public void featureSelectionChanged(FeatureCollectionEvent fce) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFeatureService service = (AbstractFeatureService)StationDialog.this.cbTheme.getSelectedItem();
                        StationDialog.this.selectedThemeFeatureCount = StationDialog.this.refreshSelectedFeatureCount(false, StationDialog.this.ckbSelected, service, StationDialog.this.selectedThemeFeatureCount, StationDialog.this.labSelected);
                    }
                });
            }

            public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
            }

            public void featureCollectionChanged() {
            }
        });
        Thread t = new Thread("loadDistances"){

            @Override
            public void run() {
                StationDialog.this.loadDistances();
            }
        };
        t.start();
        ActiveLayerModel layerModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        layerModel.addTreeModelWithoutProgressListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                StationDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                StationDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                StationDialog.this.setLayerModel();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                StationDialog.this.setLayerModel();
            }
        });
        this.setLayerModel();
        this.enabledOrNot();
    }

    private void loadDistances() {
        MetaClass metaClass = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_stat_fg");
        String query = "SELECT %s, %s FROM %s;";
        String routeQuery = String.format("SELECT %s, %s FROM %s;", metaClass.getID(), metaClass.getPrimaryKey(), metaClass.getTableName());
        try {
            MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(routeQuery, 0, ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.CATALOGUE, (String)"load distances"));
            if (mos != null) {
                Object[] distances = new Integer[mos.length];
                for (int i = 0; i < mos.length; ++i) {
                    distances[i] = (Integer)mos[i].getBean().getProperty("abstand");
                }
                Arrays.sort(distances);
                this.cbDistance.setModel(new DefaultComboBoxModel<Object>(distances));
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error while retrieving distances", (Throwable)ex);
        }
    }

    private void initComponents() {
        this.bgBuffer = new ButtonGroup();
        this.jDialog1 = new JDialog();
        this.labTheme = new JLabel();
        this.cbTheme = new JComboBox();
        this.labTableName = new JLabel();
        this.txtTable = new JTextField();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.ckbSelected = new JCheckBox();
        this.labSelected = new JLabel();
        this.labTableAbstand = new JLabel();
        this.cbDistance = new JComboBox();
        this.txtAbst = new JTextField();
        this.labTableAbstand1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(StationDialog.class, (String)"StationDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTheme, (String)NbBundle.getMessage(StationDialog.class, (String)"StationDialog.labTheme.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.labTheme, gridBagConstraints);
        this.cbTheme.setMinimumSize(new Dimension(200, 27));
        this.cbTheme.setPreferredSize(new Dimension(200, 27));
        this.cbTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationDialog.this.cbThemeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.cbTheme, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableName, (String)NbBundle.getMessage(StationDialog.class, (String)"StationDialog.labTableName.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableName, gridBagConstraints);
        this.txtTable.setMinimumSize(new Dimension(200, 27));
        this.txtTable.setPreferredSize(new Dimension(200, 27));
        this.txtTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationDialog.this.txtTableActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtTable, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(StationDialog.class, (String)"StationDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(80, 29));
        this.butOk.setPreferredSize(new Dimension(100, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(StationDialog.class, (String)"StationDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.setPreferredSize(new Dimension(100, 29));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelected, (String)NbBundle.getMessage(StationDialog.class, (String)"StationDialog.ckbSelected.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.ckbSelected, gridBagConstraints);
        this.labSelected.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.labSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableAbstand, (String)NbBundle.getMessage(StationDialog.class, (String)"StationDialog.labTableAbstand.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableAbstand, gridBagConstraints);
        this.cbDistance.setMinimumSize(new Dimension(100, 27));
        this.cbDistance.setPreferredSize(new Dimension(100, 27));
        this.cbDistance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationDialog.this.cbDistanceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.cbDistance, gridBagConstraints);
        this.txtAbst.setToolTipText(NbBundle.getMessage(StationDialog.class, (String)"StationDialog.txtAbst.toolTipText", (Object[])new Object[0]));
        this.txtAbst.setMinimumSize(new Dimension(50, 27));
        this.txtAbst.setPreferredSize(new Dimension(50, 27));
        this.txtAbst.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                StationDialog.this.txtAbstFocusLost(evt);
            }
        });
        this.txtAbst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StationDialog.this.txtAbstActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.txtAbst, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableAbstand1, (String)NbBundle.getMessage(StationDialog.class, (String)"StationDialog.labTableAbstand1.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableAbstand1, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        final String tableName = this.txtTable.getText();
        try {
            if (this.txtAbst.getText() != null && !this.txtAbst.getText().equals("")) {
                Integer.parseInt(this.txtAbst.getText());
            }
        }
        catch (NumberFormatException e) {
            MessageDialog d = new MessageDialog((Frame)AppBroker.getInstance().getWatergisApp(), true, "Bitte nur ganzzahlige Werte verwenden.");
            d.setSize(500, 80);
            StaticSwingTools.showDialog((JDialog)d);
            this.txtAbst.setText("");
            return;
        }
        try {
            int answ;
            final List<FeatureServiceFeature> featureList = FeatureServiceHelper.getFeatures(service, this.ckbSelected.isSelected());
            final ArrayList resultedFeatures = new ArrayList();
            if (featureList == null || featureList.isEmpty()) {
                JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "Es wurden keine Objekte ausgew\u00e4hlt");
                return;
            }
            if ((!this.ckbSelected.isSelected() || FeatureServiceHelper.isAllOrNoneFeaturesSelected(service)) && (answ = JOptionPane.showConfirmDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(StationDialog.class, (String)"StationDialog.butOkActionPerformed().allFeatures.message"), NbBundle.getMessage(StationDialog.class, (String)"StationDialog.butOkActionPerformed().allFeatures.title"), 0)) == 1) {
                return;
            }
            WaitingDialogThread<H2FeatureService> wdt = new WaitingDialogThread<H2FeatureService>((Frame)AppBroker.getInstance().getWatergisApp(), true, "Erstelle Stationen                                       ", null, 100, true){

                protected H2FeatureService doInBackground() throws Exception {
                    Object distanceObject = StationDialog.this.cbDistance.getSelectedItem();
                    int distance = 10;
                    int progress = 10;
                    this.wd.setText(NbBundle.getMessage(StationDialog.class, (String)"BufferDialog.butOkActionPerformed.doInBackground.retrieving"));
                    this.wd.setMax(100);
                    this.wd.setProgress(5);
                    if (Thread.interrupted()) {
                        return null;
                    }
                    this.wd.setProgress(10);
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (distanceObject instanceof Integer) {
                        distance = (Integer)distanceObject;
                    }
                    try {
                        distance = Integer.parseInt(StationDialog.this.txtAbst.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    LayerProperties serviceLayerProperties = ((FeatureServiceFeature)featureList.get(0)).getLayerProperties();
                    LayerProperties newLayerProperties = serviceLayerProperties.clone();
                    int count = 0;
                    newLayerProperties.setFeatureService((AbstractFeatureService)serviceLayerProperties.getFeatureService().clone());
                    ArrayList<String> orderedAttributeNames = new ArrayList<String>();
                    HashMap<String, FeatureServiceAttribute> attributes = new HashMap<String, FeatureServiceAttribute>();
                    FeatureServiceAttribute attr = new FeatureServiceAttribute("id", "integer", false);
                    attributes.put("id", attr);
                    orderedAttributeNames.add("id");
                    attr = new FeatureServiceAttribute("stat", String.valueOf(4), false);
                    orderedAttributeNames.add("stat");
                    attributes.put("stat", attr);
                    attr = new FeatureServiceAttribute("geom", "Geometry", false);
                    orderedAttributeNames.add("geom");
                    attributes.put("geom", attr);
                    attr = new FeatureServiceAttribute("stat_km", String.valueOf(8), false);
                    orderedAttributeNames.add("stat_km");
                    attributes.put("stat_km", attr);
                    attr = new FeatureServiceAttribute("stat_c", String.valueOf(12), false);
                    orderedAttributeNames.add("stat_c");
                    attributes.put("stat_c", attr);
                    newLayerProperties.getFeatureService().setFeatureServiceAttributes(attributes);
                    this.wd.setText(NbBundle.getMessage(StationDialog.class, (String)"BufferDialog.butOkActionPerformed.doInBackground.createFeatures"));
                    GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
                    H2FeatureService service = null;
                    int featuresCreated = 0;
                    for (FeatureServiceFeature f : featureList) {
                        FeatureServiceFeature newFeature;
                        Coordinate coordinate;
                        Geometry geom = f.getGeometry();
                        ++count;
                        if (geom == null) continue;
                        LengthIndexedLine lil = new LengthIndexedLine(geom);
                        int lastGeomIndex = 0;
                        int geomIndex = 0;
                        while ((double)geomIndex < geom.getLength()) {
                            coordinate = lil.extractPoint((double)geomIndex);
                            if (service != null) {
                                newFeature = (JDBCFeature)service.getFeatureFactory().createNewFeature();
                                newFeature.setProperty("stat", (Object)geomIndex);
                                newFeature.setProperty("stat_km", (Object)((double)geomIndex / 1000.0));
                                newFeature.setProperty("stat_c", (Object)(geomIndex / 1000 + "+" + geomIndex % 1000));
                                newFeature.setGeometry((Geometry)factory.createPoint(coordinate));
                                newFeature.saveChangesWithoutUpdateEnvelope();
                            } else {
                                newFeature = (FeatureServiceFeature)f.clone();
                                newFeature.setLayerProperties(newLayerProperties);
                                newFeature.setGeometry((Geometry)factory.createPoint(coordinate));
                                newFeature.setProperty("stat", (Object)geomIndex);
                                newFeature.setProperty("stat_km", (Object)((double)geomIndex / 1000.0));
                                newFeature.setProperty("stat_c", (Object)(geomIndex / 1000 + "+" + geomIndex % 1000));
                                resultedFeatures.add(newFeature);
                                ++featuresCreated;
                            }
                            lastGeomIndex = geomIndex;
                            geomIndex += distance;
                        }
                        if ((int)geom.getLength() != lastGeomIndex) {
                            geomIndex = (int)geom.getLength();
                            coordinate = lil.extractPoint(geom.getLength());
                            if (service != null) {
                                newFeature = (JDBCFeature)service.getFeatureFactory().createNewFeature();
                                newFeature.setProperty("stat", (Object)geomIndex);
                                newFeature.setProperty("stat_km", (Object)((double)geomIndex / 1000.0));
                                newFeature.setProperty("stat_c", (Object)(geomIndex / 1000 + "+" + geomIndex % 1000));
                                newFeature.setGeometry((Geometry)factory.createPoint(coordinate));
                                newFeature.saveChangesWithoutUpdateEnvelope();
                            } else {
                                newFeature = (FeatureServiceFeature)f.clone();
                                newFeature.setLayerProperties(newLayerProperties);
                                newFeature.setGeometry((Geometry)factory.createPoint(coordinate));
                                newFeature.setProperty("stat", (Object)geomIndex);
                                newFeature.setProperty("stat_km", (Object)((double)geomIndex / 1000.0));
                                newFeature.setProperty("stat_c", (Object)(geomIndex / 1000 + "+" + geomIndex % 1000));
                                resultedFeatures.add(newFeature);
                                ++featuresCreated;
                            }
                        }
                        if (Thread.interrupted()) {
                            return null;
                        }
                        if (featuresCreated > 50000) {
                            if (service == null) {
                                service = FeatureServiceHelper.createNewService(AppBroker.getInstance().getWatergisApp(), resultedFeatures, tableName, orderedAttributeNames);
                            }
                            featuresCreated = 0;
                        }
                        if (progress >= 10 + count * 80 / featureList.size()) continue;
                        progress = 10 + count * 80 / featureList.size();
                        this.wd.setProgress(progress);
                    }
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (service == null) {
                        this.wd.setText(NbBundle.getMessage(StationDialog.class, (String)"BufferDialog.butOkActionPerformed.doInBackground.creatingDatasource"));
                        return FeatureServiceHelper.createNewService(AppBroker.getInstance().getWatergisApp(), resultedFeatures, tableName, orderedAttributeNames);
                    }
                    return service;
                }

                protected void done() {
                    try {
                        H2FeatureService service = (H2FeatureService)this.get();
                        if (service != null) {
                            service.setSLDInputStream(StationDialog.SLD.replace("$LAYER_NAME$", tableName));
                            FeatureServiceHelper.addServiceLayerToTheTree((AbstractFeatureService)service);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Error while execute the buffer operation.", (Throwable)ex);
                    }
                }
            };
            if (H2FeatureService.tableAlreadyExists((String)tableName)) {
                JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(StationDialog.class, (String)"BufferDialog.butOkActionPerformed.tableAlreadyExists", (Object)tableName), NbBundle.getMessage(StationDialog.class, (String)"BufferDialog.butOkActionPerformed.tableAlreadyExists.title"), 0);
            } else {
                this.setVisible(false);
                wdt.start();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while execute the buffer operation.", (Throwable)e);
        }
    }

    private double toDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        String doubleAsString = o.toString();
        try {
            return Double.parseDouble(doubleAsString);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)(o.toString() + " is not a number."), (Throwable)e);
            return 0.0;
        }
    }

    private void cbThemeActionPerformed(ActionEvent evt) {
        AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        this.selectedThemeFeatureCount = this.refreshSelectedFeatureCount(false, this.ckbSelected, service, this.selectedThemeFeatureCount, this.labSelected);
        this.enabledOrNot();
    }

    private void cbDistanceActionPerformed(ActionEvent evt) {
    }

    private void txtTableActionPerformed(ActionEvent evt) {
        this.txtTable.setText("Stationen|frei");
    }

    private void txtAbstActionPerformed(ActionEvent evt) {
    }

    private void txtAbstFocusLost(FocusEvent evt) {
    }

    public int refreshSelectedFeatureCount(boolean forceGuiRefresh, JCheckBox box, AbstractFeatureService featureService, int lastSelectedFeatureCount, JLabel selectionCountlab) {
        int count = featureService == null ? 0 : FeatureServiceHelper.getSelectedFeatures(featureService).size();
        selectionCountlab.setText(NbBundle.getMessage(StationDialog.class, (String)"BufferDialog.refreshSelectedFeatureCount.text", (Object)count));
        if (forceGuiRefresh || count != lastSelectedFeatureCount) {
            box.setSelected(count > 0);
        }
        return count;
    }

    private void setLayerModel() {
        final Object selectedObject = this.cbTheme.getSelectedItem();
        this.cbTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(StationDialog.class, (String)"BufferDialog.setlayerModel.searchServices")}));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                StationDialog.this.cbTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(new String[]{"LineString"}).toArray(new AbstractFeatureService[0])));
                if (selectedObject != null) {
                    StationDialog.this.cbTheme.setSelectedItem(selectedObject);
                } else if (StationDialog.this.cbTheme.getModel().getSize() > 0) {
                    StationDialog.this.cbTheme.setSelectedIndex(0);
                } else {
                    StationDialog.this.cbTheme.setSelectedItem(null);
                }
            }
        });
        t.start();
    }

    private void enabledOrNot() {
        boolean isServiceSelected = this.cbTheme.getSelectedItem() instanceof AbstractFeatureService && this.txtTable.getText() != null && !this.txtTable.getText().equals("");
        this.butOk.setEnabled(isServiceSelected);
    }
}

