/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.strtree.STRtree;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class UnionDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(UnionDialog.class);
    private int selectedThemeFeatureCount = 0;
    private int selectedTargetThemeFeatureCount = 0;
    private ButtonGroup bgBuffer;
    private JButton butCancel;
    private JButton butOk;
    private JComboBox cbTargetTheme;
    private JComboBox cbTheme;
    private JCheckBox ckbSelected;
    private JCheckBox ckbSelectedTarget;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel labSelected;
    private JLabel labSelectedTarget;
    private JLabel labTableName;
    private JLabel labTargetTheme;
    private JLabel labTheme;
    private JTextField txtTable;

    public UnionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.cbTheme.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : (value != null ? ((AbstractFeatureService)value).getName() : " ");
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        this.cbTargetTheme.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : (value != null ? ((AbstractFeatureService)value).getName() : " ");
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        this.txtTable.setText("Verschneiden");
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

            public void featuresAdded(FeatureCollectionEvent fce) {
            }

            public void allFeaturesRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresChanged(FeatureCollectionEvent fce) {
            }

            public void featureSelectionChanged(FeatureCollectionEvent fce) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFeatureService service = (AbstractFeatureService)UnionDialog.this.cbTheme.getSelectedItem();
                        UnionDialog.this.selectedThemeFeatureCount = UnionDialog.this.refreshSelectedFeatureCount(false, UnionDialog.this.ckbSelected, service, UnionDialog.this.selectedThemeFeatureCount, UnionDialog.this.labSelected);
                        AbstractFeatureService targetService = (AbstractFeatureService)UnionDialog.this.cbTargetTheme.getSelectedItem();
                        UnionDialog.this.selectedTargetThemeFeatureCount = UnionDialog.this.refreshSelectedFeatureCount(false, UnionDialog.this.ckbSelectedTarget, targetService, UnionDialog.this.selectedTargetThemeFeatureCount, UnionDialog.this.labSelectedTarget);
                    }
                });
            }

            public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
            }

            public void featureCollectionChanged() {
            }
        });
        ActiveLayerModel layerModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        layerModel.addTreeModelWithoutProgressListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                UnionDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                UnionDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                UnionDialog.this.setLayerModel();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                UnionDialog.this.setLayerModel();
            }
        });
        this.setLayerModel();
        this.enabledOrNot();
    }

    private void initComponents() {
        this.bgBuffer = new ButtonGroup();
        this.jDialog1 = new JDialog();
        this.labTheme = new JLabel();
        this.cbTheme = new JComboBox();
        this.labTableName = new JLabel();
        this.txtTable = new JTextField();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.labTargetTheme = new JLabel();
        this.cbTargetTheme = new JComboBox();
        this.jPanel3 = new JPanel();
        this.ckbSelectedTarget = new JCheckBox();
        this.labSelectedTarget = new JLabel();
        this.jPanel4 = new JPanel();
        this.ckbSelected = new JCheckBox();
        this.labSelected = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTheme, (String)NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.labTheme.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.getContentPane().add((Component)this.labTheme, gridBagConstraints);
        this.cbTheme.setMinimumSize(new Dimension(200, 27));
        this.cbTheme.setPreferredSize(new Dimension(200, 27));
        this.cbTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnionDialog.this.cbThemeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.getContentPane().add((Component)this.cbTheme, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableName, (String)NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.labTableName.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableName, gridBagConstraints);
        this.txtTable.setMinimumSize(new Dimension(200, 27));
        this.txtTable.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtTable, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(80, 29));
        this.butOk.setPreferredSize(new Dimension(89, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnionDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnionDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTargetTheme, (String)NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.labTargetTheme.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTargetTheme, gridBagConstraints);
        this.cbTargetTheme.setMinimumSize(new Dimension(200, 27));
        this.cbTargetTheme.setPreferredSize(new Dimension(200, 27));
        this.cbTargetTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnionDialog.this.cbTargetThemeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.cbTargetTheme, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelectedTarget, (String)NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.ckbSelectedTarget.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.ckbSelectedTarget, gridBagConstraints);
        this.labSelectedTarget.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel3.add((Component)this.labSelectedTarget, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelected, (String)NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.ckbSelected.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.ckbSelected, gridBagConstraints);
        this.labSelected.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.labSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void setLayerModel() {
        this.cbTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.setlayerModel.searchServices")}));
        this.cbTargetTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.setlayerModel.searchPolygonServices")}));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                UnionDialog.this.cbTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(new String[]{"Polygon", "MultiPolygon"}).toArray(new AbstractFeatureService[0])));
                UnionDialog.this.cbTargetTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(new String[]{"Polygon", "MultiPolygon"}).toArray(new AbstractFeatureService[0])));
                if (UnionDialog.this.cbTheme.getModel().getSize() > 0) {
                    UnionDialog.this.cbTheme.setSelectedIndex(0);
                } else {
                    UnionDialog.this.cbTheme.setSelectedItem(null);
                }
                if (UnionDialog.this.cbTargetTheme.getModel().getSize() > 0) {
                    UnionDialog.this.cbTargetTheme.setSelectedIndex(0);
                } else {
                    UnionDialog.this.cbTargetTheme.setSelectedItem(null);
                }
            }
        });
        t.start();
    }

    private void butOkActionPerformed(ActionEvent evt) {
        final AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        final AbstractFeatureService targetService = (AbstractFeatureService)this.cbTargetTheme.getSelectedItem();
        final String tableName = this.txtTable.getText();
        WaitingDialogThread<H2FeatureService> wdt = new WaitingDialogThread<H2FeatureService>((Frame)AppBroker.getInstance().getWatergisApp(), true, "Verschneiden                                            ", null, 100, true){

            protected H2FeatureService doInBackground() throws Exception {
                int progress = 10;
                this.wd.setText(NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.butOkActionPerformed.doInBackground.retrieving"));
                this.wd.setMax(100);
                this.wd.setProgress(5);
                if (Thread.interrupted()) {
                    return null;
                }
                List<FeatureServiceFeature> featureList = FeatureServiceHelper.getFeatures(service, UnionDialog.this.ckbSelected.isSelected());
                this.wd.setProgress(10);
                if (Thread.interrupted()) {
                    return null;
                }
                List<FeatureServiceFeature> targetFeatureList = FeatureServiceHelper.getFeatures(targetService, UnionDialog.this.ckbSelectedTarget.isSelected());
                STRtree featureTree = FeatureServiceHelper.getFeatureTree(targetFeatureList);
                ArrayList<FeatureServiceFeature> resultedFeatures = new ArrayList<FeatureServiceFeature>();
                LayerProperties serviceLayerProperties = featureList.get(0).getLayerProperties();
                LayerProperties targetServiceLayerProperties = targetFeatureList.get(0).getLayerProperties();
                HashMap<String, FeatureServiceAttribute> featureServiceAttributes = new HashMap<String, FeatureServiceAttribute>(serviceLayerProperties.getFeatureService().getFeatureServiceAttributes());
                HashMap<String, FeatureServiceAttribute> targetFeatureServiceAttributes = new HashMap<String, FeatureServiceAttribute>(targetServiceLayerProperties.getFeatureService().getFeatureServiceAttributes());
                ArrayList<String> secondaryFeatureProperties = new ArrayList<String>();
                Map<String, FeatureServiceAttribute> newFeatureServiceAttributes = FeatureServiceHelper.getSuitableFeatureServiceAttribute(featureServiceAttributes, targetFeatureServiceAttributes, targetService.getOrderedFeatureServiceAttributes(), secondaryFeatureProperties);
                LayerProperties newLayerProperties = serviceLayerProperties.clone();
                int count = 0;
                newLayerProperties.setFeatureService((AbstractFeatureService)serviceLayerProperties.getFeatureService().clone());
                newLayerProperties.getFeatureService().setFeatureServiceAttributes(newFeatureServiceAttributes);
                this.wd.setText(NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.butOkActionPerformed.doInBackground.createFeatures"));
                for (FeatureServiceFeature f : featureList) {
                    boolean suitableFeatureFound = false;
                    Geometry searchGeom = f.getGeometry();
                    ++count;
                    if (searchGeom != null) {
                        List intersectingFeatures = featureTree.query(searchGeom.getEnvelopeInternal());
                        for (FeatureServiceFeature targetFeature : intersectingFeatures) {
                            Geometry newGeom;
                            suitableFeatureFound = true;
                            Geometry sourceGeom = f.getGeometry();
                            Geometry targetGeom = targetFeature.getGeometry();
                            if (!sourceGeom.isValid()) {
                                sourceGeom = sourceGeom.buffer(0.0);
                            }
                            if (!targetGeom.isValid()) {
                                targetGeom = targetGeom.buffer(0.0);
                            }
                            if ((newGeom = sourceGeom.intersection(targetGeom)) == null || newGeom.isEmpty()) continue;
                            for (int geomIndex = 0; geomIndex < newGeom.getNumGeometries(); ++geomIndex) {
                                if (!newGeom.getGeometryN(geomIndex).getGeometryType().equalsIgnoreCase("POLYGON")) continue;
                                FeatureServiceFeature newFeature = (FeatureServiceFeature)f.clone();
                                newFeature.setGeometry(newGeom.getGeometryN(geomIndex));
                                resultedFeatures.add(FeatureServiceHelper.mergeFeatures(newFeature, targetFeature, newLayerProperties, secondaryFeatureProperties, ""));
                            }
                        }
                    }
                    if (!suitableFeatureFound) {
                        resultedFeatures.add(FeatureServiceHelper.mergeFeatures(f, null, newLayerProperties, secondaryFeatureProperties, ""));
                    }
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (progress >= 10 + count * 80 / featureList.size()) continue;
                    progress = 10 + count * 80 / featureList.size();
                    this.wd.setProgress(progress);
                }
                ArrayList<String> orderedAttributeNames = new ArrayList<String>();
                orderedAttributeNames.addAll(service.getOrderedFeatureServiceAttributes());
                orderedAttributeNames.addAll(secondaryFeatureProperties);
                this.wd.setText(NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.butOkActionPerformed.doInBackground.creatingDatasource"));
                return FeatureServiceHelper.createNewService(AppBroker.getInstance().getWatergisApp(), resultedFeatures, tableName, orderedAttributeNames);
            }

            protected void done() {
                try {
                    H2FeatureService service2 = (H2FeatureService)this.get();
                    if (service2 != null) {
                        FeatureServiceHelper.addServiceLayerToTheTree((AbstractFeatureService)service2);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while execute the Union operation.", (Throwable)ex);
                }
            }
        };
        if (H2FeatureService.tableAlreadyExists((String)tableName)) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.butOkActionPerformed.tableAlreadyExists", (Object)tableName), NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.butOkActionPerformed.tableAlreadyExists.title"), 0);
        } else {
            this.setVisible(false);
            wdt.start();
        }
    }

    private void cbThemeActionPerformed(ActionEvent evt) {
        AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        this.selectedThemeFeatureCount = this.refreshSelectedFeatureCount(false, this.ckbSelected, service, this.selectedThemeFeatureCount, this.labSelected);
        this.enabledOrNot();
    }

    private void cbTargetThemeActionPerformed(ActionEvent evt) {
        AbstractFeatureService service = (AbstractFeatureService)this.cbTargetTheme.getSelectedItem();
        this.selectedTargetThemeFeatureCount = this.refreshSelectedFeatureCount(false, this.ckbSelectedTarget, service, this.selectedTargetThemeFeatureCount, this.labSelectedTarget);
        this.enabledOrNot();
    }

    public int refreshSelectedFeatureCount(boolean forceGuiRefresh, JCheckBox box, AbstractFeatureService featureService, int lastSelectedFeatureCount, JLabel selectionCountlab) {
        int count = featureService == null ? 0 : FeatureServiceHelper.getSelectedFeatures(featureService).size();
        selectionCountlab.setText(NbBundle.getMessage(UnionDialog.class, (String)"UnionDialog.refreshSelectedFeatureCount.text", (Object)count));
        if (forceGuiRefresh || count != lastSelectedFeatureCount) {
            box.setSelected(count > 0);
        }
        return count;
    }

    private void enabledOrNot() {
        boolean isServiceSelected = this.cbTheme.getSelectedItem() instanceof AbstractFeatureService && this.cbTargetTheme.getSelectedItem() instanceof AbstractFeatureService;
        this.butOk.setEnabled(isServiceSelected);
    }
}

