/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.watergis.server.actions.AddProfileAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.DefaultCidsLayerBindableReferenceCombo;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.custom.attributerule.MessageDialog;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.commons.security.WebDavClient;
import de.cismet.commons.security.WebDavHelper;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.PasswordEncrypter;
import de.cismet.tools.gui.ConfirmationJFileChooser;
import de.cismet.tools.gui.RestrictedFileSystemView;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.profile.AbstractImportDialog;
import de.cismet.watergis.profile.ProfileLine;
import de.cismet.watergis.profile.ProfileReader;
import de.cismet.watergis.profile.ProfileReaderFactory;
import de.cismet.watergis.profile.QpCheckResult;
import de.cismet.watergis.profile.WPROFReader;
import de.cismet.watergis.utils.CidsBeanUtils;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Date;
import java.text.Format;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class UploadQpDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(UploadQpDialog.class);
    private static int idCounter = -1;
    private static final WebDavClient webDavClient;
    public static final String WEB_DAV_USER;
    public static final String WEB_DAV_PASSWORD;
    public static final String WEB_DAV_DIRECTORY;
    private MetaClass LAWA_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_la");
    private final Format formatter = new WatergisDefaultRuleSet.TimeFormatter();
    private boolean cancelled = false;
    private String lastPath = DownloadManager.instance().getDestinationDirectory().toString();
    private MetaClass LAGESTATUS_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_hyk");
    private MetaClass LAGE_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_l_bezug");
    private MetaClass HOEHE_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_h_bezug");
    private MetaClass FREIGABE_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_freigabe");
    private MetaClass QP_PKTE_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.qp_pkte");
    private ConnectionContext cc = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"UploadQpDialog");
    private ProfileReader reader = null;
    private boolean checkPerformed = false;
    private JButton butCancel;
    private JButton butCheck;
    private JButton butColumns;
    private JButton butGafFile;
    private JButton butOk;
    private JButton butOk1;
    private JButton butRoute;
    private JButton butUploadFiles;
    private JComboBox cbFreigabe;
    private JComboBox cbHoehe;
    private JComboBox cbLage;
    private JComboBox cbLageStatus;
    private JComboBox cbRoute;
    private JDialog diaRoute;
    private Box.Filler filler1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JXDatePicker jxDate;
    private JLabel labCheck;
    private JLabel labCol;
    private JLabel labRoute;
    private JLabel lblRoute;
    private JList<String> liFiles;
    private JTextField txtBemerkung;
    private JTextField txtBeschreibung;
    private JTextField txtGafFile;
    private JTextField txtTime;
    private JTextField txtTitle;
    private JTextField txtUsr;

    private UploadQpDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        AutoCompleteDecorator.decorate((JComboBox)this.cbRoute, (ObjectToStringConverter)new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object item) {
                if (item instanceof CidsLayerFeature) {
                    return String.valueOf(((CidsLayerFeature)item).getProperty("la_cd"));
                }
                return String.valueOf(item);
            }
        });
        this.cbRoute.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel && value instanceof CidsLayerFeature) {
                    ((JLabel)c).setText(String.valueOf(((CidsLayerFeature)value).getProperty("la_cd")));
                }
                return c;
            }
        });
        this.cbFreigabe.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel && value instanceof CidsLayerFeature) {
                    String freigabe = String.valueOf(((CidsLayerFeature)value).getProperty("freigabe"));
                    String name = String.valueOf(((CidsLayerFeature)value).getProperty("name"));
                    ((JLabel)c).setText(freigabe + "-" + name);
                }
                return c;
            }
        });
        this.cbHoehe.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel && value instanceof CidsLayerFeature) {
                    String hBez = String.valueOf(((CidsLayerFeature)value).getProperty("h_bezug"));
                    String name = String.valueOf(((CidsLayerFeature)value).getProperty("name"));
                    ((JLabel)c).setText(hBez + "-" + name);
                }
                return c;
            }
        });
        this.cbLage.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel && value instanceof CidsLayerFeature) {
                    String lBez = String.valueOf(((CidsLayerFeature)value).getProperty("l_bezug"));
                    String name = String.valueOf(((CidsLayerFeature)value).getProperty("name"));
                    ((JLabel)c).setText(lBez + "-" + name);
                }
                return c;
            }
        });
        this.cbLageStatus.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel && value instanceof CidsLayerFeature) {
                    String lst = String.valueOf(((CidsLayerFeature)value).getProperty("l_st"));
                    String name = String.valueOf(((CidsLayerFeature)value).getProperty("name"));
                    ((JLabel)c).setText(lst + "-" + name);
                }
                return c;
            }
        });
        this.setFilter();
        this.setSize(195, 700);
    }

    private void setFilter() {
        CidsLayerFeatureFilter filter = new CidsLayerFeatureFilter(){

            public boolean accept(CidsLayerFeature bean) {
                if (bean == null) {
                    return true;
                }
                return bean.getProperty("qp") != null && (Boolean)bean.getProperty("qp") != false;
            }
        };
        ((DefaultCidsLayerBindableReferenceCombo)this.cbLageStatus).setBeanFilter(filter);
        ((DefaultCidsLayerBindableReferenceCombo)this.cbFreigabe).setBeanFilter(filter);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.butColumns.setEnabled(false);
            this.butOk.setEnabled(false);
            this.butCheck.setEnabled(false);
            this.txtBemerkung.setText("");
            this.txtBeschreibung.setText("");
            this.txtGafFile.setText("");
            this.liFiles.setModel(new DefaultListModel());
            this.txtTime.setText("");
            this.txtTitle.setText("");
            this.txtUsr.setText("");
            this.cbFreigabe.setSelectedItem(null);
            this.cbLageStatus.setSelectedItem(null);
            InitComboboxThread thread = new InitComboboxThread("InitComboThread");
            thread.start();
            this.cancelled = true;
            this.resetDialog();
        }
        super.setVisible(b);
    }

    private void resetDialog() {
        this.checkPerformed = false;
        this.reader = null;
        this.lblRoute.setText("");
        this.butRoute.setEnabled(false);
        this.labRoute.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/ok.png")));
        this.labCol.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/stop.png")));
        this.labCheck.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/stop.png")));
    }

    public static UploadQpDialog getInstance() {
        return LazyInitializer.INSTANCE;
    }

    private void initComponents() {
        this.diaRoute = new JDialog();
        this.butOk1 = new JButton();
        this.jLabel11 = new JLabel();
        this.cbRoute = new DefaultCidsLayerBindableReferenceCombo(this.LAWA_MC, true);
        this.jScrollPane2 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.txtGafFile = new JTextField();
        this.butGafFile = new JButton();
        this.filler1 = new Box.Filler(new Dimension(200, 0), new Dimension(200, 0), new Dimension(200, Short.MAX_VALUE));
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.liFiles = new JList();
        this.butUploadFiles = new JButton();
        this.jPanel5 = new JPanel();
        this.butColumns = new JButton();
        this.labCol = new JLabel();
        this.jPanel13 = new JPanel();
        this.butRoute = new JButton();
        this.labRoute = new JLabel();
        this.lblRoute = new JLabel();
        this.jPanel6 = new JPanel();
        this.cbLage = new DefaultCidsLayerBindableReferenceCombo(this.LAGE_MC, false);
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cbHoehe = new DefaultCidsLayerBindableReferenceCombo(this.HOEHE_MC, false);
        this.jSeparator1 = new JSeparator();
        this.jPanel7 = new JPanel();
        this.butCheck = new JButton();
        this.labCheck = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jPanel8 = new JPanel();
        this.cbLageStatus = new DefaultCidsLayerBindableReferenceCombo(this.LAGESTATUS_MC, false);
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.cbFreigabe = new DefaultCidsLayerBindableReferenceCombo(this.FREIGABE_MC, false);
        this.jPanel9 = new JPanel();
        this.jLabel5 = new JLabel();
        this.txtUsr = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.txtTime = new JFormattedTextField(this.formatter);
        this.jxDate = new JXDatePicker();
        this.jPanel10 = new JPanel();
        this.jLabel8 = new JLabel();
        this.txtTitle = new JTextField();
        this.jPanel11 = new JPanel();
        this.jLabel9 = new JLabel();
        this.txtBeschreibung = new JTextField();
        this.jPanel12 = new JPanel();
        this.jLabel10 = new JLabel();
        this.txtBemerkung = new JTextField();
        this.jSeparator3 = new JSeparator();
        this.diaRoute.setDefaultCloseOperation(2);
        this.diaRoute.setTitle(NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.diaRoute.title", (Object[])new Object[0]));
        this.diaRoute.setAlwaysOnTop(true);
        this.diaRoute.setModal(true);
        this.diaRoute.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk1, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butOk1.text", (Object[])new Object[0]));
        this.butOk1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.butOk1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.diaRoute.getContentPane().add((Component)this.butOk1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.jLabel11.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.diaRoute.getContentPane().add((Component)this.jLabel11, gridBagConstraints);
        this.cbRoute.setMinimumSize(new Dimension(200, 27));
        this.cbRoute.setPreferredSize(new Dimension(200, 27));
        this.cbRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.cbRouteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.diaRoute.getContentPane().add((Component)this.cbRoute, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.title", (Object[])new Object[0]));
        this.setMinimumSize(new Dimension(690, 191));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butOk.text_1", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(170, 29));
        this.butOk.setPreferredSize(new Dimension(170, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butCancel.text_1", (Object[])new Object[0]));
        this.butCancel.setMinimumSize(new Dimension(170, 29));
        this.butCancel.setPreferredSize(new Dimension(170, 29));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.txtGafFile.setEditable(false);
        this.txtGafFile.setText(NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.txtGafFile.text_1", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.txtGafFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butGafFile, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butGafFile.text_1", (Object[])new Object[0]));
        this.butGafFile.setMaximumSize(new Dimension(146, 29));
        this.butGafFile.setMinimumSize(new Dimension(146, 29));
        this.butGafFile.setPreferredSize(new Dimension(146, 29));
        this.butGafFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.butGafFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.butGafFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        this.jPanel2.add((Component)this.filler1, gridBagConstraints);
        this.jPanel4.setPreferredSize(new Dimension(252, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(66, 75));
        this.liFiles.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.liFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butUploadFiles, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butUploadFiles.text", (Object[])new Object[0]));
        this.butUploadFiles.setMaximumSize(new Dimension(146, 29));
        this.butUploadFiles.setMinimumSize(new Dimension(146, 29));
        this.butUploadFiles.setPreferredSize(new Dimension(146, 29));
        this.butUploadFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.butUploadFilesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel4.add((Component)this.butUploadFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butColumns, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butColumns.text", (Object[])new Object[0]));
        this.butColumns.setMinimumSize(new Dimension(146, 29));
        this.butColumns.setPreferredSize(new Dimension(146, 29));
        this.butColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.butColumnsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 140);
        this.jPanel5.add((Component)this.butColumns, gridBagConstraints);
        this.labCol.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/stop.png")));
        Mnemonics.setLocalizedText((JLabel)this.labCol, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.labCol.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel5.add((Component)this.labCol, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel13.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butRoute, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butRoute.text", (Object[])new Object[0]));
        this.butRoute.setEnabled(false);
        this.butRoute.setMinimumSize(new Dimension(146, 29));
        this.butRoute.setPreferredSize(new Dimension(146, 29));
        this.butRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.butRouteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel13.add((Component)this.butRoute, gridBagConstraints);
        this.labRoute.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/ok.png")));
        Mnemonics.setLocalizedText((JLabel)this.labRoute, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.labRoute.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel13.add((Component)this.labRoute, gridBagConstraints);
        this.lblRoute.setMaximumSize(new Dimension(130, 20));
        this.lblRoute.setMinimumSize(new Dimension(130, 20));
        this.lblRoute.setPreferredSize(new Dimension(130, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.jPanel13.add((Component)this.lblRoute, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel13, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.cbLage.setMinimumSize(new Dimension(200, 27));
        this.cbLage.setPreferredSize(new Dimension(200, 27));
        this.cbLage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.cbLageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.jPanel6.add((Component)this.cbLage, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.jLabel1.text", (Object[])new Object[0]));
        this.jLabel1.setMinimumSize(new Dimension(110, 20));
        this.jLabel1.setPreferredSize(new Dimension(110, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel6.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.jLabel2.text", (Object[])new Object[0]));
        this.jLabel2.setMinimumSize(new Dimension(110, 20));
        this.jLabel2.setPreferredSize(new Dimension(110, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel6.add((Component)this.jLabel2, gridBagConstraints);
        this.cbHoehe.setMinimumSize(new Dimension(200, 27));
        this.cbHoehe.setPreferredSize(new Dimension(200, 27));
        this.cbHoehe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.cbHoeheActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.jPanel6.add((Component)this.cbHoehe, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butCheck, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butCheck.text", (Object[])new Object[0]));
        this.butCheck.setMinimumSize(new Dimension(146, 29));
        this.butCheck.setPreferredSize(new Dimension(146, 29));
        this.butCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.butCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel7.add((Component)this.butCheck, gridBagConstraints);
        this.labCheck.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/stop.png")));
        Mnemonics.setLocalizedText((JLabel)this.labCheck, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.labCheck.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel7.add((Component)this.labCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanel8.setLayout(new GridBagLayout());
        this.cbLageStatus.setMinimumSize(new Dimension(200, 27));
        this.cbLageStatus.setPreferredSize(new Dimension(200, 27));
        this.cbLageStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.cbLageStatusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.jPanel8.add((Component)this.cbLageStatus, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.jLabel3.text", (Object[])new Object[0]));
        this.jLabel3.setMinimumSize(new Dimension(110, 20));
        this.jLabel3.setPreferredSize(new Dimension(110, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel3, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.jLabel4.text", (Object[])new Object[0]));
        this.jLabel4.setMinimumSize(new Dimension(110, 20));
        this.jLabel4.setPreferredSize(new Dimension(110, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel8.add((Component)this.jLabel4, gridBagConstraints);
        this.cbFreigabe.setMinimumSize(new Dimension(200, 27));
        this.cbFreigabe.setPreferredSize(new Dimension(200, 27));
        this.cbFreigabe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.cbFreigabeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.jPanel8.add((Component)this.cbFreigabe, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.jLabel5.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel9.add((Component)this.jLabel5, gridBagConstraints);
        this.txtUsr.setText(NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.txtUsr.text", (Object[])new Object[0]));
        this.txtUsr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.txtUsrActionPerformed(evt);
            }
        });
        this.txtUsr.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UploadQpDialog.this.txtUsrKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel9.add((Component)this.txtUsr, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.jLabel6.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel9.add((Component)this.jLabel6, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.jLabel7.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel9.add((Component)this.jLabel7, gridBagConstraints);
        this.txtTime.setText(NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.txtTime.text", (Object[])new Object[0]));
        this.txtTime.setToolTipText(NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.txtTime.toolTipText", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel9.add((Component)this.txtTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel9.add((Component)this.jxDate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel10.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.jLabel8.text", (Object[])new Object[0]));
        this.jLabel8.setMinimumSize(new Dimension(110, 20));
        this.jLabel8.setPreferredSize(new Dimension(110, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel10.add((Component)this.jLabel8, gridBagConstraints);
        this.txtTitle.setText(NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.txtTitle.text", (Object[])new Object[0]));
        this.txtTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.txtTitleActionPerformed(evt);
            }
        });
        this.txtTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UploadQpDialog.this.txtTitleKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel10.add((Component)this.txtTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel10, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.jLabel9.text", (Object[])new Object[0]));
        this.jLabel9.setMinimumSize(new Dimension(110, 20));
        this.jLabel9.setPreferredSize(new Dimension(110, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel11.add((Component)this.jLabel9, gridBagConstraints);
        this.txtBeschreibung.setText(NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.txtBeschreibung.text", (Object[])new Object[0]));
        this.txtBeschreibung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.txtBeschreibungActionPerformed(evt);
            }
        });
        this.txtBeschreibung.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UploadQpDialog.this.txtBeschreibungKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel11.add((Component)this.txtBeschreibung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel11, gridBagConstraints);
        this.jPanel12.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.jLabel10.text", (Object[])new Object[0]));
        this.jLabel10.setMinimumSize(new Dimension(110, 20));
        this.jLabel10.setPreferredSize(new Dimension(110, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel12.add((Component)this.jLabel10, gridBagConstraints);
        this.txtBemerkung.setText(NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.txtBemerkung.text", (Object[])new Object[0]));
        this.txtBemerkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UploadQpDialog.this.txtBemerkungActionPerformed(evt);
            }
        });
        this.txtBemerkung.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                UploadQpDialog.this.txtBemerkungKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel12.add((Component)this.txtBemerkung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.jSeparator3, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        int answer;
        if (this.butOk.isEnabled() && (answer = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butCancelActionPerformed.message"), NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butCancelActionPerformed.title"), 0)) == 1) {
            return;
        }
        this.cancelled = true;
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        WaitingDialogThread wdt = new WaitingDialogThread(StaticSwingTools.getParentFrame((Component)this), true, "Importiere Profile              ", null, 100, true){

            /*
             * WARNING - void declaration
             */
            protected Object doInBackground() throws Exception {
                String userName = SessionManager.getSession().getUser().getName();
                CidsBean qpUplBean = UploadQpDialog.this.createQpUplObject();
                Set<Double> profileSet = UploadQpDialog.this.reader.getProfiles();
                int profNumber = 0;
                this.wd.setMax(profileSet.size());
                for (Double profileId : profileSet) {
                    this.wd.setText("Importiere Profil " + ++profNumber + "/" + profileSet.size());
                    this.wd.setProgress(profNumber);
                    CidsBean qpNplBean = UploadQpDialog.this.createQpNplObject((Geometry)UploadQpDialog.this.reader.getNpLine(profileId), UploadQpDialog.this.reader.getProfileContent(profileId).get(0), qpUplBean);
                    ArrayList<Object[]> dataList = new ArrayList<Object[]>();
                    for (ProfileLine profileLine : UploadQpDialog.this.reader.getProfileContent(profileId)) {
                        Integer qpId = UploadQpDialog.getNewId();
                        Object[] pktData = UploadQpDialog.this.fillQpPkt(qpUplBean, qpNplBean, profileLine);
                        dataList.add(pktData);
                    }
                    ServerActionParameter pktDataParam = new ServerActionParameter(AddProfileAction.ParameterType.DATA.toString(), dataList.toArray((T[])new Object[dataList.size()][]));
                    Boolean bl = (Boolean)SessionManager.getProxy().executeTask("addProfileAction", AppBroker.getInstance().getDomain(), null, ConnectionContext.createDummy(), new ServerActionParameter[]{pktDataParam});
                }
                String fileName = "qp-" + String.valueOf(qpUplBean.getProperty("upl_nr")) + ".zip";
                String filePrefix = "qp/";
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ZipOutputStream zout = new ZipOutputStream(bout);
                ArrayList<String> files = new ArrayList<String>();
                files.add(UploadQpDialog.this.txtGafFile.getText());
                if (UploadQpDialog.this.liFiles.getModel() != null && UploadQpDialog.this.liFiles.getModel().getSize() > 0) {
                    void var10_14;
                    boolean bl = false;
                    while (var10_14 < UploadQpDialog.this.liFiles.getModel().getSize()) {
                        files.add((String)UploadQpDialog.this.liFiles.getModel().getElementAt((int)var10_14));
                        ++var10_14;
                    }
                }
                for (String f : files) {
                    int count;
                    ZipEntry entry = new ZipEntry(f.substring(f.lastIndexOf("/") + 1));
                    zout.putNextEntry(entry);
                    FileInputStream fis = new FileInputStream(f);
                    byte[] tmp = new byte[256];
                    while ((count = fis.read(tmp)) != -1) {
                        zout.write(tmp, 0, count);
                    }
                    zout.closeEntry();
                }
                zout.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bout.toByteArray());
                WebDavHelper.createFolder((String)(WEB_DAV_DIRECTORY + "qp/"), (WebDavClient)webDavClient);
                WebDavHelper.uploadFileToWebDAV((String)fileName, (InputStream)byteArrayInputStream, (String)(WEB_DAV_DIRECTORY + "qp/"), (WebDavClient)webDavClient, (Component)UploadQpDialog.this);
                return null;
            }

            protected void done() {
                try {
                    CidsLayer layer;
                    this.get();
                    List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp_upl");
                    if (services == null || services.isEmpty()) {
                        layer = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.qp_upl", (ConnectionContext)UploadQpDialog.this.cc));
                        AppBroker.getInstance().getMappingComponent().getMappingModel().addLayer((RetrievalServiceLayer)layer);
                    }
                    if ((services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp_npl")) == null || services.isEmpty()) {
                        layer = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.qp_npl", (ConnectionContext)UploadQpDialog.this.cc));
                        AppBroker.getInstance().getMappingComponent().getMappingModel().addLayer((RetrievalServiceLayer)layer);
                    }
                    if ((services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp_pkte")) == null || services.isEmpty()) {
                        layer = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.qp_pkte", (ConnectionContext)UploadQpDialog.this.cc));
                        AppBroker.getInstance().getMappingComponent().getMappingModel().addLayer((RetrievalServiceLayer)layer);
                    }
                    this.reloadService("qp_upl");
                    this.reloadService("qp_pkte");
                    this.reloadService("qp_npl");
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while importing QB Objects", (Throwable)e);
                }
            }

            private void reloadService(String name) {
                AttributeTable tablePf;
                List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree(name);
                for (AbstractFeatureService featureService : services) {
                    featureService.retrieve(true);
                }
                if (services != null && !services.isEmpty() && (tablePf = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeatureService(services.get(0))) != null) {
                    tablePf.reload();
                }
            }
        };
        wdt.start();
        this.cancelled = false;
        this.setVisible(false);
    }

    private Object[] fillQpPkt(CidsBean qpUpl, CidsBean qNpl, ProfileLine line) {
        Object[] pktObject = new Object[14];
        Double stat = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.STATION);
        pktObject[0] = qpUpl.getPrimaryKeyValue();
        pktObject[1] = qNpl.getPrimaryKeyValue();
        pktObject[2] = line.getField(ProfileReader.GAF_FIELDS.ID);
        pktObject[3] = stat != null && stat >= 0.0 ? stat : null;
        pktObject[4] = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.Y);
        pktObject[5] = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.Z);
        pktObject[6] = line.getField(ProfileReader.GAF_FIELDS.KZ);
        pktObject[7] = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.RK);
        pktObject[8] = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.BK);
        pktObject[9] = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.HW);
        pktObject[10] = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.RW);
        pktObject[11] = line.getField(ProfileReader.GAF_FIELDS.HYK);
        return pktObject;
    }

    private CidsBean createQpUplObject() throws Exception {
        CidsBean newQpUplBean = CidsBeanUtils.createNewCidsBeanFromTableName("dlm25w.qp_upl");
        GregorianCalendar now = new GregorianCalendar();
        Date aufnDate = this.jxDate.getDate() == null ? null : new Date(this.jxDate.getDate().getTime());
        newQpUplBean.setProperty("ww_gr", (Object)AppBroker.getInstance().getOwnWwGr());
        newQpUplBean.setProperty("l_st", (Object)((CidsLayerFeature)this.cbLageStatus.getSelectedItem()).getBean());
        newQpUplBean.setProperty("l_bezug", (Object)((CidsLayerFeature)this.cbLage.getSelectedItem()).getBean());
        newQpUplBean.setProperty("h_bezug", (Object)((CidsLayerFeature)this.cbHoehe.getSelectedItem()).getBean());
        newQpUplBean.setProperty("l_calc", (Object)(this.reader.isCalc() ? "calc" : "-"));
        newQpUplBean.setProperty("upl_name", (Object)SessionManager.getSession().getUser().getName());
        newQpUplBean.setProperty("aufn_name", (Object)this.txtUsr.getText());
        newQpUplBean.setProperty("aufn_datum", (Object)aufnDate);
        newQpUplBean.setProperty("aufn_zeit", (Object)this.txtTime.getText());
        newQpUplBean.setProperty("freigabe", (Object)((CidsLayerFeature)this.cbFreigabe.getSelectedItem()).getBean());
        newQpUplBean.setProperty("titel", (Object)this.txtTitle.getText());
        newQpUplBean.setProperty("beschreib", (Object)this.txtBeschreibung.getText());
        newQpUplBean.setProperty("bemerkung", (Object)this.txtBemerkung.getText());
        newQpUplBean.setProperty("fis_g_user", (Object)SessionManager.getSession().getUser().getName());
        return newQpUplBean.persist(this.cc);
    }

    private CidsBean createQpNplObject(Geometry npl, ProfileLine line, CidsBean upl) throws Exception {
        CidsBean newQpNplBean = CidsBeanUtils.createNewCidsBeanFromTableName("dlm25w.qp_npl");
        CidsBean geomBean = CidsBeanUtils.createNewCidsBeanFromTableName("geom");
        geomBean.setProperty("geo_field", (Object)npl);
        Double stat = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.STATION);
        newQpNplBean.setProperty("ww_gr", (Object)AppBroker.getInstance().getOwnWwGr());
        newQpNplBean.setProperty("geom", (Object)geomBean);
        newQpNplBean.setProperty("stat", stat != null && stat >= 0.0 ? stat : null);
        newQpNplBean.setProperty("l_st", (Object)((CidsLayerFeature)this.cbLageStatus.getSelectedItem()).getBean());
        newQpNplBean.setProperty("qp_upl", (Object)upl);
        newQpNplBean.setProperty("bemerkung", (Object)this.txtBemerkung.getText());
        newQpNplBean.setProperty("fis_g_user", (Object)SessionManager.getSession().getUser().getName());
        return newQpNplBean.persist(this.cc);
    }

    private void butGafFileActionPerformed(ActionEvent evt) {
        File file = StaticSwingTools.chooseFile((String)this.lastPath, (boolean)false, null, (String)"Alle Dateien", (Component)AppBroker.getInstance().getComponent(ComponentName.MAIN));
        if (file != null) {
            this.lastPath = file.getParent();
            this.txtGafFile.setText(file.getAbsolutePath());
            if (this.txtGafFile.getText() != null && !this.txtGafFile.getText().isEmpty()) {
                this.butColumns.setEnabled(true);
            }
            this.resetDialog();
        }
    }

    private void butUploadFilesActionPerformed(ActionEvent evt) {
        Object fc;
        try {
            fc = new ConfirmationJFileChooser(this.lastPath);
        }
        catch (Exception bug) {
            fc = new JFileChooser(this.lastPath, (FileSystemView)new RestrictedFileSystemView());
        }
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return "Alle Dateien";
            }
        };
        ((JFileChooser)fc).setAcceptAllFileFilterUsed(false);
        ((JFileChooser)fc).setFileFilter(fileFilter);
        ((JFileChooser)fc).setMultiSelectionEnabled(true);
        int state = ((JFileChooser)fc).showOpenDialog(AppBroker.getInstance().getComponent(ComponentName.MAIN));
        if (state == 0) {
            File[] files = ((JFileChooser)fc).getSelectedFiles();
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (File file : files) {
                this.lastPath = file.getParent();
                model.addElement(file.getAbsolutePath());
            }
            this.liFiles.setModel(model);
        } else {
            this.liFiles.setModel(new DefaultListModel());
        }
    }

    private void butColumnsActionPerformed(ActionEvent evt) {
        this.reader = ProfileReaderFactory.getReader(new File(this.txtGafFile.getText()));
        AbstractImportDialog dialog = this.reader.getImportDialog(StaticSwingTools.getParentFrame((Component)this));
        if (dialog != null) {
            dialog.setAlwaysOnTop(true);
            StaticSwingTools.showDialog((JDialog)dialog);
            if (dialog.isCancelled()) {
                this.reader = null;
                this.labCol.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/stop.png")));
                return;
            }
            this.butCheck.setEnabled(this.cbHoehe.getSelectedItem() != null && this.cbLage.getSelectedItem() != null && this.reader != null);
            this.labCol.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/ok.png")));
            if (dialog.isRouteRequired()) {
                this.butRoute.setEnabled(true);
                this.labRoute.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/stop.png")));
            } else {
                this.butRoute.setEnabled(false);
                this.labRoute.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/ok.png")));
            }
        }
    }

    private void cbLageActionPerformed(ActionEvent evt) {
        this.butCheck.setEnabled(this.cbHoehe.getSelectedItem() != null && this.cbLage.getSelectedItem() != null && this.reader != null);
        this.checkUploadButton();
    }

    private void cbHoeheActionPerformed(ActionEvent evt) {
        this.butCheck.setEnabled(this.cbHoehe.getSelectedItem() != null && this.cbLage.getSelectedItem() != null && this.reader != null);
        this.checkUploadButton();
    }

    private void butCheckActionPerformed(ActionEvent evt) {
        this.reader.setLageBezug((CidsLayerFeature)this.cbLage.getSelectedItem());
        this.reader.setHoeheBezug((CidsLayerFeature)this.cbHoehe.getSelectedItem());
        QpCheckResult result = this.reader.checkFileForHints();
        if (result != null) {
            MessageDialog d;
            String text;
            String title;
            Object[] res = new Object[]{result.getCorrect(), result.getIncorrect(), null};
            if (result.getErrors() != null && !result.getErrors().isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (QpCheckResult.ErrorResult er : result.getErrors()) {
                    sb.append("Zeile").append(er.getLine()).append(": ").append(er.getErrorText());
                }
            }
            res[2] = this.listToString(result.getErrors());
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butCheckActionPerformed.message", (Object[])res), NbBundle.getMessage(UploadQpDialog.class, (String)"UploadQpDialog.butCheckActionPerformed.title"), 1);
            if (result.getCorrect() == 0) {
                title = "Import-Info";
                text = "Die Datei enh\u00e4lt keine g\u00fcltigen QP - ein Upload ist nicht m\u00f6glich";
                d = new MessageDialog((Frame)AppBroker.getInstance().getWatergisApp(), true, "Die Datei enh\u00e4lt keine g\u00fcltigen QP - ein Upload ist nicht m\u00f6glich", "Import-Info");
                d.setSize(500, 80);
                StaticSwingTools.showDialog((JDialog)d);
            } else if (result.getIncorrect() > 0) {
                title = "Import-Info";
                text = "Beim Upload werden nur die g\u00fcltigen QP ber\u00fccksichtigt!";
                d = new MessageDialog((Frame)AppBroker.getInstance().getWatergisApp(), true, "Beim Upload werden nur die g\u00fcltigen QP ber\u00fccksichtigt!", "Import-Info");
                d.setSize(500, 80);
                StaticSwingTools.showDialog((JDialog)d);
            }
            if (result.getCorrect() > 0) {
                this.checkPerformed = true;
                this.labCheck.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/ok.png")));
            }
        }
        this.checkUploadButton();
    }

    private void cbLageStatusActionPerformed(ActionEvent evt) {
        this.checkUploadButton();
    }

    private void cbFreigabeActionPerformed(ActionEvent evt) {
        this.checkUploadButton();
    }

    private void txtTitleActionPerformed(ActionEvent evt) {
        this.checkUploadButton();
    }

    private void txtBeschreibungActionPerformed(ActionEvent evt) {
        this.checkUploadButton();
    }

    private void txtBemerkungActionPerformed(ActionEvent evt) {
        this.checkUploadButton();
    }

    private void txtUsrActionPerformed(ActionEvent evt) {
        this.checkUploadButton();
    }

    private void txtTitleKeyReleased(KeyEvent evt) {
        this.checkUploadButton();
    }

    private void txtBeschreibungKeyReleased(KeyEvent evt) {
        this.checkUploadButton();
    }

    private void txtBemerkungKeyReleased(KeyEvent evt) {
        this.checkUploadButton();
    }

    private void txtUsrKeyReleased(KeyEvent evt) {
        this.checkUploadButton();
    }

    private void butRouteActionPerformed(ActionEvent evt) {
        this.diaRoute.setSize(300, 150);
        this.diaRoute.setAlwaysOnTop(true);
        StaticSwingTools.centerWindowOnScreen((Window)this.diaRoute);
    }

    private void butOk1ActionPerformed(ActionEvent evt) {
        if (this.cbRoute.getSelectedItem() != null && this.reader instanceof WPROFReader) {
            CidsLayerFeature routeFeature = (CidsLayerFeature)this.cbRoute.getSelectedItem();
            ((WPROFReader)this.reader).setRoute(routeFeature);
            this.diaRoute.setVisible(false);
            this.labRoute.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/ok.png")));
            this.lblRoute.setText(String.valueOf(routeFeature.getProperty("la_cd")));
        }
    }

    private void cbRouteActionPerformed(ActionEvent evt) {
    }

    static synchronized int getNewId() {
        return --idCounter;
    }

    private String listToString(List<QpCheckResult.ErrorResult> list) {
        ArrayList<Object> errors = null;
        int size = list != null ? list.size() : 0;
        boolean errorCut = false;
        int MAX_SIZE = 20;
        if (size > 20) {
            errors = new ArrayList();
            for (int i = 0; i < 20; ++i) {
                errors.add(list.get(i));
            }
            errorCut = true;
        } else if (list != null) {
            errors = new ArrayList<QpCheckResult.ErrorResult>(list);
        }
        if (errors == null || errors.isEmpty()) {
            return "keine";
        }
        StringBuilder sb = new StringBuilder();
        for (QpCheckResult.ErrorResult errorResult : errors) {
            sb.append("Zeile ").append(errorResult.getLine()).append(": ").append(errorResult.getErrorText()).append("\n");
        }
        if (errorCut) {
            sb.append("... weitere Fehler in ").append(size - 20).append(" Zeilen\n");
        }
        return sb.toString();
    }

    private void checkUploadButton() {
        boolean active = this.cbFreigabe.getSelectedItem() != null && this.cbHoehe.getSelectedItem() != null && this.cbLage.getSelectedItem() != null && this.cbLageStatus.getSelectedItem() != null && this.reader != null && this.checkPerformed && this.labRoute.getIcon().toString().endsWith("ok.png");
        this.butOk.setEnabled(active);
    }

    public String getGafFile() {
        return this.txtGafFile.getText();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("WebDav");
        String pass = bundle.getString("password");
        if (pass != null) {
            pass = new String(PasswordEncrypter.decrypt((char[])pass.toCharArray(), (boolean)true));
        }
        WEB_DAV_PASSWORD = pass;
        WEB_DAV_USER = bundle.getString("username");
        WEB_DAV_DIRECTORY = bundle.getString("url");
        webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, true);
    }

    private static final class LazyInitializer {
        private static final transient UploadQpDialog INSTANCE = new UploadQpDialog((Frame)AppBroker.getInstance().getWatergisApp(), true);

        private LazyInitializer() {
        }
    }

    private final class InitComboboxThread
    extends Thread {
        public InitComboboxThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            boolean done = false;
            do {
                if (UploadQpDialog.this.cbHoehe.getModel().getSize() > 1 && UploadQpDialog.this.cbLage.getModel().getSize() > 1 && UploadQpDialog.this.cbLageStatus.getModel().getSize() > 1) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UploadQpDialog.this.cbHoehe.setSelectedIndex(0);
                            UploadQpDialog.this.cbLage.setSelectedIndex(0);
                            UploadQpDialog.this.cbLageStatus.setSelectedIndex(UploadQpDialog.this.cbLageStatus.getModel().getSize() - 1);
                        }
                    });
                    done = true;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!done);
        }
    }
}

