/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.panels;

import de.cismet.tools.gui.RestrictedFileSystemView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class DocumentPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(DocumentPanel.class);
    private String lastPath;
    private JButton butFile;
    private JTextField txtFile;

    public DocumentPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.txtFile = new JTextField();
        this.butFile = new JButton();
        this.setLayout(new GridBagLayout());
        this.txtFile.setText(NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.txtFile.text", (Object[])new Object[0]));
        this.txtFile.setEnabled(false);
        this.txtFile.setMinimumSize(new Dimension(16, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.txtFile, gridBagConstraints);
        this.butFile.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-importfile.png")));
        this.butFile.setMinimumSize(new Dimension(16, 16));
        this.butFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.butFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.butFile, gridBagConstraints);
    }

    private void butFileActionPerformed(ActionEvent evt) {
        JFileChooser fc;
        String path = this.lastPath;
        if (this.txtFile.getText() != null && !this.txtFile.getText().equals("") && !this.txtFile.getText().startsWith("http")) {
            if (this.txtFile.getText().contains("/")) {
                path = this.txtFile.getText().substring(0, this.txtFile.getText().lastIndexOf("/"));
            } else if (this.txtFile.getText().contains("\\")) {
                path = this.txtFile.getText().substring(0, this.txtFile.getText().lastIndexOf("\\"));
            }
        }
        try {
            fc = new JFileChooser(path);
        }
        catch (Exception bug) {
            fc = new JFileChooser(path, (FileSystemView)new RestrictedFileSystemView());
        }
        fc.setFileSelectionMode(0);
        fc.setAcceptAllFileFilterUsed(true);
        int ans = fc.showSaveDialog(this);
        if (ans == 0) {
            this.lastPath = fc.getSelectedFile().getParent();
            this.txtFile.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    public String getFile() {
        return this.txtFile.getText();
    }

    public void setValue(String file) {
        this.txtFile.setText(file);
    }

    public String getValue() {
        return this.txtFile.getText();
    }
}

