/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.profile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.watergis.profile.ProfileReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProfileLine {
    private static final Logger LOG = Logger.getLogger(ProfileLine.class);
    private String[] data;
    private final Map<ProfileReader.GAF_FIELDS, Integer> fieldMap;
    private CidsLayerFeature bezug;

    public ProfileLine(Map<ProfileReader.GAF_FIELDS, Integer> fieldMap, String[] data) {
        Integer statIndex;
        if (fieldMap.size() < data.length) {
            this.data = new String[fieldMap.size()];
            this.fieldMap = new HashMap<ProfileReader.GAF_FIELDS, Integer>();
            int i = 0;
            for (ProfileReader.GAF_FIELDS field : fieldMap.keySet()) {
                int index = i++;
                this.fieldMap.put(field, index);
                this.data[index] = data[fieldMap.get((Object)field)];
            }
        } else {
            this.data = data;
            this.fieldMap = new HashMap<ProfileReader.GAF_FIELDS, Integer>(fieldMap);
        }
        if ((statIndex = this.fieldMap.get((Object)ProfileReader.GAF_FIELDS.STATION)) != null) {
            this.data[statIndex.intValue()] = this.data[statIndex].replace("*", "");
        }
    }

    public CidsLayerFeature getBezug() {
        return this.bezug;
    }

    public void setBezug(CidsLayerFeature bezug) {
        try {
            if (!(this.bezug == bezug || this.bezug == null && bezug != null && bezug.getProperty("l_bezug").equals(5650))) {
                CrsTransformer transformer = new CrsTransformer("EPSG:5650");
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 0);
                String rw = this.getField(ProfileReader.GAF_FIELDS.RW).replace(',', '.');
                String hw = this.getField(ProfileReader.GAF_FIELDS.HW).replace(',', '.');
                if (rw != null && hw != null) {
                    try {
                        Double rwD = Double.parseDouble(rw);
                        Double hwD = Double.parseDouble(hw);
                        Point point = factory.createPoint(new Coordinate(rwD.doubleValue(), hwD.doubleValue()));
                        Geometry transformedPoint = transformer.fastTransformGeometry((Geometry)point, this.getEPSG(bezug));
                        this.setField(ProfileReader.GAF_FIELDS.RW, transformedPoint.getCoordinate().x);
                        this.setField(ProfileReader.GAF_FIELDS.HW, transformedPoint.getCoordinate().y);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while transforming coordinates", (Throwable)e);
        }
        this.bezug = bezug;
    }

    private String getEPSG(CidsLayerFeature bezug) {
        if (bezug == null) {
            return "EPSG:5650";
        }
        return "EPSG:" + bezug.getProperty("l_bezug");
    }

    public String getField(ProfileReader.GAF_FIELDS field) {
        Integer index = this.fieldMap.get((Object)field);
        if (index == null || index >= this.data.length) {
            return null;
        }
        return this.data[index];
    }

    public Double getFieldAsDouble(ProfileReader.GAF_FIELDS field) throws NumberFormatException {
        Integer index = this.fieldMap.get((Object)field);
        if (index == null) {
            return null;
        }
        if (index >= this.data.length) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.data[index].replace(',', '.'));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setField(ProfileReader.GAF_FIELDS field, Object o) {
        Integer index = this.fieldMap.get((Object)field);
        if (index == null) {
            this.fieldMap.put(field, this.fieldMap.size());
            String[] tmp = this.data;
            index = tmp.length;
            this.data = new String[this.data.length + 1];
            System.arraycopy(tmp, 0, this.data, 0, tmp.length);
        } else if (index >= this.data.length) {
            String[] tmp = this.data;
            this.data = new String[index + 1];
            System.arraycopy(tmp, 0, this.data, 0, tmp.length);
        }
        this.data[index.intValue()] = o == null ? null : o.toString();
    }

    public boolean hasCorrectLength() {
        return this.fieldMap.size() <= this.data.length;
    }
}

