/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.commons.security.WebDavClient;
import de.cismet.commons.security.WebDavHelper;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.PasswordEncrypter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import org.apache.log4j.Logger;

public class FotoScriptlet
extends JRDefaultScriptlet {
    private static final Logger LOG = Logger.getLogger(FotoScriptlet.class);
    private static final String WEB_DAV_USER;
    private static final String WEB_DAV_PASSWORD;
    private static final String WEB_DAV_DIRECTORY;
    private static final WebDavClient webDavClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image loadFoto() {
        BufferedImage result = null;
        String path = (String)((JRFillField)this.fieldsMap.get("dateipfad")).getValue();
        String filename = (String)((JRFillField)this.fieldsMap.get("foto")).getValue();
        String file = path + filename;
        String encodedFilename = WebDavHelper.encodeURL((String)file);
        InputStream inputStream = null;
        try {
            inputStream = webDavClient.getInputStream(WEB_DAV_DIRECTORY + encodedFilename);
            result = ImageIO.read(inputStream);
        }
        catch (IOException ex) {
            LOG.error((Object)"Couldn't load photo", (Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    LOG.error((Object)("Couldn't close stream for " + encodedFilename), (Throwable)ex);
                }
            }
        }
        if (result == null) {
            try {
                result = ImageIO.read(((Object)((Object)this)).getClass().getResource("/de/cismet/watergis/res/icon128/file-broken.png"));
            }
            catch (IOException ex1) {
                LOG.error((Object)"Couldn't load fallback photo", (Throwable)ex1);
            }
        }
        return result;
    }

    public Image generateMap() {
        try {
            Geometry point = (Geometry)((JRFillParameter)this.parametersMap.get("punkt")).getValue();
            MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
            HeadlessMapProvider mapProvider = HeadlessMapProvider.createHeadlessMapProviderAndAddLayers((MappingComponent)mc);
            XBoundingBox boundingBox = new XBoundingBox(point);
            boundingBox.setX1(boundingBox.getX1() - 50.0);
            boundingBox.setY1(boundingBox.getY1() - 50.0);
            boundingBox.setX2(boundingBox.getX2() + 50.0);
            boundingBox.setY2(boundingBox.getY2() + 50.0);
            BoundingBox scaledBBox = mc.getScaledBoundingBox(500.0, (BoundingBox)boundingBox);
            int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode());
            XBoundingBox bbox = new XBoundingBox(scaledBBox.getGeometry(srid));
            mapProvider.setBoundingBox(bbox);
            return mapProvider.getImageAndWait(311, 236);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving map.", (Throwable)e);
            return null;
        }
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("WebDav");
        String pass = bundle.getString("password");
        if (pass != null) {
            pass = new String(PasswordEncrypter.decrypt((char[])pass.toCharArray(), (boolean)true));
        }
        WEB_DAV_PASSWORD = pass;
        WEB_DAV_USER = bundle.getString("username");
        WEB_DAV_DIRECTORY = bundle.getString("url");
        webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, true);
    }

    public class SignallingRetrievalListener
    implements RetrievalListener {
        private BufferedImage image = null;
        private final Lock lock;
        private Condition condition;

        public SignallingRetrievalListener(Lock lock, Condition condition) {
            this.lock = lock;
            this.condition = condition;
        }

        public void retrievalStarted(RetrievalEvent e) {
        }

        public void retrievalProgress(RetrievalEvent e) {
        }

        public void retrievalComplete(RetrievalEvent e) {
            if (e.getRetrievedObject() instanceof Image) {
                Image retrievedImage = (Image)e.getRetrievedObject();
                this.image = new BufferedImage(retrievedImage.getWidth(null), retrievedImage.getHeight(null), 1);
                Graphics2D g = (Graphics2D)this.image.getGraphics();
                g.drawImage(retrievedImage, 0, 0, null);
                g.dispose();
            }
            this.signalAll();
        }

        public void retrievalAborted(RetrievalEvent e) {
            this.signalAll();
        }

        public void retrievalError(RetrievalEvent e) {
            this.signalAll();
        }

        public BufferedImage getRetrievedImage() {
            return this.image;
        }

        private void signalAll() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

