/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.watergis.profile.GafReader;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import org.apache.log4j.Logger;

public class GafScriptlet
extends JRDefaultScriptlet {
    private static final Logger LOG = Logger.getLogger(GafScriptlet.class);
    private final CidsLayer ppLayer = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.qp_gaf_pp"));

    public Image loadPreview() {
        Image result = null;
        try {
            String qpNr = (String)((JRFillParameter)this.parametersMap.get("qp_nr")).getValue();
            this.ppLayer.initAndWait();
            List features = this.ppLayer.getFeatureFactory().createFeatures((Object)("qp_nr = " + qpNr), null, null, 0, 0, null);
            if (features != null) {
                GafReader reader = new GafReader(features);
                result = reader.createImage(reader.getProfiles().toArray(new Double[1])[0], 311, 226);
            } else if (result == null) {
                try {
                    result = ImageIO.read(((Object)((Object)this)).getClass().getResource("/de/cismet/watergis/res/icon128/file-broken.png"));
                }
                catch (IOException ex1) {
                    LOG.error((Object)"Couldn't load fallback photo", (Throwable)ex1);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot create gaf preview image", (Throwable)e);
            try {
                result = ImageIO.read(((Object)((Object)this)).getClass().getResource("/de/cismet/watergis/res/icon128/file-broken.png"));
            }
            catch (IOException ex1) {
                LOG.error((Object)"Couldn't load fallback photo", (Throwable)ex1);
            }
        }
        return result;
    }

    public Image generateMap() {
        try {
            Geometry point = (Geometry)((JRFillParameter)this.parametersMap.get("punkt")).getValue();
            MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
            HeadlessMapProvider mapProvider = HeadlessMapProvider.createHeadlessMapProviderAndAddLayers((MappingComponent)mc);
            XBoundingBox boundingBox = new XBoundingBox(point);
            boundingBox.setX1(boundingBox.getX1() - 50.0);
            boundingBox.setY1(boundingBox.getY1() - 50.0);
            boundingBox.setX2(boundingBox.getX2() + 50.0);
            boundingBox.setY2(boundingBox.getY2() + 50.0);
            BoundingBox scaledBBox = mc.getScaledBoundingBox(500.0, (BoundingBox)boundingBox);
            int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode());
            XBoundingBox bbox = new XBoundingBox(scaledBBox.getGeometry(srid));
            mapProvider.setBoundingBox(bbox);
            return mapProvider.getImageAndWait(311, 236);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving map.", (Throwable)e);
            return null;
        }
    }

    public class SignallingRetrievalListener
    implements RetrievalListener {
        private BufferedImage image = null;
        private final Lock lock;
        private final Condition condition;

        public SignallingRetrievalListener(Lock lock, Condition condition) {
            this.lock = lock;
            this.condition = condition;
        }

        public void retrievalStarted(RetrievalEvent e) {
        }

        public void retrievalProgress(RetrievalEvent e) {
        }

        public void retrievalComplete(RetrievalEvent e) {
            if (e.getRetrievedObject() instanceof Image) {
                Image retrievedImage = (Image)e.getRetrievedObject();
                this.image = new BufferedImage(retrievedImage.getWidth(null), retrievedImage.getHeight(null), 1);
                Graphics2D g = (Graphics2D)this.image.getGraphics();
                g.drawImage(retrievedImage, 0, 0, null);
                g.dispose();
            }
            this.signalAll();
        }

        public void retrievalAborted(RetrievalEvent e) {
            this.signalAll();
        }

        public void retrievalError(RetrievalEvent e) {
            this.signalAll();
        }

        public BufferedImage getRetrievedImage() {
            return this.image;
        }

        private void signalAll() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

