/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewByArea;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.reports.types.Flaeche;
import de.cismet.watergis.reports.types.GewFlObj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class GerOffenFlHelper {
    private final Map<Object, List<GewFlObj>> gemPartMap = new HashMap<Object, List<GewFlObj>>();

    public GerOffenFlHelper(Flaeche[] flNr, int[] routeIds, int[] allowedWdmArray) throws Exception {
        this.init(flNr, routeIds, allowedWdmArray);
    }

    private void init(Flaeche[] flNr, int[] routeIds, int[] allowedWdmArray) throws Exception {
        for (Flaeche fl : flNr) {
            this.gemPartMap.put(fl.getAttr1(), this.getAllRoutes(fl, routeIds, allowedWdmArray));
            Integer[] idList = this.getGew(fl.getAttr1()).toArray(new Integer[0]);
            int[] routes = new int[idList.length];
            for (int i = 0; i < idList.length; ++i) {
                routes[i] = idList[i];
            }
            if (routes.length != 0) continue;
            routes = null;
        }
    }

    public Map<Object, List<GewFlObj>> getGemPartMap() {
        return this.gemPartMap;
    }

    private List<GewFlObj> getAllRoutes(Flaeche fl, int[] routeIds, int[] allowedWdmArray) throws Exception {
        AllGewByArea search = new AllGewByArea(routeIds, allowedWdmArray, fl.getGeom());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<GewFlObj> objList = new ArrayList<GewFlObj>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new GewFlObj((Integer)f.get(0), (String)f.get(1), (String)f.get(5), (String)f.get(6), (String)f.get(7), (Integer)f.get(8), (String)f.get(2), (Double)f.get(3), (Double)f.get(4), fl.getAttr1()));
            }
        }
        return objList;
    }

    public Collection<Integer> getGew(Object flNr) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GewFlObj tmp : gemList) {
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    public int getCountGewAll(Object flNr) {
        return this.getCountGewAll(flNr, -1);
    }

    public double getLengthGewAll(Object flNr) {
        return this.getLengthGewAll(flNr, -1);
    }

    public int getCountGewAll(Object flNr, int gewId) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        TreeSet<String> ts = new TreeSet<String>();
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId) continue;
            ts.add(tmp.getBaCd());
        }
        return ts.size();
    }

    public double getLengthGewAll(Object flNr, int gewId) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn(Object flNr) {
        return this.getLengthOffeneAbschn(flNr, -1);
    }

    public double getLengthOffeneAbschn(Object flNr, int gewId) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn(Object flNr, int gewId, double from, double till) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    public int getCountOffeneAbschn(Object flNr, String owner) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    public double getLengthOffeneAbschn(Object flNr, String owner) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthOffeneAbschn(Object flNr, String owner, Integer wdm) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm.intValue() || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public int getCountGewAll(Object flNr, String gu) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            ++count;
        }
        return count;
    }

    public int getCountGewAll(Object flNr, String gu, Integer wdm) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        int count = 0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm.intValue()) continue;
            ++count;
        }
        return count;
    }

    public double getLengthGewAll(Object flNr, String gu) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    public double getLengthGewAll(Object flNr, String gu, Integer wdm) {
        List<GewFlObj> gemList = this.gemPartMap.get(flNr);
        double length = 0.0;
        for (GewFlObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm.intValue()) continue;
            length += tmp.getLength();
        }
        return length;
    }
}

