/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewGeschlByGem;
import de.cismet.cids.custom.watergis.server.search.AllGewWithParts;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.gui.dialog.GerinneGeschlGemeindeReportDialog;
import de.cismet.watergis.gui.dialog.GerinneGeschlGewaesserReportDialog;
import de.cismet.watergis.reports.GerOffenHelper;
import de.cismet.watergis.reports.GerinneGGemeindeReport;
import de.cismet.watergis.reports.types.FeatureDataSource;
import de.cismet.watergis.reports.types.GmdPartObjGeschl;
import de.cismet.watergis.reports.types.KatasterGewObj;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;

public class GerinneGGewaesserReport
extends GerinneGGemeindeReport {
    private List<GmdPartObjGeschl> objList;
    private GerOffenHelper gerOffenHelper;

    public File createGerinneGewaesserReport(int[] gew) throws Exception {
        HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY");
        this.parameters.put("datum", df.format(new Date()));
        this.parameters.put("spalte1", false);
        this.parameters.put("spalte2", false);
        this.parameters.put("spalte3", false);
        this.parameters.put("spalte4", false);
        this.parameters.put("spalte5", false);
        this.parameters.put("spalte6", false);
        this.parameters.put("spalte7", false);
        this.parameters.put("spalte8", false);
        this.parameters.put("spalte9", false);
        this.parameters.put("spalte10", false);
        this.parameters.put("spalte11", false);
        this.parameters.put("ges", true);
        this.parameters.put("dimension", GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null);
        this.parameters.put("tiefenklasse", GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null);
        this.parameters.put("fachdata", GerinneGeschlGewaesserReportDialog.getInstance().isAllDataPerObject());
        this.parameters.put("perObject", GerinneGeschlGewaesserReportDialog.getInstance().isPerObject());
        this.parameters.put("sumGu", GerinneGeschlGewaesserReportDialog.getInstance().isSumGu());
        this.parameters.put("withWdm", GerinneGeschlGewaesserReportDialog.getInstance().isPerWdm());
        this.parameters.put("dataSources", dataSources);
        FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)GerinneGGewaesserReport.class.getResourceAsStream("/de/cismet/watergis/reports/gerinneGeschlGew.jasper"));
        this.init(gew);
        if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
            this.parameters.put("gemKomp", true);
            dataSources.put("gewaesser", this.getGewaesser2());
        } else if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null || GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null || GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null || GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses().size() == 1) {
            this.parameters.put("gemKomp", false);
            dataSources.put("gewaesser", this.getGewaesser1());
        } else {
            this.parameters.put("gemKomp", false);
            dataSources.put("gewaesser", this.getGewaesser());
        }
        if (GerinneGeschlGewaesserReportDialog.getInstance().isPerObject()) {
            dataSources.put("objects", this.getObjects());
        }
        if (GerinneGeschlGewaesserReportDialog.getInstance().isSumGu() && !GerinneGeschlGewaesserReportDialog.getInstance().isPerWdm()) {
            if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                dataSources.put("gu", this.getGuDataSource2());
            } else if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null || GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null || GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null || GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses().size() == 1) {
                dataSources.put("gu", this.getGuDataSource1());
            } else {
                dataSources.put("gu", this.getGuDataSource());
            }
        }
        if (GerinneGeschlGewaesserReportDialog.getInstance().isSumGu() && GerinneGeschlGewaesserReportDialog.getInstance().isPerWdm()) {
            if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                dataSources.put("gu", this.getGuWdmDataSource2());
            } else if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null || GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null || GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null || GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null && GerinneGeschlGewaesserReportDialog.getInstance().getClasses().size() == 1) {
                dataSources.put("gu", this.getGuWdmDataSource1());
            } else {
                dataSources.put("gu", this.getGuWdmDataSource());
            }
        }
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)this.parameters, (JRDataSource)dummyDataSource);
        File file = new File(GerinneGeschlGewaesserReportDialog.getInstance().getPath() + "/Gerinne_geschlossen_Gew\u00e4sser.xlsx");
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleOutputStreamExporterOutput exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
        exporter.setExporterOutput((ExporterOutput)exportOut);
        SimpleXlsxReportConfiguration config = new SimpleXlsxReportConfiguration();
        config.setOnePagePerSheet(Boolean.TRUE);
        config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
        config.setShowGridLines(Boolean.valueOf(true));
        config.setColumnWidthRatio(Float.valueOf(1.5f));
        config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        config.setCellHidden(Boolean.valueOf(true));
        config.setDetectCellType(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)config);
        exporter.exportReport();
        exportOut.close();
        out.close();
        return file;
    }

    public static void main(String[] args) {
        GerinneGGewaesserReport report = new GerinneGGewaesserReport();
        try {
            report.createReport(new int[]{2}, new int[]{2});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(int[] routeIds) throws Exception {
        this.objList = this.getAllRlDDue(routeIds);
        this.gerOffenHelper = new GerOffenHelper(routeIds, this.getAllowedWdms());
    }

    private List<GmdPartObjGeschl> getAllRlDDue(int[] routeIds) throws Exception {
        AllGewGeschlByGem search = new AllGewGeschlByGem(routeIds, this.getAllowedWdms());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<GmdPartObjGeschl> objList = new ArrayList<GmdPartObjGeschl>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new GmdPartObjGeschl((Integer)f.get(0), (String)f.get(7), (String)f.get(1), (String)f.get(4), (String)f.get(2), (Integer)f.get(3), (String)f.get(8), (Double)f.get(9), (Double)f.get(10), (Integer)f.get(11), (Integer)f.get(12), (Double)f.get(5), (Double)f.get(6), (String)f.get(13), (String)f.get(14), (String)f.get(15), (String)f.get(16), (String)f.get(17), (Integer)f.get(18), (String)f.get(19), (String)f.get(20), (String)f.get(21), (Double)f.get(22), (Double)f.get(23), (Double)f.get(24), (Double)f.get(25), (Double)f.get(26), (Double)f.get(27), (Double)f.get(28), (Double)f.get(29), (Double)f.get(30), (Double)f.get(31), (Double)f.get(32), (String)f.get(33), (String)f.get(34)));
            }
        }
        return objList;
    }

    private List<KatasterGewObj> getAllRoutes(int[] routeIds, int[] allowedWdmArray) throws Exception {
        AllGewWithParts search = new AllGewWithParts(routeIds, allowedWdmArray);
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<KatasterGewObj> objList = new ArrayList<KatasterGewObj>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new KatasterGewObj((Integer)f.get(0), (String)f.get(1), (String)f.get(7), (String)f.get(8), (String)f.get(9), (Integer)f.get(10), (String)f.get(2), (Double)f.get(3), (Double)f.get(4)));
            }
        }
        return objList;
    }

    private int[] getAllowedWdms() {
        ArrayList<Integer> wdmList = new ArrayList<Integer>();
        if (GerinneGeschlGewaesserReportDialog.getInstance().is1501()) {
            wdmList.add(1501);
        }
        if (GerinneGeschlGewaesserReportDialog.getInstance().is1502()) {
            wdmList.add(1502);
        }
        if (GerinneGeschlGewaesserReportDialog.getInstance().is1503()) {
            wdmList.add(1503);
        }
        if (GerinneGeschlGewaesserReportDialog.getInstance().is1504()) {
            wdmList.add(1504);
        }
        if (GerinneGeschlGewaesserReportDialog.getInstance().is1505()) {
            wdmList.add(1505);
        }
        int[] wdms = new int[wdmList.size()];
        for (int i = 0; i < wdmList.size(); ++i) {
            wdms[i] = (Integer)wdmList.get(i);
        }
        return wdms;
    }

    private FeatureDataSource getGewaesser() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        this.sheetNames.add("Gew\u00e4sser");
        for (Integer gew : this.gerOffenHelper.getGew()) {
            double colLength;
            double colCount;
            String lab;
            String anz;
            Integer till;
            Integer from;
            int i;
            List<Object> l;
            HashMap<String, Object> feature = new HashMap<String, Object>();
            double count = 0.0;
            double length = 0.0;
            feature.put("anzGew", this.objList.size());
            feature.put("group", null);
            feature.put("gewName", this.getGewName(gew));
            feature.put("code", this.getBaCd(gew));
            feature.put("arten", art);
            feature.put("laenge", this.gerOffenHelper.getLengthGewAll(gew));
            if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                for (i = 0; i < l.size(); ++i) {
                    from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                    till = (Integer)l.get(i);
                    anz = "anz" + i;
                    String laenge = "laenge" + i;
                    lab = "lab" + (i + 1);
                    colCount = this.getCountAllTf(gew, from, till);
                    colLength = this.getLengthAllTf(gew, from, till);
                    count += colCount;
                    length += colLength;
                    feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                    feature.put(anz, colCount);
                    feature.put(laenge, colLength);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    first = false;
                }
            } else if (GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null) {
                l = GerinneGeschlGewaesserReportDialog.getInstance().getDimensions();
                for (i = 0; i < l.size(); ++i) {
                    from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                    till = (Integer)l.get(i);
                    anz = "anz" + (i + 1);
                    String laenge = "laenge" + (i + 1);
                    lab = "lab" + (i + 1);
                    colCount = this.getCountAllDim(gew, from, till);
                    colLength = this.getLengthAllDim(gew, from, till);
                    count += colCount;
                    length += colLength;
                    feature.put(lab, "Dimension:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                    feature.put(anz, colCount);
                    feature.put(laenge, colLength);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    first = false;
                }
            } else if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null) {
                l = GerinneGeschlGewaesserReportDialog.getInstance().getArt();
                for (i = 0; i < l.size(); ++i) {
                    String anz2 = "anz" + (i + 1);
                    String laenge = "laenge" + (i + 1);
                    String lab2 = "lab" + (i + 1);
                    double colCount2 = this.getCount(gew, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)));
                    double colLength2 = this.getLength(gew, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)));
                    count += colCount2;
                    length += colLength2;
                    feature.put(lab2, this.toColumnName((GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i))));
                    feature.put(anz2, colCount2);
                    feature.put(laenge, colLength2);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    if (GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() == 1) {
                        this.parameters.put("ges", false);
                    }
                    first = false;
                }
            }
            feature.put("anzGes", count);
            feature.put("laengeGes", length);
            features.add(feature);
        }
        Map<String, Object> total = this.createKumFeature(features, false);
        total.put("gewName", null);
        total.put("code", null);
        features.add(total);
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesser1() throws Exception {
        boolean isTiefeArt;
        List<Integer> d;
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        this.parameters.put("dimension", true);
        String art = this.createArtString();
        if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null && GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() > 1) {
            d = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
            isTiefeArt = true;
        } else {
            d = GerinneGeschlGewaesserReportDialog.getInstance().getDimensions();
            isTiefeArt = false;
        }
        this.sheetNames.add("Gew\u00e4sser");
        for (int di = 0; di < d.size(); ++di) {
            ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
            for (Integer gew : this.gerOffenHelper.getGew()) {
                int i;
                List<Object> l;
                HashMap<String, Object> feature = new HashMap<String, Object>();
                Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                Integer dimTill = d.get(di);
                double count = 0.0;
                double length = 0.0;
                feature.put("dimLab", isTiefeArt ? "Tiefe" : "Dimension");
                feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                feature.put("anzGew", this.getGew().size());
                feature.put("group", null);
                feature.put("gewName", this.getGewName(gew));
                feature.put("code", this.getBaCd(gew));
                feature.put("arten", art);
                feature.put("laenge", this.gerOffenHelper.getLengthGewAll(gew));
                if (!isTiefeArt && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                    l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                    for (i = 0; i < l.size(); ++i) {
                        double colLength;
                        double colCount;
                        Integer from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                        Integer till = (Integer)l.get(i);
                        String anz = "anz" + i;
                        String laenge = "laenge" + i;
                        String lab = "lab" + (i + 1);
                        if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() == 1) {
                            GerinneGeschlGemeindeReportDialog.Art arten = GerinneGeschlGewaesserReportDialog.getInstance().getArt().get(0);
                            colCount = this.getCountAllTfDim(gew, arten, from, till, dimFrom, dimTill);
                            colLength = this.getLengthAllTfDim(gew, arten, from, till, dimFrom, dimTill);
                        } else {
                            colCount = this.getCountAllTfDim(gew, from, till, dimFrom, dimTill);
                            colLength = this.getLengthAllTfDim(gew, from, till, dimFrom, dimTill);
                        }
                        count += colCount;
                        length += colLength;
                        feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        first = false;
                    }
                } else if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null) {
                    l = GerinneGeschlGewaesserReportDialog.getInstance().getArt();
                    for (i = 0; i < l.size(); ++i) {
                        double colLength;
                        double colCount;
                        String anz = "anz" + (i + 1);
                        String laenge = "laenge" + (i + 1);
                        String lab = "lab" + (i + 1);
                        if (isTiefeArt) {
                            colCount = this.getCountTf(gew, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            colLength = this.getLengthTf(gew, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                        } else {
                            colCount = this.getCountDim(gew, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            colLength = this.getLengthDim(gew, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                        }
                        count += colCount;
                        length += colLength;
                        feature.put(lab, this.toColumnName((GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i))));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        if (GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() == 1) {
                            this.parameters.put("ges", false);
                        }
                        first = false;
                    }
                }
                feature.put("anzGes", count);
                feature.put("laengeGes", length);
                features.add(feature);
                featuresKum.add(feature);
                featuresKumDim.add(feature);
            }
            features.add(this.createKumFeature(featuresKumDim, true));
        }
        Map<String, Object> total = this.createKumFeature(featuresKum, false);
        total.put("gewName", null);
        total.put("code", null);
        features.add(total);
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesser2() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        this.sheetNames.add("Gew\u00e4sser");
        for (int di = 0; di < GerinneGeschlGewaesserReportDialog.getInstance().getDimensions().size(); ++di) {
            ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
            List<Integer> d = GerinneGeschlGewaesserReportDialog.getInstance().getDimensions();
            for (Integer gew : this.gerOffenHelper.getGew()) {
                Integer till;
                Integer from;
                HashMap<String, Object> feature = new HashMap<String, Object>();
                Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                Integer dimTill = d.get(di);
                double count = 0.0;
                double length = 0.0;
                feature.put("anzGew", this.getGew().size());
                feature.put("group", null);
                feature.put("gewName", this.getGewName(gew));
                feature.put("code", this.getBaCd(gew));
                feature.put("arten", art);
                feature.put("laenge", this.gerOffenHelper.getLengthGewAll(gew));
                feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                for (GerinneGeschlGemeindeReportDialog.Art a : GerinneGeschlGewaesserReportDialog.getInstance().getArt()) {
                    double countA = 0.0;
                    double lengthA = 0.0;
                    if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                        int i;
                        List<Integer> l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                        for (i = 0; i < l.size(); ++i) {
                            from = i > 0 ? l.get(i - 1) : new Integer(0);
                            till = l.get(i);
                            String anz = "anz" + this.getArtPrefix(a) + (i + 1);
                            String laenge = "laenge" + this.getArtPrefix(a) + (i + 1);
                            String lab = "lab" + (i + 1);
                            double colCount = this.getCountAllTfDim(gew, a, from, till, dimFrom, dimTill);
                            double colLength = this.getLengthAllTfDim(gew, a, from, till, dimFrom, dimTill);
                            count += colCount;
                            length += colLength;
                            countA += colCount;
                            lengthA += colLength;
                            feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            first = false;
                        }
                    }
                    feature.put("anz" + this.getArtPrefix(a) + "Ges", countA);
                    feature.put("laenge" + this.getArtPrefix(a) + "Ges", lengthA);
                }
                feature.put("anzGes", count);
                feature.put("laengeGes", length);
                if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                    List<Integer> l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                    double countT = 0.0;
                    double lengthT = 0.0;
                    for (int i = 0; i < l.size(); ++i) {
                        for (GerinneGeschlGemeindeReportDialog.Art a : GerinneGeschlGewaesserReportDialog.getInstance().getArt()) {
                            from = i > 0 ? l.get(i - 1) : new Integer(0);
                            till = l.get(i);
                            double colCount = this.getCountAllTfDim(gew, a, from, till, dimFrom, dimTill);
                            double colLength = this.getLengthAllTfDim(gew, a, from, till, dimFrom, dimTill);
                            countT += colCount;
                            lengthT += colLength;
                        }
                        String anz = "anz" + i;
                        String laenge = "laenge" + i;
                        feature.put(anz, countT);
                        feature.put(laenge, lengthT);
                    }
                }
                features.add(feature);
                featuresKum.add(feature);
                featuresKumDim.add(feature);
            }
            features.add(this.createKumFeature(featuresKumDim, true));
        }
        Map<String, Object> total = this.createKumFeature(featuresKum, false);
        total.put("gewName", null);
        total.put("code", null);
        features.add(total);
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getObjects() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        this.sheetNames.add("Objekte");
        for (Integer gew : this.getGew()) {
            for (GmdPartObjGeschl obj : this.getObjects(gew)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                feature.put("group", null);
                feature.put("gewName", this.getGewName(gew));
                feature.put("code", this.getBaCd(gew));
                feature.put("arten", art);
                feature.put("laenge", this.getLengthGew(gew));
                feature.put("von", this.convertStation(obj.getFrom()));
                feature.put("bis", this.convertStation(obj.getTill()));
                feature.put("anzahlObj", this.objList.size());
                feature.put("tf", this.getTf(obj.getTf()));
                feature.put("dim", this.getDim(obj.getDim()));
                feature.put("ls", obj.getLs());
                feature.put("prof", obj.getProf());
                feature.put("ma", obj.getMa());
                feature.put("objNr", obj.getObjNr());
                feature.put("objNr_gu", obj.getObjNrGu());
                feature.put("tr", obj.getTr());
                feature.put("tr_gu", obj.getTrGu());
                feature.put("ausbaujahr", obj.getAusbaujahr());
                feature.put("wbbl", obj.getWbbl());
                feature.put("art", obj.getArt());
                feature.put("laengeObj", obj.getLength());
                feature.put("faktor", obj.getLs());
                feature.put("zustKl", obj.getLs());
                feature.put("br", obj.getLs());
                feature.put("brOben", obj.getBrOben());
                feature.put("hoehe", obj.getHoehe());
                feature.put("hEin", obj.gethEin());
                feature.put("hAus", obj.gethAus());
                feature.put("gefaelle", obj.getGefaelle());
                feature.put("dhAus", obj.getDhAus());
                feature.put("dhEin", obj.getDhEin());
                feature.put("hAb", obj.gethAb());
                feature.put("hAuf", obj.gethAuf());
                feature.put("aufstieg", obj.getAufstieg());
                features.add(feature);
            }
        }
        Map<String, Object> kumFeature = this.createKumFeature(features, false);
        kumFeature.put("code", null);
        kumFeature.put("gewName", null);
        kumFeature.put("von", null);
        kumFeature.put("bis", null);
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuDataSource() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        this.sheetNames.add("GU");
        for (String gu : this.getGu()) {
            double colLength;
            double colCount;
            String lab;
            String anz;
            Integer till;
            Integer from;
            int i;
            List<Object> l;
            HashMap<String, Object> feature = new HashMap<String, Object>();
            double count = 0.0;
            double length = 0.0;
            feature.put("anzGu", this.getGu().size());
            feature.put("gu", gu);
            feature.put("guName", gu);
            feature.put("group", null);
            feature.put("arten", art);
            feature.put("laenge", this.getLengthGew(gu));
            if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                for (i = 0; i < l.size(); ++i) {
                    from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                    till = (Integer)l.get(i);
                    anz = "anz" + i;
                    String laenge = "laenge" + i;
                    lab = "lab" + (i + 1);
                    colCount = this.getCountAllTf(gu, from, till);
                    colLength = this.getLengthAllTf(gu, from, till);
                    count += colCount;
                    length += colLength;
                    feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                    feature.put(anz, colCount);
                    feature.put(laenge, colLength);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    first = false;
                }
            } else if (GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null) {
                l = GerinneGeschlGewaesserReportDialog.getInstance().getDimensions();
                for (i = 0; i < l.size(); ++i) {
                    from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                    till = (Integer)l.get(i);
                    anz = "anz" + (i + 1);
                    String laenge = "laenge" + (i + 1);
                    lab = "lab" + (i + 1);
                    colCount = this.getCountAllDim(gu, from, till);
                    colLength = this.getLengthAllDim(gu, from, till);
                    count += colCount;
                    length += colLength;
                    feature.put(lab, "Dimension:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                    feature.put(anz, colCount);
                    feature.put(laenge, colLength);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    first = false;
                }
            } else if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null) {
                l = GerinneGeschlGewaesserReportDialog.getInstance().getArt();
                for (i = 0; i < l.size(); ++i) {
                    String anz2 = "anz" + (i + 1);
                    String laenge = "laenge" + (i + 1);
                    String lab2 = "lab" + (i + 1);
                    double colCount2 = this.getCount(gu, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)));
                    double colLength2 = this.getLength(gu, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)));
                    count += colCount2;
                    length += colLength2;
                    feature.put(lab2, this.toColumnName((GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i))));
                    feature.put(anz2, colCount2);
                    feature.put(laenge, colLength2);
                }
                if (first) {
                    for (i = 0; i < l.size(); ++i) {
                        this.parameters.put("spalte" + (i + 1), true);
                    }
                    if (GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() == 1) {
                        this.parameters.put("ges", false);
                    }
                    first = false;
                }
            }
            feature.put("anzGes", count);
            feature.put("laengeGes", length);
            features.add(feature);
        }
        features.add(this.createKumFeature(features, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuDataSource1() throws Exception {
        boolean isTiefeArt;
        List<Integer> d;
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        this.parameters.put("dimension", true);
        String art = this.createArtString();
        if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null && GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() > 1) {
            d = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
            isTiefeArt = true;
        } else {
            d = GerinneGeschlGewaesserReportDialog.getInstance().getDimensions();
            isTiefeArt = false;
        }
        this.sheetNames.add("Gu");
        for (int di = 0; di < d.size(); ++di) {
            ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
            for (String gu : this.getGu()) {
                int i;
                List<Object> l;
                HashMap<String, Object> feature = new HashMap<String, Object>();
                Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                Integer dimTill = d.get(di);
                double count = 0.0;
                double length = 0.0;
                feature.put("dimLab", isTiefeArt ? "Tiefe" : "Dimension");
                feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                feature.put("anzGu", this.getGu().size());
                feature.put("group", null);
                feature.put("guName", gu);
                feature.put("gu", gu);
                feature.put("arten", art);
                feature.put("laenge", this.getLengthGew(gu));
                if (!isTiefeArt && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                    l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                    for (i = 0; i < l.size(); ++i) {
                        double colLength;
                        double colCount;
                        Integer from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                        Integer till = (Integer)l.get(i);
                        String anz = "anz" + i;
                        String laenge = "laenge" + i;
                        String lab = "lab" + (i + 1);
                        if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() == 1) {
                            GerinneGeschlGemeindeReportDialog.Art arten = GerinneGeschlGewaesserReportDialog.getInstance().getArt().get(0);
                            colCount = this.getCountAllTfDim(gu, arten, from, till, dimFrom, dimTill);
                            colLength = this.getLengthAllTfDim(gu, arten, from, till, dimFrom, dimTill);
                        } else {
                            colCount = this.getCountAllTfDim(gu, from, till, dimFrom, dimTill);
                            colLength = this.getLengthAllTfDim(gu, from, till, dimFrom, dimTill);
                        }
                        count += colCount;
                        length += colLength;
                        feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        first = false;
                    }
                } else if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null) {
                    l = GerinneGeschlGewaesserReportDialog.getInstance().getArt();
                    for (i = 0; i < l.size(); ++i) {
                        double colLength;
                        double colCount;
                        String anz = "anz" + (i + 1);
                        String laenge = "laenge" + (i + 1);
                        String lab = "lab" + (i + 1);
                        if (isTiefeArt) {
                            colCount = this.getCountTf(gu, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            colLength = this.getLengthTf(gu, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                        } else {
                            colCount = this.getCountDim(gu, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            colLength = this.getLengthDim(gu, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                        }
                        count += colCount;
                        length += colLength;
                        feature.put(lab, this.toColumnName((GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i))));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        if (GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() == 1) {
                            this.parameters.put("ges", false);
                        }
                        first = false;
                    }
                }
                feature.put("anzGes", count);
                feature.put("laengeGes", length);
                features.add(feature);
                featuresKum.add(feature);
                featuresKumDim.add(feature);
            }
            features.add(this.createKumFeature(featuresKumDim, true));
        }
        features.add(this.createKumFeature(featuresKum, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuDataSource2() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        this.sheetNames.add("GU");
        for (int di = 0; di < GerinneGeschlGewaesserReportDialog.getInstance().getDimensions().size(); ++di) {
            ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
            List<Integer> d = GerinneGeschlGewaesserReportDialog.getInstance().getDimensions();
            for (String gu : this.getGu()) {
                Integer till;
                Integer from;
                HashMap<String, Object> feature = new HashMap<String, Object>();
                Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                Integer dimTill = d.get(di);
                double count = 0.0;
                double length = 0.0;
                feature.put("anzGew", this.getGew().size());
                feature.put("group", null);
                feature.put("guName", gu);
                feature.put("gu", gu);
                feature.put("arten", art);
                feature.put("laenge", this.getLengthGew(gu));
                feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                for (GerinneGeschlGemeindeReportDialog.Art a : GerinneGeschlGewaesserReportDialog.getInstance().getArt()) {
                    double countA = 0.0;
                    double lengthA = 0.0;
                    if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                        int i;
                        List<Integer> l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                        for (i = 0; i < l.size(); ++i) {
                            from = i > 0 ? l.get(i - 1) : new Integer(0);
                            till = l.get(i);
                            String anz = "anz" + this.getArtPrefix(a) + (i + 1);
                            String laenge = "laenge" + this.getArtPrefix(a) + (i + 1);
                            String lab = "lab" + (i + 1);
                            double colCount = this.getCountAllTfDim(gu, a, from, till, dimFrom, dimTill);
                            double colLength = this.getLengthAllTfDim(gu, a, from, till, dimFrom, dimTill);
                            count += colCount;
                            length += colLength;
                            countA += colCount;
                            lengthA += colLength;
                            feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            first = false;
                        }
                    }
                    feature.put("anz" + this.getArtPrefix(a) + "Ges", countA);
                    feature.put("laenge" + this.getArtPrefix(a) + "Ges", lengthA);
                }
                feature.put("anzGes", count);
                feature.put("laengeGes", length);
                if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                    List<Integer> l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                    double countT = 0.0;
                    double lengthT = 0.0;
                    for (int i = 0; i < l.size(); ++i) {
                        for (GerinneGeschlGemeindeReportDialog.Art a : GerinneGeschlGewaesserReportDialog.getInstance().getArt()) {
                            from = i > 0 ? l.get(i - 1) : new Integer(0);
                            till = l.get(i);
                            double colCount = this.getCountAllTfDim(gu, a, from, till, dimFrom, dimTill);
                            double colLength = this.getLengthAllTfDim(gu, a, from, till, dimFrom, dimTill);
                            countT += colCount;
                            lengthT += colLength;
                        }
                        String anz = "anz" + i;
                        String laenge = "laenge" + i;
                        feature.put(anz, countT);
                        feature.put(laenge, lengthT);
                    }
                }
                features.add(feature);
                featuresKum.add(feature);
                featuresKumDim.add(feature);
            }
            features.add(this.createKumFeature(featuresKumDim, true));
        }
        Map<String, Object> total = this.createKumFeature(featuresKum, false);
        total.put("gu", null);
        total.put("guName", null);
        features.add(total);
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuWdmDataSource() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        this.sheetNames.add("GU");
        for (String gu : this.getGu()) {
            ArrayList<Map<String, Object>> subGroupFeatures = new ArrayList<Map<String, Object>>();
            for (Integer wdm : this.getWdm(gu)) {
                double colLength;
                double colCount;
                String lab;
                String anz;
                Integer till;
                Integer from;
                int i;
                List<Object> l;
                HashMap<String, Object> feature = new HashMap<String, Object>();
                double count = 0.0;
                double length = 0.0;
                feature.put("wdm", wdm);
                feature.put("anzGu", this.getGu().size());
                feature.put("gu", gu);
                feature.put("guName", gu);
                feature.put("group", null);
                feature.put("arten", art);
                feature.put("laenge", this.getLengthGew(gu, wdm));
                if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                    l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                    for (i = 0; i < l.size(); ++i) {
                        from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                        till = (Integer)l.get(i);
                        anz = "anz" + i;
                        String laenge = "laenge" + i;
                        lab = "lab" + (i + 1);
                        colCount = this.getCountAllTf(gu, wdm, from, till);
                        colLength = this.getLengthAllTf(gu, wdm, from, till);
                        count += colCount;
                        length += colLength;
                        feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        first = false;
                    }
                } else if (GerinneGeschlGewaesserReportDialog.getInstance().getDimensions() != null) {
                    l = GerinneGeschlGewaesserReportDialog.getInstance().getDimensions();
                    for (i = 0; i < l.size(); ++i) {
                        from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                        till = (Integer)l.get(i);
                        anz = "anz" + (i + 1);
                        String laenge = "laenge" + (i + 1);
                        lab = "lab" + (i + 1);
                        colCount = this.getCountAllDim(gu, wdm, from, till);
                        colLength = this.getLengthAllDim(gu, wdm, from, till);
                        count += colCount;
                        length += colLength;
                        feature.put(lab, "Dimension:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                        feature.put(anz, colCount);
                        feature.put(laenge, colLength);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        first = false;
                    }
                } else if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null) {
                    l = GerinneGeschlGewaesserReportDialog.getInstance().getArt();
                    for (i = 0; i < l.size(); ++i) {
                        String anz2 = "anz" + (i + 1);
                        String laenge = "laenge" + (i + 1);
                        String lab2 = "lab" + (i + 1);
                        double colCount2 = this.getCount(gu, wdm, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)));
                        double colLength2 = this.getLength(gu, wdm, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)));
                        count += colCount2;
                        length += colLength2;
                        feature.put(lab2, this.toColumnName((GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i))));
                        feature.put(anz2, colCount2);
                        feature.put(laenge, colLength2);
                    }
                    if (first) {
                        for (i = 0; i < l.size(); ++i) {
                            this.parameters.put("spalte" + (i + 1), true);
                        }
                        if (GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() == 1) {
                            this.parameters.put("ges", false);
                        }
                        first = false;
                    }
                }
                feature.put("anzGes", count);
                feature.put("laengeGes", length);
                subGroupFeatures.add(feature);
                features.add(feature);
            }
            features.add(this.createKumFeature(subGroupFeatures, true));
        }
        Map<String, Object> total = this.createKumFeature(features, false);
        total.put("gu", null);
        total.put("guName", null);
        total.put("wdm", null);
        features.add(total);
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuWdmDataSource1() throws Exception {
        boolean isTiefeArt;
        List<Integer> d;
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        this.parameters.put("dimension", true);
        String art = this.createArtString();
        if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null && GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() > 1) {
            d = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
            isTiefeArt = true;
        } else {
            d = GerinneGeschlGewaesserReportDialog.getInstance().getDimensions();
            isTiefeArt = false;
        }
        this.sheetNames.add("Gu");
        for (int di = 0; di < d.size(); ++di) {
            ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
            for (String gu : this.getGu()) {
                ArrayList<Map<String, Object>> subGroupFeatures = new ArrayList<Map<String, Object>>();
                for (Integer wdm : this.getWdm(gu)) {
                    int i;
                    List<Object> l;
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                    Integer dimTill = d.get(di);
                    double count = 0.0;
                    double length = 0.0;
                    feature.put("wdm", wdm);
                    feature.put("dimLab", isTiefeArt ? "Tiefe" : "Dimension");
                    feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                    feature.put("anzGu", this.getGu().size());
                    feature.put("group", null);
                    feature.put("guName", gu);
                    feature.put("gu", gu);
                    feature.put("arten", art);
                    feature.put("laenge", this.getLengthGew(gu, wdm));
                    if (!isTiefeArt && GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                        l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                        for (i = 0; i < l.size(); ++i) {
                            double colLength;
                            double colCount;
                            Integer from = i > 0 ? (Integer)l.get(i - 1) : new Integer(0);
                            Integer till = (Integer)l.get(i);
                            String anz = "anz" + i;
                            String laenge = "laenge" + i;
                            String lab = "lab" + (i + 1);
                            if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null && GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() == 1) {
                                GerinneGeschlGemeindeReportDialog.Art arten = GerinneGeschlGewaesserReportDialog.getInstance().getArt().get(0);
                                colCount = this.getCountAllTfDim(gu, wdm, arten, from, till, dimFrom, dimTill);
                                colLength = this.getLengthAllTfDim(gu, wdm, arten, from, till, dimFrom, dimTill);
                            } else {
                                colCount = this.getCountAllTfDim(gu, wdm, from, till, dimFrom, dimTill);
                                colLength = this.getLengthAllTfDim(gu, wdm, from, till, dimFrom, dimTill);
                            }
                            count += colCount;
                            length += colLength;
                            feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            first = false;
                        }
                    } else if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() != null) {
                        l = GerinneGeschlGewaesserReportDialog.getInstance().getArt();
                        for (i = 0; i < l.size(); ++i) {
                            double colLength;
                            double colCount;
                            String anz = "anz" + (i + 1);
                            String laenge = "laenge" + (i + 1);
                            String lab = "lab" + (i + 1);
                            if (isTiefeArt) {
                                colCount = this.getCountTf(gu, wdm, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                                colLength = this.getLengthTf(gu, wdm, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            } else {
                                colCount = this.getCountDim(gu, wdm, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                                colLength = this.getLengthDim(gu, wdm, (GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i)), dimFrom, dimTill);
                            }
                            count += colCount;
                            length += colLength;
                            feature.put(lab, this.toColumnName((GerinneGeschlGemeindeReportDialog.Art)((Object)l.get(i))));
                            feature.put(anz, colCount);
                            feature.put(laenge, colLength);
                        }
                        if (first) {
                            for (i = 0; i < l.size(); ++i) {
                                this.parameters.put("spalte" + (i + 1), true);
                            }
                            if (GerinneGeschlGewaesserReportDialog.getInstance().getArt().size() == 1) {
                                this.parameters.put("ges", false);
                            }
                            first = false;
                        }
                    }
                    feature.put("anzGes", count);
                    feature.put("laengeGes", length);
                    features.add(feature);
                    subGroupFeatures.add(feature);
                    featuresKum.add(feature);
                    featuresKumDim.add(feature);
                }
                features.add(this.createKumFeature(subGroupFeatures, true));
            }
            features.add(this.createKumFeature(featuresKumDim, true));
        }
        Map<String, Object> total = this.createKumFeature(featuresKum, false);
        total.put("gu", null);
        total.put("guName", null);
        total.put("wdm", null);
        features.add(total);
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuWdmDataSource2() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> featuresKum = new ArrayList<Map<String, Object>>();
        boolean first = true;
        String art = this.createArtString();
        this.sheetNames.add("GU");
        for (int di = 0; di < GerinneGeschlGewaesserReportDialog.getInstance().getDimensions().size(); ++di) {
            ArrayList<Map<String, Object>> featuresKumDim = new ArrayList<Map<String, Object>>();
            List<Integer> d = GerinneGeschlGewaesserReportDialog.getInstance().getDimensions();
            for (String gu : this.getGu()) {
                ArrayList<Map<String, Object>> subGroupFeatures = new ArrayList<Map<String, Object>>();
                for (Integer wdm : this.getWdm(gu)) {
                    Integer till;
                    Integer from;
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    Integer dimFrom = di > 0 ? d.get(di - 1) : new Integer(0);
                    Integer dimTill = d.get(di);
                    double count = 0.0;
                    double length = 0.0;
                    feature.put("wdm", wdm);
                    feature.put("anzGew", this.getGew().size());
                    feature.put("group", null);
                    feature.put("guName", gu);
                    feature.put("gu", gu);
                    feature.put("arten", art);
                    feature.put("laenge", this.getLengthGew(gu, wdm));
                    feature.put("dimension", d.get(di) == null ? "ohne" : "bis " + d.get(di));
                    for (GerinneGeschlGemeindeReportDialog.Art a : GerinneGeschlGewaesserReportDialog.getInstance().getArt()) {
                        double countA = 0.0;
                        double lengthA = 0.0;
                        if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                            int i;
                            List<Integer> l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                            for (i = 0; i < l.size(); ++i) {
                                from = i > 0 ? l.get(i - 1) : new Integer(0);
                                till = l.get(i);
                                String anz = "anz" + this.getArtPrefix(a) + (i + 1);
                                String laenge = "laenge" + this.getArtPrefix(a) + (i + 1);
                                String lab = "lab" + (i + 1);
                                double colCount = this.getCountAllTfDim(gu, wdm, a, from, till, dimFrom, dimTill);
                                double colLength = this.getLengthAllTfDim(gu, wdm, a, from, till, dimFrom, dimTill);
                                count += colCount;
                                length += colLength;
                                countA += colCount;
                                lengthA += colLength;
                                feature.put(lab, "Tiefe:\n" + (l.get(i) == null ? "ohne" : "bis " + l.get(i)));
                                feature.put(anz, colCount);
                                feature.put(laenge, colLength);
                            }
                            if (first) {
                                for (i = 0; i < l.size(); ++i) {
                                    this.parameters.put("spalte" + (i + 1), true);
                                }
                                first = false;
                            }
                        }
                        feature.put("anz" + this.getArtPrefix(a) + "Ges", countA);
                        feature.put("laenge" + this.getArtPrefix(a) + "Ges", lengthA);
                    }
                    feature.put("anzGes", count);
                    feature.put("laengeGes", length);
                    if (GerinneGeschlGewaesserReportDialog.getInstance().getClasses() != null) {
                        List<Integer> l = GerinneGeschlGewaesserReportDialog.getInstance().getClasses();
                        double countT = 0.0;
                        double lengthT = 0.0;
                        for (int i = 0; i < l.size(); ++i) {
                            for (GerinneGeschlGemeindeReportDialog.Art a : GerinneGeschlGewaesserReportDialog.getInstance().getArt()) {
                                from = i > 0 ? l.get(i - 1) : new Integer(0);
                                till = l.get(i);
                                double colCount = this.getCountAllTfDim(gu, wdm, a, from, till, dimFrom, dimTill);
                                double colLength = this.getLengthAllTfDim(gu, wdm, a, from, till, dimFrom, dimTill);
                                countT += colCount;
                                lengthT += colLength;
                            }
                            String anz = "anz" + i;
                            String laenge = "laenge" + i;
                            feature.put(anz, countT);
                            feature.put(laenge, lengthT);
                        }
                    }
                    features.add(feature);
                    subGroupFeatures.add(feature);
                    featuresKum.add(feature);
                    featuresKumDim.add(feature);
                }
                features.add(this.createKumFeature(subGroupFeatures, true));
            }
            features.add(this.createKumFeature(featuresKumDim, true));
        }
        Map<String, Object> total = this.createKumFeature(featuresKum, false);
        total.put("gu", null);
        total.put("guName", null);
        total.put("wdm", null);
        features.add(total);
        return new FeatureDataSource(features);
    }

    private Collection<Integer> getGew() {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GmdPartObjGeschl tmp : this.objList) {
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    private List<GmdPartObjGeschl> getGew(String owner) {
        ArrayList<GmdPartObjGeschl> list = new ArrayList<GmdPartObjGeschl>();
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(owner)) continue;
            list.add(tmp);
        }
        return list;
    }

    private String getGewName(int gew) {
        return this.gerOffenHelper.getGewName(gew);
    }

    private String getBaCd(int gew) {
        return this.gerOffenHelper.getBaCd(gew);
    }

    private double getLengthGew(int gewId) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gewId) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCount(int gew) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew) continue;
            ++count;
        }
        return count;
    }

    private double getCountAllDim(int gew, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getCount(int gew, GerinneGeschlGemeindeReportDialog.Art art) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name())) continue;
            ++count;
        }
        return count;
    }

    private double getLength(int gew, GerinneGeschlGemeindeReportDialog.Art art) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name())) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthAllDim(int gew, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTf(int gew, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTf(int gew, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(int gew, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(int gew, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountTf(int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthTf(int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountDim(int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthDim(int gew, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private Collection<GmdPartObjGeschl> getObjects(int gew) {
        TreeSet<GmdPartObjGeschl> ts = new TreeSet<GmdPartObjGeschl>();
        for (GmdPartObjGeschl tmp : this.objList) {
            if (tmp.getId() != gew) continue;
            ts.add(tmp);
        }
        return ts.descendingSet();
    }

    private Collection<String> getGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (GmdPartObjGeschl tmp : this.objList) {
            ts.add(tmp.getOwner());
        }
        return ts.descendingSet();
    }

    private double getCountAllTf(String gu, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTf(String gu, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllDim(String gu, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllDim(String gu, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCount(String gu, GerinneGeschlGemeindeReportDialog.Art art) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            ++count;
        }
        return count;
    }

    private double getLength(String gu, GerinneGeschlGemeindeReportDialog.Art art) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String gu, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String gu, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String gu, Integer wdm, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String gu, Integer wdm, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountTf(String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthTf(String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountDim(String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthDim(String gu, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String gu, Integer wdm) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private Collection<Integer> getWdm(String gu) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu)) continue;
            ts.add(tmp.getWidmung());
        }
        return ts.descendingSet();
    }

    private double getCountAllTf(String gu, Integer wdm, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTf(String gu, Integer wdm, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllDim(String gu, Integer wdm, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllDim(String gu, Integer wdm, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || tmp.getArt().equals("p") || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCount(String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getWidmung().equals(wdm) || !tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            ++count;
        }
        return count;
    }

    private double getLength(String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getWidmung().equals(wdm) || !tmp.getOwner().equals(gu) || !tmp.getArt().equals(art.name())) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountAllTfDim(String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthAllTfDim(String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer tfFrom, Integer tfTill, Integer dimFrom, Integer dimTill) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), tfFrom, tfTill) || !this.valueBetween(tmp.getDim(), dimFrom, dimTill)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountTf(String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthTf(String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getTf(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getCountDim(String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        int count = 0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthDim(String gu, Integer wdm, GerinneGeschlGemeindeReportDialog.Art art, Integer from, Integer till) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || !tmp.getWidmung().equals(wdm) || !tmp.getArt().equals(art.name()) || !this.valueBetween(tmp.getDim(), from, till)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String gu) {
        double length = 0.0;
        for (GmdPartObjGeschl tmp : this.objList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    @Override
    protected String createArtString() {
        String art;
        if (GerinneGeschlGewaesserReportDialog.getInstance().getArt() == null) {
            art = "RL-D-Due";
        } else {
            art = null;
            for (GerinneGeschlGemeindeReportDialog.Art a : GerinneGeschlGewaesserReportDialog.getInstance().getArt()) {
                if (art == null) {
                    art = a.name();
                    continue;
                }
                art = art + "-" + a.name();
            }
        }
        return art;
    }
}

