/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewOffenBySb;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.gui.dialog.GerinneOSbReportDialog;
import de.cismet.watergis.reports.GerinneOGemeindeReport;
import de.cismet.watergis.reports.SbHelper;
import de.cismet.watergis.reports.types.FeatureDataSource;
import de.cismet.watergis.reports.types.SbObj;
import de.cismet.watergis.reports.types.SbPartObjOffen;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.apache.log4j.Logger;

public class GerinneOSbReport
extends GerinneOGemeindeReport {
    private static final Logger LOG = Logger.getLogger(GerinneOSbReport.class);
    private static final String[] exceptionalNumberFields = new String[]{"gmdNummer", "gmdName", "code", "anzahlGu", "gu"};
    private static final int PROFSTAT = 1;
    private List<SbPartObjOffen> objList;
    private final List<String> sheetNames = new ArrayList<String>();
    private SbHelper helper;

    public File createSbReport(int[] gew) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY");
        parameters.put("datum", df.format(new Date()));
        parameters.put("perSb", GerinneOSbReportDialog.getInstance().isPerSb());
        parameters.put("dataSources", dataSources);
        FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)GerinneOSbReport.class.getResourceAsStream("/de/cismet/watergis/reports/GerinneOffenSb.jasper"));
        this.init(gew);
        this.helper = new SbHelper(gew, this.getAllowedWdms());
        dataSources.put("gewaesser", this.getSb());
        if (GerinneOSbReportDialog.getInstance().isPerSb()) {
            dataSources.put("gewaesserAbschnitt", this.getSbPerSheet());
        }
        File file = new File(GerinneOSbReportDialog.getInstance().getPath() + "/GerinneOffenSchaubezirke.xls");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dummyDataSource);
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleOutputStreamExporterOutput exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
        exporter.setExporterOutput((ExporterOutput)exportOut);
        SimpleXlsReportConfiguration config = new SimpleXlsReportConfiguration();
        config.setOnePagePerSheet(Boolean.TRUE);
        config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
        config.setShowGridLines(Boolean.valueOf(true));
        config.setColumnWidthRatio(Float.valueOf(1.5f));
        config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        config.setCellHidden(Boolean.valueOf(true));
        config.setDetectCellType(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)config);
        exporter.exportReport();
        exportOut.close();
        out.close();
        return file;
    }

    public static void main(String[] args) {
        GerinneOSbReport report = new GerinneOSbReport();
        try {
            report.createGemeindeReport(new int[]{2}, new int[]{2});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(int[] routeIds) throws Exception {
        this.objList = this.getAllRoutes(routeIds);
    }

    private List<SbPartObjOffen> getAllRoutes(int[] routeIds) throws Exception {
        AllGewOffenBySb search = new AllGewOffenBySb(routeIds, this.getAllowedWdms());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<SbPartObjOffen> objList = new ArrayList<SbPartObjOffen>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new SbPartObjOffen((Integer)f.get(0), (String)f.get(1), (String)f.get(2), (Integer)f.get(3), (String)f.get(4), (String)f.get(5), (Double)f.get(6), (Double)f.get(7), (String)f.get(8), (String)f.get(9), (String)f.get(10), (Double)f.get(11), (Double)f.get(12), (Double)f.get(13), (Double)f.get(14), (Double)f.get(15), (Double)f.get(16), (Double)f.get(17), (Double)f.get(18), (Double)f.get(19), (Double)f.get(20), (Double)f.get(21), (Double)f.get(22), (String)f.get(23), (Double)f.get(24), (Double)f.get(25), (String)f.get(26), (Double)f.get(27), (Double)f.get(28), (Double)f.get(29), (Double)f.get(30), (String)f.get(31), (Double)f.get(32), (Integer)f.get(33), (Double)f.get(34), (Double)f.get(35), (Double)f.get(36), (Double)f.get(37), (Double)f.get(38), (Double)f.get(39), (Double)f.get(40), (Double)f.get(41), (Double)f.get(42), (Double)f.get(43), (Double)f.get(44), (Double)f.get(45), (Double)f.get(46), (Double)f.get(47), (Double)f.get(48), (String)f.get(49)));
            }
        }
        return objList;
    }

    private int[] getAllowedWdms() {
        ArrayList<Integer> wdmList = new ArrayList<Integer>();
        if (GerinneOSbReportDialog.getInstance().is1501()) {
            wdmList.add(1501);
        }
        if (GerinneOSbReportDialog.getInstance().is1502()) {
            wdmList.add(1502);
        }
        if (GerinneOSbReportDialog.getInstance().is1503()) {
            wdmList.add(1503);
        }
        if (GerinneOSbReportDialog.getInstance().is1504()) {
            wdmList.add(1504);
        }
        if (GerinneOSbReportDialog.getInstance().is1505()) {
            wdmList.add(1505);
        }
        int[] wdms = new int[wdmList.size()];
        for (int i = 0; i < wdmList.size(); ++i) {
            wdms[i] = (Integer)wdmList.get(i);
        }
        return wdms;
    }

    private FeatureDataSource getSb() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Schaubezirke");
        for (String gu : this.helper.getGu()) {
            ArrayList<Map<String, Object>> featuresGu = new ArrayList<Map<String, Object>>();
            int anzSb = this.helper.getSbCount(gu);
            for (Integer wdm : this.helper.getWidmung(gu)) {
                ArrayList<Map<String, Object>> featuresWdm = new ArrayList<Map<String, Object>>();
                for (String sb : this.helper.getSb(gu, wdm)) {
                    SbObj firstPart;
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    Collection<SbObj> sbParts = this.helper.getSbPart(gu, wdm, sb);
                    double offenLength = this.helper.getLengthOffeneAbschn(gu, wdm, sb);
                    double prof = this.getLengthGew(sbParts);
                    double mw = this.getLengthMw(sbParts);
                    double gewAll = this.helper.getLengthGewAll(gu, wdm, sb);
                    feature.put("teil", gewAll == (firstPart = sbParts.toArray(new SbObj[sbParts.size()])[0]).getBaLen() ? null : "x");
                    feature.put("group", gu);
                    feature.put("name", gu);
                    feature.put("gu", this.helper.getGuId(gu));
                    feature.put("sb", sb);
                    feature.put("anzSb", anzSb);
                    feature.put("sbName", this.helper.getSbName(sb));
                    feature.put("wdm", wdm);
                    feature.put("gew_a", this.helper.getCountGewAll(gu, wdm, sb));
                    feature.put("gew_l", gewAll);
                    feature.put("offene_l", offenLength);
                    feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                    feature.put("prof_l", prof);
                    feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
                    feature.put("mw_l", mw);
                    feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                    feature.put("profTrap_a", this.getCountProf("tr", sbParts));
                    feature.put("profTrap_l", this.getLengthProf("tr", sbParts));
                    feature.put("profRe_a", this.getCountProf("re", sbParts));
                    feature.put("profRe_l", this.getLengthProf("re", sbParts));
                    feature.put("brSohleMin", this.getMinMax("brSo", sbParts, true));
                    feature.put("brSohleMit", this.getMit("brSo", sbParts));
                    feature.put("brSohleMax", this.getMinMax("brSo", sbParts, false));
                    feature.put("bvReMin", this.getMinMax("bvRe", sbParts, true));
                    feature.put("bvReMit", this.getMit("bvRe", sbParts));
                    feature.put("bvReMax", this.getMinMax("bvRe", sbParts, false));
                    feature.put("bhReMin", this.getMinMax("bhRe", sbParts, true));
                    feature.put("bhReMit", this.getMit("bhRe", sbParts));
                    feature.put("bhReMax", this.getMinMax("bhRe", sbParts, false));
                    feature.put("blReMin", this.getMinMax("blRe", sbParts, true));
                    feature.put("blReMit", this.getMit("blRe", sbParts));
                    feature.put("blReMax", this.getMinMax("blRe", sbParts, false));
                    feature.put("bvLiMin", this.getMinMax("bvLi", sbParts, true));
                    feature.put("bvLiMit", this.getMit("bvLi", sbParts));
                    feature.put("bvLiMax", this.getMinMax("bvLi", sbParts, false));
                    feature.put("bhLiMin", this.getMinMax("bhLi", sbParts, true));
                    feature.put("bhLiMit", this.getMit("bhLi", sbParts));
                    feature.put("bhLiMax", this.getMinMax("bhLi", sbParts, false));
                    feature.put("blLiMin", this.getMinMax("blLi", sbParts, true));
                    feature.put("blLiMit", this.getMit("blLi", sbParts));
                    feature.put("blLiMax", this.getMinMax("blLi", sbParts, false));
                    feature.put("mwMin", this.getMinMax("mw", sbParts, true));
                    feature.put("mwMit", this.getMit("mw", sbParts));
                    feature.put("mwMax", this.getMinMax("mw", sbParts, false));
                    feature.put("flQsGerMin", this.getMinMax("flQsGer", sbParts, true));
                    feature.put("flQsGerMit", this.getMit("flQsGer", sbParts));
                    feature.put("flQsGerMax", this.getMinMax("flQsGer", sbParts, false));
                    feature.put("flQsGewMin", this.getMinMax("flQsGew", sbParts, true));
                    feature.put("flQsGewMit", this.getMit("flQsGew", sbParts));
                    feature.put("flQsGewMax", this.getMinMax("flQsGew", sbParts, false));
                    feature.put("flSohle", this.getSum("flSo", sbParts));
                    feature.put("flBoeRe", this.getSum("flBRe", sbParts));
                    feature.put("flBoeLi", this.getSum("flBLi", sbParts));
                    feature.put("flBoe", this.getSum("flB", sbParts));
                    feature.put("flGer", this.getSum("flGer", sbParts));
                    feature.put("brGewMin", this.getMinMax("brGew", sbParts, true));
                    feature.put("brGewMit", this.getMit("brGew", sbParts));
                    feature.put("brGewMax", this.getMinMax("brGew", sbParts, false));
                    feature.put("flGew", this.getSum("flGew", sbParts));
                    feature.put("blNassReMin", this.getMinMax("blNRe", sbParts, true));
                    feature.put("blNassReMit", this.getMit("blNRe", sbParts));
                    feature.put("blNassReMax", this.getMinMax("blNRe", sbParts, false));
                    feature.put("blTroReMin", this.getMinMax("blTRe", sbParts, true));
                    feature.put("blTroReMit", this.getMit("blTRe", sbParts));
                    feature.put("blTroReMax", this.getMinMax("blTRe", sbParts, false));
                    feature.put("blNassLiMin", this.getMinMax("blNLi", sbParts, true));
                    feature.put("blNassLiMit", this.getMit("blNLi", sbParts));
                    feature.put("blNassLiMax", this.getMinMax("blNLi", sbParts, false));
                    feature.put("blTroLiMin", this.getMinMax("blTLi", sbParts, true));
                    feature.put("blTroLiMit", this.getMit("blTLi", sbParts));
                    feature.put("blTroLiMax", this.getMinMax("blTLi", sbParts, false));
                    feature.put("flBoeNassRe", this.getSum("flBnRe", sbParts));
                    feature.put("flBoeTroRe", this.getSum("flBtRe", sbParts));
                    feature.put("flBoeNassLi", this.getSum("flBnLi", sbParts));
                    feature.put("flBoeTroLi", this.getSum("flBtLi", sbParts));
                    feature.put("flBoeNass", this.getSum("flBn", sbParts));
                    feature.put("flBoeTro", this.getSum("flBt", sbParts));
                    feature.put("flNass", this.getSum("flN", sbParts));
                    feature.put("summe", false);
                    features.add(feature);
                    featuresWdm.add(feature);
                    featuresGu.add(feature);
                }
                features.add(this.createKumFeature(featuresWdm, true));
            }
            features.add(this.createKumFeature(featuresGu, false));
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getSbPerSheet() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (String gu : this.helper.getGu()) {
            for (Integer wdm : this.helper.getWidmung(gu)) {
                for (String sb : this.helper.getSb(gu, wdm)) {
                    ArrayList<Map<String, Object>> featuresSb = new ArrayList<Map<String, Object>>();
                    this.sheetNames.add(this.helper.getGuId(gu) + "-" + wdm + "-" + sb);
                    for (Integer gew : this.helper.getGew(gu, wdm, sb)) {
                        HashMap<String, Object> feature = new HashMap<String, Object>();
                        Collection<SbObj> sbParts = this.helper.getSbPart(gu, wdm, sb, gew);
                        double offenLength = this.helper.getLengthOffeneAbschn(gu, wdm, sb, gew);
                        double prof = this.getLengthGew(sbParts);
                        double mw = this.getLengthMw(sbParts);
                        double gewAll = this.helper.getLengthGewAll(gu, wdm, sb, gew);
                        feature.put("group", gu + "-" + wdm + "-" + sb);
                        feature.put("gu", gu);
                        feature.put("wdm", wdm);
                        feature.put("sb", sb);
                        feature.put("sbName", this.helper.getSbName(sb));
                        feature.put("anzGew", this.helper.getGew(gu, wdm, sb).size());
                        feature.put("code", this.helper.getBaCd(gew));
                        feature.put("name", this.helper.getGewName(gew));
                        feature.put("von", this.convertStation(this.getMinFrom(sbParts)));
                        feature.put("bis", this.convertStation(this.getMaxTill(sbParts)));
                        feature.put("laenge", gewAll);
                        feature.put("offene_l", offenLength);
                        feature.put("offene_a", gewAll != 0.0 ? offenLength * 100.0 / gewAll : 100.0);
                        feature.put("prof_l", prof);
                        feature.put("prof_a", offenLength != 0.0 ? prof * 100.0 / offenLength : 100.0);
                        feature.put("mw_l", mw);
                        feature.put("mw_a", prof != 0.0 ? mw * 100.0 / prof : 100.0);
                        feature.put("profTrap_a", this.getCountProf("tr", sbParts));
                        feature.put("profTrap_l", this.getLengthProf("tr", sbParts));
                        feature.put("profRe_a", this.getCountProf("re", sbParts));
                        feature.put("profRe_l", this.getLengthProf("re", sbParts));
                        feature.put("brSohleMin", this.getMinMax("brSo", sbParts, true));
                        feature.put("brSohleMit", this.getMit("brSo", sbParts));
                        feature.put("brSohleMax", this.getMinMax("brSo", sbParts, false));
                        feature.put("bvReMin", this.getMinMax("bvRe", sbParts, true));
                        feature.put("bvReMit", this.getMit("bvRe", sbParts));
                        feature.put("bvReMax", this.getMinMax("bvRe", sbParts, false));
                        feature.put("bhReMin", this.getMinMax("bhRe", sbParts, true));
                        feature.put("bhReMit", this.getMit("bhRe", sbParts));
                        feature.put("bhReMax", this.getMinMax("bhRe", sbParts, false));
                        feature.put("blReMin", this.getMinMax("blRe", sbParts, true));
                        feature.put("blReMit", this.getMit("blRe", sbParts));
                        feature.put("blReMax", this.getMinMax("blRe", sbParts, false));
                        feature.put("bvLiMin", this.getMinMax("bvLi", sbParts, true));
                        feature.put("bvLiMit", this.getMit("bvLi", sbParts));
                        feature.put("bvLiMax", this.getMinMax("bvLi", sbParts, false));
                        feature.put("bhLiMin", this.getMinMax("bhLi", sbParts, true));
                        feature.put("bhLiMit", this.getMit("bhLi", sbParts));
                        feature.put("bhLiMax", this.getMinMax("bhLi", sbParts, false));
                        feature.put("blLiMin", this.getMinMax("blLi", sbParts, true));
                        feature.put("blLiMit", this.getMit("blLi", sbParts));
                        feature.put("blLiMax", this.getMinMax("blLi", sbParts, false));
                        feature.put("mwMin", this.getMinMax("mw", sbParts, true));
                        feature.put("mwMit", this.getMit("mw", sbParts));
                        feature.put("mwMax", this.getMinMax("mw", sbParts, false));
                        feature.put("flQsGerMin", this.getMinMax("flQsGer", sbParts, true));
                        feature.put("flQsGerMit", this.getMit("flQsGer", sbParts));
                        feature.put("flQsGerMax", this.getMinMax("flQsGer", sbParts, false));
                        feature.put("flQsGewMin", this.getMinMax("flQsGew", sbParts, true));
                        feature.put("flQsGewMit", this.getMit("flQsGew", sbParts));
                        feature.put("flQsGewMax", this.getMinMax("flQsGew", sbParts, false));
                        feature.put("flSohle", this.getSum("flSo", sbParts));
                        feature.put("flBoeRe", this.getSum("flBRe", sbParts));
                        feature.put("flBoeLi", this.getSum("flBLi", sbParts));
                        feature.put("flBoe", this.getSum("flB", sbParts));
                        feature.put("flGer", this.getSum("flGer", sbParts));
                        feature.put("brGewMin", this.getMinMax("brGew", sbParts, true));
                        feature.put("brGewMit", this.getMit("brGew", sbParts));
                        feature.put("brGewMax", this.getMinMax("brGew", sbParts, false));
                        feature.put("flGew", this.getSum("flGew", sbParts));
                        feature.put("blNassReMin", this.getMinMax("blNRe", sbParts, true));
                        feature.put("blNassReMit", this.getMit("blNRe", sbParts));
                        feature.put("blNassReMax", this.getMinMax("blNRe", sbParts, false));
                        feature.put("blTroReMin", this.getMinMax("blTRe", sbParts, true));
                        feature.put("blTroReMit", this.getMit("blTRe", sbParts));
                        feature.put("blTroReMax", this.getMinMax("blTRe", sbParts, false));
                        feature.put("blNassLiMin", this.getMinMax("blNLi", sbParts, true));
                        feature.put("blNassLiMit", this.getMit("blNLi", sbParts));
                        feature.put("blNassLiMax", this.getMinMax("blNLi", sbParts, false));
                        feature.put("blTroLiMin", this.getMinMax("blTLi", sbParts, true));
                        feature.put("blTroLiMit", this.getMit("blTLi", sbParts));
                        feature.put("blTroLiMax", this.getMinMax("blTLi", sbParts, false));
                        feature.put("flBoeNassRe", this.getSum("flBnRe", sbParts));
                        feature.put("flBoeTroRe", this.getSum("flBtRe", sbParts));
                        feature.put("flBoeNassLi", this.getSum("flBnLi", sbParts));
                        feature.put("flBoeTroLi", this.getSum("flBtLi", sbParts));
                        feature.put("flBoeNass", this.getSum("flBn", sbParts));
                        feature.put("flBoeTro", this.getSum("flBt", sbParts));
                        feature.put("flNass", this.getSum("flN", sbParts));
                        feature.put("summe", false);
                        features.add(feature);
                        featuresSb.add(feature);
                    }
                    features.add(this.createKumFeature(featuresSb, true));
                }
            }
        }
        if (features.isEmpty()) {
            return null;
        }
        return new FeatureDataSource(features);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal) {
        return this.createKumFeature(featureListKum, subtotal, 0);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal, int stat) {
        HashMap<String, Object> kumFeature = new HashMap<String, Object>();
        if (!subtotal) {
            kumFeature.put("summe", Boolean.TRUE);
        }
        kumFeature.put("zwischenSumme", subtotal);
        if (featureListKum == null || featureListKum.isEmpty()) {
            return kumFeature;
        }
        Map<String, Object> firstElement = featureListKum.get(0);
        for (String key : new ArrayList<String>(firstElement.keySet())) {
            double totalTmp;
            double specificTmp;
            double lengthSpecific;
            double lengthTotal;
            Object value = firstElement.get(key);
            if (key.endsWith("offene_a") && value instanceof Double) {
                lengthTotal = 0.0;
                lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = this.toDouble(f.get("offene_l"));
                    totalTmp = this.toDouble(f.get("gew_l"));
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                } else {
                    kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                }
            }
            if (key.endsWith("prof_a") && value instanceof Double) {
                lengthTotal = 0.0;
                lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = this.toDouble(f.get("prof_l"));
                    totalTmp = this.toDouble(f.get("offene_l"));
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                } else {
                    kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                }
            }
            if (key.endsWith("mw_a") && value instanceof Double) {
                lengthTotal = 0.0;
                lengthSpecific = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    specificTmp = this.toDouble(f.get("mw_l"));
                    totalTmp = this.toDouble(f.get("prof_l"));
                    lengthTotal += totalTmp;
                    lengthSpecific += specificTmp;
                }
                if (lengthTotal == 0.0) {
                    kumFeature.put(key, 100.0);
                    continue;
                }
                kumFeature.put(key, lengthSpecific * 100.0 / lengthTotal);
                continue;
            }
            if (key.endsWith("Min") && value instanceof Double) {
                double min = value != null ? (Double)value : Double.MAX_VALUE;
                for (Map<String, Object> f : featureListKum) {
                    double val = this.toDouble(f.get(key));
                    if (stat == 1) {
                        f.put("key", null);
                    }
                    if (!(val < min)) continue;
                    min = val;
                }
                if (min == Double.MAX_VALUE) continue;
                kumFeature.put(key, min);
                continue;
            }
            if (key.endsWith("Max") && value instanceof Double) {
                double max = this.toDouble(value);
                for (Map<String, Object> f : featureListKum) {
                    double val = this.toDouble(f.get(key));
                    if (stat == 1) {
                        f.put("key", null);
                    }
                    if (!(val > max)) continue;
                    max = val;
                }
                if (max == 0.0) continue;
                kumFeature.put(key, max);
                continue;
            }
            if (key.endsWith("Mit") && value instanceof Double) {
                double mit = 0.0;
                double length = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    double val = this.toDouble(f.get(key));
                    double len = this.toDouble(f.get("prof_l"));
                    mit += val * len;
                    length += len;
                }
                if (length == 0.0) continue;
                kumFeature.put(key, mit / length);
                continue;
            }
            if (key.equals("sb") && value instanceof String) {
                kumFeature.put(key, value);
                continue;
            }
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Integer) {
                int sum = 0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Integer)f.get(key)).intValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Double) {
                double sum = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    sum += this.toDouble(f.get(key));
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (value instanceof String && !key.equals("group") || value instanceof Boolean || Arrays.binarySearch(exceptionalNumberFields, key) >= 0) continue;
            kumFeature.put(key, value);
        }
        return kumFeature;
    }

    private double toDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        return (Double)o;
    }

    private double getMinFrom(Collection<SbObj> sbParts) {
        double min = Double.MAX_VALUE;
        for (SbObj tmp : sbParts) {
            if (!(tmp.getFrom() < min)) continue;
            min = tmp.getFrom();
        }
        return min;
    }

    private double getMaxTill(Collection<SbObj> sbParts) {
        double max = 0.0;
        for (SbObj tmp : sbParts) {
            if (!(tmp.getTill() > max)) continue;
            max = tmp.getTill();
        }
        return max;
    }

    private int getCountGewAll() {
        TreeSet<String> ts = new TreeSet<String>();
        for (SbPartObjOffen tmp : this.objList) {
            ts.add(tmp.getBaCd());
        }
        return ts.size();
    }

    private double getLengthGew() {
        return this.getLengthGew(-1);
    }

    private double getLengthGew(int gewId) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthGew(Collection<SbObj> sbParts) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            for (SbObj sb : sbParts) {
                if (tmp.getId().intValue() != sb.getId()) continue;
                length += tmp.getLengthInGewPart(sb.getId(), sb.getFrom(), sb.getTill()).doubleValue();
            }
        }
        return length;
    }

    private double getLengthGew(int gewId, double from, double till) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getLengthMw(int gewId) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(Collection<SbObj> sbParts) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            for (SbObj sb : sbParts) {
                if (tmp.getId().intValue() != sb.getId() || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
                length += tmp.getLengthInGewPart(sb.getId(), sb.getFrom(), sb.getTill()).doubleValue();
            }
        }
        return length;
    }

    private double getLengthMw(String gu) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(String gu, int wdm) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthMw(int gewId, double from, double till) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getMw() == null || tmp.getMw() == 0.0) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, int gewId) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, Collection<SbObj> sbParts) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            for (SbObj sb : sbParts) {
                if (tmp.getId().intValue() != sb.getId() || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
                length += tmp.getLengthInGewPart(sb.getId(), sb.getFrom(), sb.getTill()).doubleValue();
            }
        }
        return length;
    }

    private double getLengthProf(String prof, String gu) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, String gu, int wdm) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthProf(String prof, int gewId, double from, double till) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        return length;
    }

    private double getMinMax(String field, Collection<SbObj> sbParts, boolean min) {
        double currentVal = 0.0;
        boolean firstValue = true;
        for (SbPartObjOffen tmp : this.objList) {
            for (SbObj sb : sbParts) {
                double value;
                if (!tmp.isInGewPart(sb.getId(), sb.getFrom(), sb.getTill()) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
                currentVal = value;
                firstValue = false;
            }
        }
        return currentVal;
    }

    private double getMinMax(String field, String gu, boolean min) {
        double currentVal = 0.0;
        boolean firstValue = true;
        for (SbPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMinMax(String field, String gu, int wdm, boolean min) {
        double currentVal = 0.0;
        boolean firstValue = true;
        for (SbPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMinMax(String field, int gewId, double from, double till, boolean min) {
        double currentVal = 0.0;
        boolean firstValue = true;
        for (SbPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || (value = tmp.get(field)) == 0.0 || !(firstValue || min && value < currentVal) && (min || !(value > currentVal))) continue;
            currentVal = value;
            firstValue = false;
        }
        return currentVal;
    }

    private double getMit(String field, int gewId) {
        double currentVal = 0.0;
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            double value;
            if (gewId != -1 && tmp.getId() != gewId || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, Collection<SbObj> sbParts) {
        double currentVal = 0.0;
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            for (SbObj sb : sbParts) {
                double value;
                if (!tmp.isInGewPart(sb.getId(), sb.getFrom(), sb.getTill()) || (value = tmp.get(field)) == 0.0) continue;
                currentVal += value * tmp.getLengthInGewPart(sb.getId(), sb.getFrom(), sb.getTill());
                length += tmp.getLengthInGewPart(sb.getId(), sb.getFrom(), sb.getTill()).doubleValue();
            }
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, String gu) {
        double currentVal = 0.0;
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, String gu, int wdm) {
        double currentVal = 0.0;
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLength();
            length += tmp.getLength().doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getMit(String field, int gewId, double from, double till) {
        double currentVal = 0.0;
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            double value;
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || (value = tmp.get(field)) == 0.0) continue;
            currentVal += value * tmp.getLengthInGewPart(gewId, from, till);
            length += tmp.getLengthInGewPart(gewId, from, till).doubleValue();
        }
        if (length == 0.0) {
            return 0.0;
        }
        return currentVal / length;
    }

    private double getSum(String field, int gewId) {
        double currentVal = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    private double getSum(String field, Collection<SbObj> sbParts) {
        double currentVal = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            for (SbObj sb : sbParts) {
                if (!tmp.isInGewPart(sb.getId(), sb.getFrom(), sb.getTill())) continue;
                double value = tmp.get(field);
                currentVal += value / tmp.getLength() * tmp.getLengthInGewPart(sb.getId(), sb.getFrom(), sb.getTill());
            }
        }
        return currentVal;
    }

    private double getSum(String field, int gewId, double from, double till) {
        double currentVal = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till)) continue;
            double value = tmp.get(field);
            currentVal += value / tmp.getLength() * tmp.getLengthInGewPart(gewId, from, till);
        }
        return currentVal;
    }

    private double getSum(String field, String gu) {
        double currentVal = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu)) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    private double getSum(String field, String gu, int wdm) {
        double currentVal = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm)) continue;
            double value = tmp.get(field);
            currentVal += value;
        }
        return currentVal;
    }

    @Override
    public int getCountProf(String prof, int gewId) {
        int count = 0;
        for (SbPartObjOffen tmp : this.objList) {
            if (gewId != -1 && tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, Collection<SbObj> sbParts) {
        int count = 0;
        for (SbPartObjOffen tmp : this.objList) {
            for (SbObj sb : sbParts) {
                if (!tmp.isInGewPart(sb.getId(), sb.getFrom(), sb.getTill()) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getCountProf(String prof, String gu) {
        int count = 0;
        for (SbPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, String gu, int wdm) {
        int count = 0;
        for (SbPartObjOffen tmp : this.objList) {
            if (tmp.getOwner() == null || !tmp.getOwner().equals(gu) || tmp.getWdm() == null || !tmp.getWdm().equals(wdm) || tmp.getProfil() == null || !tmp.getProfil().equals(prof)) continue;
            ++count;
        }
        return count;
    }

    public int getCountProf(String prof, int gewId, double from, double till) {
        int count = 0;
        for (SbPartObjOffen tmp : this.objList) {
            if (tmp.getId() != gewId || tmp.getProfil() == null || !tmp.getProfil().equals(prof) || !tmp.isInGewPart(gewId, from, till)) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGew(String gu) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private double getLengthGew(String gu, int wdm) {
        double length = 0.0;
        for (SbPartObjOffen tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWdm() != wdm) continue;
            length += tmp.getLength().doubleValue();
        }
        return length;
    }

    private int getCountGew(String gu) {
        int count = 0;
        for (SbPartObjOffen tmp : this.objList) {
            if (!tmp.getOwner().equals(gu)) continue;
            ++count;
        }
        return count;
    }

    private int getCountGew(String gu, int wdm) {
        int count = 0;
        for (SbPartObjOffen tmp : this.objList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWdm() != wdm) continue;
            ++count;
        }
        return count;
    }

    private String convertStation(Double station) {
        int km = (int)(station / 1000.0);
        int m = (int)(station % 1000.0);
        String mString = String.valueOf(m);
        while (mString.length() < 3) {
            mString = "0" + mString;
        }
        return km + "+" + mString;
    }

    static {
        Arrays.sort(exceptionalNumberFields);
    }
}

