/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewByGem;
import de.cismet.cids.custom.watergis.server.search.AllLineObjects;
import de.cismet.cids.custom.watergis.server.search.AllPunktObjects;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.watergis.gui.dialog.KatasterGemeindeReportDialog;
import de.cismet.watergis.reports.types.FeatureDataSource;
import de.cismet.watergis.reports.types.GemeindenData;
import de.cismet.watergis.reports.types.GmdPartObj;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import org.apache.log4j.Logger;

public class KatasterGemeindeReport {
    private static final Logger LOG = Logger.getLogger(KatasterGemeindeReport.class);
    private static ImageIcon annotationIco = new ImageIcon(KatasterGemeindeReport.class.getResource("/de/cismet/watergis/reports/Station.png"));
    private static final String[] exceptionalFields = new String[]{"name", "nummer", "gmdNummer", "gmdName", "code", "anzahlGu", "gu"};
    private final Map<Integer, List<GmdPartObj>> gemPartMap = new HashMap<Integer, List<GmdPartObj>>();
    private final Map<Integer, GemeindenData> gemDataMap = new HashMap<Integer, GemeindenData>();
    private final List<String> sheetNames = new ArrayList<String>();

    public File createGemeindeReport(int[] gemId, int[] gew, WaitDialog wd) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY");
        parameters.put("datum", df.format(new Date()));
        parameters.put("gemeinden", gemId.length);
        parameters.put("wasserschutz", KatasterGemeindeReportDialog.getInstance().isWsg());
        parameters.put("ueber", KatasterGemeindeReportDialog.getInstance().isSchutzgebiete());
        parameters.put("ben", KatasterGemeindeReportDialog.getInstance().isBen());
        parameters.put("aus", KatasterGemeindeReportDialog.getInstance().isAus());
        parameters.put("pegel", KatasterGemeindeReportDialog.getInstance().isPegel());
        parameters.put("gb", KatasterGemeindeReportDialog.getInstance().isGb());
        parameters.put("sb", KatasterGemeindeReportDialog.getInstance().isSb());
        parameters.put("prof", KatasterGemeindeReportDialog.getInstance().isProf());
        parameters.put("sbef", KatasterGemeindeReportDialog.getInstance().isSbef());
        parameters.put("ubef", KatasterGemeindeReportDialog.getInstance().isUbef());
        parameters.put("bbef", KatasterGemeindeReportDialog.getInstance().isBbef());
        parameters.put("rl", KatasterGemeindeReportDialog.getInstance().isRl());
        parameters.put("d", KatasterGemeindeReportDialog.getInstance().isD());
        parameters.put("due", KatasterGemeindeReportDialog.getInstance().isDue());
        parameters.put("scha", KatasterGemeindeReportDialog.getInstance().isScha());
        parameters.put("wehr", KatasterGemeindeReportDialog.getInstance().isWehr());
        parameters.put("schw", KatasterGemeindeReportDialog.getInstance().isSchw());
        parameters.put("foto", KatasterGemeindeReportDialog.getInstance().isFoto());
        parameters.put("anlp", KatasterGemeindeReportDialog.getInstance().isAnlp());
        parameters.put("anll", KatasterGemeindeReportDialog.getInstance().isAnll());
        parameters.put("kr", KatasterGemeindeReportDialog.getInstance().isKr());
        parameters.put("ea", KatasterGemeindeReportDialog.getInstance().isEa());
        parameters.put("deich", KatasterGemeindeReportDialog.getInstance().isDeich());
        parameters.put("ughz", KatasterGemeindeReportDialog.getInstance().isUghz());
        parameters.put("leis", KatasterGemeindeReportDialog.getInstance().isLeis());
        parameters.put("tech", KatasterGemeindeReportDialog.getInstance().isTech());
        parameters.put("dok", KatasterGemeindeReportDialog.getInstance().isDok());
        parameters.put("proj", KatasterGemeindeReportDialog.getInstance().isProj());
        parameters.put("perGew", KatasterGemeindeReportDialog.getInstance().isPerGew());
        parameters.put("perAbschn", KatasterGemeindeReportDialog.getInstance().isPerPart());
        parameters.put("sumGu", KatasterGemeindeReportDialog.getInstance().isSumGu());
        parameters.put("wdm", KatasterGemeindeReportDialog.getInstance().isPerWdm());
        parameters.put("dataSources", dataSources);
        FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)KatasterGemeindeReport.class.getResourceAsStream("/de/cismet/watergis/reports/gemeinden.jasper"));
        if (!this.init(gemId, gew, wd)) {
            return null;
        }
        dataSources.put("gemeinden", this.getGemeindenAll());
        if (KatasterGemeindeReportDialog.getInstance().isPerGew() && !KatasterGemeindeReportDialog.getInstance().isPerPart()) {
            dataSources.put("gewaesser", this.getGewaesser());
        } else if (KatasterGemeindeReportDialog.getInstance().isPerPart()) {
            dataSources.put("gewaesserAbschnitt", this.getGewaesserAbschnitt());
        }
        if (KatasterGemeindeReportDialog.getInstance().isPerGew() && KatasterGemeindeReportDialog.getInstance().isSumGu()) {
            if (KatasterGemeindeReportDialog.getInstance().isPerWdm()) {
                dataSources.put("gewaesserGuAbschnitt", this.getGewaesserGuWidmung());
            } else {
                dataSources.put("gewaesserGu", this.getGewaesserGu());
            }
        }
        if (KatasterGemeindeReportDialog.getInstance().isSumGu()) {
            if (KatasterGemeindeReportDialog.getInstance().isPerWdm()) {
                dataSources.put("guWidmung", this.getGuWidmung());
            } else {
                dataSources.put("gu", this.getGuTable());
            }
        }
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dummyDataSource);
        File file = new File(KatasterGemeindeReportDialog.getInstance().getPath() + "/Kataster_Gemeinden.xlsx");
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleOutputStreamExporterOutput exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
        exporter.setExporterOutput((ExporterOutput)exportOut);
        SimpleXlsxReportConfiguration config = new SimpleXlsxReportConfiguration();
        config.setOnePagePerSheet(Boolean.TRUE);
        config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
        config.setShowGridLines(Boolean.valueOf(true));
        config.setColumnWidthRatio(Float.valueOf(1.5f));
        config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        config.setCellHidden(Boolean.valueOf(true));
        config.setDetectCellType(Boolean.valueOf(true));
        config.setIgnoreCellBackground(Boolean.valueOf(false));
        exporter.setConfiguration((ReportExportConfiguration)config);
        exporter.exportReport();
        exportOut.close();
        out.close();
        return file;
    }

    public static void main(String[] args) {
        KatasterGemeindeReport report = new KatasterGemeindeReport();
    }

    private boolean init(int[] gemNr, int[] routeIds, WaitDialog wd) throws Exception {
        wd.setMax(gemNr.length + 1);
        wd.setProgress(0);
        for (int gem : gemNr) {
            List<GmdPartObj> parts = this.mergeRoutes(this.getAllRoutes(gem, routeIds));
            this.gemPartMap.put(gem, parts);
            Integer[] idList = this.getGew(gem).toArray(new Integer[0]);
            int[] routes = new int[idList.length];
            for (int i = 0; i < idList.length; ++i) {
                routes[i] = idList[i];
            }
            if (routes.length == 0) {
                routes = null;
            }
            GemeindenData gemData = new GemeindenData(gem, routes);
            this.gemDataMap.put(gem, gemData);
            ArrayList<GmdPartObj> newParts = new ArrayList<GmdPartObj>();
            for (GmdPartObj tmp : parts) {
                double length = gemData.getLength(GemeindenData.LineFromPolygonTable.sg_see, tmp.getId(), tmp.getFrom(), tmp.getTill());
                if (!tmp.getArt().equals("g") && length >= 0.01) {
                    if (length == Math.abs(tmp.getTill() - tmp.getFrom())) {
                        tmp.setArt("s");
                        newParts.add(tmp);
                        continue;
                    }
                    List<GemeindenData.LineObjectData> seaParts = gemData.getLengthFromTill(GemeindenData.LineFromPolygonTable.sg_see, tmp.getId(), tmp.getFrom(), tmp.getTill());
                    double lastEnd = tmp.getFrom();
                    for (GemeindenData.LineObjectData line : seaParts) {
                        GmdPartObj obj;
                        if (line.getFrom() > lastEnd) {
                            obj = new GmdPartObj(tmp);
                            obj.setFrom(lastEnd);
                            obj.setTill(line.getFrom());
                            newParts.add(obj);
                            lastEnd = line.getFrom();
                        }
                        obj = new GmdPartObj(tmp);
                        obj.setFrom(lastEnd);
                        obj.setTill(line.getTo());
                        obj.setArt("s");
                        newParts.add(obj);
                        lastEnd = line.getTo();
                    }
                    if (!(lastEnd < tmp.getTill())) continue;
                    GmdPartObj obj = new GmdPartObj(tmp);
                    obj.setFrom(lastEnd);
                    newParts.add(obj);
                    continue;
                }
                newParts.add(tmp);
            }
            this.gemPartMap.put(gem, newParts);
            int progress = wd.getProgress() + 1;
            if (Thread.interrupted()) {
                return false;
            }
            wd.setText("Erstelle (Gemeinden) " + progress + "/" + gemNr.length);
            wd.setProgress(progress);
        }
        return true;
    }

    private List<GmdPartObj> mergeRoutes(List<GmdPartObj> routes) {
        ArrayList<GmdPartObj> newRoutes = new ArrayList<GmdPartObj>();
        if (routes == null || routes.size() < 2) {
            return routes;
        }
        GmdPartObj lastRoute = routes.get(0);
        for (int i = 1; i < routes.size(); ++i) {
            GmdPartObj tmp = routes.get(i);
            if (lastRoute.getArt().equals(tmp.getArt()) && lastRoute.getId() == tmp.getId() && lastRoute.getTill() > tmp.getFrom() - 0.01 && lastRoute.getNr_li() == tmp.getNr_li() && lastRoute.getNr_re() == tmp.getNr_re()) {
                lastRoute.setTill(tmp.getTill());
                continue;
            }
            newRoutes.add(lastRoute);
            lastRoute = tmp;
        }
        newRoutes.add(lastRoute);
        return newRoutes;
    }

    private List<GmdPartObj> getAllRoutes(int gemId, int[] routeIds) throws Exception {
        AllGewByGem search = new AllGewByGem(gemId, routeIds, this.getAllowedWdms());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<GmdPartObj> objList = new ArrayList<GmdPartObj>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new GmdPartObj((Integer)f.get(0), (String)f.get(1), (String)f.get(7), (String)f.get(8), (String)f.get(9), (Integer)f.get(10), (String)f.get(2), (Double)f.get(3), (Double)f.get(4), (Integer)f.get(5), (Integer)f.get(6), (Double)f.get(11), (Double)f.get(12)));
            }
        }
        return objList;
    }

    private int[] getAllowedWdms() {
        ArrayList<Integer> wdmList = new ArrayList<Integer>();
        if (KatasterGemeindeReportDialog.getInstance().is1501()) {
            wdmList.add(1501);
        }
        if (KatasterGemeindeReportDialog.getInstance().is1502()) {
            wdmList.add(1502);
        }
        if (KatasterGemeindeReportDialog.getInstance().is1503()) {
            wdmList.add(1503);
        }
        if (KatasterGemeindeReportDialog.getInstance().is1504()) {
            wdmList.add(1504);
        }
        if (KatasterGemeindeReportDialog.getInstance().is1505()) {
            wdmList.add(1505);
        }
        int[] wdms = new int[wdmList.size()];
        for (int i = 0; i < wdmList.size(); ++i) {
            wdms[i] = (Integer)wdmList.get(i);
        }
        return wdms;
    }

    private FeatureDataSource getGemeindenAll() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Gemeinden");
        TreeSet<Integer> set = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return ((GemeindenData)KatasterGemeindeReport.this.gemDataMap.get(o1)).getGmdName().compareTo(((GemeindenData)KatasterGemeindeReport.this.gemDataMap.get(o2)).getGmdName());
            }
        });
        set.addAll(this.gemDataMap.keySet());
        for (Integer gem : set) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            feature.put("name", this.gemDataMap.get(gem).getGmdName());
            feature.put("nummer", gem);
            feature.put("gew_a", this.toNullIfZero(this.getLengthGewAll(gem) * 100.0 / this.getLengthGewAll()));
            feature.put("gew_l", this.toNullIfZero(this.getLengthGewAll(gem)));
            double lengthSee = this.getLengthSeeAbschn(gem);
            feature.put("offene_a", this.toNullIfZero((this.getLengthGewAll(gem) - this.getLengthGeschlAbschn(gem) - lengthSee) * 100.0 / this.getLengthGewAll(gem)));
            feature.put("offene_l", this.toNullIfZero(this.getLengthGewAll(gem) - this.getLengthGeschlAbschn(gem) - lengthSee));
            feature.put("see_a", this.toNullIfZero(lengthSee * 100.0 / this.getLengthGewAll(gem)));
            feature.put("see_l", this.toNullIfZero(lengthSee));
            feature.put("geschl_a", this.toNullIfZero(this.getLengthGeschlAbschn(gem) * 100.0 / this.getLengthGewAll(gem)));
            feature.put("geschl_l", this.toNullIfZero(this.getLengthGeschlAbschn(gem)));
            feature.put("wschutz_a", this.toNullIfZero(this.getCountLineObjectsAll(GemeindenData.LineFromPolygonTable.wr_sg_wsg, (int)gem)));
            feature.put("wschutz_l", this.toNullIfZero(this.getLengthLineObjectsAll(GemeindenData.LineFromPolygonTable.wr_sg_wsg, (int)gem)));
            feature.put("ueber_a", this.toNullIfZero(this.getCountLineObjectsAll(GemeindenData.LineFromPolygonTable.wr_sg_uesg, (int)gem)));
            feature.put("ueber_l", this.toNullIfZero(this.getLengthLineObjectsAll(GemeindenData.LineFromPolygonTable.wr_sg_uesg, (int)gem)));
            feature.put("ben_a", this.toNullIfZero(this.getCountPointObjectsAll(AllPunktObjects.Table.wr_wbu_ben, gem)));
            feature.put("aus_a", this.toNullIfZero(this.getCountPointObjectsAll(AllPunktObjects.Table.wr_wbu_aus, gem)));
            feature.put("pegel_a", this.toNullIfZero(this.getCountPointObjectsAll(AllPunktObjects.Table.mn_ow_pegel, gem)));
            feature.put("gb_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_gb, (int)gem)));
            feature.put("gb_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_gb, (int)gem)));
            feature.put("sb_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_sb, (int)gem)));
            feature.put("sb_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_sb, (int)gem)));
            feature.put("prof_a", this.toNullIfZero(this.percentage(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_prof, (int)gem), this.getLengthGewAll(gem) - this.getLengthGeschlAbschn(gem))));
            feature.put("prof_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_prof, (int)gem)));
            feature.put("sbef_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_sbef, (int)gem)));
            feature.put("sbef_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_sbef, (int)gem)));
            feature.put("ubef_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_ubef, (int)gem)));
            feature.put("ubef_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_ubef, (int)gem)));
            feature.put("bbef_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_bbef, (int)gem)));
            feature.put("bbef_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_bbef, (int)gem)));
            feature.put("rl_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_rl, (int)gem)));
            feature.put("rl_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_rl, (int)gem)));
            feature.put("d_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_d, (int)gem)));
            feature.put("d_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_d, (int)gem)));
            feature.put("due_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_due, (int)gem)));
            feature.put("due_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_due, (int)gem)));
            feature.put("scha_a", this.toNullIfZero(this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_scha, gem)));
            feature.put("wehr_a", this.toNullIfZero(this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_wehr, gem)));
            feature.put("schw_a", this.toNullIfZero(this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_schw, gem)));
            feature.put("foto_a", this.toNullIfZero(this.getCountPointObjectsAll(AllPunktObjects.Table.foto, gem)));
            feature.put("anlp_a", this.toNullIfZero(this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_anlp, gem)));
            feature.put("anll_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_anll, (int)gem)));
            feature.put("anll_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_anll, (int)gem)));
            feature.put("kr_a", this.toNullIfZero(this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_kr, gem)));
            feature.put("ea_a", this.toNullIfZero(this.getCountPointObjectsAll(AllPunktObjects.Table.fg_ba_ea, gem)));
            feature.put("deich_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.deich_ft, (int)gem)));
            feature.put("deich_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.deich_ft, (int)gem)));
            feature.put("ughz_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_ughz, (int)gem)));
            feature.put("ughz_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_ughz, (int)gem)));
            feature.put("leis_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_leis, (int)gem)));
            feature.put("leis_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_leis, (int)gem)));
            feature.put("tech_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_tech, (int)gem)));
            feature.put("tech_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_tech, (int)gem)));
            feature.put("dok_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_doku, (int)gem)));
            feature.put("dok_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_doku, (int)gem)));
            feature.put("proj_a", this.toNullIfZero(this.getCountLineObjectsAll(AllLineObjects.Table.fg_ba_proj, (int)gem)));
            feature.put("proj_l", this.toNullIfZero(this.getLengthLineObjectsAll(AllLineObjects.Table.fg_ba_proj, (int)gem)));
            features.add(feature);
        }
        features.add(this.createKumFeature(features, false, true));
        return new FeatureDataSource(features);
    }

    private double percentage(double part, double total) {
        if (part == 0.0) {
            return 0.0;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return part * 100.0 / total;
    }

    private FeatureDataSource getGewaesser() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        TreeSet<Integer> set = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return ((GemeindenData)KatasterGemeindeReport.this.gemDataMap.get(o1)).getGmdName().compareTo(((GemeindenData)KatasterGemeindeReport.this.gemDataMap.get(o2)).getGmdName());
            }
        });
        set.addAll(this.gemDataMap.keySet());
        for (Integer gem : set) {
            if (this.getGew(gem).isEmpty()) continue;
            this.sheetNames.add(this.gemDataMap.get(gem).getGmdName());
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (int gew : this.getGew(gem)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                feature.put("gmdName", this.gemDataMap.get(gem).getGmdName());
                feature.put("gmdNummer", gem);
                feature.put("anzahlGew", this.getCountGewAll(gem));
                feature.put("group", gem);
                feature.put("code", this.getBaCd(gem, gew));
                feature.put("gewName", this.getGewName(gem, gew));
                feature.put("gewLaenge", this.getLengthGew((int)gem, gew));
                feature.put("offene_a", this.getCountOffeneAbschn((int)gem, gew));
                feature.put("offene_l", this.getLengthOffeneAbschn((int)gem, gew));
                feature.put("see_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.sg_see, (int)gem, gew));
                feature.put("see_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.sg_see, (int)gem, gew));
                feature.put("geschl_a", this.getCountGeschlAbschn((int)gem, gew));
                feature.put("geschl_l", this.getLengthGeschlAbschn((int)gem, gew));
                feature.put("wschutz_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, (int)gem, gew));
                feature.put("wschutz_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, (int)gem, gew));
                feature.put("ueber_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, (int)gem, gew));
                feature.put("ueber_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, (int)gem, gew));
                feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, (int)gem, gew));
                feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, (int)gem, gew));
                feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, (int)gem, gew));
                feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, (int)gem, gew));
                feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, (int)gem, gew));
                feature.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, (int)gem, gew));
                feature.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, (int)gem, gew));
                feature.put("prof_a", this.percentage(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, (int)gem, gew), this.getLengthGew((int)gem, gew) - this.getLengthGeschlAbschn((int)gem, gew)));
                feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, (int)gem, gew));
                feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, (int)gem, gew));
                feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, (int)gem, gew));
                feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, (int)gem, gew));
                feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, (int)gem, gew));
                feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, (int)gem, gew));
                feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, (int)gem, gew));
                feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, (int)gem, gew));
                feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, (int)gem, gew));
                feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, (int)gem, gew));
                feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, (int)gem, gew));
                feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, (int)gem, gew));
                feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, (int)gem, gew));
                feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, (int)gem, gew));
                feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, (int)gem, gew));
                feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, (int)gem, gew));
                feature.put("foto_a", this.getCountPointObjects(AllPunktObjects.Table.foto, (int)gem, gew));
                feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, (int)gem, gew));
                feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, (int)gem, gew));
                feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, (int)gem, gew));
                feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, (int)gem, gew));
                feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, (int)gem, gew));
                feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, (int)gem, gew));
                feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, (int)gem, gew));
                feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, (int)gem, gew));
                feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, (int)gem, gew));
                feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, (int)gem, gew));
                feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, (int)gem, gew));
                feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, (int)gem, gew));
                feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, (int)gem, gew));
                feature.put("dok_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_doku, (int)gem, gew));
                feature.put("dok_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_doku, (int)gem, gew));
                feature.put("proj_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_proj, (int)gem, gew));
                feature.put("proj_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_proj, (int)gem, gew));
                features.add(feature);
                featureListKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserAbschnitt() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Integer gem : this.gemDataMap.keySet()) {
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> featureListGewKum = new ArrayList<Map<String, Object>>();
            String code = null;
            if (this.gemPartMap.get(gem).isEmpty()) continue;
            this.sheetNames.add(this.gemDataMap.get(gem).getGmdName());
            for (GmdPartObj gew : this.gemPartMap.get(gem)) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("gmdName", this.gemDataMap.get(gem).getGmdName());
                hashMap.put("gmdNummer", gem);
                hashMap.put("anzahlGew", this.getCountGewAll(gem));
                hashMap.put("anzahlAbschn", this.gemPartMap.get(gem).size());
                hashMap.put("group", gem);
                hashMap.put("code", this.getBaCd(gem, gew.getId()));
                hashMap.put("gewName", gew.getGewName());
                hashMap.put("von", this.convertStation(gew.getFrom()));
                hashMap.put("bis", this.convertStation(gew.getTill()));
                hashMap.put("laenge", gew.getLength());
                hashMap.put("gewLaenge", gew.getLength());
                hashMap.put("offene_a", this.getCountOffeneAbschn(gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("offene_l", this.getLengthOffeneAbschn(gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("see_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.sg_see, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("see_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.sg_see, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("geschl_a", this.getCountGeschlAbschn(gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("geschl_l", this.getLengthGeschlAbschn(gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("wschutz_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("wschutz_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("ueber_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("ueber_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("prof_a", this.percentage(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()), gew.getLength() - this.getLengthGeschlAbschn(gem, gew.getId(), gew.getFrom(), gew.getTill())));
                hashMap.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("foto_a", this.getCountPointObjects(AllPunktObjects.Table.foto, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("dok_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_doku, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("dok_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_doku, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("proj_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_proj, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                hashMap.put("proj_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_proj, (int)gem, gew.getId(), gew.getFrom(), gew.getTill()));
                String newCode = this.getBaCd(gem, gew.getId());
                if (code != null && !code.equals(newCode)) {
                    Map<String, Object> kumObj = this.createKumFeature(featureListGewKum, true, false);
                    kumObj.remove("von");
                    kumObj.remove("bis");
                    kumObj.remove("gewLaenge");
                    features.add(kumObj);
                    featureListGewKum.clear();
                }
                code = newCode;
                features.add(hashMap);
                featureListKum.add(hashMap);
                featureListGewKum.add(hashMap);
            }
            Map<String, Object> kumObj = this.createKumFeature(featureListGewKum, true, false);
            kumObj.remove("von");
            kumObj.remove("bis");
            kumObj.remove("gewLaenge");
            features.add(kumObj);
            featureListGewKum.clear();
            kumObj = this.createKumFeature(featureListKum, false, false);
            kumObj.remove("code");
            kumObj.remove("gewName");
            kumObj.remove("von");
            kumObj.remove("bis");
            kumObj.remove("gewLaenge");
            features.add(kumObj);
            for (Map map : features) {
                if (map.get("summe") != null) continue;
                map.remove("code");
                map.remove("gewName");
                map.remove("gewLaenge");
            }
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserGu() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Integer gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("GU " + this.gemDataMap.get(gem).getGmdName());
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (String guName : this.getGu(gem)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                feature.put("gmdName", this.gemDataMap.get(gem).getGmdName());
                feature.put("gmdNummer", gem);
                feature.put("anzahlGu", this.getCountGu(gem));
                feature.put("group", gem);
                feature.put("gu", this.getGuId(gem, guName));
                feature.put("guName", guName);
                feature.put("gewAnzahl", this.getCountGew(gem, guName));
                feature.put("gewLaenge", this.getLengthGew((int)gem, guName));
                feature.put("offene_a", this.getCountOffeneAbschn((int)gem, guName));
                feature.put("offene_l", this.getLengthOffeneAbschn((int)gem, guName));
                feature.put("see_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.sg_see, (int)gem, guName));
                feature.put("see_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.sg_see, (int)gem, guName));
                feature.put("geschl_a", this.getCountGeschlAbschn((int)gem, guName));
                feature.put("geschl_l", this.getLengthGeschlAbschn((int)gem, guName));
                feature.put("wschutz_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, (int)gem, guName));
                feature.put("wschutz_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, (int)gem, guName));
                feature.put("ueber_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, (int)gem, guName));
                feature.put("ueber_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, (int)gem, guName));
                feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, (int)gem, guName));
                feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, (int)gem, guName));
                feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, (int)gem, guName));
                feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, (int)gem, guName));
                feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, (int)gem, guName));
                feature.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, (int)gem, guName));
                feature.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, (int)gem, guName));
                feature.put("prof_a", this.percentage(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, (int)gem, guName), this.getLengthGew((int)gem, guName) - this.getLengthGeschlAbschn((int)gem, guName)));
                feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, (int)gem, guName));
                feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, (int)gem, guName));
                feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, (int)gem, guName));
                feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, (int)gem, guName));
                feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, (int)gem, guName));
                feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, (int)gem, guName));
                feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, (int)gem, guName));
                feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, (int)gem, guName));
                feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, (int)gem, guName));
                feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, (int)gem, guName));
                feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, (int)gem, guName));
                feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, (int)gem, guName));
                feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, (int)gem, guName));
                feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, (int)gem, guName));
                feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, (int)gem, guName));
                feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, (int)gem, guName));
                feature.put("foto_a", this.getCountPointObjects(AllPunktObjects.Table.foto, (int)gem, guName));
                feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, (int)gem, guName));
                feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, (int)gem, guName));
                feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, (int)gem, guName));
                feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, (int)gem, guName));
                feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, (int)gem, guName));
                feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, (int)gem, guName));
                feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, (int)gem, guName));
                feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, (int)gem, guName));
                feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, (int)gem, guName));
                feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, (int)gem, guName));
                feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, (int)gem, guName));
                feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, (int)gem, guName));
                feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, (int)gem, guName));
                feature.put("dok_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_doku, (int)gem, guName));
                feature.put("dok_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_doku, (int)gem, guName));
                feature.put("proj_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_proj, (int)gem, guName));
                feature.put("proj_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_proj, (int)gem, guName));
                features.add(feature);
                featureListKum.add(feature);
            }
            features.add(this.createKumFeature(featureListKum, false, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserGuWidmung() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (Integer gem : this.gemDataMap.keySet()) {
            this.sheetNames.add("GU " + this.gemDataMap.get(gem).getGmdName());
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (String guName : this.getGu(gem)) {
                ArrayList<Map<String, Object>> featureListGuKum = new ArrayList<Map<String, Object>>();
                for (Integer wdm : this.getWidmung(gem, guName)) {
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    feature.put("gmdName", this.gemDataMap.get(gem).getGmdName());
                    feature.put("gmdNummer", gem);
                    feature.put("anzahlGu", this.getCountGu(gem));
                    feature.put("group", gem);
                    feature.put("gu", this.getGuId(gem, guName));
                    feature.put("guName", guName);
                    feature.put("widmung", String.valueOf(wdm));
                    feature.put("gew_a", this.getCountGew(gem, guName, wdm));
                    feature.put("gew_l", this.getLengthGew(gem, guName, wdm));
                    feature.put("offene_a", this.getCountOffeneAbschn(gem, guName, wdm));
                    feature.put("offene_l", this.getLengthOffeneAbschn(gem, guName, wdm));
                    feature.put("see_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.sg_see, (int)gem, (int)wdm));
                    feature.put("see_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.sg_see, (int)gem, (int)wdm));
                    feature.put("geschl_a", this.getCountGeschlAbschn(gem, guName, wdm));
                    feature.put("geschl_l", this.getLengthGeschlAbschn(gem, guName, wdm));
                    feature.put("wschutz_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, (int)gem, (int)wdm));
                    feature.put("wschutz_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, (int)gem, (int)wdm));
                    feature.put("ueber_a", this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, (int)gem, (int)wdm));
                    feature.put("ueber_l", this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, (int)gem, (int)wdm));
                    feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, (int)gem, (int)wdm));
                    feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, (int)gem, (int)wdm));
                    feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, (int)gem, (int)wdm));
                    feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, (int)gem, (int)wdm));
                    feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, (int)gem, (int)wdm));
                    feature.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, (int)gem, (int)wdm));
                    feature.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, (int)gem, (int)wdm));
                    feature.put("prof_a", this.percentage(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, (int)gem, (int)wdm), this.getLengthGew((int)gem, (int)wdm) - this.getLengthGeschlAbschn((int)gem, (int)wdm)));
                    feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, (int)gem, (int)wdm));
                    feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, (int)gem, (int)wdm));
                    feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, (int)gem, (int)wdm));
                    feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, (int)gem, (int)wdm));
                    feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, (int)gem, (int)wdm));
                    feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, (int)gem, (int)wdm));
                    feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, (int)gem, (int)wdm));
                    feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, (int)gem, (int)wdm));
                    feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, (int)gem, (int)wdm));
                    feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, (int)gem, (int)wdm));
                    feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, (int)gem, (int)wdm));
                    feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, (int)gem, (int)wdm));
                    feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, (int)gem, (int)wdm));
                    feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, (int)gem, (int)wdm));
                    feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, (int)gem, (int)wdm));
                    feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, (int)gem, (int)wdm));
                    feature.put("foto_a", this.getCountPointObjects(AllPunktObjects.Table.foto, (int)gem, (int)wdm));
                    feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, (int)gem, (int)wdm));
                    feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, (int)gem, (int)wdm));
                    feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, (int)gem, (int)wdm));
                    feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, (int)gem, (int)wdm));
                    feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, (int)gem, (int)wdm));
                    feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, (int)gem, (int)wdm));
                    feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, (int)gem, (int)wdm));
                    feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, (int)gem, (int)wdm));
                    feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, (int)gem, (int)wdm));
                    feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, (int)gem, (int)wdm));
                    feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, (int)gem, (int)wdm));
                    feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, (int)gem, (int)wdm));
                    feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, (int)gem, (int)wdm));
                    feature.put("dok_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_doku, (int)gem, (int)wdm));
                    feature.put("dok_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_doku, (int)gem, (int)wdm));
                    feature.put("proj_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_proj, (int)gem, (int)wdm));
                    feature.put("proj_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_proj, (int)gem, (int)wdm));
                    features.add(feature);
                    featureListKum.add(feature);
                    featureListGuKum.add(feature);
                }
                features.add(this.createKumFeature(featureListGuKum, true, false));
            }
            features.add(this.createKumFeature(featureListKum, false, false));
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuTable() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("GU");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        for (String guName : this.getGu()) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            feature.put("anzahlGu", this.getCountGu());
            feature.put("group", 1);
            feature.put("gu", this.getGuId(guName));
            feature.put("guName", guName);
            feature.put("gewAnzahl", this.getCountGew(guName));
            feature.put("gewLaenge", this.getLengthGew(guName));
            double lengthSee = this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.sg_see, guName);
            feature.put("offene_a", this.toNullIfZero((this.getLengthGew(guName) - this.getLengthGeschlAbschn(guName) - lengthSee) * 100.0 / this.getLengthGew(guName)));
            feature.put("offene_l", this.toNullIfZero(this.getLengthGew(guName) - this.getLengthGeschlAbschn(guName) - lengthSee));
            feature.put("see_a", this.toNullIfZero(lengthSee * 100.0 / this.getLengthGew(guName)));
            feature.put("see_l", this.toNullIfZero(lengthSee));
            feature.put("geschl_a", this.toNullIfZero(this.getLengthGeschlAbschn(guName) * 100.0 / this.getLengthGew(guName)));
            feature.put("geschl_l", this.toNullIfZero(this.getLengthGeschlAbschn(guName)));
            feature.put("wschutz_a", this.toNullIfZero(this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, guName)));
            feature.put("wschutz_l", this.toNullIfZero(this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, guName)));
            feature.put("ueber_a", this.toNullIfZero(this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, guName)));
            feature.put("ueber_l", this.toNullIfZero(this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, guName)));
            feature.put("ben_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, guName)));
            feature.put("aus_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, guName)));
            feature.put("pegel_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, guName)));
            feature.put("gb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, guName)));
            feature.put("gb_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, guName)));
            feature.put("sb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, guName)));
            feature.put("sb_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, guName)));
            feature.put("prof_a", this.toNullIfZero(this.percentage(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName), this.getLengthGew(guName) - this.getLengthGeschlAbschn(guName))));
            feature.put("prof_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName)));
            feature.put("sbef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, guName)));
            feature.put("sbef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, guName)));
            feature.put("ubef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, guName)));
            feature.put("ubef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, guName)));
            feature.put("bbef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, guName)));
            feature.put("bbef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, guName)));
            feature.put("rl_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, guName)));
            feature.put("rl_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, guName)));
            feature.put("d_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, guName)));
            feature.put("d_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, guName)));
            feature.put("due_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, guName)));
            feature.put("due_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, guName)));
            feature.put("scha_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, guName)));
            feature.put("wehr_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, guName)));
            feature.put("schw_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, guName)));
            feature.put("foto_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.foto, guName)));
            feature.put("anlp_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, guName)));
            feature.put("anll_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, guName)));
            feature.put("anll_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, guName)));
            feature.put("kr_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, guName)));
            feature.put("ea_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, guName)));
            feature.put("deich_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.deich_ft, guName)));
            feature.put("deich_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.deich_ft, guName)));
            feature.put("ughz_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, guName)));
            feature.put("ughz_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, guName)));
            feature.put("leis_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, guName)));
            feature.put("leis_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, guName)));
            feature.put("tech_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, guName)));
            feature.put("tech_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, guName)));
            feature.put("dok_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_doku, guName)));
            feature.put("dok_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_doku, guName)));
            feature.put("proj_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_proj, guName)));
            feature.put("proj_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_proj, guName)));
            features.add(feature);
            featureListKum.add(feature);
        }
        features.add(this.createKumFeature(featureListKum, false, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuWidmung() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("GU");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        for (String guName : this.getGu()) {
            ArrayList<Map<String, Object>> featureListGuKum = new ArrayList<Map<String, Object>>();
            for (Integer wdm : this.getWidmung(guName)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                feature.put("anzahlGu", this.getCountGu());
                feature.put("gu", this.getGuId(guName));
                feature.put("guName", guName);
                feature.put("widmung", String.valueOf(wdm));
                feature.put("gew_a", this.getCountGew(guName, wdm));
                feature.put("gew_l", this.getLengthGew(guName, (int)wdm));
                double lengthSee = this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.sg_see, guName, (int)wdm);
                feature.put("offene_a", this.toNullIfZero((this.getLengthGew(guName, (int)wdm) - this.getLengthGeschlAbschn(guName, (int)wdm) - lengthSee) * 100.0 / this.getLengthGew(guName, (int)wdm)));
                feature.put("offene_l", this.toNullIfZero(this.getLengthGew(guName, (int)wdm) - this.getLengthGeschlAbschn(guName, (int)wdm) - lengthSee));
                feature.put("see_a", this.toNullIfZero(lengthSee * 100.0 / this.getLengthGew(guName, (int)wdm)));
                feature.put("see_l", this.toNullIfZero(lengthSee));
                feature.put("geschl_a", this.toNullIfZero(this.getLengthGeschlAbschn(guName, (int)wdm) * 100.0 / this.getLengthGew(guName, (int)wdm)));
                feature.put("geschl_l", this.toNullIfZero(this.getLengthGeschlAbschn(guName, (int)wdm)));
                feature.put("wschutz_a", this.toNullIfZero(this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, guName, (int)wdm)));
                feature.put("wschutz_l", this.toNullIfZero(this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_wsg, guName, (int)wdm)));
                feature.put("ueber_a", this.toNullIfZero(this.getCountLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, guName, (int)wdm)));
                feature.put("ueber_l", this.toNullIfZero(this.getLengthLineObjects(GemeindenData.LineFromPolygonTable.wr_sg_uesg, guName, (int)wdm)));
                feature.put("ben_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, guName, (int)wdm)));
                feature.put("aus_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, guName, (int)wdm)));
                feature.put("pegel_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, guName, (int)wdm)));
                feature.put("gb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, guName, (int)wdm)));
                feature.put("gb_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, guName, (int)wdm)));
                feature.put("sb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, guName, (int)wdm)));
                feature.put("sb_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, guName, (int)wdm)));
                feature.put("prof_a", this.toNullIfZero(this.percentage(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName, (int)wdm), this.getLengthGew(guName, (int)wdm) - this.getLengthGeschlAbschn(guName, (int)wdm))));
                feature.put("prof_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName, (int)wdm)));
                feature.put("sbef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, guName, (int)wdm)));
                feature.put("sbef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, guName, (int)wdm)));
                feature.put("ubef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, guName, (int)wdm)));
                feature.put("ubef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, guName, (int)wdm)));
                feature.put("bbef_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, guName, (int)wdm)));
                feature.put("bbef_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, guName, (int)wdm)));
                feature.put("rl_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, guName, (int)wdm)));
                feature.put("rl_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, guName, (int)wdm)));
                feature.put("d_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, guName, (int)wdm)));
                feature.put("d_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, guName, (int)wdm)));
                feature.put("due_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, guName, (int)wdm)));
                feature.put("due_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, guName, (int)wdm)));
                feature.put("scha_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, guName, (int)wdm)));
                feature.put("wehr_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, guName, (int)wdm)));
                feature.put("schw_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, guName, (int)wdm)));
                feature.put("foto_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.foto, guName, (int)wdm)));
                feature.put("anlp_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, guName, (int)wdm)));
                feature.put("anll_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, guName, (int)wdm)));
                feature.put("anll_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, guName, (int)wdm)));
                feature.put("kr_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, guName, (int)wdm)));
                feature.put("ea_a", this.toNullIfZero(this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, guName, (int)wdm)));
                feature.put("deich_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.deich_ft, guName, (int)wdm)));
                feature.put("deich_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.deich_ft, guName, (int)wdm)));
                feature.put("ughz_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, guName, (int)wdm)));
                feature.put("ughz_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, guName, (int)wdm)));
                feature.put("leis_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, guName, (int)wdm)));
                feature.put("leis_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, guName, (int)wdm)));
                feature.put("tech_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, guName, (int)wdm)));
                feature.put("tech_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, guName, (int)wdm)));
                feature.put("dok_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_doku, guName, (int)wdm)));
                feature.put("dok_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_doku, guName, (int)wdm)));
                feature.put("proj_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_proj, guName, (int)wdm)));
                feature.put("proj_l", this.toNullIfZero(this.getLengthLineObjects(AllLineObjects.Table.fg_ba_proj, guName, (int)wdm)));
                features.add(feature);
                featureListKum.add(feature);
                featureListGuKum.add(feature);
            }
            features.add(this.createKumFeature(featureListGuKum, true, false));
        }
        features.add(this.createKumFeature(featureListKum, false, false));
        return new FeatureDataSource(features);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal, boolean isGeschDouble) {
        HashMap<String, Object> kumFeature = new HashMap<String, Object>();
        kumFeature.put("summe", Boolean.TRUE);
        kumFeature.put("zwischenSumme", subtotal);
        if (featureListKum == null || featureListKum.isEmpty()) {
            return kumFeature;
        }
        Map<String, Object> firstElement = featureListKum.get(0);
        for (String key : firstElement.keySet()) {
            Object value = firstElement.get(key);
            Object firstNonNullvalue = firstElement.get(key);
            if (firstNonNullvalue == null) {
                for (Map<String, Object> f : featureListKum) {
                    if (f.get(key) == null) continue;
                    firstNonNullvalue = f.get(key);
                    break;
                }
            }
            if (value == null && firstNonNullvalue == null) continue;
            if (key != null && key.equalsIgnoreCase("group")) {
                kumFeature.put(key, value);
                continue;
            }
            if (Arrays.binarySearch(exceptionalFields, key) < 0 && firstNonNullvalue instanceof Integer) {
                int sum = 0;
                for (Map<String, Object> f : featureListKum) {
                    if (!(f.get(key) instanceof Number)) continue;
                    sum += ((Integer)f.get(key)).intValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (Arrays.binarySearch(exceptionalFields, key) < 0 && firstNonNullvalue instanceof Double) {
                double sum = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    if (!(f.get(key) instanceof Number)) continue;
                    sum += ((Double)f.get(key)).doubleValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (Arrays.binarySearch(exceptionalFields, key) >= 0) continue;
            kumFeature.put(key, value);
        }
        if (isGeschDouble) {
            Double offene = (Double)kumFeature.get("offene_l");
            Double geschl = (Double)kumFeature.get("geschl_l");
            Double see = (Double)kumFeature.get("see_l");
            Double prof = (Double)kumFeature.get("prof_l");
            if (offene == null) {
                offene = 0.0;
            }
            if (see == null) {
                see = 0.0;
            }
            if (geschl == null) {
                geschl = 0.0;
            }
            if (prof == null) {
                prof = 0.0;
            }
            kumFeature.put("offene_a", this.toNullIfZero(offene * 100.0 / (offene + geschl + see)));
            kumFeature.put("see_a", this.toNullIfZero(see * 100.0 / (offene + geschl + see)));
            kumFeature.put("geschl_a", this.toNullIfZero(geschl * 100.0 / (offene + geschl + see)));
            if (offene == 0.0) {
                kumFeature.put("prof_a", 0.0);
            } else {
                kumFeature.put("prof_a", this.toNullIfZero(prof * 100.0 / (offene + see)));
            }
        }
        kumFeature.put("wschutz_a", null);
        kumFeature.put("ueber_a", null);
        kumFeature.put("sb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, null)));
        kumFeature.put("gb_a", this.toNullIfZero(this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, null)));
        kumFeature.put("sbef_a", null);
        kumFeature.put("ubef_a", null);
        kumFeature.put("bbef_a", null);
        kumFeature.put("rl_a", null);
        kumFeature.put("d_a", null);
        kumFeature.put("due_a", null);
        kumFeature.put("anll_a", null);
        kumFeature.put("deich_a", null);
        kumFeature.put("ughz_a", null);
        kumFeature.put("leis_a", null);
        kumFeature.put("tech_a", null);
        kumFeature.put("dok_a", null);
        kumFeature.put("proj_a", null);
        return kumFeature;
    }

    private Object toNullIfZero(Object o) {
        if (o instanceof Number && ((Number)o).doubleValue() == 0.0) {
            return null;
        }
        return o;
    }

    private Collection<Integer> getGew(int gemNr) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GmdPartObj tmp : gemList) {
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    private List<GmdPartObj> getGew(int gemNr, String owner) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        ArrayList<GmdPartObj> list = new ArrayList<GmdPartObj>();
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            list.add(tmp);
        }
        return list;
    }

    private Collection<String> getGu(int gemNr) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<String> ts = new TreeSet<String>();
        for (GmdPartObj tmp : gemList) {
            ts.add(tmp.getOwner());
        }
        return ts.descendingSet();
    }

    private Collection<String> getGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (Integer gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                ts.add(tmp.getOwner());
            }
        }
        return ts.descendingSet();
    }

    private String getGuId(int gemNr, String owner) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            return tmp.getGu();
        }
        return null;
    }

    private String getGuId(String owner) {
        for (int gemNr : this.gemPartMap.keySet()) {
            String tmp = this.getGuId(gemNr, owner);
            if (tmp == null) continue;
            return tmp;
        }
        return null;
    }

    private Integer getWdm(int gemNr, int gew) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        for (GmdPartObj tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getWidmung();
        }
        return null;
    }

    private Collection<Integer> getWidmung(int gemNr, String guName) {
        List<GmdPartObj> gmdList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (GmdPartObj gmdPart : gmdList) {
            if (!gmdPart.getOwner().equals(guName)) continue;
            ts.add(gmdPart.getWidmung());
        }
        return ts.descendingSet();
    }

    private Collection<Integer> getWidmung(String guName) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (Integer gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gmdList = this.gemPartMap.get(gemNr);
            for (GmdPartObj gmdPart : gmdList) {
                if (!gmdPart.getOwner().equals(guName)) continue;
                ts.add(gmdPart.getWidmung());
            }
        }
        return ts.descendingSet();
    }

    private int getCountGu(int gemNr) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<String> ts = new TreeSet<String>();
        for (GmdPartObj tmp : gemList) {
            ts.add(tmp.getOwner());
        }
        return ts.size();
    }

    private int getCountGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (Integer gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                ts.add(tmp.getOwner());
            }
        }
        return ts.size();
    }

    private String getBaCd(int gemNr, int gew) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        for (GmdPartObj tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getBaCd();
        }
        return null;
    }

    private String getGewName(int gemNr, int gew) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        for (GmdPartObj tmp : gemList) {
            if (tmp.getId() != gew) continue;
            return tmp.getGewName();
        }
        return null;
    }

    private int getCountGewAll(int gemNr) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<String> ts = new TreeSet<String>();
        for (GmdPartObj tmp : gemList) {
            ts.add(tmp.getBaCd());
        }
        return ts.size();
    }

    private double getLengthGewAll(int gemNr) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGewAll() {
        double length = 0.0;
        for (int gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                length += tmp.getLength();
            }
        }
        return length;
    }

    private double getLengthGew(int gemNr, int gewId) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (tmp.getId() != gewId) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(int gemNr, String gu) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String gu, int wdm) {
        double length = 0.0;
        for (Integer gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountGew(int gemNr, String gu) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu)) continue;
            ++count;
        }
        return count;
    }

    private int getCountGew(String gu, int wdm) {
        int count = 0;
        for (Integer gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthGew(int gemNr, String gu, int wdm) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGew(int gemNr, String gu, int wdm) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(gu) || tmp.getWidmung() != wdm) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGew(String gu) {
        double length = 0.0;
        for (int gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(gu)) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountGew(String gu) {
        int count = 0;
        for (int gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(gu)) continue;
                ++count;
            }
        }
        return count;
    }

    private int getCountOffeneAbschn(int gemNr) {
        return this.getCountOffeneAbschn(gemNr, -1);
    }

    private double getLengthOffeneAbschn(int gemNr) {
        return this.getLengthOffeneAbschn(gemNr, -1);
    }

    private double getLengthSeeAbschn(int gemNr) {
        return this.getLengthSeeAbschn(gemNr, -1);
    }

    private int getCountSeeAbschn(int gemNr) {
        return this.getCountSeeAbschn(gemNr, -1);
    }

    private int getCountGeschlAbschn(int gemNr) {
        return this.getCountGeschlAbschn(gemNr, -1);
    }

    private double getLengthGeschlAbschn(int gemNr) {
        return this.getLengthGeschlAbschn(gemNr, -1);
    }

    private int getCountOffeneAbschn(int gemNr, int gewId) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            ++count;
        }
        return count;
    }

    private int getCountSeeAbschn(int gemNr, int gewId) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("s")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(int gemNr, int gewId) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthSeeAbschn(int gemNr, int gewId) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("s")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(int gemNr, int gewId) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(int gemNr, int gewId) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschn(int gemNr, int gewId, double from, double till) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(int gemNr, int gewId, double from, double till) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (tmp.getId() != gewId || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    private int getCountGeschlAbschn(int gemNr, int gewId, double from, double till) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(int gemNr, int gewId, double from, double till) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    private int getCountOffeneAbschn(int gemNr, String owner) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(int gemNr, String owner) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(int gemNr, String owner) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(int gemNr, String owner) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschn(String owner, int wdm) {
        int count = 0;
        for (Integer gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthOffeneAbschn(String owner, int wdm) {
        double length = 0.0;
        for (Integer gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountGeschlAbschn(String owner, int wdm) {
        int count = 0;
        for (Integer gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthGeschlAbschn(String owner, int wdm) {
        double length = 0.0;
        for (Integer gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountOffeneAbschn(int gemNr, String owner, int wdm) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(int gemNr, String owner, int wdm) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p") && !tmp.getArt().equals("o") || tmp.getWidmung() != wdm) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(int gemNr, String owner, int wdm) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        int count = 0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(int gemNr, String owner, int wdm) {
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschn(String owner) {
        int count = 0;
        for (int gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthOffeneAbschn(String owner) {
        double length = 0.0;
        for (int gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("p") && !tmp.getArt().equals("o")) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountGeschlAbschn(String owner) {
        int count = 0;
        for (int gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("g")) continue;
                ++count;
            }
        }
        return count;
    }

    private double getLengthGeschlAbschn(String owner) {
        double length = 0.0;
        for (int gemNr : this.gemPartMap.keySet()) {
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || !tmp.getArt().equals("g")) continue;
                length += tmp.getLength();
            }
        }
        return length;
    }

    private int getCountLineObjectsAll(AllLineObjects.Table table, int gemNr) {
        return this.getCountLineObjects(table, gemNr, -1);
    }

    private double getLengthLineObjectsAll(AllLineObjects.Table table, int gemNr) {
        return this.getLengthLineObjects(table, gemNr, -1);
    }

    private int getCountLineObjectsAll(GemeindenData.LineFromPolygonTable table, int gemNr) {
        return this.getCountLineObjects(table, gemNr, -1);
    }

    private double getLengthLineObjectsAll(GemeindenData.LineFromPolygonTable table, int gemNr) {
        return this.getLengthLineObjects(table, gemNr, -1);
    }

    private int getCountPointObjectsAll(AllPunktObjects.Table table, int gemNr) {
        return this.getCountPointObjects(table, gemNr, -1);
    }

    private int getCountLineObjects(AllLineObjects.Table table, int gemNr, int gewId) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> set = new TreeSet<Integer>();
        boolean count = false;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            set.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return set.size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, int gemNr, int gewId) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            length += gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(GemeindenData.LineFromPolygonTable table, int gemNr, int gewId) {
        if (gewId < 0) {
            GemeindenData gemData = this.gemDataMap.get(gemNr);
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            TreeSet<Integer> set = new TreeSet<Integer>();
            for (GmdPartObj tmp : gemList) {
                set.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
            }
            return set.size();
        }
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> set = new TreeSet<Integer>();
        boolean count = false;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            set.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return set.size();
    }

    private double getLengthLineObjects(GemeindenData.LineFromPolygonTable table, int gemNr, int gewId) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            length += gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, int gemNr, int gewId) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> ids = new TreeSet<Integer>();
        boolean count = false;
        for (GmdPartObj tmp : gemList) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            ids.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ids.size();
    }

    private String print(TreeSet<Integer> ids) {
        StringBuilder sb = new StringBuilder();
        Iterator<Integer> it = ids.descendingIterator();
        while (it.hasNext()) {
            sb.append(it.next() + "\n");
        }
        return sb.toString();
    }

    private int getCountLineObjects(AllLineObjects.Table table, int gemNr, int gewId, double from, double till) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        return gemData.getIds(table, gewId, from, till).size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, int gemNr, int gewId, double from, double till) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        return gemData.getLength(table, gewId, from, till);
    }

    private int getCountLineObjects(GemeindenData.LineFromPolygonTable table, int gemNr, int gewId, double from, double till) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        return gemData.getIds(table, gewId, from, till).size();
    }

    private double getLengthLineObjects(GemeindenData.LineFromPolygonTable table, int gemNr, int gewId, double from, double till) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        return gemData.getLength(table, gewId, from, till);
    }

    private int getCountPointObjects(AllPunktObjects.Table table, int gemNr, int gewId, double from, double till) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        return gemData.getIds(table, gewId, from, till).size();
    }

    private int getCountLineObjects(AllLineObjects.Table table, int gemNr, String owner) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            set.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return set.size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, int gemNr, String owner) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            length += gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(GemeindenData.LineFromPolygonTable table, int gemNr, String owner) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            set.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return set.size();
    }

    private double getLengthLineObjects(GemeindenData.LineFromPolygonTable table, int gemNr, String owner) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            length += gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, int gemNr, String owner) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> ids = new TreeSet<Integer>();
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner)) continue;
            ids.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ids.size();
    }

    private int getCountLineObjects(AllLineObjects.Table table, int gemNr, String owner, int wdm) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            set.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return set.size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, int gemNr, String owner, int wdm) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            length += gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(GemeindenData.LineFromPolygonTable table, int gemNr, String owner, int wdm) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            set.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return set.size();
    }

    private double getLengthLineObjects(GemeindenData.LineFromPolygonTable table, int gemNr, String owner, int wdm) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        double length = 0.0;
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            length += gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, int gemNr, String owner, int wdm) {
        GemeindenData gemData = this.gemDataMap.get(gemNr);
        List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
        TreeSet<Integer> ids = new TreeSet<Integer>();
        for (GmdPartObj tmp : gemList) {
            if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
            ids.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ids.size();
    }

    private int getCountLineObjects(AllLineObjects.Table table, String owner, int wdm) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (Integer gemNr : this.gemDataMap.keySet()) {
            GemeindenData gemData = this.gemDataMap.get(gemNr);
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
                set.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
            }
        }
        return set.size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, String owner, int wdm) {
        double length = 0.0;
        for (Integer gemNr : this.gemDataMap.keySet()) {
            GemeindenData gemData = this.gemDataMap.get(gemNr);
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
                length += gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return length;
    }

    private int getCountLineObjects(GemeindenData.LineFromPolygonTable table, String owner, int wdm) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (Integer gemNr : this.gemDataMap.keySet()) {
            GemeindenData gemData = this.gemDataMap.get(gemNr);
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
                set.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
            }
        }
        return set.size();
    }

    private double getLengthLineObjects(GemeindenData.LineFromPolygonTable table, String owner, int wdm) {
        double length = 0.0;
        for (Integer gemNr : this.gemDataMap.keySet()) {
            GemeindenData gemData = this.gemDataMap.get(gemNr);
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
                length += gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, String owner, int wdm) {
        TreeSet<Integer> ids = new TreeSet<Integer>();
        for (Integer gemNr : this.gemDataMap.keySet()) {
            GemeindenData gemData = this.gemDataMap.get(gemNr);
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner) || tmp.getWidmung() != wdm) continue;
                ids.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
            }
        }
        return ids.size();
    }

    private int getCountLineObjects(AllLineObjects.Table table, String owner) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int gemNr : this.gemDataMap.keySet()) {
            GemeindenData gemData = this.gemDataMap.get(gemNr);
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (owner != null && !tmp.getOwner().equals(owner)) continue;
                set.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
            }
        }
        return set.size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, String owner) {
        double length = 0.0;
        for (int gemNr : this.gemDataMap.keySet()) {
            GemeindenData gemData = this.gemDataMap.get(gemNr);
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner)) continue;
                length += gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return length;
    }

    private int getCountLineObjects(GemeindenData.LineFromPolygonTable table, String owner) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int gemNr : this.gemDataMap.keySet()) {
            GemeindenData gemData = this.gemDataMap.get(gemNr);
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner)) continue;
                set.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
            }
        }
        return set.size();
    }

    private double getLengthLineObjects(GemeindenData.LineFromPolygonTable table, String owner) {
        double length = 0.0;
        for (int gemNr : this.gemDataMap.keySet()) {
            GemeindenData gemData = this.gemDataMap.get(gemNr);
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner)) continue;
                length += gemData.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
            }
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, String owner) {
        TreeSet<Integer> ids = new TreeSet<Integer>();
        for (int gemNr : this.gemDataMap.keySet()) {
            GemeindenData gemData = this.gemDataMap.get(gemNr);
            List<GmdPartObj> gemList = this.gemPartMap.get(gemNr);
            for (GmdPartObj tmp : gemList) {
                if (!tmp.getOwner().equals(owner)) continue;
                ids.addAll(gemData.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
            }
        }
        return ids.size();
    }

    private String convertStation(Double station) {
        int km = (int)(station / 1000.0);
        int m = (int)(station % 1000.0);
        String mString = String.valueOf(m);
        while (mString.length() < 3) {
            mString = "0" + mString;
        }
        return km + "+" + mString;
    }

    static {
        Arrays.sort(exceptionalFields);
    }
}

