/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGewBySb;
import de.cismet.cids.custom.watergis.server.search.AllLineObjects;
import de.cismet.cids.custom.watergis.server.search.AllPunktObjects;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.watergis.gui.dialog.KatasterSbReportDialog;
import de.cismet.watergis.reports.types.FeatureDataSource;
import de.cismet.watergis.reports.types.GewaesserData;
import de.cismet.watergis.reports.types.SbObj;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import org.apache.log4j.Logger;

public class KatasterSbReport {
    private static final Logger LOG = Logger.getLogger(KatasterSbReport.class);
    private static final String[] exceptionalNumberFields = new String[]{"gmdNummer", "group", "gmdName", "code", "anzahlGu", "gu"};
    GewaesserData gd;
    private List<SbObj> parts;
    private List<String> sheetNames = new ArrayList<String>();

    public File createGewaesserReport(int[] gew) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, FeatureDataSource> dataSources = new HashMap<String, FeatureDataSource>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY");
        parameters.put("datum", df.format(new Date()));
        parameters.put("gemeinden", 0);
        parameters.put("wasserschutz", KatasterSbReportDialog.getInstance().isWsg());
        parameters.put("ueber", KatasterSbReportDialog.getInstance().isSchutzgebiete());
        parameters.put("ben", KatasterSbReportDialog.getInstance().isBen());
        parameters.put("aus", KatasterSbReportDialog.getInstance().isAus());
        parameters.put("pegel", KatasterSbReportDialog.getInstance().isPegel());
        parameters.put("gb", KatasterSbReportDialog.getInstance().isGb());
        parameters.put("sb", KatasterSbReportDialog.getInstance().isSb());
        parameters.put("gmd", KatasterSbReportDialog.getInstance().isGmd());
        parameters.put("prof", KatasterSbReportDialog.getInstance().isProf());
        parameters.put("sbef", KatasterSbReportDialog.getInstance().isSbef());
        parameters.put("ubef", KatasterSbReportDialog.getInstance().isUbef());
        parameters.put("bbef", KatasterSbReportDialog.getInstance().isBbef());
        parameters.put("rl", KatasterSbReportDialog.getInstance().isRl());
        parameters.put("d", KatasterSbReportDialog.getInstance().isD());
        parameters.put("due", KatasterSbReportDialog.getInstance().isDue());
        parameters.put("scha", KatasterSbReportDialog.getInstance().isScha());
        parameters.put("wehr", KatasterSbReportDialog.getInstance().isWehr());
        parameters.put("schw", KatasterSbReportDialog.getInstance().isSchw());
        parameters.put("foto", KatasterSbReportDialog.getInstance().isFoto());
        parameters.put("anlp", KatasterSbReportDialog.getInstance().isAnlp());
        parameters.put("anll", KatasterSbReportDialog.getInstance().isAnll());
        parameters.put("kr", KatasterSbReportDialog.getInstance().isKr());
        parameters.put("ea", KatasterSbReportDialog.getInstance().isEa());
        parameters.put("deich", KatasterSbReportDialog.getInstance().isDeich());
        parameters.put("ughz", KatasterSbReportDialog.getInstance().isUghz());
        parameters.put("leis", KatasterSbReportDialog.getInstance().isLeis());
        parameters.put("tech", KatasterSbReportDialog.getInstance().isTech());
        parameters.put("dok", KatasterSbReportDialog.getInstance().isDok());
        parameters.put("proj", KatasterSbReportDialog.getInstance().isProj());
        parameters.put("perGew", KatasterSbReportDialog.getInstance().isPerGew());
        parameters.put("perAbschn", false);
        parameters.put("sumGu", false);
        parameters.put("wdm", false);
        parameters.put("dataSources", dataSources);
        FeatureDataSource dummyDataSource = new FeatureDataSource(new ArrayList<Map<String, Object>>());
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)KatasterSbReport.class.getResourceAsStream("/de/cismet/watergis/reports/sb_gewaesser.jasper"));
        this.init(gew);
        dataSources.put("schaubezirke", this.getGewaesser());
        if (KatasterSbReportDialog.getInstance().isPerGew()) {
            dataSources.put("gewaesser", this.getGewaesserAbschnitt());
        }
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dummyDataSource);
        File file = new File(KatasterSbReportDialog.getInstance().getPath() + "/Kataster_Schaubezirke.xlsx");
        FileOutputStream fout = new FileOutputStream(file);
        BufferedOutputStream out = new BufferedOutputStream(fout);
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleOutputStreamExporterOutput exportOut = new SimpleOutputStreamExporterOutput((OutputStream)out);
        exporter.setExporterOutput((ExporterOutput)exportOut);
        SimpleXlsxReportConfiguration config = new SimpleXlsxReportConfiguration();
        config.setOnePagePerSheet(Boolean.TRUE);
        config.setSheetNames(this.sheetNames.toArray(new String[this.sheetNames.size()]));
        config.setShowGridLines(Boolean.valueOf(true));
        config.setColumnWidthRatio(Float.valueOf(1.5f));
        config.setRemoveEmptySpaceBetweenColumns(Boolean.valueOf(true));
        config.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        config.setCellHidden(Boolean.valueOf(true));
        config.setDetectCellType(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)config);
        exporter.exportReport();
        exportOut.close();
        out.close();
        return file;
    }

    public static void main(String[] args) {
        KatasterSbReport report = new KatasterSbReport();
        try {
            report.createGewaesserReport(new int[]{2});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(int[] routeIds) throws Exception {
        this.parts = this.getAllRoutes(routeIds);
        int[] routes = routeIds;
        if (routes.length == 0) {
            routes = null;
        }
        this.gd = new GewaesserData(routes);
    }

    private List<SbObj> getAllRoutes(int[] routeIds) throws Exception {
        AllGewBySb search = new AllGewBySb(routeIds, this.getAllowedWdms());
        User user = SessionManager.getSession().getUser();
        ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
        ArrayList<SbObj> objList = new ArrayList<SbObj>();
        if (attributes != null && !attributes.isEmpty()) {
            for (ArrayList f : attributes) {
                objList.add(new SbObj((Integer)f.get(0), (String)f.get(1), (String)f.get(7), (String)f.get(8), (String)f.get(9), (Integer)f.get(10), (String)f.get(2), (Double)f.get(3), (Double)f.get(4), (String)f.get(5), (String)f.get(6), (Double)f.get(11), (String)f.get(12)));
            }
        }
        return objList;
    }

    private int[] getAllowedWdms() {
        ArrayList<Integer> wdmList = new ArrayList<Integer>();
        if (KatasterSbReportDialog.getInstance().is1501()) {
            wdmList.add(1501);
        }
        if (KatasterSbReportDialog.getInstance().is1502()) {
            wdmList.add(1502);
        }
        if (KatasterSbReportDialog.getInstance().is1503()) {
            wdmList.add(1503);
        }
        if (KatasterSbReportDialog.getInstance().is1504()) {
            wdmList.add(1504);
        }
        if (KatasterSbReportDialog.getInstance().is1505()) {
            wdmList.add(1505);
        }
        int[] wdms = new int[wdmList.size()];
        for (int i = 0; i < wdmList.size(); ++i) {
            wdms[i] = (Integer)wdmList.get(i);
        }
        return wdms;
    }

    private FeatureDataSource getGewaesser() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("Schaubezirke");
        for (String string : this.getGu()) {
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            for (Integer wdm : this.getWidmung(string)) {
                ArrayList<Map<String, Object>> featureListKumWdm = new ArrayList<Map<String, Object>>();
                for (String sb : this.getSb(string, wdm)) {
                    HashMap<String, Object> feature = new HashMap<String, Object>();
                    feature.put("anzahlSb", this.getSb(string, wdm).size());
                    feature.put("gu", this.getGuId(string));
                    feature.put("guName", string);
                    feature.put("group", string);
                    feature.put("widmung", wdm);
                    feature.put("sb", sb);
                    feature.put("sbName", this.getSbName(sb));
                    feature.put("gewAnz", this.getCountGew(string, wdm, sb));
                    feature.put("gewLaenge", this.getLengthGew(string, wdm, sb));
                    feature.put("gew_a", this.getCountGew(string, wdm, sb));
                    feature.put("gewLaenge", this.getLengthGew(string, wdm, sb));
                    feature.put("offene_a", this.getCountOffeneAbschn(string, wdm, sb));
                    feature.put("offene_l", this.getLengthOffeneAbschn(string, wdm, sb));
                    feature.put("see_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.sg_see, string, (int)wdm, sb));
                    feature.put("see_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.sg_see, string, (int)wdm, sb));
                    feature.put("geschl_a", this.getCountGeschlAbschn(string, wdm, sb));
                    feature.put("geschl_l", this.getLengthGeschlAbschn(string, wdm, sb));
                    feature.put("wschutz_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, string, (int)wdm, sb));
                    feature.put("wschutz_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, string, (int)wdm, sb));
                    feature.put("ueber_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, string, (int)wdm, sb));
                    feature.put("ueber_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, string, (int)wdm, sb));
                    feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, string, wdm, sb));
                    feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, string, wdm, sb));
                    feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, string, wdm, sb));
                    feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, string, (int)wdm, sb));
                    feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, string, (int)wdm, sb));
                    feature.put("gmd_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gmd, string, (int)wdm, sb));
                    feature.put("gmd_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gmd, string, (int)wdm, sb));
                    feature.put("prof_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_prof, string, (int)wdm, sb));
                    feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, string, (int)wdm, sb));
                    feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, string, (int)wdm, sb));
                    feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, string, (int)wdm, sb));
                    feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, string, (int)wdm, sb));
                    feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, string, (int)wdm, sb));
                    feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, string, (int)wdm, sb));
                    feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, string, (int)wdm, sb));
                    feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, string, (int)wdm, sb));
                    feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, string, (int)wdm, sb));
                    feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, string, (int)wdm, sb));
                    feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, string, (int)wdm, sb));
                    feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, string, (int)wdm, sb));
                    feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, string, (int)wdm, sb));
                    feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, string, wdm, sb));
                    feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, string, wdm, sb));
                    feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, string, wdm, sb));
                    feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, string, wdm, sb));
                    feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, string, (int)wdm, sb));
                    feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, string, (int)wdm, sb));
                    feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, string, wdm, sb));
                    feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, string, wdm, sb));
                    feature.put("foto_a", this.getCountPointObjects(AllPunktObjects.Table.foto, string, wdm, sb));
                    feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, string, (int)wdm, sb));
                    feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, string, (int)wdm, sb));
                    feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, string, (int)wdm, sb));
                    feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, string, (int)wdm, sb));
                    feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, string, (int)wdm, sb));
                    feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, string, (int)wdm, sb));
                    feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, string, (int)wdm, sb));
                    feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, string, (int)wdm, sb));
                    feature.put("dok_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_doku, string, (int)wdm, sb));
                    feature.put("dok_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_doku, string, (int)wdm, sb));
                    feature.put("proj_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_proj, string, (int)wdm, sb));
                    feature.put("proj_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_proj, string, (int)wdm, sb));
                    features.add(feature);
                    featureListKum.add(feature);
                    featureListKumWdm.add(feature);
                }
                features.add(this.createKumFeature(featureListKumWdm, true));
            }
            features.add(this.createKumFeature(featureListKum, false));
        }
        for (Map map : features) {
            if (map.get("summe") != null && map.get("zwischenSumme") != null && ((Boolean)map.get("zwischenSumme")).booleanValue()) continue;
            map.remove("guName");
            map.remove("gu");
            map.remove("widmung");
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGewaesserAbschnitt() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        for (String sb : this.getSb()) {
            ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
            String sheetName = String.valueOf(this.getGuIdBySb(sb)) + "-" + String.valueOf(this.getWidmungBySb(sb)) + "-" + String.valueOf(sb);
            this.sheetNames.add(sheetName);
            for (Integer gew : this.getGew(sb)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                feature.put("anzahlGew", this.getCountGewBySb(sb));
                feature.put("code", this.getBaCd(gew));
                feature.put("widmung", this.getWdm(gew));
                feature.put("gu", this.getGuIdBySb(sb));
                feature.put("group", sheetName);
                feature.put("guName", this.getOwner(gew));
                feature.put("sb", sb);
                feature.put("sbName", this.getSbName(sb));
                feature.put("gewName", this.getGewName(gew));
                feature.put("von", this.convertStation(this.startGew(sb, gew)));
                feature.put("bis", this.convertStation(this.endGew(sb, gew)));
                double gewAll = this.getLengthGew(gew);
                feature.put("teil", Math.abs(gewAll - (this.endGew(sb, gew) - this.startGew(sb, gew))) < 0.01 ? null : "x");
                feature.put("gewLaenge", this.getLengthGew(gew, sb));
                feature.put("offene_a", this.getCountOffeneAbschnBySb(sb, gew));
                feature.put("offene_l", this.getLengthOffeneAbschnBySb(sb, gew));
                feature.put("see_a", this.getCountLineObjectsBySb(GewaesserData.LineFromPolygonTable.sg_see, sb, (int)gew));
                feature.put("see_l", this.getLengthLineObjectsBySb(GewaesserData.LineFromPolygonTable.sg_see, sb, (int)gew));
                feature.put("geschl_a", this.getCountGeschlAbschnBySb(sb, gew));
                feature.put("geschl_l", this.getLengthGeschlAbschnBySb(sb, gew));
                feature.put("wschutz_a", this.getCountLineObjectsBySb(GewaesserData.LineFromPolygonTable.wr_sg_wsg, sb, (int)gew));
                feature.put("wschutz_l", this.getLengthLineObjectsBySb(GewaesserData.LineFromPolygonTable.wr_sg_wsg, sb, (int)gew));
                feature.put("ueber_a", this.getCountLineObjectsBySb(GewaesserData.LineFromPolygonTable.wr_sg_uesg, sb, (int)gew));
                feature.put("ueber_l", this.getLengthLineObjectsBySb(GewaesserData.LineFromPolygonTable.wr_sg_uesg, sb, (int)gew));
                feature.put("ben_a", this.getCountPointObjectsBySb(AllPunktObjects.Table.wr_wbu_ben, sb, gew));
                feature.put("aus_a", this.getCountPointObjectsBySb(AllPunktObjects.Table.wr_wbu_aus, sb, gew));
                feature.put("pegel_a", this.getCountPointObjectsBySb(AllPunktObjects.Table.mn_ow_pegel, sb, gew));
                feature.put("gb_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_gb, sb, (int)gew));
                feature.put("gb_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_gb, sb, (int)gew));
                feature.put("gmd_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_gmd, sb, (int)gew));
                feature.put("gmd_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_gmd, sb, (int)gew));
                feature.put("prof_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_prof, sb, (int)gew));
                feature.put("prof_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_prof, sb, (int)gew));
                feature.put("sbef_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_sbef, sb, (int)gew));
                feature.put("sbef_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_sbef, sb, (int)gew));
                feature.put("ubef_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_ubef, sb, (int)gew));
                feature.put("ubef_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_ubef, sb, (int)gew));
                feature.put("bbef_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_bbef, sb, (int)gew));
                feature.put("bbef_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_bbef, sb, (int)gew));
                feature.put("rl_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_rl, sb, (int)gew));
                feature.put("rl_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_rl, sb, (int)gew));
                feature.put("d_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_d, sb, (int)gew));
                feature.put("d_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_d, sb, (int)gew));
                feature.put("due_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_due, sb, (int)gew));
                feature.put("due_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_due, sb, (int)gew));
                feature.put("scha_a", this.getCountPointObjectsBySb(AllPunktObjects.Table.fg_ba_scha, sb, gew));
                feature.put("wehr_a", this.getCountPointObjectsBySb(AllPunktObjects.Table.fg_ba_wehr, sb, gew));
                feature.put("schw_a", this.getCountPointObjectsBySb(AllPunktObjects.Table.fg_ba_schw, sb, gew));
                feature.put("anlp_a", this.getCountPointObjectsBySb(AllPunktObjects.Table.fg_ba_anlp, sb, gew));
                feature.put("anll_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_anll, sb, (int)gew));
                feature.put("anll_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_anll, sb, (int)gew));
                feature.put("kr_a", this.getCountPointObjectsBySb(AllPunktObjects.Table.fg_ba_kr, sb, gew));
                feature.put("ea_a", this.getCountPointObjectsBySb(AllPunktObjects.Table.fg_ba_ea, sb, gew));
                feature.put("deich_a", this.getCountLineObjectsBySb(AllLineObjects.Table.deich_ft, sb, (int)gew));
                feature.put("deich_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.deich_ft, sb, (int)gew));
                feature.put("ughz_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_ughz, sb, (int)gew));
                feature.put("ughz_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_ughz, sb, (int)gew));
                feature.put("leis_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_leis, sb, (int)gew));
                feature.put("leis_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_leis, sb, (int)gew));
                feature.put("tech_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_tech, sb, (int)gew));
                feature.put("tech_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_tech, sb, (int)gew));
                feature.put("dok_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_doku, sb, (int)gew));
                feature.put("dok_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_doku, sb, (int)gew));
                feature.put("proj_a", this.getCountLineObjectsBySb(AllLineObjects.Table.fg_ba_proj, sb, (int)gew));
                feature.put("proj_l", this.getLengthLineObjectsBySb(AllLineObjects.Table.fg_ba_proj, sb, (int)gew));
                features.add(feature);
                featureListKum.add(feature);
            }
            Map<String, Object> l = this.createKumFeature(featureListKum, false);
            l.put("code", null);
            l.put("gewName", null);
            l.put("von", null);
            l.put("bis", null);
            features.add(l);
        }
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuTable() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("GU");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        for (String guName : this.getGu()) {
            HashMap<String, Object> feature = new HashMap<String, Object>();
            feature.put("anzahlGu", this.getCountGu());
            feature.put("group", 1);
            feature.put("gu", this.getGuId(guName));
            feature.put("guName", guName);
            feature.put("gewAnzahl", this.getCountGew(guName));
            feature.put("gewLaenge", this.getLengthGew(guName));
            feature.put("offene_a", this.getCountOffeneAbschn(guName));
            feature.put("offene_l", this.getLengthOffeneAbschn(guName));
            feature.put("see_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.sg_see, guName));
            feature.put("see_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.sg_see, guName));
            feature.put("geschl_a", this.getCountGeschlAbschn(guName));
            feature.put("geschl_l", this.getLengthGeschlAbschn(guName));
            feature.put("wschutz_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, guName));
            feature.put("wschutz_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, guName));
            feature.put("ueber_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, guName));
            feature.put("ueber_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, guName));
            feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, guName));
            feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, guName));
            feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, guName));
            feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, guName));
            feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, guName));
            feature.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, guName));
            feature.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, guName));
            feature.put("prof_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_prof, guName));
            feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName));
            feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, guName));
            feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, guName));
            feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, guName));
            feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, guName));
            feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, guName));
            feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, guName));
            feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, guName));
            feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, guName));
            feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, guName));
            feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, guName));
            feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, guName));
            feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, guName));
            feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, guName));
            feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, guName));
            feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, guName));
            feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, guName));
            feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, guName));
            feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, guName));
            feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, guName));
            feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, guName));
            feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, guName));
            feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, guName));
            feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, guName));
            feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, guName));
            feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, guName));
            feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, guName));
            feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, guName));
            feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, guName));
            features.add(feature);
            featureListKum.add(feature);
        }
        features.add(this.createKumFeature(featureListKum, false));
        return new FeatureDataSource(features);
    }

    private FeatureDataSource getGuWidmung() throws Exception {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        this.sheetNames.add("GU");
        ArrayList<Map<String, Object>> featureListKum = new ArrayList<Map<String, Object>>();
        for (String guName : this.getGu()) {
            ArrayList<Map<String, Object>> featureListGuKum = new ArrayList<Map<String, Object>>();
            for (Integer wdm : this.getWidmung(guName)) {
                HashMap<String, Object> feature = new HashMap<String, Object>();
                feature.put("anzahlGu", this.getCountGu());
                feature.put("gu", this.getGuId(guName));
                feature.put("guName", guName);
                feature.put("widmung", wdm);
                feature.put("gew_a", this.getCountGew(guName, wdm));
                feature.put("gew_l", this.getLengthGew(guName, wdm));
                feature.put("offene_a", this.getCountOffeneAbschn(guName, wdm));
                feature.put("offene_l", this.getLengthOffeneAbschn(guName, wdm));
                feature.put("see_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.sg_see, guName, (int)wdm));
                feature.put("see_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.sg_see, guName, (int)wdm));
                feature.put("geschl_a", this.getCountGeschlAbschn(guName, wdm));
                feature.put("geschl_l", this.getLengthGeschlAbschn(guName, wdm));
                feature.put("wschutz_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, guName, (int)wdm));
                feature.put("wschutz_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_wsg, guName, (int)wdm));
                feature.put("ueber_a", this.getCountLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, guName, (int)wdm));
                feature.put("ueber_l", this.getLengthLineObjects(GewaesserData.LineFromPolygonTable.wr_sg_uesg, guName, (int)wdm));
                feature.put("ben_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_ben, guName, wdm));
                feature.put("aus_a", this.getCountPointObjects(AllPunktObjects.Table.wr_wbu_aus, guName, wdm));
                feature.put("pegel_a", this.getCountPointObjects(AllPunktObjects.Table.mn_ow_pegel, guName, wdm));
                feature.put("gb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_gb, guName, (int)wdm));
                feature.put("gb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_gb, guName, (int)wdm));
                feature.put("sb_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sb, guName, (int)wdm));
                feature.put("sb_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sb, guName, (int)wdm));
                feature.put("prof_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_prof, guName, (int)wdm));
                feature.put("prof_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_prof, guName, (int)wdm));
                feature.put("sbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_sbef, guName, (int)wdm));
                feature.put("sbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_sbef, guName, (int)wdm));
                feature.put("ubef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ubef, guName, (int)wdm));
                feature.put("ubef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ubef, guName, (int)wdm));
                feature.put("bbef_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_bbef, guName, (int)wdm));
                feature.put("bbef_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_bbef, guName, (int)wdm));
                feature.put("rl_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_rl, guName, (int)wdm));
                feature.put("rl_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_rl, guName, (int)wdm));
                feature.put("d_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_d, guName, (int)wdm));
                feature.put("d_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_d, guName, (int)wdm));
                feature.put("due_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_due, guName, (int)wdm));
                feature.put("due_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_due, guName, (int)wdm));
                feature.put("scha_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_scha, guName, wdm));
                feature.put("wehr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_wehr, guName, wdm));
                feature.put("schw_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_schw, guName, wdm));
                feature.put("anlp_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_anlp, guName, wdm));
                feature.put("anll_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_anll, guName, (int)wdm));
                feature.put("anll_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_anll, guName, (int)wdm));
                feature.put("kr_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_kr, guName, wdm));
                feature.put("ea_a", this.getCountPointObjects(AllPunktObjects.Table.fg_ba_ea, guName, wdm));
                feature.put("deich_a", this.getCountLineObjects(AllLineObjects.Table.deich_ft, guName, (int)wdm));
                feature.put("deich_l", this.getLengthLineObjects(AllLineObjects.Table.deich_ft, guName, (int)wdm));
                feature.put("ughz_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_ughz, guName, (int)wdm));
                feature.put("ughz_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_ughz, guName, (int)wdm));
                feature.put("leis_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_leis, guName, (int)wdm));
                feature.put("leis_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_leis, guName, (int)wdm));
                feature.put("tech_a", this.getCountLineObjects(AllLineObjects.Table.fg_ba_tech, guName, (int)wdm));
                feature.put("tech_l", this.getLengthLineObjects(AllLineObjects.Table.fg_ba_tech, guName, (int)wdm));
                features.add(feature);
                featureListKum.add(feature);
                featureListGuKum.add(feature);
            }
            features.add(this.createKumFeature(featureListGuKum, true));
        }
        features.add(this.createKumFeature(featureListKum, false));
        return new FeatureDataSource(features);
    }

    private Map<String, Object> createKumFeature(List<Map<String, Object>> featureListKum, boolean subtotal) {
        HashMap<String, Object> kumFeature = new HashMap<String, Object>();
        kumFeature.put("summe", Boolean.TRUE);
        kumFeature.put("zwischenSumme", subtotal);
        if (featureListKum == null || featureListKum.isEmpty()) {
            return kumFeature;
        }
        Map<String, Object> firstElement = featureListKum.get(0);
        for (String key : firstElement.keySet()) {
            Object value = firstElement.get(key);
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Integer) {
                int sum = 0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Integer)f.get(key)).intValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            if (Arrays.binarySearch(exceptionalNumberFields, key) < 0 && value instanceof Double) {
                double sum = 0.0;
                for (Map<String, Object> f : featureListKum) {
                    sum += ((Double)f.get(key)).doubleValue();
                }
                kumFeature.put(key, sum);
                continue;
            }
            kumFeature.put(key, value);
        }
        return kumFeature;
    }

    private Collection<Integer> getGew() {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    private Collection<Integer> getGew(String sb) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            if (!tmp.getSb().equals(sb)) continue;
            ts.add(tmp.getId());
        }
        return ts.descendingSet();
    }

    private Collection<String> getGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (SbObj tmp : this.parts) {
            ts.add(tmp.getGuName());
        }
        return ts.descendingSet();
    }

    private String getGuId(String owner) {
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner)) continue;
            return tmp.getGu();
        }
        return null;
    }

    private String getGuIdBySb(String sb) {
        for (SbObj tmp : this.parts) {
            if (!tmp.getSb().equals(sb)) continue;
            return tmp.getGu();
        }
        return null;
    }

    private String getOwner(int gew) {
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew) continue;
            return tmp.getGuName();
        }
        return null;
    }

    private String getSbName(String sb) {
        for (SbObj tmp : this.parts) {
            if (!tmp.getSb().equals(sb)) continue;
            return tmp.getSbName();
        }
        return null;
    }

    private Integer getWdm(int gew) {
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew) continue;
            return tmp.getWidmung();
        }
        return null;
    }

    private Collection<Integer> getWidmung(String guName) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj gmdPart : this.parts) {
            if (!gmdPart.getGuName().equals(guName)) continue;
            ts.add(gmdPart.getWidmung());
        }
        return ts;
    }

    private Integer getWidmungBySb(String sb) {
        for (SbObj gmdPart : this.parts) {
            if (!gmdPart.getSb().equals(sb)) continue;
            return gmdPart.getWidmung();
        }
        return null;
    }

    private Collection<String> getSb(String guName, int wdm) {
        TreeSet<String> ts = new TreeSet<String>();
        for (SbObj gmdPart : this.parts) {
            if (!gmdPart.getGuName().equals(guName) || gmdPart.getWidmung() != wdm) continue;
            ts.add(gmdPart.getSb());
        }
        return ts;
    }

    private Collection<String> getSb() {
        TreeSet<String> ts = new TreeSet<String>();
        for (SbObj gmdPart : this.parts) {
            ts.add(gmdPart.getSb());
        }
        return ts.descendingSet();
    }

    private double startGew(String sb, Integer gew) {
        double min = Double.MAX_VALUE;
        for (SbObj gmdPart : this.parts) {
            if (gmdPart.getId() != gew.intValue() || !gmdPart.getSb().equals(sb) || !(gmdPart.getFrom() < min)) continue;
            min = gmdPart.getFrom();
        }
        return min;
    }

    private double endGew(String sb, Integer gew) {
        double max = Double.MIN_VALUE;
        for (SbObj gmdPart : this.parts) {
            if (gmdPart.getId() != gew.intValue() || !gmdPart.getSb().equals(sb) || !(gmdPart.getTill() > max)) continue;
            max = gmdPart.getTill();
        }
        return max;
    }

    private int getCountGu() {
        TreeSet<String> ts = new TreeSet<String>();
        for (SbObj tmp : this.parts) {
            ts.add(tmp.getGuName());
        }
        return ts.size();
    }

    private String getBaCd(int gew) {
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew) continue;
            return tmp.getBaCd();
        }
        return null;
    }

    private String getGewName(int gew) {
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew) continue;
            return tmp.getGewName();
        }
        return null;
    }

    private int getCountGewAll() {
        TreeSet<String> ts = new TreeSet<String>();
        for (SbObj tmp : this.parts) {
            ts.add(tmp.getBaCd());
        }
        return ts.size();
    }

    private double getLengthGewAll() {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(int gewId) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gewId) continue;
            return tmp.getBaLen();
        }
        return 0.0;
    }

    private double getLengthGew(int gewId, String sb) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gewId || !tmp.getSb().equals(sb)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String gu) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(gu)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String gu, int wdm) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private double getLengthGew(String gu, int wdm, String sb) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm || !tmp.getSb().equals(sb)) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGew(String gu) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(gu)) continue;
            ++count;
        }
        return count;
    }

    private int getCountGewBySb(String sb) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getSb().equals(sb)) continue;
            ++count;
        }
        return count;
    }

    private int getCountGew(String gu, int wdm) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm) continue;
            ++count;
        }
        return count;
    }

    private int getCountGew(String gu, int wdm, String sb) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(gu) || tmp.getWidmung() != wdm || !tmp.getSb().equals(sb)) continue;
            ++count;
        }
        return count;
    }

    private int getCountOffeneAbschn() {
        return this.getCountOffeneAbschn(-1);
    }

    private double getLengthOffeneAbschn() {
        return this.getLengthOffeneAbschn(-1);
    }

    private int getCountGeschlAbschn() {
        return this.getCountGeschlAbschn(-1);
    }

    private double getLengthGeschlAbschn() {
        return this.getLengthGeschlAbschn(-1);
    }

    private int getCountOffeneAbschn(int gewId) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(int gewId) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(int gewId) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(int gewId) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (gewId >= 0 && tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschn(int gewId, double from, double till) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(int gewId, double from, double till) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gewId || !tmp.getArt().equals("p")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    private int getCountGeschlAbschn(int gewId, double from, double till) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gewId || !tmp.isInGewPart(gewId, from, till) || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(int gewId, double from, double till) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gewId || !tmp.getArt().equals("g")) continue;
            length += tmp.getLengthInGewPart(gewId, from, till);
        }
        return length;
    }

    private int getCountOffeneAbschn(String owner) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(String owner) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(String owner) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(String owner) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschn(String owner, int wdm) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(String owner, int wdm) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(String owner, int wdm) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(String owner, int wdm) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschn(String owner, int wdm, String sb) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getSb().equals(sb) || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschn(String owner, int wdm, String sb) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getSb().equals(sb) || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschn(String owner, int wdm, String sb) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getSb().equals(sb) || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschn(String owner, int wdm, String sb) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getSb().equals(sb) || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountOffeneAbschnBySb(String sb, int gew) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew || !tmp.getSb().equals(sb) || !tmp.getArt().equals("p")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthOffeneAbschnBySb(String sb, int gew) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew || !tmp.getSb().equals(sb) || !tmp.getArt().equals("p")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountGeschlAbschnBySb(String sb, int gew) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew || !tmp.getSb().equals(sb) || !tmp.getArt().equals("g")) continue;
            ++count;
        }
        return count;
    }

    private double getLengthGeschlAbschnBySb(String sb, int gew) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew || !tmp.getSb().equals(sb) || !tmp.getArt().equals("g")) continue;
            length += tmp.getLength();
        }
        return length;
    }

    private int getCountLineObjectsAll(AllLineObjects.Table table) {
        return this.getCountLineObjects(table, -1);
    }

    private double getLengthLineObjectsAll(AllLineObjects.Table table) {
        return this.getLengthLineObjects(table, -1);
    }

    private int getCountLineObjectsAll(GewaesserData.LineFromPolygonTable table) {
        return this.getCountLineObjects(table, -1);
    }

    private double getLengthLineObjectsAll(GewaesserData.LineFromPolygonTable table) {
        return this.getLengthLineObjects(table, -1);
    }

    private int getCountPointObjectsAll(AllPunktObjects.Table table) {
        return this.getCountPointObjects(table, -1);
    }

    private int getCountLineObjects(AllLineObjects.Table table, int gewId) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ts.size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, int gewId) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(GewaesserData.LineFromPolygonTable table, int gewId) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            count += this.gd.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(GewaesserData.LineFromPolygonTable table, int gewId) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, int gewId) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            if (gewId >= 0 && gewId != tmp.getId()) continue;
            ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ts.size();
    }

    private int getCountLineObjects(AllLineObjects.Table table, int gewId, double from, double till) {
        return this.gd.getIds(table, gewId, from, till).size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, int gewId, double from, double till) {
        return this.gd.getLength(table, gewId, from, till);
    }

    private int getCountLineObjects(GewaesserData.LineFromPolygonTable table, int gewId, double from, double till) {
        return this.gd.getCount(table, gewId, from, till);
    }

    private double getLengthLineObjects(GewaesserData.LineFromPolygonTable table, int gewId, double from, double till) {
        return this.gd.getLength(table, gewId, from, till);
    }

    private int getCountPointObjects(AllPunktObjects.Table table, int gewId, double from, double till) {
        return this.gd.getIds(table, gewId, from, till).size();
    }

    private int getCountLineObjects(AllLineObjects.Table table, String owner) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner)) continue;
            ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ts.size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, String owner) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner)) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(GewaesserData.LineFromPolygonTable table, String owner) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner)) continue;
            count += this.gd.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(GewaesserData.LineFromPolygonTable table, int gemNr, String owner) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner)) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, int gemNr, String owner) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner)) continue;
            ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ts.size();
    }

    private int getCountLineObjects(AllLineObjects.Table table, String owner, int wdm) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm) continue;
            ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ts.size();
    }

    private double getLengthLineObjects(AllLineObjects.Table table, String owner, int wdm) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(GewaesserData.LineFromPolygonTable table, String owner, int wdm) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm) continue;
            count += this.gd.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(GewaesserData.LineFromPolygonTable table, String owner, int wdm) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, String owner, int wdm) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm) continue;
            ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ts.size();
    }

    private int getCountLineObjects(AllLineObjects.Table table, String owner, int wdm, String sb) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getSb().equals(sb)) continue;
            count += this.gd.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(AllLineObjects.Table table, String owner, int wdm, String sb) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getSb().equals(sb)) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjects(GewaesserData.LineFromPolygonTable table, String owner, int wdm, String sb) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getSb().equals(sb)) continue;
            count += this.gd.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjects(GewaesserData.LineFromPolygonTable table, String owner, int wdm, String sb) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getSb().equals(sb)) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, String owner, int wdm, String sb) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner) || tmp.getWidmung() != wdm || !tmp.getSb().equals(sb)) continue;
            ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ts.size();
    }

    private int getCountLineObjectsBySb(AllLineObjects.Table table, String sb, int gew) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew || !tmp.getSb().equals(sb)) continue;
            ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ts.size();
    }

    private double getLengthLineObjectsBySb(AllLineObjects.Table table, String sb, int gew) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew || !tmp.getSb().equals(sb)) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountLineObjectsBySb(GewaesserData.LineFromPolygonTable table, String sb, int gew) {
        int count = 0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew || !tmp.getSb().equals(sb)) continue;
            count += this.gd.getCount(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return count;
    }

    private double getLengthLineObjectsBySb(GewaesserData.LineFromPolygonTable table, String sb, int gew) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew || !tmp.getSb().equals(sb)) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjectsBySb(AllPunktObjects.Table table, String sb, int gew) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            if (tmp.getId() != gew || !tmp.getSb().equals(sb)) continue;
            ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ts.size();
    }

    private double getLengthLineObjects(GewaesserData.LineFromPolygonTable table, String owner) {
        double length = 0.0;
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner)) continue;
            length += this.gd.getLength(table, tmp.getId(), tmp.getFrom(), tmp.getTill());
        }
        return length;
    }

    private int getCountPointObjects(AllPunktObjects.Table table, String owner) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (SbObj tmp : this.parts) {
            if (!tmp.getGuName().equals(owner)) continue;
            ts.addAll(this.gd.getIds(table, tmp.getId(), tmp.getFrom(), tmp.getTill()));
        }
        return ts.size();
    }

    private String convertStation(Double station) {
        int km = (int)(station / 1000.0);
        int m = (int)(station % 1000.0);
        String mString = String.valueOf(m);
        while (mString.length() < 3) {
            mString = "0" + mString;
        }
        return km + "+" + mString;
    }

    static {
        Arrays.sort(exceptionalNumberFields);
    }
}

