/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.server;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.watergis.broker.AppBroker;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;

public class GeoLinkServer {
    private static final Logger LOG = Logger.getLogger(GeoLinkServer.class);

    public static void startServer() {
        try {
            final MappingComponent mappingComponent = AppBroker.getInstance().getMappingComponent();
            Thread http = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1500L);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Http Interface initialisieren");
                        }
                        Server server = new Server();
                        ServerConnector connector = new ServerConnector(server);
                        connector.setPort(AppBroker.getInstance().getWatergisApp().getHttpInterfacePort().intValue());
                        server.setConnectors(new Connector[]{connector});
                        AbstractHandler param = new AbstractHandler(){

                            public void handle(String target, Request rqst, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                                Request base_request = rqst;
                                base_request.setHandled(true);
                                response.setContentType("text/html");
                                response.setStatus(202);
                                response.getWriter().println("<html><head><title>HTTP interface</title></head><body><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"80%\"><tr><td width=\"30%\" align=\"center\" valign=\"middle\"><img border=\"0\" src=\"http://www.cismet.de/images/cismetLogo250M.png\" ><br></td><td width=\"%\">&nbsp;</td><td width=\"50%\" align=\"left\" valign=\"middle\"><font face=\"Arial\" size=\"3\" color=\"#1c449c\"><b>Geolink</b> - dieses Fenster kann geschlossen werden !</font><br><br><br></td></tr></table></body></html>");
                            }
                        };
                        AbstractHandler hello = new AbstractHandler(){

                            public void handle(String target, Request rqst, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                                block13: {
                                    try {
                                        if (request.getLocalAddr().equals(request.getRemoteAddr())) {
                                            String y1;
                                            String x1;
                                            LOG.info((Object)"HttpInterface connected");
                                            if (target.equalsIgnoreCase("/gotoBoundingBox")) {
                                                x1 = request.getParameter("x1");
                                                y1 = request.getParameter("y1");
                                                String x2 = request.getParameter("x2");
                                                String y2 = request.getParameter("y2");
                                                try {
                                                    BoundingBox bb = new BoundingBox(new Double(x1).doubleValue(), new Double(y1).doubleValue(), new Double(x2).doubleValue(), new Double(y2).doubleValue());
                                                    mappingComponent.gotoBoundingBoxWithHistory(bb);
                                                }
                                                catch (Exception e) {
                                                    LOG.warn((Object)"gotoBoundingBox failed", (Throwable)e);
                                                }
                                            }
                                            if (target.equalsIgnoreCase("/gotoScale")) {
                                                x1 = request.getParameter("x1");
                                                y1 = request.getParameter("y1");
                                                String scaleDenominator = request.getParameter("scaleDenominator");
                                                try {
                                                    BoundingBox bb = new BoundingBox(new Double(x1).doubleValue(), new Double(y1).doubleValue(), new Double(x1).doubleValue(), new Double(y1).doubleValue());
                                                    mappingComponent.gotoBoundingBoxWithHistory(mappingComponent.getScaledBoundingBox(new Double(scaleDenominator).doubleValue(), bb));
                                                }
                                                catch (Exception e) {
                                                    LOG.warn((Object)"gotoBoundingBox failed", (Throwable)e);
                                                }
                                            }
                                            if (target.equalsIgnoreCase("/centerOnPoint")) {
                                                x1 = request.getParameter("x1");
                                                y1 = request.getParameter("y1");
                                                try {
                                                    BoundingBox bb = new BoundingBox(new Double(x1).doubleValue(), new Double(y1).doubleValue(), new Double(x1).doubleValue(), new Double(y1).doubleValue());
                                                    mappingComponent.gotoBoundingBoxWithHistory(bb);
                                                }
                                                catch (Exception e) {
                                                    LOG.warn((Object)"centerOnPoint failed", (Throwable)e);
                                                }
                                            } else {
                                                LOG.warn((Object)("Unknown target: " + target));
                                            }
                                            break block13;
                                        }
                                        LOG.warn((Object)"Someone tries to access the http interface from an other computer. Access denied.");
                                    }
                                    catch (Throwable t) {
                                        LOG.error((Object)"Error while handle http requests", t);
                                    }
                                }
                            }
                        };
                        HandlerCollection handlers = new HandlerCollection();
                        handlers.setHandlers(new Handler[]{param, hello});
                        server.setHandler((Handler)handlers);
                        server.start();
                        server.join();
                    }
                    catch (Throwable t) {
                        LOG.error((Object)"Error in the HttpInterface of cismap", t);
                    }
                }
            });
            http.start();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Initialise HTTP interface");
            }
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Nothing at all", t);
        }
    }
}

