/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class CustomGafCatalogueReader {
    private static final Logger LOG = Logger.getLogger(CustomGafCatalogueReader.class);
    private final int[] columnIndex = new int[5];
    private String[] header;
    private final ArrayList<String[]> content = new ArrayList();
    private FILE_TYPE type;

    public CustomGafCatalogueReader(File catalogueFile) throws IllegalArgumentException {
        this.init(catalogueFile);
    }

    private CustomGafCatalogueReader() {
    }

    public FILE_TYPE getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public static CustomGafCatalogueReader createBkCatalogue(List<DefaultFeatureServiceFeature> features, List<CidsBean> bkList) {
        void var6_10;
        boolean hasCustomCatalogue = false;
        CustomGafCatalogueReader catalogue = new CustomGafCatalogueReader();
        TreeSet<BkObject> objectSet = new TreeSet<BkObject>();
        for (DefaultFeatureServiceFeature defaultFeatureServiceFeature : features) {
            if (defaultFeatureServiceFeature.getProperty("bk") != null) {
                CidsBean bean = CustomGafCatalogueReader.getBeanByProperty(bkList, "bk", defaultFeatureServiceFeature.getProperty("bk"));
                BkObject bkObject = new BkObject(bean);
                objectSet.add(bkObject);
                continue;
            }
            if (defaultFeatureServiceFeature.getProperty("bk_name") == null) continue;
            hasCustomCatalogue = true;
            BkObject bkObject = new BkObject();
            bkObject.setName((String)defaultFeatureServiceFeature.getProperty("bk_name"));
            bkObject.setAx((Double)defaultFeatureServiceFeature.getProperty("bk_ax"));
            bkObject.setAy((Double)defaultFeatureServiceFeature.getProperty("bk_ay"));
            bkObject.setDp((Double)defaultFeatureServiceFeature.getProperty("bk_dp"));
            objectSet.add(bkObject);
        }
        int number = 1000;
        for (BkObject obj : objectSet) {
            String[] contentFields = new String[5];
            Integer bkNumber = obj.getBk();
            if (bkNumber == null) {
                bkNumber = ++number;
            }
            contentFields[BK_FIELDS.BK.ordinal()] = bkNumber.toString();
            contentFields[BK_FIELDS.NAME.ordinal()] = obj.getName();
            contentFields[BK_FIELDS.AX.ordinal()] = obj.getAx().toString();
            contentFields[BK_FIELDS.AY.ordinal()] = obj.getAy().toString();
            contentFields[BK_FIELDS.DP.ordinal()] = obj.getDp().toString();
            catalogue.content.add(contentFields);
        }
        boolean bl = false;
        while (var6_10 < 5) {
            catalogue.columnIndex[var6_10] = var6_10;
            ++var6_10;
        }
        catalogue.type = FILE_TYPE.BK;
        return catalogue;
    }

    /*
     * WARNING - void declaration
     */
    public static CustomGafCatalogueReader createRkCatalogue(List<DefaultFeatureServiceFeature> features, List<CidsBean> rkList) {
        void var6_10;
        boolean hasCustomCatalogue = false;
        CustomGafCatalogueReader catalogue = new CustomGafCatalogueReader();
        TreeSet<RkObject> objectSet = new TreeSet<RkObject>();
        for (DefaultFeatureServiceFeature defaultFeatureServiceFeature : features) {
            if (defaultFeatureServiceFeature.getProperty("rk") != null) {
                CidsBean bean = CustomGafCatalogueReader.getBeanByProperty(rkList, "rk", defaultFeatureServiceFeature.getProperty("rk"));
                RkObject rkObject = new RkObject(bean);
                objectSet.add(rkObject);
                continue;
            }
            if (defaultFeatureServiceFeature.getProperty("rk_name") == null) continue;
            hasCustomCatalogue = true;
            RkObject rkObject = new RkObject();
            rkObject.setName((String)defaultFeatureServiceFeature.getProperty("rk_name"));
            rkObject.setK((Double)defaultFeatureServiceFeature.getProperty("rk_k"));
            rkObject.setKst((Double)defaultFeatureServiceFeature.getProperty("rk_kst"));
            objectSet.add(rkObject);
        }
        int number = 1000;
        for (RkObject obj : objectSet) {
            String[] contentFields = new String[4];
            Integer rkNumber = obj.getRk();
            if (rkNumber == null) {
                rkNumber = ++number;
            }
            contentFields[RK_FIELDS.RK.ordinal()] = rkNumber.toString();
            contentFields[RK_FIELDS.NAME.ordinal()] = obj.getName();
            contentFields[RK_FIELDS.K.ordinal()] = obj.getK().toString();
            contentFields[RK_FIELDS.KST.ordinal()] = obj.getKst().toString();
            catalogue.content.add(contentFields);
        }
        boolean bl = false;
        while (var6_10 < 4) {
            catalogue.columnIndex[var6_10] = var6_10;
            ++var6_10;
        }
        catalogue.type = FILE_TYPE.RK;
        return catalogue;
    }

    private static CidsBean getBeanByProperty(List<CidsBean> list, String property, Object value) {
        for (CidsBean b : list) {
            Object p = b.getProperty(property);
            if (p == null || !p.toString().equals(value.toString())) continue;
            return b;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(File catalogueFile) throws IllegalArgumentException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(catalogueFile));
            String headerLine = reader.readLine();
            ArrayList<String> headers = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(headerLine, "\t;");
            int index = 0;
            this.determineFileType(headerLine);
            if (this.type.equals((Object)FILE_TYPE.UNKNOWN)) {
                LOG.error((Object)"unknown file type. Custom rk or custom bk catalogue expected.");
                throw new IllegalArgumentException("Die Kopfzeile passt weder zu einer Rauheits- noch zu einer Bewuchsklasse");
            }
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                headers.add(token);
                try {
                    Enum field;
                    if (this.type.equals((Object)FILE_TYPE.RK)) {
                        field = RK_FIELDS.valueOf(token.toUpperCase());
                        this.columnIndex[field.ordinal()] = index;
                    } else {
                        field = BK_FIELDS.valueOf(token.toUpperCase());
                        this.columnIndex[field.ordinal()] = index;
                    }
                }
                catch (IllegalArgumentException field) {
                    // empty catch block
                }
                ++index;
            }
            this.header = headers.toArray(new String[headers.size()]);
            while ((line = reader.readLine()) != null && line.length() >= 2) {
                st = new StringTokenizer(line, "\t;");
                ArrayList<String> contFields = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    contFields.add(token);
                }
                String[] contentFields = contFields.toArray(new String[contFields.size()]);
                this.content.add(contentFields);
            }
            int i = 0;
            for (String[] fileLine : this.content) {
                ++i;
                try {
                    if (this.type.equals((Object)FILE_TYPE.RK)) {
                        this.createRkObjectFromLine(fileLine);
                        continue;
                    }
                    if (!this.type.equals((Object)FILE_TYPE.BK)) continue;
                    this.createBkObjectFromLine(fileLine);
                }
                catch (IllegalArgumentException e) {
                    LOG.error((Object)("not parsable line found " + i), (Throwable)e);
                    throw new IllegalArgumentException("Ung\u00fcltige Werte in Zeile " + i + " gefunden.");
                    return;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reading GAF file", (Throwable)e);
            return;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOG.error((Object)"Cannot close reader", (Throwable)ex);
                }
            }
        }
    }

    private void determineFileType(String headerLine) {
        this.type = headerLine.toUpperCase().contains("BK") && headerLine.toUpperCase().contains("NAME") && headerLine.toUpperCase().contains("AX") && headerLine.toUpperCase().contains("AY") && headerLine.toUpperCase().contains("DP") ? FILE_TYPE.BK : (headerLine.toUpperCase().contains("RK") && headerLine.toUpperCase().contains("NAME") && headerLine.toUpperCase().contains("K") && headerLine.toUpperCase().contains("KST") ? FILE_TYPE.RK : FILE_TYPE.UNKNOWN);
    }

    public String createCatalogueFile() {
        StringBuilder gafContent = new StringBuilder();
        if (this.type.equals((Object)FILE_TYPE.RK)) {
            for (Enum enum_ : RK_FIELDS.values()) {
                gafContent.append(enum_.name());
                if (enum_.ordinal() == RK_FIELDS.values().length - 1) continue;
                gafContent.append("\t");
            }
        } else {
            for (Enum enum_ : BK_FIELDS.values()) {
                gafContent.append(enum_.name());
                if (enum_.ordinal() == RK_FIELDS.values().length - 1) continue;
                gafContent.append("\t");
            }
        }
        gafContent.append("\r\n");
        if (this.type.equals((Object)FILE_TYPE.RK)) {
            for (String[] line : this.content) {
                for (RK_FIELDS col : RK_FIELDS.values()) {
                    gafContent.append(line[this.columnIndex[col.ordinal()]]);
                    if (col.ordinal() == RK_FIELDS.values().length - 1) continue;
                    gafContent.append("\t");
                }
                gafContent.append("\r\n");
            }
        } else {
            for (String[] line : this.content) {
                for (BK_FIELDS col : BK_FIELDS.values()) {
                    gafContent.append(line[this.columnIndex[col.ordinal()]]);
                    if (col.ordinal() == BK_FIELDS.values().length - 1) continue;
                    gafContent.append("\t");
                }
                gafContent.append("\r\n");
            }
        }
        return gafContent.toString();
    }

    public List<Integer> getAllRk() {
        ArrayList<Integer> rk = new ArrayList<Integer>();
        if (!this.type.equals((Object)FILE_TYPE.RK)) {
            throw new IllegalArgumentException("The getAllRk method is only allowed on a rk file type");
        }
        for (String[] line : this.content) {
            try {
                rk.add(Integer.parseInt(line[this.columnIndex[RK_FIELDS.RK.ordinal()]]));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Rk is not a number", (Throwable)e);
            }
        }
        return rk;
    }

    public List<Integer> getAllBk() {
        ArrayList<Integer> bk = new ArrayList<Integer>();
        if (!this.type.equals((Object)FILE_TYPE.BK)) {
            throw new IllegalArgumentException("The getAllBk method is only allowed on a bk file type");
        }
        for (String[] line : this.content) {
            try {
                bk.add(Integer.parseInt(line[this.columnIndex[BK_FIELDS.BK.ordinal()]]));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Bk is not a number", (Throwable)e);
            }
        }
        return bk;
    }

    public String getRkId(String name, Double k, Double kst) {
        if (!this.type.equals((Object)FILE_TYPE.RK)) {
            throw new IllegalArgumentException("The getRkId method is only allowed on a rk file type");
        }
        for (String[] line : this.content) {
            if (!line[this.columnIndex[RK_FIELDS.NAME.ordinal()]].equals(name) || !line[this.columnIndex[RK_FIELDS.K.ordinal()]].equals(k.toString()) || !line[this.columnIndex[RK_FIELDS.KST.ordinal()]].equals(kst.toString())) continue;
            return line[this.columnIndex[RK_FIELDS.RK.ordinal()]];
        }
        return null;
    }

    public String getBkId(String name, Double ax, Double ay, Double dp) {
        if (!this.type.equals((Object)FILE_TYPE.BK)) {
            throw new IllegalArgumentException("The getBkId method is only allowed on a bk file type");
        }
        for (String[] line : this.content) {
            if (!line[this.columnIndex[BK_FIELDS.NAME.ordinal()]].equals(name) || !line[this.columnIndex[BK_FIELDS.AX.ordinal()]].equals(ax.toString()) || !line[this.columnIndex[BK_FIELDS.AY.ordinal()]].equals(ay.toString()) || !line[this.columnIndex[BK_FIELDS.DP.ordinal()]].equals(dp.toString())) continue;
            return line[this.columnIndex[BK_FIELDS.BK.ordinal()]];
        }
        return null;
    }

    public RkObject getRkById(String id) {
        if (!this.type.equals((Object)FILE_TYPE.RK)) {
            throw new IllegalArgumentException("The getRkById method is only allowed on a rk file type");
        }
        for (String[] line : this.content) {
            if (!line[this.columnIndex[RK_FIELDS.RK.ordinal()]].equals(id)) continue;
            return this.createRkObjectFromLine(line);
        }
        return null;
    }

    public BkObject getBkById(String id) {
        if (!this.type.equals((Object)FILE_TYPE.BK)) {
            throw new IllegalArgumentException("The getBkById method is only allowed on a bk file type");
        }
        for (String[] line : this.content) {
            if (!line[this.columnIndex[BK_FIELDS.BK.ordinal()]].equals(id)) continue;
            return this.createBkObjectFromLine(line);
        }
        return null;
    }

    private BkObject createBkObjectFromLine(String[] line) throws IllegalArgumentException {
        if (!this.type.equals((Object)FILE_TYPE.BK)) {
            throw new IllegalArgumentException("The createBkObjectFromLine method is only allowed on a bk file type");
        }
        BkObject obj = new BkObject();
        try {
            obj.setBk(Integer.parseInt(line[this.columnIndex[BK_FIELDS.BK.ordinal()]]));
            obj.setName(line[this.columnIndex[BK_FIELDS.NAME.ordinal()]]);
            obj.setAx(Double.parseDouble(line[this.columnIndex[BK_FIELDS.AX.ordinal()]].replace(',', '.')));
            obj.setAy(Double.parseDouble(line[this.columnIndex[BK_FIELDS.AY.ordinal()]].replace(',', '.')));
            obj.setDp(Double.parseDouble(line[this.columnIndex[BK_FIELDS.DP.ordinal()]].replace(',', '.')));
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Cannot parse bk line", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e.getCause());
        }
        return obj;
    }

    private RkObject createRkObjectFromLine(String[] line) throws IllegalArgumentException {
        if (!this.type.equals((Object)FILE_TYPE.RK)) {
            throw new IllegalArgumentException("The createRkObjectFromLine method is only allowed on a rk file type");
        }
        RkObject obj = new RkObject();
        try {
            obj.setRk(Integer.parseInt(line[this.columnIndex[RK_FIELDS.RK.ordinal()]]));
            obj.setName(line[this.columnIndex[RK_FIELDS.NAME.ordinal()]]);
            obj.setK(Double.parseDouble(line[this.columnIndex[RK_FIELDS.K.ordinal()]].replace(',', '.')));
            obj.setKst(Double.parseDouble(line[this.columnIndex[RK_FIELDS.KST.ordinal()]].replace(',', '.')));
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Cannot parse rk line", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e.getCause());
        }
        return obj;
    }

    public static class BkObject
    implements Comparable<BkObject> {
        private Integer bk;
        private String name;
        private Double ax;
        private Double ay;
        private Double dp;

        public BkObject() {
        }

        protected BkObject(CidsBean bean) {
            this.bk = (Integer)bean.getProperty("bk");
            this.name = (String)bean.getProperty("name");
            this.ax = (Double)bean.getProperty("ax");
            this.ay = (Double)bean.getProperty("ay");
            this.dp = (Double)bean.getProperty("dp");
        }

        public Integer getBk() {
            return this.bk;
        }

        public void setBk(int bk) {
            this.bk = bk;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Double getAx() {
            return this.ax;
        }

        public void setAx(double ax) {
            this.ax = ax;
        }

        public Double getAy() {
            return this.ay;
        }

        public void setAy(double ay) {
            this.ay = ay;
        }

        public Double getDp() {
            return this.dp;
        }

        public void setDp(double dp) {
            this.dp = dp;
        }

        @Override
        public int compareTo(BkObject o) {
            if (o.bk == null && this.bk != null) {
                return -1;
            }
            if (o.bk != null && this.bk == null) {
                return 1;
            }
            if (o.bk == null && this.bk == null) {
                if (this.name.equals(o.name)) {
                    if (this.ax.equals(o.ax)) {
                        if (this.ay.equals(o.ay)) {
                            return this.dp.compareTo(o.dp);
                        }
                        return this.ay.compareTo(o.ay);
                    }
                    return this.ax.compareTo(o.ax);
                }
                return this.name.compareTo(o.name);
            }
            return this.bk.compareTo(o.bk);
        }
    }

    public static class RkObject
    implements Comparable<RkObject> {
        private Integer rk;
        private String name;
        private Double k;
        private Double kst;

        public RkObject() {
        }

        protected RkObject(CidsBean bean) {
            this.rk = (Integer)bean.getProperty("rk");
            this.name = (String)bean.getProperty("name");
            this.k = (Double)bean.getProperty("k");
            this.kst = (Double)bean.getProperty("kst");
        }

        public Integer getRk() {
            return this.rk;
        }

        public void setRk(int rk) {
            this.rk = rk;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Double getK() {
            return this.k;
        }

        public void setK(double k) {
            this.k = k;
        }

        public Double getKst() {
            return this.kst;
        }

        public void setKst(double kst) {
            this.kst = kst;
        }

        @Override
        public int compareTo(RkObject o) {
            if (o.rk == null && this.rk != null) {
                return -1;
            }
            if (o.rk != null && this.rk == null) {
                return 1;
            }
            if (o.rk == null && this.rk == null) {
                if (this.name.equals(o.name)) {
                    if (this.k.equals(o.k)) {
                        return this.kst.compareTo(o.kst);
                    }
                    return this.k.compareTo(o.k);
                }
                return this.name.compareTo(o.name);
            }
            return this.rk.compareTo(o.rk);
        }
    }

    public static enum FILE_TYPE {
        RK,
        BK,
        UNKNOWN;

    }

    public static enum BK_FIELDS {
        BK,
        NAME,
        AX,
        AY,
        DP;

    }

    public static enum RK_FIELDS {
        RK,
        NAME,
        K,
        KST;

    }
}

