/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import de.cismet.watergis.utils.PersistentGeometryWrapper;
import java.util.Arrays;
import java.util.TreeSet;

public class GeometryCollectionWrapper
extends GeometryCollection {
    private static final long serialVersionUID = -5694727726395021467L;
    protected PersistentGeometryWrapper[] geometries;

    public GeometryCollectionWrapper(PersistentGeometryWrapper[] geometries, GeometryFactory factory) {
        super(new Geometry[]{geometries[0]}, factory);
        if (geometries == null) {
            geometries = new PersistentGeometryWrapper[]{};
        }
        if (GeometryCollectionWrapper.hasNullElements((Object[])geometries)) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
        this.geometries = geometries;
    }

    public GeometryCollectionWrapper(PersistentGeometryWrapper[] geometries, PrecisionModel precisionModel, int SRID) {
        this(geometries, new GeometryFactory(precisionModel, SRID));
    }

    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            Coordinate[] childCoordinates = this.geometries[i].getCoordinates();
            for (int j = 0; j < childCoordinates.length; ++j) {
                coordinates[++k] = childCoordinates[j];
            }
        }
        return coordinates;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.geometries.length; ++i) {
            if (this.geometries[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getDimension() {
        int dimension = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            dimension = Math.max(dimension, this.geometries[i].getDimension());
        }
        return dimension;
    }

    public int getBoundaryDimension() {
        int dimension = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            dimension = Math.max(dimension, this.geometries[i].getBoundaryDimension());
        }
        return dimension;
    }

    public int getNumGeometries() {
        return this.geometries.length;
    }

    public Geometry getGeometryN(int n) {
        return this.geometries[n].getGeom();
    }

    public int getNumPoints() {
        int numPoints = 0;
        for (int i = 0; i < this.geometries.length; ++i) {
            numPoints += this.geometries[i].getNumPoints();
        }
        return numPoints;
    }

    public String getGeometryType() {
        return "GeometryCollection";
    }

    public Geometry getBoundary() {
        this.checkNotGeometryCollection((Geometry)this);
        Assert.shouldNeverReachHere();
        return null;
    }

    public double getArea() {
        double area = 0.0;
        for (int i = 0; i < this.geometries.length; ++i) {
            area += this.geometries[i].getArea();
        }
        return area;
    }

    public double getLength() {
        double sum = 0.0;
        for (int i = 0; i < this.geometries.length; ++i) {
            sum += this.geometries[i].getLength();
        }
        return sum;
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        GeometryCollectionWrapper otherCollection = (GeometryCollectionWrapper)other;
        if (this.geometries.length != otherCollection.geometries.length) {
            return false;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            if (this.geometries[i].equalsExact(otherCollection.geometries[i], tolerance)) continue;
            return false;
        }
        return true;
    }

    public void apply(CoordinateFilter filter) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    public void apply(CoordinateSequenceFilter filter) {
        if (this.geometries.length == 0) {
            return;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
            if (filter.isDone()) break;
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    public void apply(GeometryFilter filter) {
        filter.filter((Geometry)this);
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    public void apply(GeometryComponentFilter filter) {
        filter.filter((Geometry)this);
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    public Object clone() {
        GeometryCollectionWrapper gc = (GeometryCollectionWrapper)((Object)super.clone());
        gc.geometries = new PersistentGeometryWrapper[this.geometries.length];
        for (int i = 0; i < this.geometries.length; ++i) {
            gc.geometries[i] = (PersistentGeometryWrapper)((Object)this.geometries[i].clone());
        }
        return gc;
    }

    public void normalize() {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].normalize();
        }
        Arrays.sort((Object[])this.geometries);
    }

    protected Envelope computeEnvelopeInternal() {
        Envelope envelope = new Envelope();
        for (int i = 0; i < this.geometries.length; ++i) {
            envelope.expandToInclude(this.geometries[i].getEnvelopeInternal());
        }
        return envelope;
    }

    protected int compareToSameClass(Object o) {
        TreeSet<PersistentGeometryWrapper> theseElements = new TreeSet<PersistentGeometryWrapper>(Arrays.asList(this.geometries));
        TreeSet<PersistentGeometryWrapper> otherElements = new TreeSet<PersistentGeometryWrapper>(Arrays.asList(((GeometryCollectionWrapper)((Object)o)).geometries));
        return this.compare(theseElements, otherElements);
    }

    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        int i;
        GeometryCollectionWrapper gc = (GeometryCollectionWrapper)((Object)o);
        int n1 = this.getNumGeometries();
        int n2 = gc.getNumGeometries();
        for (i = 0; i < n1 && i < n2; ++i) {
            Geometry otherGeom;
            Geometry thisGeom = this.getGeometryN(i);
            int holeComp = thisGeom.compareTo((Object)(otherGeom = gc.getGeometryN(i)), comp);
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i < n1) {
            return 1;
        }
        if (i < n2) {
            return -1;
        }
        return 0;
    }

    public Geometry reverse() {
        int n = this.geometries.length;
        Geometry[] revGeoms = new Geometry[n];
        for (int i = 0; i < this.geometries.length; ++i) {
            revGeoms[i] = this.geometries[i].reverse();
        }
        return this.getFactory().createGeometryCollection(revGeoms);
    }
}

