/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.IllegalParametersException;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.PersistentFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.cismap.commons.tools.ShapeWriter;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.security.WebAccessManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.JumpFeature;
import de.cismet.watergis.utils.ShapefileWriter;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class JumpShapeWriter
implements ShapeWriter {
    private static final Logger LOG = Logger.getLogger(JumpShapeWriter.class);
    private static final boolean WRITE_META_PDF = true;
    private static final boolean WRITE_PRJ = true;
    private static final boolean WRITE_CPG = true;
    private static final String DEFAULT_CPG_CONTENT = "UTF-8";
    private static final boolean DATE_AS_STRING = true;
    public static final String DEFAULT_GEOM_PROPERTY_NAME = "the_geom";

    public void writeShape(FeatureServiceFeature[] features, List<String[]> aliasAttributeList, File fileToSaveTo) throws Exception {
        String charset = DEFAULT_CPG_CONTENT;
        String[] charsetString = this.findCustomCharset(aliasAttributeList);
        if (charsetString != null) {
            charset = charsetString[0];
        }
        List<String[]> newAliasAttributeList = this.removeSpecialValues(aliasAttributeList);
        try {
            Charset.forName(charset);
        }
        catch (Exception e) {
            LOG.error((Object)("Charset " + charset + " not found. Use " + Charset.defaultCharset().name() + " instead."));
            charset = Charset.defaultCharset().name();
        }
        String charsetAlias = charset;
        if (charsetString != null && charsetString[1] != null) {
            charsetAlias = charsetString[1];
        }
        if (Thread.interrupted()) {
            return;
        }
        try {
            this.writeShpFile(features, fileToSaveTo, newAliasAttributeList, charset);
        }
        catch (InterruptedException e) {
            this.clear(fileToSaveTo);
            return;
        }
        catch (IllegalParametersException e) {
            JOptionPane.showMessageDialog((Component)AppBroker.getInstance().getRootWindow(), NbBundle.getMessage(JumpShapeWriter.class, (String)"JumpShapeWriter.writeShape.message"), NbBundle.getMessage(JumpShapeWriter.class, (String)"JumpShapeWriter.writeShape.title"), 0);
            this.clear(fileToSaveTo);
            throw e;
        }
        if (Thread.interrupted()) {
            this.clear(fileToSaveTo);
            return;
        }
        String crs = null;
        if (features != null && features.length > 0) {
            Geometry g = features[0].getGeometry();
            crs = CrsTransformer.createCrsFromSrid((int)g.getSRID());
        }
        this.writePrjFile(fileToSaveTo, crs);
        this.writeCpgFile(fileToSaveTo, charsetAlias);
        if (features.length > 0 && features[0].getLayerProperties() != null && features[0].getLayerProperties().getFeatureService() != null) {
            this.writeMetaPdf(fileToSaveTo, features[0].getLayerProperties().getFeatureService());
        }
        if (Thread.interrupted()) {
            this.clear(fileToSaveTo);
            return;
        }
    }

    private String[] findCustomCharset(List<String[]> aliasAttributeList) {
        String[] charset = null;
        for (String[] alias : aliasAttributeList) {
            if (alias[0].equals("$charset$")) {
                if (charset == null) {
                    charset = new String[2];
                }
                charset[0] = alias[1];
                continue;
            }
            if (!alias[0].equals("$charset_alias$")) continue;
            if (charset == null) {
                charset = new String[2];
            }
            charset[1] = alias[1];
        }
        return charset;
    }

    private List<String[]> removeSpecialValues(List<String[]> aliasAttributeList) {
        ArrayList<String[]> newAliasList = new ArrayList<String[]>();
        for (String[] alias : aliasAttributeList) {
            if (alias[0].startsWith("$") && alias[0].endsWith("$") && alias[0].length() > 2) continue;
            newAliasList.add(alias);
        }
        return newAliasList;
    }

    private void clear(File fileToSaveTo) {
        String fileNameWithoutExt = fileToSaveTo.getAbsolutePath();
        if (fileToSaveTo.getAbsolutePath().contains(".")) {
            fileNameWithoutExt = fileToSaveTo.getAbsolutePath().substring(0, fileToSaveTo.getAbsolutePath().lastIndexOf("."));
        }
        String fileName = fileNameWithoutExt + ".shp";
        this.deleteFileIfExists(fileName);
        fileName = fileNameWithoutExt + ".shx";
        this.deleteFileIfExists(fileName);
        fileName = fileNameWithoutExt + ".prj";
        this.deleteFileIfExists(fileName);
        fileName = fileNameWithoutExt + ".dbf";
        this.deleteFileIfExists(fileName);
        fileName = fileNameWithoutExt + ".pdf";
        this.deleteFileIfExists(fileName);
        fileName = fileNameWithoutExt + ".cpg";
        this.deleteFileIfExists(fileName);
    }

    public void writeDbf(FeatureServiceFeature[] features, List<String[]> aliasAttributeList, File fileToSaveTo) throws Exception {
        File tmpFile = fileToSaveTo;
        if (fileToSaveTo.getName().contains(".") && fileToSaveTo.getName().substring(fileToSaveTo.getName().lastIndexOf(".")).equalsIgnoreCase(".dbf")) {
            tmpFile = new File(fileToSaveTo.getParent(), fileToSaveTo.getName().substring(0, fileToSaveTo.getName().lastIndexOf(".")) + ".shp");
        } else if (!fileToSaveTo.getAbsolutePath().contains(".")) {
            tmpFile = new File(fileToSaveTo.getParent(), fileToSaveTo.getName() + ".shp");
        }
        this.writeShape(features, aliasAttributeList, tmpFile);
        if (Thread.interrupted()) {
            this.clear(fileToSaveTo);
            return;
        }
        String fileNameWithoutExt = fileToSaveTo.getAbsolutePath();
        if (fileToSaveTo.getAbsolutePath().contains(".")) {
            fileNameWithoutExt = fileToSaveTo.getAbsolutePath().substring(0, fileToSaveTo.getAbsolutePath().lastIndexOf("."));
        }
        String fileName = fileNameWithoutExt + ".shp";
        this.deleteFileIfExists(fileName);
        fileName = fileNameWithoutExt + ".shx";
        this.deleteFileIfExists(fileName);
        fileName = fileNameWithoutExt + ".prj";
        this.deleteFileIfExists(fileName);
        if (Thread.interrupted()) {
            this.clear(fileToSaveTo);
            return;
        }
    }

    public void writeShpFile(FeatureServiceFeature[] features, File file, List<String[]> aliasAttributeList, String charset) throws Exception {
        AttributeTableRuleSet ruleSet;
        FeatureServiceFeature feature;
        ShapefileWriter writer = new ShapefileWriter();
        List<Feature> basicFeatures = this.cidsFeatures2BasicFeature(features, aliasAttributeList);
        FeatureSchema schema = basicFeatures.get(0).getSchema();
        FeatureDataset set = new FeatureDataset(basicFeatures, schema);
        basicFeatures = null;
        DriverProperties properties = new DriverProperties();
        properties.set("File", file.getAbsolutePath());
        properties.set("ShapeType", "xy");
        if (charset != null) {
            properties.set("charset", charset);
        }
        if (features != null && features.length > 0 && (feature = features[0]) != null && feature.getLayerProperties() != null && (ruleSet = feature.getLayerProperties().getAttributeTableRuleSet()) instanceof WatergisDefaultRuleSet) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (aliasAttributeList != null) {
                for (String[] name : aliasAttributeList) {
                    map.put(name[0], name[1]);
                }
            }
            writer.setRuleSet((WatergisDefaultRuleSet)ruleSet, map);
        }
        if (features[0] instanceof PersistentFeature) {
            writer.writePersistentFeatures((FeatureCollection)set, properties);
        } else {
            writer.write((FeatureCollection)set, properties);
        }
    }

    private void writePrjFile(File file, String crs) {
        try {
            Crs crsObject;
            String fileWithoutExtension = file.getAbsolutePath();
            if (fileWithoutExtension.contains(".")) {
                fileWithoutExtension = fileWithoutExtension.substring(0, fileWithoutExtension.lastIndexOf("."));
            }
            String crsDefinition = "PROJCS[\"ETRS_1989_UTM_Zone_33N_zE-N\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",33500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",5650]]";
            if (crs != null && (crsObject = this.getCrsFromName(crs)) != null) {
                crsDefinition = crsObject.getEsriDefinition();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(fileWithoutExtension + ".prj"));
            bw.write(crsDefinition);
            bw.close();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while writing prj file");
        }
    }

    private Crs getCrsFromName(String crsName) {
        List crsList = CismapBroker.getInstance().getMappingComponent().getCrsList();
        for (Crs crs : crsList) {
            if (!crs.getCode().equals(crsName)) continue;
            return crs;
        }
        return null;
    }

    private void writeCpgFile(File file, String charset) {
        try {
            String fileWithoutExtension = file.getAbsolutePath();
            if (fileWithoutExtension.contains(".")) {
                fileWithoutExtension = fileWithoutExtension.substring(0, fileWithoutExtension.lastIndexOf("."));
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(fileWithoutExtension + ".cpg"));
            if (charset == null) {
                bw.write(DEFAULT_CPG_CONTENT);
            } else {
                bw.write(charset);
            }
            bw.close();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while writing cpg file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetaPdf(File file, AbstractFeatureService service) {
        CidsLayer cl;
        String link;
        if (service instanceof CidsLayer && (link = (cl = (CidsLayer)service).getMetaDocumentLink()) != null) {
            BufferedInputStream bin = null;
            FilterOutputStream out = null;
            try {
                int byteCount;
                URL u = new URL(link);
                InputStream in = WebAccessManager.getInstance().doRequest(u);
                String fileWithoutExtension = file.getAbsolutePath();
                if (fileWithoutExtension.contains(".")) {
                    fileWithoutExtension = fileWithoutExtension.substring(0, fileWithoutExtension.lastIndexOf("."));
                }
                bin = new BufferedInputStream(in);
                out = new BufferedOutputStream(new FileOutputStream(fileWithoutExtension + ".pdf"));
                byte[] tmp = new byte[256];
                while ((byteCount = bin.read(tmp, 0, tmp.length)) != -1) {
                    ((BufferedOutputStream)out).write(tmp, 0, byteCount);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while downloading meta document.", (Throwable)e);
            }
            finally {
                try {
                    if (bin != null) {
                        bin.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Cannot close stream", (Throwable)ex);
                }
            }
        }
    }

    private List<Feature> cidsFeatures2BasicFeature(FeatureServiceFeature[] features, List<String[]> aliasAttributeList) {
        ArrayList<Feature> featureList = new ArrayList<Feature>(features.length);
        Map attributesMap = features[0].getLayerProperties().getFeatureService().getFeatureServiceAttributes();
        FeatureSchema schema = this.createScheme(attributesMap, aliasAttributeList);
        List<String[]> names = aliasAttributeList;
        boolean hasGeometry = this.hasGeometry(attributesMap, aliasAttributeList);
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 0);
        Point defaultGeom = gf.createPoint(new Coordinate(0.0, 0.0));
        if (names == null) {
            names = this.generateAliasAttributeList(attributesMap);
        }
        for (FeatureServiceFeature f : features) {
            Object bf = null;
            if (f instanceof PersistentFeature) {
                bf = new JumpFeature(f, schema);
            } else {
                bf = new BasicFeature(schema);
                for (String[] name : names) {
                    Object value = f.getProperty(name[1]);
                    if (value instanceof Boolean) {
                        value = String.valueOf(value);
                    } else if (value instanceof Timestamp || value instanceof Date) {
                        value = String.valueOf(value);
                    }
                    if (schema.getAttributeType(name[0]) == AttributeType.DOUBLE && value instanceof Integer) {
                        value = ((Integer)value).doubleValue();
                    }
                    bf.setAttribute(name[0], value);
                }
                if (!hasGeometry) {
                    bf.setAttribute(DEFAULT_GEOM_PROPERTY_NAME, (Object)defaultGeom);
                } else if (f.getGeometry() == null) {
                    bf.setAttribute(this.getGeometryAttribute(attributesMap, aliasAttributeList), (Object)defaultGeom);
                }
            }
            featureList.add((Feature)bf);
        }
        return featureList;
    }

    private FeatureSchema createScheme(Map<String, FeatureServiceAttribute> attributes, List<String[]> aliasAttributeList) {
        List<String[]> attributeNames = aliasAttributeList;
        FeatureSchema schema = new FeatureSchema();
        if (aliasAttributeList == null) {
            attributeNames = this.generateAliasAttributeList(attributes);
        }
        if (!this.hasGeometry(attributes, aliasAttributeList)) {
            schema.addAttribute(DEFAULT_GEOM_PROPERTY_NAME, AttributeType.GEOMETRY);
        }
        for (String[] name : attributeNames) {
            FeatureServiceAttribute attr = attributes.get(name[1]);
            schema.addAttribute(name[0], this.getPropertyType(attr));
        }
        return schema;
    }

    private boolean hasGeometry(Map<String, FeatureServiceAttribute> attributes, List<String[]> aliasAttributeList) {
        List<String[]> attributeNames = aliasAttributeList;
        boolean hasGeometry = false;
        if (aliasAttributeList == null) {
            attributeNames = this.generateAliasAttributeList(attributes);
        }
        for (String[] name : attributeNames) {
            FeatureServiceAttribute attr = attributes.get(name[1]);
            if (!attr.isGeometry()) continue;
            hasGeometry = true;
            break;
        }
        return hasGeometry;
    }

    private String getGeometryAttribute(Map<String, FeatureServiceAttribute> attributes, List<String[]> aliasAttributeList) {
        List<String[]> attributeNames = aliasAttributeList;
        if (aliasAttributeList == null) {
            attributeNames = this.generateAliasAttributeList(attributes);
        }
        for (String[] name : attributeNames) {
            FeatureServiceAttribute attr = attributes.get(name[1]);
            if (!attr.isGeometry()) continue;
            return name[1];
        }
        return null;
    }

    private List<String[]> generateAliasAttributeList(Map<String, FeatureServiceAttribute> attributeMap) {
        ArrayList<String[]> aliasAttrList = new ArrayList<String[]>();
        for (String key : attributeMap.keySet()) {
            String[] aliasAttr = new String[]{key.toString(), key.toString()};
            aliasAttrList.add(aliasAttr);
        }
        return aliasAttrList;
    }

    private AttributeType getPropertyType(FeatureServiceAttribute attr) {
        if (attr != null) {
            if (attr.isGeometry()) {
                return AttributeType.GEOMETRY;
            }
            Class cl = FeatureTools.getClass((FeatureServiceAttribute)attr);
            if (cl.equals(String.class)) {
                return AttributeType.STRING;
            }
            if (cl.equals(Integer.class)) {
                return AttributeType.INTEGER;
            }
            if (cl.equals(Long.class)) {
                return AttributeType.INTEGER;
            }
            if (cl.equals(Double.class)) {
                return AttributeType.DOUBLE;
            }
            if (cl.equals(Date.class)) {
                return AttributeType.STRING;
            }
            if (cl.equals(Boolean.class)) {
                return AttributeType.STRING;
            }
            if (cl.equals(BigDecimal.class)) {
                return AttributeType.OBJECT;
            }
            return AttributeType.STRING;
        }
        return null;
    }

    private void deleteFileIfExists(String fileName) {
        File fileToDelete = new File(fileName);
        if (fileToDelete.exists()) {
            fileToDelete.delete();
        }
    }
}

