/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.utils;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;

public class LinearReferencingWatergisHelper
implements LinearReferencingHelper {
    private static final String PROP_GEOM_GEOFIELD = "geo_field";
    private static final String PROP_STATION_VALUE = "wert";
    private static final String PROP_STATION_GEOM = "real_point";
    private static final String PROP_STATION_ROUTE = "route";
    private static final String PROP_ROUTE_GEOM = "geom";
    private static final String PROP_FG_BAK_NAME = "ba_cd";
    private static final String PROP_FG_BA_NAME = "ba_cd";
    private static final String PROP_FG_LAK_NAME = "la_cd";
    private static final String PROP_FG_LA_NAME = "la_cd";
    private static final String PROP_SG_SU_NAME = "su_cd";
    private static final String PROP_SG_UMRING_NAME = "see_id";
    private static final String PROP_FG_BA_DUV_NAME = "ba_cd";
    private static final String PROP_FG_BA_DUV_GES_NAME = "ba_cd";
    private static final String PROP_STATIONLINIE_FROM = "von";
    private static final String PROP_STATIONLINIE_TO = "bis";
    private static final String PROP_STATIONLINIE_GEOM = "geom";
    private static final String MC_NAME_FG_BAK = "fg_bak";
    private static final String MC_NAME_FG_BA = "fg_ba";
    private static final String MC_NAME_FG_LA = "fg_la";
    private static final String MC_NAME_FG_LAK = "fg_lak";
    private static final String MC_NAME_SG_SU = "sg_su";
    private static final String MC_NAME_SG_UMRING = "sg_umring";
    private static final String MC_NAME_FG_BA_DUV = "fg_ba_duv";
    private static final String MC_NAME_FG_BA_DUV_GES = "fg_ba_duv_ges";
    private static final String CN_GEOM = "GEOM";
    private static final String CN_FG_BAK_STATIONLINE = "dlm25w.FG_BAK_LINIE";
    private static final String CN_FG_BAK_STATION = "dlm25w.FG_BAK_PUNKT";
    private static final String CN_FG_BA_STATIONLINE = "dlm25w.FG_BA_LINIE";
    private static final String CN_FG_BA_STATION = "dlm25w.FG_BA_PUNKT";
    private static final String CN_FG_LAK_STATIONLINE = "dlm25w.FG_LAK_LINIE";
    private static final String CN_FG_LAK_STATION = "dlm25w.FG_LAK_PUNKT";
    private static final String CN_FG_LA_STATIONLINE = "dlm25w.FG_LA_LINIE";
    private static final String CN_FG_LA_STATION = "dlm25w.FG_LA_PUNKT";
    private static final String CN_SG_SU_STATION = "dlm25w.SG_SU_PUNKT";
    private static final String CN_SG_UMRING_STATION = "duv.SG_UMRING_PUNKT";
    private static final String CN_FG_BA_DUV_STATION = "duv.FG_BA_DUV_PUNKT";
    private static final String CN_FG_BA_DUV_GES_STATION = "duv.FG_BA_DUV_GES_PUNKT";
    private static final String CN_SG_SU_STATIONLINE = "dlm25w.SG_SU_LINIE";
    private static final String CN_SG_UMRING_STATIONLINE = "duv.SG_UMRING_LINIE";
    private static final String CN_FG_BA_DUV_STATIONLINE = "duv.FG_BA_DUV_LINIE";
    private static final String CN_FG_BA_DUV_GES_STATIONLINE = "duv.FG_BA_DUV_GES_LINIE";
    private static final MetaClass MC_GEOM = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"GEOM");
    private static final MetaClass MC_FG_BAK_STATION = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.FG_BAK_PUNKT");
    private static final MetaClass MC_FG_BA_STATION = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.FG_BA_PUNKT");
    private static final MetaClass MC_FG_LAK_STATION = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.FG_LAK_PUNKT");
    private static final MetaClass MC_FG_LA_STATION = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.FG_LA_PUNKT");
    private static final MetaClass MC_SG_SU_STATION = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.SG_SU_PUNKT");
    private static final MetaClass MC_SG_UMRING_STATION = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"duv.SG_UMRING_PUNKT");
    private static final MetaClass MC_FG_BA_DUV_STATION = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"duv.FG_BA_DUV_PUNKT");
    private static final MetaClass MC_FG_BA_DUV_GES_STATION = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"duv.FG_BA_DUV_GES_PUNKT");
    private static final MetaClass MC_FG_BAK_STATIONLINIE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.FG_BAK_LINIE");
    private static final MetaClass MC_FG_BA_STATIONLINIE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.FG_BA_LINIE");
    private static final MetaClass MC_FG_LAK_STATIONLINIE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.FG_LAK_LINIE");
    private static final MetaClass MC_FG_LA_STATIONLINIE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.FG_LA_LINIE");
    private static final MetaClass MC_SG_SU_STATIONLINIE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.SG_SU_LINIE");
    private static final MetaClass MC_SG_UMRING_STATIONLINIE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"duv.SG_UMRING_LINIE");
    private static final MetaClass MC_FG_BA_DUV_STATIONLINIE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"duv.FG_BA_DUV_LINIE");
    private static final MetaClass MC_FG_BA_DUV_GES_STATIONLINIE = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"duv.FG_BA_DUV_GES_LINIE");
    private int NEW_STATION_ID = -1;
    private int NEW_LINE_ID = -1;

    public double distanceOfStationGeomToRouteGeomFromStationBean(CidsBean cidsBean) {
        Geometry routeGeometry = this.getRouteGeometryFromStationBean(cidsBean);
        Geometry pointGeometry = this.getPointGeometryFromStationBean(cidsBean);
        if (pointGeometry != null) {
            double distance = pointGeometry.distance(routeGeometry);
            return distance;
        }
        return 0.0;
    }

    public Geometry getRouteGeometryFromStationBean(CidsBean stationBean) {
        CidsBean geomBean = this.getRouteGeomBeanFromStationBean(stationBean);
        if (geomBean != null) {
            return (Geometry)geomBean.getProperty(PROP_GEOM_GEOFIELD);
        }
        return null;
    }

    public void setLinearValueToStationBean(Double value, CidsBean stationBean) throws Exception {
        if (stationBean == null || stationBean.getProperty(PROP_STATION_VALUE) != null && stationBean.getProperty(PROP_STATION_VALUE).equals(value)) {
            return;
        }
        stationBean.setProperty(PROP_STATION_VALUE, (Object)value);
    }

    public Geometry getPointGeometryFromStationBean(CidsBean stationBean) {
        CidsBean geomBean = this.getPointGeomBeanFromStationBean(stationBean);
        if (geomBean != null) {
            return (Geometry)geomBean.getProperty(PROP_GEOM_GEOFIELD);
        }
        return null;
    }

    public void setPointGeometryToStationBean(Geometry point, CidsBean stationBean) throws Exception {
        Geometry oldGeom = (Geometry)this.getPointGeomBeanFromStationBean(stationBean).getProperty(PROP_GEOM_GEOFIELD);
        if (oldGeom == null && point == null) {
            return;
        }
        if (oldGeom == null || point == null || !oldGeom.equalsExact(point)) {
            this.getPointGeomBeanFromStationBean(stationBean).setProperty(PROP_GEOM_GEOFIELD, (Object)point);
        }
    }

    public void setRouteGeometryToStationBean(Geometry geometry, CidsBean stationBean) throws Exception {
        this.getRouteGeomBeanFromStationBean(stationBean).setProperty(PROP_GEOM_GEOFIELD, (Object)geometry);
    }

    public String getRouteNameFromStationBean(CidsBean stationBean) {
        Object result = null;
        CidsBean routeBean = this.getRouteBeanFromStationBean(stationBean);
        if (routeBean != null) {
            if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BAK)) {
                result = routeBean.getProperty("ba_cd");
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA)) {
                result = routeBean.getProperty("ba_cd");
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_LAK)) {
                result = routeBean.getProperty("la_cd");
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_LA)) {
                result = routeBean.getProperty("la_cd");
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_SG_SU)) {
                result = routeBean.getProperty(PROP_SG_SU_NAME);
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA_DUV)) {
                result = routeBean.getProperty("ba_cd");
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA_DUV_GES)) {
                result = routeBean.getProperty("ba_cd");
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_SG_UMRING)) {
                result = routeBean.getProperty(PROP_SG_UMRING_NAME);
            } else {
                LOG.error((Object)"Unknown station bean. Cannot extract route name from station.");
            }
        } else {
            LOG.error((Object)"Cannot extract route bean from station.");
        }
        return String.valueOf(result);
    }

    private CidsBean getPointGeomBeanFromStationBean(CidsBean stationBean) {
        if (stationBean == null) {
            return null;
        }
        return (CidsBean)stationBean.getProperty(PROP_STATION_GEOM);
    }

    public CidsBean getRouteBeanFromStationBean(CidsBean stationBean) {
        if (stationBean == null) {
            return null;
        }
        return (CidsBean)stationBean.getProperty(PROP_STATION_ROUTE);
    }

    private CidsBean getRouteGeomBeanFromStationBean(CidsBean stationBean) {
        CidsBean route = this.getRouteBeanFromStationBean(stationBean);
        if (route != null) {
            return (CidsBean)route.getProperty("geom");
        }
        return null;
    }

    public CidsBean createStationBeanFromRouteBean(CidsBean routeBean) {
        return this.createStationBeanFromRouteBean(routeBean, 0.0);
    }

    public CidsBean createStationBeanFromRouteBean(CidsBean routeBean, double value) {
        CidsBean stationBean;
        block20: {
            stationBean = null;
            CidsBean geomBean = MC_GEOM.getEmptyInstance().getBean();
            if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BAK)) {
                stationBean = MC_FG_BAK_STATION.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA)) {
                stationBean = MC_FG_BA_STATION.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_LAK)) {
                stationBean = MC_FG_LAK_STATION.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_LA)) {
                stationBean = MC_FG_LA_STATION.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_SG_SU)) {
                stationBean = MC_SG_SU_STATION.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA_DUV)) {
                stationBean = MC_FG_BA_DUV_STATION.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA_DUV_GES)) {
                stationBean = MC_FG_BA_DUV_GES_STATION.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_SG_UMRING)) {
                stationBean = MC_SG_UMRING_STATION.getEmptyInstance().getBean();
            } else {
                LOG.error((Object)"Unknown route bean. Cannot create the corresponding station bean.");
            }
            try {
                int newStationId = this.getNewStationId();
                stationBean.setProperty(PROP_STATION_ROUTE, (Object)routeBean);
                stationBean.setProperty(PROP_STATION_VALUE, (Object)value);
                stationBean.setProperty(PROP_STATION_GEOM, (Object)geomBean);
                try {
                    CidsBean routeGeomBean = (CidsBean)routeBean.getProperty("geom");
                    Geometry geom = (Geometry)routeGeomBean.getProperty(PROP_GEOM_GEOFIELD);
                    this.setPointGeometryToStationBean(LinearReferencedPointFeature.getPointOnLine((double)value, (Geometry)geom), stationBean);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot set the geometry of the station", (Throwable)e);
                }
                stationBean.setProperty("id", (Object)newStationId);
                stationBean.getMetaObject().setID(newStationId);
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block20;
                LOG.debug((Object)"Error while filling bean", (Throwable)ex);
            }
        }
        return stationBean;
    }

    public CidsBean createLineBeanFromStationBean(CidsBean fromBean, CidsBean toBean) {
        CidsBean linieBean;
        block19: {
            CidsBean routeBean = this.getRouteBeanFromStationBean(fromBean);
            if (routeBean == null) {
                return null;
            }
            linieBean = null;
            if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BAK)) {
                linieBean = MC_FG_BAK_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA)) {
                linieBean = MC_FG_BA_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_LAK)) {
                linieBean = MC_FG_LAK_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_LA)) {
                linieBean = MC_FG_LA_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_SG_SU)) {
                linieBean = MC_SG_SU_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA_DUV)) {
                linieBean = MC_FG_BA_DUV_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA_DUV_GES)) {
                linieBean = MC_FG_BA_DUV_GES_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_SG_UMRING)) {
                linieBean = MC_SG_UMRING_STATIONLINIE.getEmptyInstance().getBean();
            } else {
                LOG.error((Object)"Unknown route bean. Cannot create the corresponding line bean.");
            }
            CidsBean geomBean = MC_GEOM.getEmptyInstance().getBean();
            try {
                linieBean.setProperty(PROP_STATIONLINIE_FROM, (Object)fromBean);
                linieBean.setProperty(PROP_STATIONLINIE_TO, (Object)toBean);
                geomBean.setProperty(PROP_GEOM_GEOFIELD, (Object)((Geometry)((CidsBean)routeBean.getProperty("geom")).getProperty(PROP_GEOM_GEOFIELD)));
                linieBean.setProperty("geom", (Object)geomBean);
                linieBean.setProperty("id", (Object)this.NEW_LINE_ID);
                linieBean.getMetaObject().setID(this.NEW_LINE_ID);
                --this.NEW_LINE_ID;
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block19;
                LOG.debug((Object)"Error while filling bean", (Throwable)ex);
            }
        }
        return linieBean;
    }

    public CidsBean createLineBeanFromRouteBean(CidsBean routeBean) {
        CidsBean linieBean;
        block19: {
            if (routeBean == null) {
                return null;
            }
            linieBean = null;
            if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BAK)) {
                linieBean = MC_FG_BAK_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA)) {
                linieBean = MC_FG_BA_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_LAK)) {
                linieBean = MC_FG_LAK_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_LA)) {
                linieBean = MC_FG_LA_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_SG_SU)) {
                linieBean = MC_SG_SU_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA_DUV)) {
                linieBean = MC_FG_BA_DUV_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_FG_BA_DUV_GES)) {
                linieBean = MC_FG_BA_DUV_GES_STATIONLINIE.getEmptyInstance().getBean();
            } else if (routeBean.getMetaObject().getMetaClass().getName().equals(MC_NAME_SG_UMRING)) {
                linieBean = MC_SG_UMRING_STATIONLINIE.getEmptyInstance().getBean();
            } else {
                LOG.error((Object)"Unknown route bean. Cannot create the corresponding line bean.");
            }
            CidsBean fromBean = this.createStationBeanFromRouteBean(routeBean);
            CidsBean toBean = this.createStationBeanFromRouteBean(routeBean);
            CidsBean geomBean = MC_GEOM.getEmptyInstance().getBean();
            try {
                toBean.setProperty(PROP_STATION_VALUE, (Object)((Geometry)((CidsBean)routeBean.getProperty("geom")).getProperty(PROP_GEOM_GEOFIELD)).getLength());
                linieBean.setProperty(PROP_STATIONLINIE_FROM, (Object)fromBean);
                linieBean.setProperty(PROP_STATIONLINIE_TO, (Object)toBean);
                geomBean.setProperty(PROP_GEOM_GEOFIELD, (Object)((Geometry)((CidsBean)routeBean.getProperty("geom")).getProperty(PROP_GEOM_GEOFIELD)));
                linieBean.setProperty("geom", (Object)geomBean);
                linieBean.setProperty("id", (Object)this.NEW_LINE_ID);
                linieBean.getMetaObject().setID(this.NEW_LINE_ID);
                --this.NEW_LINE_ID;
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block19;
                LOG.debug((Object)"Error while filling bean", (Throwable)ex);
            }
        }
        return linieBean;
    }

    public double getLinearValueFromStationBean(CidsBean stationBean) {
        if (stationBean == null || stationBean.getProperty(PROP_STATION_VALUE) == null) {
            return 0.0;
        }
        return (Double)stationBean.getProperty(PROP_STATION_VALUE);
    }

    public CidsBean getStationBeanFromLineBean(CidsBean lineBean, boolean isFrom) {
        if (lineBean == null) {
            return null;
        }
        String stationField = isFrom ? PROP_STATIONLINIE_FROM : PROP_STATIONLINIE_TO;
        return (CidsBean)lineBean.getProperty(stationField);
    }

    public CidsBean getGeomBeanFromLineBean(CidsBean lineBean) {
        if (lineBean == null) {
            return null;
        }
        return (CidsBean)lineBean.getProperty("geom");
    }

    public void setGeometryToLineBean(Geometry line, CidsBean lineBean) throws Exception {
        CidsBean geomBean = this.getGeomBeanFromLineBean(lineBean);
        if (geomBean == null) {
            geomBean = MC_GEOM.getEmptyInstance().getBean();
            lineBean.setProperty("geom", (Object)geomBean);
        }
        if (geomBean != null) {
            geomBean.setProperty(PROP_GEOM_GEOFIELD, (Object)line);
        }
    }

    public synchronized int getNewStationId() {
        return --this.NEW_STATION_ID;
    }

    public synchronized int getNewLineId() {
        return --this.NEW_LINE_ID;
    }

    public String getValueProperty(CidsBean station) {
        return PROP_STATION_VALUE;
    }

    public String getRouteNamePropertyFromRouteByClassName(String routeClass) {
        String routeNameProperty = null;
        if (routeClass != null) {
            if (routeClass.endsWith(MC_NAME_FG_BAK)) {
                routeNameProperty = "ba_cd";
            } else if (routeClass.endsWith(MC_NAME_FG_BA)) {
                routeNameProperty = "ba_cd";
            } else if (routeClass.endsWith(MC_NAME_FG_LAK)) {
                routeNameProperty = "la_cd";
            } else if (routeClass.endsWith(MC_NAME_FG_LA)) {
                routeNameProperty = "la_cd";
            } else if (routeClass.endsWith(MC_NAME_SG_SU)) {
                routeNameProperty = PROP_SG_SU_NAME;
            } else if (routeClass.endsWith(MC_NAME_FG_BA_DUV)) {
                routeNameProperty = "ba_cd";
            } else if (routeClass.endsWith(MC_NAME_FG_BA_DUV_GES)) {
                routeNameProperty = "ba_cd";
            } else if (routeClass.endsWith(MC_NAME_SG_UMRING)) {
                routeNameProperty = PROP_SG_UMRING_NAME;
            } else {
                LOG.error((Object)"Unknown station bean. Cannot extract route name from station.");
            }
        } else {
            LOG.error((Object)"Cannot extract route name from bean.");
        }
        return routeNameProperty;
    }

    public void setRouteBeanToStationBean(CidsBean routeBean, CidsBean stationBean) throws Exception {
        stationBean.setProperty(PROP_STATION_ROUTE, (Object)routeBean);
    }

    public String[] getDomainOfRouteTable(String routeTable) {
        return new String[]{"DLM25W"};
    }

    public Geometry getGeometryFromRoute(CidsBean routeBean) {
        return (Geometry)routeBean.getProperty("geom.geo_field");
    }
}

